/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util.management;

import fr.dyade.aaa.util.Debug;
import fr.dyade.aaa.util.management.MXServer;
import org.objectweb.util.monolog.api.BasicLevel;

public final class MXWrapper {
    public static final String ServerImpl = "MXServer";
    public static MXServer mxserver = null;

    public static void init() {
        if (mxserver != null) {
            return;
        }
        String mxname = System.getProperty(ServerImpl);
        try {
            if (mxname != null && mxname.length() > 0) {
                Class.forName(mxname).newInstance();
            }
        }
        catch (Exception exc) {
            Debug.getLogger("fr.dyade.aaa.util.management").log(BasicLevel.ERROR, (Object)("can't instantiate MXServer: " + mxname), (Throwable)exc);
        }
        Debug.getLogger("fr.dyade.aaa.util.management").log(BasicLevel.INFO, (Object)("MXWrapper.ServerImpl -> " + mxname));
    }

    public static void registerMBean(Object bean, String domain, String name) throws Exception {
        if (mxserver == null) {
            return;
        }
        Debug.getLogger("fr.dyade.aaa.util.management").log(BasicLevel.INFO, (Object)("registerMBean: " + name + " -> " + mxserver));
        mxserver.registerMBean(bean, domain, name);
    }

    public static void unregisterMBean(String domain, String name) throws Exception {
        if (mxserver == null) {
            return;
        }
        Debug.getLogger("fr.dyade.aaa.util.management").log(BasicLevel.INFO, (Object)("unregisterMBean: " + name + " -> " + mxserver));
        mxserver.unregisterMBean(domain, name);
    }

    public static void setMXServer(MXServer server) {
        Debug.getLogger("fr.dyade.aaa.util.management").log(BasicLevel.INFO, (Object)("setMXServer: " + server));
        mxserver = server;
    }

    public static MXServer getMXServer() {
        return mxserver;
    }
}

