/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;

public class Persistence {
    public static String PERSISTENCE_PROVIDER = PersistenceProvider.class.getName();
    protected static final Set<PersistenceProvider> providers = new HashSet<PersistenceProvider>();
    private static final String PERSISTENCE_PROVIDER_JAR_PROPERTY = "META-INF/services/" + PERSISTENCE_PROVIDER;
    private static final String PERSISTENCE_PROVIDER_MAP_PROPERTY = "javax.persistence.provider";
    private static boolean initialized = false;

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName) {
        return Persistence.createEntityManagerFactory(persistenceUnitName, null);
    }

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        Persistence.init();
        if (properties != null) {
            Object object = properties.get(PERSISTENCE_PROVIDER_MAP_PROPERTY);
            if (!(object instanceof String)) {
                throw new PersistenceException("Found 'javax.persistence.provider' property in the map but the value is not a String. Found object : '" + object + "'.");
            }
            String persistenceProviderName = (String)object;
            PersistenceProvider persistenceProvider = Persistence.getProviderForName(persistenceProviderName);
            if (persistenceProvider == null) {
                throw new PersistenceException("Property 'javax.persistence.provider' with value '" + persistenceProviderName + "' was provided in the Map properties but no persistence provider with this name has been found");
            }
            EntityManagerFactory entityManagerFactory = persistenceProvider.createEntityManagerFactory(persistenceUnitName, properties);
            if (entityManagerFactory == null) {
                throw new PersistenceException("Property 'javax.persistence.provider' with value '" + persistenceProviderName + "' was provided in the Map properties but the persistence provider returns " + "an empty factory for the given persistence unit '" + persistenceUnitName + "'.");
            }
            return entityManagerFactory;
        }
        EntityManagerFactory entityManagerFactory = null;
        for (PersistenceProvider persistenceProvider : providers) {
            entityManagerFactory = persistenceProvider.createEntityManagerFactory(persistenceUnitName, properties);
            if (entityManagerFactory == null) continue;
            return entityManagerFactory;
        }
        throw new PersistenceException("No EntityManagerFactory have been created in the list of '" + providers.size() + "' providers available.");
    }

    private static PersistenceProvider getProviderForName(String persistenceProviderName) {
        PersistenceProvider persistenceProvider = null;
        for (PersistenceProvider tmpProvider : providers) {
            if (!tmpProvider.getClass().getName().equals(persistenceProviderName)) continue;
            persistenceProvider = tmpProvider;
            break;
        }
        return persistenceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        if (initialized) {
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> urls = null;
        try {
            urls = classLoader.getResources(PERSISTENCE_PROVIDER_JAR_PROPERTY);
        }
        catch (IOException e) {
            throw new PersistenceException("Cannot get resources named '" + PERSISTENCE_PROVIDER_JAR_PROPERTY + "' on the current classloader '" + classLoader + "'.", e);
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            URLConnection urlConnection = null;
            try {
                urlConnection = url.openConnection();
            }
            catch (IOException e) {
                throw new PersistenceException("Cannot open connection on URL '" + url + "'.", e);
            }
            urlConnection.setDefaultUseCaches(false);
            InputStream is = null;
            try {
                is = urlConnection.getInputStream();
                Reader reader = null;
                BufferedReader bufferedReader = null;
                try {
                    reader = new InputStreamReader(is);
                    bufferedReader = new BufferedReader(reader);
                    String line = bufferedReader.readLine();
                    if (line == null) {
                        throw new PersistenceException("No lines found in the file available at the URL '" + url + "'.");
                    }
                    Persistence.addPersistenceProvider(line.trim());
                }
                finally {
                    reader.close();
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                throw new PersistenceException("Cannot get InputStream on URL '" + url + "'.", e);
            }
            finally {
                if (is == null) continue;
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new PersistenceException("Cannot close InputStream on URL '" + url + "'.", e);
                }
            }
        }
        initialized = true;
    }

    private static void addPersistenceProvider(String persistenceProviderName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> persistenceProviderClass = null;
        try {
            persistenceProviderClass = classLoader.loadClass(persistenceProviderName);
        }
        catch (ClassNotFoundException e) {
            throw new PersistenceException("Cannot load the persistence provider class with the name '" + persistenceProviderName + "' in the ClassLoader '" + classLoader + "'.", e);
        }
        Object object = null;
        try {
            object = persistenceProviderClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new PersistenceException("Cannot build an instance of the persistence provider class with the name '" + persistenceProviderName + "' in the ClassLoader '" + classLoader + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new PersistenceException("Cannot build an instance of the persistence provider class with the name '" + persistenceProviderName + "' in the ClassLoader '" + classLoader + "'.", e);
        }
        if (!(object instanceof PersistenceProvider)) {
            throw new PersistenceException("The instance of the object with the class name '" + persistenceProviderName + "' in the ClassLoader '" + classLoader + "' is not an instance of PersistenceProvider interface.");
        }
        providers.add(object);
    }
}

