/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing;

import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.PortType;
import org.apache.axis.message.addressing.ReferenceParametersType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.axis.message.addressing.ServiceNameType;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.axis.types.URI;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EndpointReference
extends EndpointReferenceType {
    private static Log log = LogFactory.getLog((class$org$apache$axis$message$addressing$EndpointReference == null ? (class$org$apache$axis$message$addressing$EndpointReference = EndpointReference.class$("org.apache.axis.message.addressing.EndpointReference")) : class$org$apache$axis$message$addressing$EndpointReference).getName());
    static /* synthetic */ Class class$org$apache$axis$message$addressing$EndpointReference;

    public EndpointReference(Address address) {
        this.setAddress(address);
    }

    public EndpointReference(URI uri) {
        this.setAddress(new Address(uri));
    }

    public EndpointReference(EndpointReferenceType endpoint) {
        super(endpoint);
    }

    public EndpointReference(String endpoint) throws URI.MalformedURIException {
        this.setAddress(new Address(new URI(endpoint)));
    }

    public EndpointReference(SOAPElement element) throws Exception {
        Iterator iter = element.getChildElements();
        while (iter.hasNext()) {
            Node child = (Node)iter.next();
            if (!(child instanceof SOAPElement) || !AddressingUtils.isAddressingNamespaceURI(child.getNamespaceURI())) continue;
            String localName = child.getLocalName();
            if ("Address".equals(localName)) {
                Address address = Address.fromSOAPElement((SOAPElement)child);
                this.setAddress(address);
                continue;
            }
            if ("PortType".equals(localName)) {
                PortType portType = PortType.fromSOAPElement((SOAPElement)child);
                this.setPortType(portType);
                continue;
            }
            if ("ServiceName".equals(localName)) {
                ServiceNameType serviceName = ServiceNameType.fromSOAPElement((SOAPElement)child);
                this.setServiceName(serviceName);
                continue;
            }
            if ("ReferenceProperties".equals(localName)) {
                ReferencePropertiesType props = ReferencePropertiesType.fromSOAPElement((SOAPElement)child);
                this.setProperties(props);
                continue;
            }
            if (!"ReferenceParameters".equals(localName)) continue;
            ReferenceParametersType params = ReferenceParametersType.fromSOAPElement((SOAPElement)child);
            this.setParameters(params);
        }
        if (this.getAddress() == null) {
            throw new IllegalArgumentException("Specified element does not contain the required 'wsa:Address' child element.");
        }
    }

    public EndpointReference(Element element) throws Exception {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            org.w3c.dom.Node child = children.item(i);
            if (!(child instanceof Element) || !AddressingUtils.isAddressingNamespaceURI(child.getNamespaceURI())) continue;
            String localName = child.getLocalName();
            if ("Address".equals(localName)) {
                Address address = Address.fromElement((Element)child);
                this.setAddress(address);
                continue;
            }
            if ("PortType".equals(localName)) {
                PortType portType = PortType.fromElement((Element)child);
                this.setPortType(portType);
                continue;
            }
            if ("ServiceName".equals(localName)) {
                ServiceNameType serviceName = ServiceNameType.fromElement((Element)child);
                this.setServiceName(serviceName);
                continue;
            }
            if ("ReferenceProperties".equals(localName)) {
                ReferencePropertiesType props = ReferencePropertiesType.fromElement((Element)child);
                this.setProperties(props);
                continue;
            }
            if (!"ReferenceParameters".equals(localName)) continue;
            ReferenceParametersType params = ReferenceParametersType.fromElement((Element)child);
            this.setParameters(params);
        }
        if (this.getAddress() == null) {
            throw new IllegalArgumentException("Specified element does not contain the required 'wsa:Address' child element.");
        }
    }

    public Element toDOM(Document doc) {
        return this.toDOM(doc, "EndpointReference");
    }

    public Element toDOM(Document doc, String elementName) {
        ReferenceParametersType refParams;
        MessageElement[] any;
        ReferencePropertiesType refProps;
        if (doc == null) {
            try {
                doc = XMLUtils.newDocument();
            }
            catch (ParserConfigurationException pce) {
                return null;
            }
        }
        Element parent = doc.createElementNS(AddressingUtils.getAddressingNamespaceURI(), elementName);
        if (doc.getDocumentElement() == null) {
            doc.appendChild(parent);
        } else {
            doc.getDocumentElement().appendChild(parent);
        }
        if (this.getAddress() != null) {
            this.getAddress().append(parent, "Address");
        }
        if (this.getPortType() != null) {
            this.getPortType().append(parent, "PortType");
        }
        if (this.getServiceName() != null) {
            this.getServiceName().append(parent, "ServiceName");
        }
        if ((refProps = this.getProperties()) != null && refProps.size() > 0) {
            refProps.append(parent, "ReferenceProperties");
        }
        if ((any = this.get_any()) != null && any.length > 0) {
            for (int i = 0; i < any.length; ++i) {
                try {
                    parent.appendChild(doc.importNode(any[i].getAsDOM(), true));
                    continue;
                }
                catch (Exception e) {
                    log.debug("", e);
                }
            }
        }
        if (AddressingUtils.getAddressingNamespaceURI().equals("http://schemas.xmlsoap.org/ws/2004/08/addressing") && (refParams = this.getParameters()) != null && refParams.size() > 0) {
            refParams.append(parent, "ReferenceParameters");
        }
        return parent;
    }

    public javax.xml.soap.SOAPHeaderElement toSOAPHeaderElement(javax.xml.soap.SOAPEnvelope env, String actorURI) throws Exception {
        return this.toSOAPHeaderElement(env, actorURI, "EndpointReference");
    }

    protected javax.xml.soap.SOAPHeaderElement toSOAPHeaderElement(javax.xml.soap.SOAPEnvelope env, String actorURI, String name) throws Exception {
        if (name == null) {
            throw new IllegalArgumentException("Name parameter must be non-null.");
        }
        if (!(env instanceof SOAPEnvelope)) {
            throw new Exception("Not supported");
        }
        SOAPHeader header = env.getHeader();
        if (header == null) {
            header = env.addHeader();
        }
        Document doc = XMLUtils.newDocument();
        SOAPHeaderElement headerElem = new SOAPHeaderElement(this.toDOM(doc, name));
        headerElem.setActor(actorURI);
        ((SOAPEnvelope)env).addHeader(headerElem);
        return headerElem;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

