/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler.modules;

import java.util.ArrayList;
import java.util.List;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.AttributeInfo;
import org.apache.commons.modeler.ManagedBean;
import org.apache.commons.modeler.OperationInfo;
import org.apache.commons.modeler.ParameterInfo;
import org.apache.commons.modeler.Registry;
import org.apache.commons.modeler.modules.ModelerSource;

public class MbeansDescriptorsDynamicMBeanSource
extends ModelerSource {
    private static Log log = LogFactory.getLog(class$org$apache$commons$modeler$modules$MbeansDescriptorsDynamicMBeanSource == null ? (class$org$apache$commons$modeler$modules$MbeansDescriptorsDynamicMBeanSource = MbeansDescriptorsDynamicMBeanSource.class$("org.apache.commons.modeler.modules.MbeansDescriptorsDynamicMBeanSource")) : class$org$apache$commons$modeler$modules$MbeansDescriptorsDynamicMBeanSource);
    Registry registry;
    String location;
    String type;
    Object source;
    List mbeans = new ArrayList();
    static /* synthetic */ Class class$org$apache$commons$modeler$modules$MbeansDescriptorsDynamicMBeanSource;

    public void setRegistry(Registry reg) {
        this.registry = reg;
    }

    public void setLocation(String loc) {
        this.location = loc;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public List loadDescriptors(Registry registry, String location, String type, Object source) throws Exception {
        this.setRegistry(registry);
        this.setLocation(location);
        this.setType(type);
        this.setSource(source);
        this.execute();
        return this.mbeans;
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry();
        }
        try {
            ManagedBean managed = this.createManagedBean(this.registry, null, this.source, this.type);
            if (managed == null) {
                return;
            }
            managed.setName(this.type);
            this.mbeans.add(managed);
        }
        catch (Exception ex) {
            log.error("Error reading descriptors ", ex);
        }
    }

    public ManagedBean createManagedBean(Registry registry, String domain, Object realObj, String type) {
        if (!(realObj instanceof DynamicMBean)) {
            return null;
        }
        DynamicMBean dmb = (DynamicMBean)realObj;
        ManagedBean mbean = new ManagedBean();
        MBeanInfo mbi = dmb.getMBeanInfo();
        try {
            MBeanAttributeInfo[] attInfo = mbi.getAttributes();
            for (int i = 0; i < attInfo.length; ++i) {
                MBeanAttributeInfo mai = attInfo[i];
                String name = mai.getName();
                AttributeInfo ai = new AttributeInfo();
                ai.setName(name);
                ai.setType(mai.getType());
                ai.setReadable(mai.isReadable());
                ai.setWriteable(mai.isWritable());
                mbean.addAttribute(ai);
            }
            MBeanOperationInfo[] opInfo = mbi.getOperations();
            for (int i = 0; i < opInfo.length; ++i) {
                MBeanOperationInfo moi = opInfo[i];
                OperationInfo op = new OperationInfo();
                op.setName(moi.getName());
                op.setReturnType(moi.getReturnType());
                MBeanParameterInfo[] parms = moi.getSignature();
                for (int j = 0; j < parms.length; ++j) {
                    ParameterInfo pi = new ParameterInfo();
                    pi.setType(parms[i].getType());
                    pi.setName(parms[i].getName());
                    op.addParameter(pi);
                }
                mbean.addOperation(op);
            }
            if (log.isDebugEnabled()) {
                log.debug("Setting name: " + type);
            }
            mbean.setName(type);
            return mbean;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

