/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.osgi.framework.BundleContext;

public class FilePersistenceManager
implements PersistenceManager {
    public static final String DEFAULT_CONFIG_DIR = "config";
    private static final String FILE_EXT = ".config";
    private static final String TMP_EXT = ".tmp";
    private static final BitSet VALID_PATH_CHARS;
    private final File location;

    static String encodePid(String pid) {
        int first;
        pid = pid.replace('.', File.separatorChar);
        if (File.separatorChar != '/') {
            pid = pid.replace('/', File.separatorChar);
        }
        for (first = 0; first < pid.length() && VALID_PATH_CHARS.get(pid.charAt(first)); ++first) {
        }
        if (first < pid.length()) {
            StringBuffer buf = new StringBuffer(pid.substring(0, first));
            for (int i = first; i < pid.length(); ++i) {
                char c = pid.charAt(i);
                if (VALID_PATH_CHARS.get(c)) {
                    buf.append(c);
                    continue;
                }
                String val = "000" + Integer.toHexString(c);
                buf.append('%');
                buf.append(val.substring(val.length() - 4));
            }
            pid = buf.toString();
        }
        return pid;
    }

    public FilePersistenceManager(String location) {
        this(null, location);
    }

    public FilePersistenceManager(BundleContext bundleContext, String location) {
        File locationFile;
        if (location == null && bundleContext != null && (locationFile = bundleContext.getDataFile(DEFAULT_CONFIG_DIR)) != null) {
            location = locationFile.getAbsolutePath();
        }
        if (location == null) {
            location = System.getProperty("user.dir") + "/config";
        }
        if (!(locationFile = new File(location)).isAbsolute()) {
            File bundleLocationFile;
            if (bundleContext != null && (bundleLocationFile = bundleContext.getDataFile(locationFile.getPath())) != null) {
                locationFile = bundleLocationFile;
            }
            locationFile = locationFile.getAbsoluteFile();
        }
        if (!locationFile.isDirectory()) {
            if (locationFile.exists()) {
                throw new IllegalArgumentException(location + " is not a directory");
            }
            if (!locationFile.mkdirs()) {
                throw new IllegalArgumentException("Cannot create directory " + location);
            }
        }
        this.location = locationFile;
    }

    public File getLocation() {
        return this.location;
    }

    public Enumeration getDictionaries() {
        return new DictionaryEnumeration();
    }

    public void delete(String pid) {
        this.getFile(pid).delete();
    }

    public boolean exists(String pid) {
        return this.getFile(pid).isFile();
    }

    public Dictionary load(String pid) throws IOException {
        return this.load(this.getFile(pid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String pid, Dictionary props) throws IOException {
        File tmpFile;
        block12: {
            OutputStream out = null;
            tmpFile = null;
            try {
                File cfgFile = this.getFile(pid);
                File cfgDir = cfgFile.getParentFile();
                cfgDir.mkdirs();
                tmpFile = File.createTempFile(cfgFile.getName(), TMP_EXT, cfgDir);
                out = new FileOutputStream(tmpFile);
                ConfigurationHandler.write(out, props);
                out.close();
                FilePersistenceManager filePersistenceManager = this;
                synchronized (filePersistenceManager) {
                    if (cfgFile.exists()) {
                        cfgFile.delete();
                    }
                    tmpFile.renameTo(cfgFile);
                }
                Object var10_9 = null;
                if (out == null) break block12;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                if (tmpFile != null && tmpFile.exists()) {
                    tmpFile.delete();
                }
                throw throwable;
            }
            try {
                out.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (tmpFile != null && tmpFile.exists()) {
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Dictionary load(File cfgFile) throws IOException {
        FilePersistenceManager filePersistenceManager = this;
        synchronized (filePersistenceManager) {
            FileInputStream ins = null;
            try {
                ins = new FileInputStream(cfgFile);
                Dictionary dictionary = ConfigurationHandler.read(ins);
                Object var6_5 = null;
                if (ins == null) return dictionary;
                try {
                    ((InputStream)ins).close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return dictionary;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (ins == null) throw throwable;
                try {}
                catch (IOException ioe) {
                    throw throwable;
                }
                ((InputStream)ins).close();
                throw throwable;
            }
        }
    }

    private File getFile(String pid) {
        return new File(this.location, FilePersistenceManager.encodePid(pid) + FILE_EXT);
    }

    static {
        int i;
        VALID_PATH_CHARS = new BitSet();
        for (i = 97; i <= 122; ++i) {
            VALID_PATH_CHARS.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            VALID_PATH_CHARS.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            VALID_PATH_CHARS.set(i);
        }
        VALID_PATH_CHARS.set(File.separatorChar);
        VALID_PATH_CHARS.set(32);
        VALID_PATH_CHARS.set(45);
        VALID_PATH_CHARS.set(95);
    }

    private class DictionaryEnumeration
    implements Enumeration {
        private Stack dirStack = new Stack();
        private File[] fileList = null;
        private int idx = 0;
        private Dictionary next;

        DictionaryEnumeration() {
            this.dirStack.push(FilePersistenceManager.this.location);
            this.next = this.seek();
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Dictionary toReturn = this.next;
            this.next = this.seek();
            return toReturn;
        }

        private Dictionary seek() {
            while (this.fileList != null && this.idx < this.fileList.length || !this.dirStack.isEmpty()) {
                File cfgFile;
                if (this.fileList == null || this.idx >= this.fileList.length) {
                    File dir2 = (File)this.dirStack.pop();
                    this.fileList = dir2.listFiles();
                    this.idx = 0;
                    continue;
                }
                if ((cfgFile = this.fileList[this.idx++]).isFile() && !cfgFile.getName().endsWith(FilePersistenceManager.TMP_EXT)) {
                    try {
                        Dictionary dict = FilePersistenceManager.this.load(cfgFile);
                        if (dict.get("service.pid") != null && !cfgFile.equals(FilePersistenceManager.this.getFile((String)dict.get("service.pid")))) continue;
                        return dict;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
                if (!cfgFile.isDirectory()) continue;
                this.dirStack.push(cfgFile);
            }
            return null;
        }
    }
}

