/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.CompositeFactory;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.InstanceCreator;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.ManifestMetadataParser;
import org.apache.felix.ipojo.parser.ParseException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.log.LogService;

public class Extender
implements SynchronousBundleListener,
BundleActivator {
    private static final String IPOJO_HEADER = "iPOJO-Components";
    private BundleContext m_context;
    private Dictionary m_components;
    private Dictionary m_creators;
    private long m_bundleId;
    static /* synthetic */ Class class$org$osgi$service$log$LogService;

    public synchronized void bundleChanged(BundleEvent event) {
        if (event.getBundle().getBundleId() == this.m_bundleId) {
            return;
        }
        switch (event.getType()) {
            case 2: {
                this.startManagementFor(event.getBundle());
                break;
            }
            case 256: {
                this.closeManagementFor(event.getBundle());
                break;
            }
        }
    }

    private void closeManagementFor(Bundle bundle) {
        ComponentFactory[] cfs = (ComponentFactory[])this.m_components.get(bundle);
        InstanceCreator creator = (InstanceCreator)this.m_creators.get(bundle);
        if (cfs == null && creator == null) {
            return;
        }
        for (int i = 0; cfs != null && i < cfs.length; ++i) {
            ComponentFactory factory = cfs[i];
            factory.stop();
        }
        if (creator != null) {
            creator.stop();
        }
        this.m_components.remove(bundle);
        this.m_creators.remove(bundle);
    }

    private void startManagementFor(Bundle bundle) {
        Dictionary dict = bundle.getHeaders();
        String header = (String)dict.get(IPOJO_HEADER);
        if (header == null) {
            return;
        }
        try {
            this.parse(bundle, header);
        }
        catch (IOException e) {
            this.err("An exception occurs during the parsing of the bundle " + bundle.getBundleId(), e);
        }
        catch (ParseException e) {
            this.err("A parse exception occurs during the parsing of the bundle " + bundle.getBundleId(), e);
        }
    }

    private void parse(Bundle bundle, String components) throws IOException, ParseException {
        ManifestMetadataParser parser2 = new ManifestMetadataParser();
        parser2.parseHeader(components);
        Element[] componentsMetadata = parser2.getComponentsMetadata();
        for (int i = 0; i < componentsMetadata.length; ++i) {
            this.addComponentFactory(bundle, componentsMetadata[i]);
        }
        this.start(bundle, parser2.getInstances());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bc) throws Exception {
        this.m_context = bc;
        this.m_bundleId = bc.getBundle().getBundleId();
        this.m_components = new Hashtable();
        this.m_creators = new Hashtable();
        this.startManagementFor(bc.getBundle());
        Extender extender = this;
        synchronized (extender) {
            this.m_context.addBundleListener((BundleListener)this);
            for (int i = 0; i < bc.getBundles().length; ++i) {
                if (bc.getBundles()[i].getState() != 32) continue;
                this.startManagementFor(bc.getBundles()[i]);
            }
        }
    }

    public void stop(BundleContext bc) throws Exception {
        this.m_context.removeBundleListener((BundleListener)this);
        Enumeration e = this.m_components.keys();
        while (e.hasMoreElements()) {
            ComponentFactory[] cfs = (ComponentFactory[])this.m_components.get(e.nextElement());
            for (int i = 0; i < cfs.length; ++i) {
                cfs[i].stop();
            }
        }
        this.m_components = null;
        Enumeration e2 = this.m_creators.keys();
        while (e2.hasMoreElements()) {
            InstanceCreator creator = (InstanceCreator)this.m_creators.remove(e2.nextElement());
            creator.stop();
        }
        this.m_creators = null;
    }

    private void addComponentFactory(Bundle bundle, Element cm) {
        ComponentFactory factory = null;
        if (cm.getName().equalsIgnoreCase("component")) {
            factory = new ComponentFactory(bundle.getBundleContext(), cm);
        } else if (cm.getName().equalsIgnoreCase("composite")) {
            factory = new CompositeFactory(bundle.getBundleContext(), cm);
        } else if (cm.getName().equalsIgnoreCase("handler")) {
            factory = new HandlerFactory(bundle.getBundleContext(), cm);
        } else {
            this.err("Not recognized element type : " + cm.getName(), null);
        }
        ComponentFactory[] cfs = (ComponentFactory[])this.m_components.get(bundle);
        if (cfs != null && cfs.length != 0) {
            ComponentFactory[] newFactory = new ComponentFactory[cfs.length + 1];
            System.arraycopy(cfs, 0, newFactory, 0, cfs.length);
            newFactory[cfs.length] = factory;
            cfs = newFactory;
            this.m_components.put(bundle, cfs);
        } else {
            this.m_components.put(bundle, new ComponentFactory[]{factory});
        }
    }

    private void start(Bundle bundle, Dictionary[] confs) {
        ComponentFactory[] cfs = (ComponentFactory[])this.m_components.get(bundle);
        if (cfs != null) {
            for (int j = 0; j < cfs.length; ++j) {
                cfs[j].start();
            }
        }
        if (confs.length > 0) {
            this.m_creators.put(bundle, new InstanceCreator(bundle.getBundleContext(), confs, cfs));
        }
    }

    private void err(String message, Throwable t) {
        ServiceReference ref = this.m_context.getServiceReference((class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Extender.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName());
        if (ref != null) {
            LogService log = (LogService)this.m_context.getService(ref);
            log.log(1, message, t);
            this.m_context.ungetService(ref);
        }
        if (t != null) {
            System.err.println("[iPOJO-Core] " + message + " : " + t.getMessage());
        } else {
            System.err.println("[iPOJO-Core] " + message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

