/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.util.Dictionary;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.FactoryStateListener;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.UnacceptableConfiguration;
import org.apache.felix.ipojo.util.Logger;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class InstanceCreator
implements TrackerCustomizer,
FactoryStateListener {
    private BundleContext m_context;
    private Logger m_logger;
    private ComponentFactory[] m_factories;
    private ManagedConfiguration[] m_configurations = new ManagedConfiguration[0];
    private Tracker m_tracker;
    static /* synthetic */ Class class$org$apache$felix$ipojo$Factory;

    public InstanceCreator(BundleContext context, Dictionary[] configurations, ComponentFactory[] factories) {
        int i;
        this.m_context = context;
        this.m_logger = new Logger(context, "InstanceCreator" + context.getBundle().getBundleId(), 2);
        this.m_configurations = new ManagedConfiguration[configurations.length];
        this.m_factories = factories;
        for (i = 0; i < configurations.length; ++i) {
            ManagedConfiguration conf;
            this.m_configurations[i] = conf = new ManagedConfiguration(configurations[i]);
            String componentType = (String)conf.getConfiguration().get("component");
            boolean found = false;
            for (int j = 0; this.m_factories != null && !found && j < this.m_factories.length; ++j) {
                if (this.m_factories[j].m_state != 1 || !this.m_factories[j].getName().equals(componentType) && (this.m_factories[j].getComponentClassName() == null || !this.m_factories[j].getComponentClassName().equals(componentType))) continue;
                this.createInstance(this.m_factories[j], conf);
                found = true;
            }
        }
        for (i = 0; this.m_factories != null && i < this.m_factories.length; ++i) {
            this.m_factories[i].addFactoryStateListener(this);
        }
        String filter = "(&(objectclass=" + (class$org$apache$felix$ipojo$Factory == null ? (class$org$apache$felix$ipojo$Factory = InstanceCreator.class$("org.apache.felix.ipojo.Factory")) : class$org$apache$felix$ipojo$Factory).getName() + ")(factory.state=1))";
        try {
            this.m_tracker = new Tracker(this.m_context, this.m_context.createFilter(filter), (TrackerCustomizer)this);
            this.m_tracker.open();
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return;
        }
    }

    private void createInstance(Factory fact, ManagedConfiguration config) {
        Dictionary conf = config.getConfiguration();
        try {
            config.setInstance(fact.createComponentInstance(conf));
            config.setFactory(fact.getName());
        }
        catch (UnacceptableConfiguration e) {
            this.m_logger.log(1, "A factory is available for the configuration but the configuration is not acceptable", e);
            this.stop();
        }
        catch (MissingHandlerException e) {
            this.m_logger.log(1, "The instance creation has failed, at least one handler is missing", e);
            this.stop();
        }
        catch (ConfigurationException e) {
            this.m_logger.log(1, "The instance creation has failed, an error during the configuration has occured", e);
            this.stop();
        }
    }

    public synchronized void stop() {
        int i;
        this.m_tracker.close();
        for (i = 0; this.m_factories != null && i < this.m_factories.length; ++i) {
            this.m_factories[i].removeFactoryStateListener(this);
        }
        for (i = 0; i < this.m_configurations.length; ++i) {
            if (this.m_configurations[i].getInstance() != null) {
                this.m_configurations[i].getInstance().dispose();
            }
            this.m_configurations[i].setInstance(null);
            this.m_configurations[i].setFactory(null);
        }
        this.m_factories = null;
        this.m_tracker = null;
        this.m_logger = null;
        this.m_configurations = null;
    }

    public void stateChanged(Factory factory, int newState) {
        if (newState == 1) {
            for (int i = 0; i < this.m_configurations.length; ++i) {
                if (this.m_configurations[i].getInstance() != null || !this.m_configurations[i].getConfiguration().get("component").equals(factory.getName()) && !this.m_configurations[i].getConfiguration().get("component").equals(((ComponentFactory)factory).getComponentClassName())) continue;
                Factory fact = factory;
                this.createInstance(fact, this.m_configurations[i]);
            }
            return;
        }
        for (int i = 0; i < this.m_configurations.length; ++i) {
            if (this.m_configurations[i].getInstance() == null || !this.m_configurations[i].getFactory().equals(factory.getName())) continue;
            this.m_configurations[i].setInstance(null);
            this.m_configurations[i].setFactory(null);
        }
    }

    public boolean addingService(ServiceReference ref) {
        String factoryName = (String)ref.getProperty("factory.name");
        String componentClass = (String)ref.getProperty("component.class");
        boolean isValid = ((String)ref.getProperty("factory.state")).equals("1");
        Factory fact = (Factory)this.m_tracker.getService(ref);
        boolean used = false;
        if (isValid) {
            for (int i = 0; i < this.m_configurations.length; ++i) {
                if (this.m_configurations[i].getInstance() != null || !this.m_configurations[i].getConfiguration().get("component").equals(factoryName) && !this.m_configurations[i].getConfiguration().get("component").equals(componentClass)) continue;
                this.createInstance(fact, this.m_configurations[i]);
                used = true;
            }
        }
        return used;
    }

    public void addedService(ServiceReference ref) {
    }

    public void modifiedService(ServiceReference ref, Object obj) {
    }

    public void removedService(ServiceReference ref, Object obj) {
        String name = (String)ref.getProperty("factory.name");
        if (name == null) {
            return;
        }
        for (int i = 0; i < this.m_configurations.length; ++i) {
            if (this.m_configurations[i].getFactory() == null || !this.m_configurations[i].getFactory().equals(name)) continue;
            if (this.m_configurations[i].getInstance() != null) {
                this.m_configurations[i].getInstance().dispose();
                this.m_configurations[i].setInstance(null);
            }
            this.m_configurations[i].setFactory(null);
        }
        this.m_tracker.ungetService(ref);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ManagedConfiguration {
        private Dictionary m_configuration;
        private String m_factoryName;
        private ComponentInstance m_instance;

        ManagedConfiguration(Dictionary conf) {
            this.m_configuration = conf;
        }

        Dictionary getConfiguration() {
            return this.m_configuration;
        }

        String getFactory() {
            return this.m_factoryName;
        }

        ComponentInstance getInstance() {
            return this.m_instance;
        }

        void setFactory(String name) {
            this.m_factoryName = name;
        }

        void setInstance(ComponentInstance instance) {
            this.m_instance = instance;
        }
    }
}

