/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.service.instantiator;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.CompositeHandler;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.composite.service.instantiator.SvcInstance;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.osgi.framework.ServiceReference;

public class ServiceInstantiatorDescription
extends HandlerDescription {
    private List m_instances;

    public ServiceInstantiatorDescription(CompositeHandler h, List insts) {
        super(h);
        this.m_instances = insts;
    }

    public Element getHandlerInfo() {
        Element services = super.getHandlerInfo();
        for (int i = 0; i < this.m_instances.size(); ++i) {
            SvcInstance inst = (SvcInstance)this.m_instances.get(i);
            Element service = new Element("Service", "");
            service.addAttribute(new Attribute("Specification", inst.getSpecification()));
            String state = "unresolved";
            if (inst.isSatisfied()) {
                state = "resolved";
            }
            service.addAttribute(new Attribute("State", state));
            Map map = inst.getUsedReferences();
            Set keys = map.keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                ServiceReference ref = (ServiceReference)it.next();
                Object o = map.get(ref);
                if (o == null) continue;
                Element fact = new Element("Factory", "");
                fact.addAttribute(new Attribute("Name", ((ComponentInstance)o).getFactory().getName()));
                service.addElement(fact);
            }
            services.addElement(service);
        }
        return services;
    }
}

