/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.dependency;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.felix.ipojo.IPojoContext;
import org.apache.felix.ipojo.PolicyServiceContext;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.composite.CompositeServiceContext;
import org.apache.felix.ipojo.handlers.dependency.DependencyCallback;
import org.apache.felix.ipojo.handlers.dependency.DependencyHandler;
import org.apache.felix.ipojo.handlers.dependency.NullableObject;
import org.apache.felix.ipojo.handlers.dependency.ServiceUsage;
import org.apache.felix.ipojo.util.ServiceReferenceRankingComparator;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class Dependency
implements TrackerCustomizer {
    public static final int RESOLVED = 1;
    public static final int UNRESOLVED = 2;
    public static final int BROKEN = 3;
    public static final int DYNAMIC_POLICY = 0;
    public static final int DYNAMIC_PRIORITY_POLICY = 1;
    public static final int STATIC_POLICY = 2;
    private DependencyHandler m_handler;
    private String m_field;
    private DependencyCallback[] m_callbacks = new DependencyCallback[0];
    private String m_specification;
    private String m_id;
    private boolean m_isAggregate = false;
    private boolean m_isOptional = false;
    private String m_strFilter;
    private boolean m_isServiceLevelRequirement = false;
    private int m_policy = 1;
    private List m_references = new ArrayList();
    private List m_usedReferences = new ArrayList();
    private int m_state;
    private Class m_clazz;
    private Filter m_filter;
    private ServiceContext m_serviceContext;
    private ServiceUsage m_usage = new ServiceUsage();
    private Tracker m_tracker;
    private boolean m_activated = false;
    private int m_bindingPolicy;
    private Object m_nullable;
    private String m_di;
    static /* synthetic */ Class class$org$apache$felix$ipojo$Nullable;

    public Dependency(DependencyHandler dh, String field, String spec, String filter, boolean isOptional, boolean isAggregate, String id, int policy, int bindingPolicy, String di) {
        this.m_handler = dh;
        this.m_field = field;
        this.m_specification = spec;
        this.m_isOptional = isOptional;
        this.m_di = di;
        this.m_strFilter = filter;
        this.m_isAggregate = isAggregate;
        this.m_id = this.m_id == null ? this.m_specification : id;
        if (policy != -1) {
            this.m_policy = policy;
        }
        this.m_bindingPolicy = bindingPolicy;
        if (!(this.m_policy != 1 && this.m_policy != 0 || ((IPojoContext)this.m_handler.getInstanceManager().getContext()).getServiceContext() instanceof CompositeServiceContext)) {
            this.m_policy = 2;
        }
    }

    public String getField() {
        return this.m_field;
    }

    public String getSpecification() {
        return this.m_specification;
    }

    public boolean isOptional() {
        return this.m_isOptional;
    }

    public boolean isAggregate() {
        return this.m_isAggregate;
    }

    protected void setAggregate() {
        this.m_isAggregate = true;
    }

    void activate() {
        if (this.m_bindingPolicy == 2) {
            this.m_activated = true;
        }
    }

    protected void setSpecification(String spec) {
        this.m_specification = spec;
    }

    protected void addDependencyCallback(DependencyCallback cb) {
        if (this.m_callbacks.length > 0) {
            DependencyCallback[] newCallbacks = new DependencyCallback[this.m_callbacks.length + 1];
            System.arraycopy(this.m_callbacks, 0, newCallbacks, 0, this.m_callbacks.length);
            newCallbacks[this.m_callbacks.length] = cb;
            this.m_callbacks = newCallbacks;
        } else {
            this.m_callbacks = new DependencyCallback[]{cb};
        }
    }

    public String getFilter() {
        if (this.m_strFilter == null) {
            return "";
        }
        return this.m_strFilter;
    }

    public DependencyHandler getHandler() {
        return this.m_handler;
    }

    public List getUsedServices() {
        return this.m_usedReferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object get() {
        if (this.m_usage.getObjects().isEmpty()) {
            if (this.isAggregate()) {
                Tracker tracker = this.m_tracker;
                synchronized (tracker) {
                    for (int i = 0; i < this.m_references.size(); ++i) {
                        ServiceReference ref = (ServiceReference)this.m_references.get(i);
                        this.m_usage.getReferences().add(ref);
                        this.m_usage.getObjects().add(this.getService(ref));
                    }
                }
            } else if (this.m_references.size() == 0) {
                if (this.m_nullable == null) {
                    this.m_handler.log(2, "[" + this.m_handler.getInstanceManager().getInstanceName() + "] The dependency is not optional, however no service object can be injected in " + this.m_field + " -> " + this.m_specification);
                    return null;
                }
                this.m_usage.getObjects().add(this.m_nullable);
            } else {
                ServiceReference ref = (ServiceReference)this.m_references.get(0);
                this.m_usage.getReferences().add(ref);
                this.m_usage.getObjects().add(this.getService(ref));
            }
            this.m_usage.setStackLevel(1);
        }
        if (this.m_isAggregate) {
            return this.m_usage.getObjects().toArray((Object[])Array.newInstance(this.m_clazz, this.m_usage.getObjects().size()));
        }
        return this.m_usage.getObjects().get(0);
    }

    private void callUnbindMethod(ServiceReference ref) {
        if (this.m_handler.getInstanceManager().getState() > 0 && this.m_handler.getInstanceManager().getPojoObjects() != null) {
            for (int i = 0; i < this.m_callbacks.length; ++i) {
                if (this.m_callbacks[i].getMethodType() != 1) continue;
                try {
                    this.m_callbacks[i].call(ref, this.getService(ref));
                    continue;
                }
                catch (NoSuchMethodException e) {
                    this.m_handler.log(1, "The method " + this.m_callbacks[i].getMethodName() + " does not exist in the class " + this.m_handler.getInstanceManager().getClassName());
                    this.m_handler.getInstanceManager().stop();
                    continue;
                }
                catch (IllegalAccessException e) {
                    this.m_handler.log(1, "The method " + this.m_callbacks[i].getMethodName() + " is not accessible in the class " + this.m_handler.getInstanceManager().getClassName());
                    this.m_handler.getInstanceManager().stop();
                    continue;
                }
                catch (InvocationTargetException e) {
                    this.m_handler.log(1, "The method " + this.m_callbacks[i].getMethodName() + " in the class " + this.m_handler.getInstanceManager().getClassName() + "throws an exception : " + e.getTargetException().getMessage());
                    this.m_handler.getInstanceManager().stop();
                }
            }
        }
    }

    private synchronized Object getService(ServiceReference ref) {
        if (!this.m_usedReferences.contains(ref)) {
            this.m_usedReferences.add(ref);
        }
        return this.m_tracker.getService(ref);
    }

    private void ungetService(ServiceReference ref) {
        this.m_tracker.ungetService(ref);
    }

    protected synchronized void callBindMethod(Object instance) {
        if (this.m_tracker == null) {
            return;
        }
        if (this.m_isOptional && this.m_references.size() == 0) {
            return;
        }
        if (this.m_isAggregate) {
            for (int i = 0; i < this.m_references.size(); ++i) {
                ServiceReference ref = (ServiceReference)this.m_references.get(i);
                for (int j = 0; j < this.m_callbacks.length; ++j) {
                    if (this.m_callbacks[j].getMethodType() != 0) continue;
                    try {
                        this.m_callbacks[j].callOnInstance(instance, ref, this.getService(ref));
                        continue;
                    }
                    catch (NoSuchMethodException e) {
                        this.m_handler.log(1, "The method " + this.m_callbacks[j].getMethodName() + " does not exist in the class " + this.m_handler.getInstanceManager().getClassName());
                        this.m_handler.getInstanceManager().stop();
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        this.m_handler.log(1, "The method " + this.m_callbacks[j].getMethodName() + " is not accessible in the class " + this.m_handler.getInstanceManager().getClassName());
                        this.m_handler.getInstanceManager().stop();
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        this.m_handler.log(1, "The method " + this.m_callbacks[j].getMethodName() + " in the class " + this.m_handler.getInstanceManager().getClassName() + "throws an exception : " + e.getTargetException().getMessage());
                        this.m_handler.getInstanceManager().setState(1);
                    }
                }
            }
        } else {
            for (int j = 0; j < this.m_callbacks.length; ++j) {
                if (this.m_callbacks[j].getMethodType() != 0) continue;
                try {
                    ServiceReference ref = (ServiceReference)this.m_references.get(0);
                    if (ref == null) continue;
                    this.m_callbacks[j].callOnInstance(instance, ref, this.getService(ref));
                    continue;
                }
                catch (NoSuchMethodException e) {
                    this.m_handler.log(1, "The method " + this.m_callbacks[j].getMethodName() + " does not exist in the class " + this.m_handler.getInstanceManager().getClassName());
                    this.m_handler.getInstanceManager().stop();
                    continue;
                }
                catch (IllegalAccessException e) {
                    this.m_handler.log(1, "The method " + this.m_callbacks[j].getMethodName() + " is not accessible in the class " + this.m_handler.getInstanceManager().getClassName());
                    this.m_handler.getInstanceManager().stop();
                    continue;
                }
                catch (InvocationTargetException e) {
                    this.m_handler.log(1, "The method " + this.m_callbacks[j].getMethodName() + " in the class " + this.m_handler.getInstanceManager().getClassName() + "throws an exception : " + e.getTargetException().getMessage());
                    this.m_handler.getInstanceManager().setState(1);
                }
            }
        }
    }

    private void callBindMethod(ServiceReference ref) {
        if (this.m_handler.getInstanceManager().getState() > 0 && this.m_handler.getInstanceManager().getPojoObjects() != null) {
            for (int i = 0; i < this.m_callbacks.length; ++i) {
                if (this.m_callbacks[i].getMethodType() != 0) continue;
                try {
                    this.m_callbacks[i].call(ref, this.getService(ref));
                    this.ungetService(ref);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    this.m_handler.log(1, "The method " + this.m_callbacks[i].getMethodName() + " does not exist in the class " + this.m_handler.getInstanceManager().getClassName());
                    this.m_handler.getInstanceManager().stop();
                    continue;
                }
                catch (IllegalAccessException e) {
                    this.m_handler.log(1, "The method " + this.m_callbacks[i].getMethodName() + " is not accessible in the class " + this.m_handler.getInstanceManager().getClassName());
                    this.m_handler.getInstanceManager().stop();
                    continue;
                }
                catch (InvocationTargetException e) {
                    this.m_handler.log(1, "The method " + this.m_callbacks[i].getMethodName() + " in the class " + this.m_handler.getInstanceManager().getClassName() + "throws an exception : " + e.getTargetException().getMessage());
                    this.m_handler.getInstanceManager().setState(1);
                }
            }
        }
    }

    public void start() {
        this.m_serviceContext = new PolicyServiceContext(this.m_handler.getInstanceManager().getGlobalContext(), this.m_handler.getInstanceManager().getLocalServiceContext(), this.m_policy);
        String filter = "(objectClass=" + this.m_specification + ")";
        if (this.m_strFilter != null) {
            filter = "(&" + filter + this.m_strFilter + ")";
        }
        try {
            this.m_clazz = this.m_handler.getInstanceManager().getContext().getBundle().loadClass(this.m_specification);
        }
        catch (ClassNotFoundException e) {
            this.m_handler.log(1, "Cannot load the interface class for the dependency " + this.m_field + " [" + this.m_specification + "]");
        }
        if (this.m_isOptional) {
            if (this.m_di != null) {
                try {
                    Class c = this.getHandler().getInstanceManager().getContext().getBundle().loadClass(this.m_di);
                    this.m_nullable = c.newInstance();
                }
                catch (IllegalAccessException e) {
                    this.m_handler.log(1, "Cannot load the default-implementation " + this.m_di + " : " + e.getMessage());
                }
                catch (InstantiationException e) {
                    this.m_handler.log(1, "Cannot load the default-implementation " + this.m_di + " : " + e.getMessage());
                }
                catch (ClassNotFoundException e) {
                    this.m_handler.log(1, "Cannot load the default-implementation " + this.m_di + " : " + e.getMessage());
                }
            } else {
                this.m_nullable = Proxy.newProxyInstance(this.getHandler().getInstanceManager().getClazz().getClassLoader(), new Class[]{this.m_clazz, class$org$apache$felix$ipojo$Nullable == null ? (class$org$apache$felix$ipojo$Nullable = Dependency.class$("org.apache.felix.ipojo.Nullable")) : class$org$apache$felix$ipojo$Nullable}, (InvocationHandler)new NullableObject());
            }
        }
        this.m_state = 2;
        try {
            this.m_filter = this.m_handler.getInstanceManager().getContext().createFilter(filter);
        }
        catch (InvalidSyntaxException e1) {
            this.m_handler.log(1, "[" + this.m_handler.getInstanceManager().getClassName() + "] A filter is malformed : " + filter + " - " + e1.getMessage());
            this.m_handler.getInstanceManager().stop();
        }
        this.m_tracker = new Tracker((BundleContext)this.m_serviceContext, this.m_filter, (TrackerCustomizer)this);
        this.m_tracker.open();
        this.m_state = this.m_tracker.size() == 0 && !this.m_isOptional ? 2 : 1;
    }

    public void stop() {
        if (this.m_tracker != null) {
            this.m_tracker.close();
            this.m_tracker = null;
        }
        this.m_state = 2;
        this.m_activated = false;
        this.m_references.clear();
        this.m_usedReferences.clear();
        this.m_clazz = null;
    }

    public int getState() {
        return this.m_state;
    }

    public List getServiceReferences() {
        return this.m_references;
    }

    protected DependencyCallback[] getCallbacks() {
        return this.m_callbacks;
    }

    public void setServiceLevelDependency() {
        this.m_isServiceLevelRequirement = true;
        this.m_policy = 0;
    }

    public String getId() {
        return this.m_id;
    }

    public boolean isServiceLevelRequirement() {
        return this.m_isServiceLevelRequirement;
    }

    public void entry(String method) {
        if (!this.m_usage.getObjects().isEmpty()) {
            int level = this.m_usage.getStackLevel();
            this.m_usage.setStackLevel(level++);
        }
    }

    public void exit(String method) {
        if (!this.m_usage.getObjects().isEmpty()) {
            int level = this.m_usage.getStackLevel();
            if (--level == 0) {
                this.m_usage.getObjects().clear();
                List refs = this.m_usage.getReferences();
                refs.clear();
            }
        }
    }

    public boolean addingService(ServiceReference ref) {
        return !this.m_activated;
    }

    public void addedService(ServiceReference reference) {
        this.m_references.add(reference);
        if (this.m_bindingPolicy == 1) {
            Collections.sort(this.m_references, new ServiceReferenceRankingComparator());
        }
        this.m_state = 1;
        if (this.m_isAggregate || this.m_references.size() == 1) {
            this.callBindMethod(reference);
        }
        this.m_handler.checkContext();
    }

    public void modifiedService(ServiceReference ref, Object arg1) {
    }

    public void removedService(ServiceReference ref, Object arg1) {
        boolean hasChanged = false;
        this.m_references.remove(ref);
        if (this.m_usedReferences.remove(ref)) {
            this.callUnbindMethod(ref);
            if (this.m_field != null) {
                this.m_handler.getInstanceManager().setterCallback(this.m_field, null);
            }
            this.ungetService(ref);
            hasChanged = true;
        }
        if (this.m_bindingPolicy == 2) {
            if (hasChanged && this.m_activated) {
                this.m_state = 3;
            }
        } else {
            this.m_state = this.m_references.size() == 0 && !this.m_isOptional ? 2 : 1;
            if (!this.m_isAggregate && hasChanged && this.m_references.size() != 0) {
                this.callBindMethod(this.m_references.get(0));
            }
        }
        this.m_handler.checkContext();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

