/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.manipulation.ConstructorCodeAdapter;
import org.apache.felix.ipojo.manipulation.FieldAdapter;
import org.apache.felix.ipojo.manipulation.MethodCodeAdapter;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class PojoAdapter
extends ClassAdapter
implements Opcodes {
    private final String m_pojo = "org/apache/felix/ipojo/Pojo";
    private String m_owner;
    private Set m_fields;
    private List m_methods = new ArrayList();
    private FieldAdapter m_getterSetterCreator = new FieldAdapter(this.cv);

    public PojoAdapter(ClassVisitor arg0, Map fields) {
        super(arg0);
        this.m_fields = fields.keySet();
    }

    public void visit(int version2, int access, String name, String signature, String superName, String[] interfaces) {
        this.m_owner = name;
        this.m_getterSetterCreator.visit(version2, access, name, signature, superName, interfaces);
        this.addCMField();
        this.addPOJOInterface(version2, access, name, signature, superName, interfaces);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return super.visitAnnotation(desc, visible);
    }

    public void visitAttribute(Attribute attr) {
        super.visitAttribute(attr);
    }

    public void visitEnd() {
        this.createComponentManagerSetter();
        this.createGetComponentInstanceMethod();
        this.m_methods.clear();
        this.cv.visitEnd();
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ((access & 8) == 0 && !name.startsWith("class$")) {
            this.addFlagField(name);
            this.m_getterSetterCreator.visitField(access, name, desc, signature, value);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.equals("<clinit>") || name.equals("class$")) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if (name.equals("<init>")) {
            String newDesc = desc.substring(1);
            newDesc = "(Lorg/apache/felix/ipojo/InstanceManager;" + newDesc;
            MethodVisitor mv = super.visitMethod(1, "<init>", newDesc, null, null);
            Type[] args = Type.getArgumentTypes(newDesc);
            String id = "$init";
            for (int i = 0; i < args.length; ++i) {
                String cn = args[i].getClassName();
                if (cn.endsWith("[]")) {
                    cn = cn.replace('[', '$');
                    cn = cn.substring(0, cn.length() - 1);
                }
                cn = cn.replace('.', '_');
                id = id + cn;
            }
            String flag = "_M" + id;
            this.m_methods.add(id);
            FieldVisitor flagField = this.cv.visitField(2, flag, "Z", null, null);
            if (flagField != null) {
                flagField.visitEnd();
            }
            if (mv == null) {
                return null;
            }
            return new ConstructorCodeAdapter(mv, this.m_owner, this.m_fields, access, name, newDesc);
        }
        if ((access & 8) == 8) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        Type[] args = Type.getArgumentTypes(desc);
        String id = name;
        for (int i = 0; i < args.length; ++i) {
            String cn = args[i].getClassName();
            if (cn.endsWith("[]")) {
                cn = cn.replace('[', '$');
                cn = cn.substring(0, cn.length() - 1);
            }
            cn = cn.replace('.', '_');
            id = id + cn;
        }
        String flag = "_M" + id;
        this.m_methods.add(id);
        FieldVisitor flagField = this.cv.visitField(2, flag, "Z", null, null);
        if (flagField != null) {
            flagField.visitEnd();
        }
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        return new MethodCodeAdapter(mv, this.m_owner, access, name, desc, this.m_fields);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        super.visitOuterClass(owner, name, desc);
    }

    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
    }

    private void addCMField() {
        FieldVisitor fv = super.visitField(2, "_cm", "Lorg/apache/felix/ipojo/InstanceManager;", null, null);
        fv.visitEnd();
    }

    private void addPOJOInterface(int version2, int access, String name, String signature, String superName, String[] interfaces) {
        String[] itfs;
        boolean found = false;
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].equals("org/apache/felix/ipojo/Pojo")) continue;
            found = true;
        }
        if (!found) {
            itfs = new String[interfaces.length + 1];
            for (int i = 0; i < interfaces.length; ++i) {
                itfs[i] = interfaces[i];
            }
            itfs[interfaces.length] = "org/apache/felix/ipojo/Pojo";
        } else {
            itfs = interfaces;
        }
        String str = "";
        for (int i = 0; i < itfs.length; ++i) {
            str = str + itfs[i] + " ";
        }
        this.cv.visit(version2, access, name, signature, superName, itfs);
    }

    private void createComponentManagerSetter() {
        MethodVisitor mv = this.cv.visitMethod(2, "_setComponentManager", "(Lorg/apache/felix/ipojo/InstanceManager;)V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, this.m_owner, "_cm", "Lorg/apache/felix/ipojo/InstanceManager;");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_owner, "_cm", "Lorg/apache/felix/ipojo/InstanceManager;");
        mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", "getRegistredFields", "()Ljava/util/Set;");
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 2);
        Label endif = new Label();
        mv.visitJumpInsn(198, endif);
        Iterator it = this.m_fields.iterator();
        while (it.hasNext()) {
            String field = (String)it.next();
            mv.visitVarInsn(25, 2);
            mv.visitLdcInsn(field);
            mv.visitMethodInsn(185, "java/util/Set", "contains", "(Ljava/lang/Object;)Z");
            Label l3 = new Label();
            mv.visitJumpInsn(153, l3);
            mv.visitVarInsn(25, 0);
            mv.visitInsn(4);
            mv.visitFieldInsn(181, this.m_owner, "_F" + field, "Z");
            mv.visitLabel(l3);
        }
        mv.visitLabel(endif);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_owner, "_cm", "Lorg/apache/felix/ipojo/InstanceManager;");
        mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", "getRegistredMethods", "()Ljava/util/Set;");
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 2);
        Label endif2 = new Label();
        mv.visitJumpInsn(198, endif2);
        for (int i = 0; i < this.m_methods.size(); ++i) {
            String methodId = (String)this.m_methods.get(i);
            mv.visitVarInsn(25, 2);
            mv.visitLdcInsn(methodId);
            mv.visitMethodInsn(185, "java/util/Set", "contains", "(Ljava/lang/Object;)Z");
            Label l3 = new Label();
            mv.visitJumpInsn(153, l3);
            mv.visitVarInsn(25, 0);
            mv.visitInsn(4);
            mv.visitFieldInsn(181, this.m_owner, "_M" + methodId, "Z");
            mv.visitLabel(l3);
        }
        mv.visitLabel(endif2);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createGetComponentInstanceMethod() {
        MethodVisitor mv = this.cv.visitMethod(1, "getComponentInstance", "()Lorg/apache/felix/ipojo/ComponentInstance;", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_owner, "_cm", "Lorg/apache/felix/ipojo/InstanceManager;");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void addFlagField(String name) {
        FieldVisitor flag = this.cv.visitField(2, "_F" + name, "Z", null, null);
        if (flag != null) {
            flag.visitEnd();
        }
    }
}

