/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.cvslib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.AbstractCvsTask;
import org.apache.tools.ant.taskdefs.cvslib.CVSEntry;
import org.apache.tools.ant.taskdefs.cvslib.ChangeLogParser;
import org.apache.tools.ant.taskdefs.cvslib.ChangeLogWriter;
import org.apache.tools.ant.taskdefs.cvslib.CvsUser;
import org.apache.tools.ant.taskdefs.cvslib.CvsVersion;
import org.apache.tools.ant.taskdefs.cvslib.RedirectingStreamHandler;
import org.apache.tools.ant.types.FileSet;

public class ChangeLogTask
extends AbstractCvsTask {
    private File m_usersFile;
    private Vector m_cvsUsers = new Vector();
    private File m_dir;
    private File m_destfile;
    private Date m_start;
    private Date m_stop;
    private final Vector m_filesets = new Vector();

    public void setDir(File dir2) {
        this.m_dir = dir2;
    }

    public void setDestfile(File destfile) {
        this.m_destfile = destfile;
    }

    public void setUsersfile(File usersFile) {
        this.m_usersFile = usersFile;
    }

    public void addUser(CvsUser user) {
        this.m_cvsUsers.addElement(user);
    }

    public void setStart(Date start) {
        this.m_start = start;
    }

    public void setEnd(Date stop) {
        this.m_stop = stop;
    }

    public void setDaysinpast(int days) {
        long time = System.currentTimeMillis() - (long)days * 24L * 60L * 60L * 1000L;
        this.setStart(new Date(time));
    }

    public void addFileset(FileSet fileSet) {
        this.m_filesets.addElement(fileSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        File savedDir = this.m_dir;
        try {
            ChangeLogParser parser2;
            Properties userList;
            block13: {
                String errors2;
                block12: {
                    Enumeration e;
                    this.validate();
                    userList = new Properties();
                    this.loadUserlist(userList);
                    Enumeration e2 = this.m_cvsUsers.elements();
                    while (true) {
                        if (!e2.hasMoreElements()) {
                            this.setCommand("log");
                            if (this.getTag() != null) {
                                CvsVersion myCvsVersion = new CvsVersion();
                                myCvsVersion.setProject(this.getProject());
                                myCvsVersion.setTaskName("cvsversion");
                                myCvsVersion.setCvsRoot(this.getCvsRoot());
                                myCvsVersion.setCvsRsh(this.getCvsRsh());
                                myCvsVersion.setPassfile(this.getPassFile());
                                myCvsVersion.setDest(this.m_dir);
                                myCvsVersion.execute();
                                if (myCvsVersion.supportsCvsLogWithSOption()) {
                                    this.addCommandArgument("-S");
                                }
                            }
                            if (null != this.m_start) {
                                SimpleDateFormat outputDate = new SimpleDateFormat("yyyy-MM-dd");
                                String dateRange = ">=" + outputDate.format(this.m_start);
                                this.addCommandArgument("-d");
                                this.addCommandArgument(dateRange);
                            }
                            if (!this.m_filesets.isEmpty()) {
                                e = this.m_filesets.elements();
                                break;
                            }
                            break block12;
                        }
                        CvsUser user = (CvsUser)e2.nextElement();
                        user.validate();
                        userList.put(user.getUserID(), user.getDisplayname());
                    }
                    while (e.hasMoreElements()) {
                        FileSet fileSet = (FileSet)e.nextElement();
                        DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
                        String[] files = scanner.getIncludedFiles();
                        int i = 0;
                        while (i < files.length) {
                            this.addCommandArgument(files[i]);
                            ++i;
                        }
                    }
                }
                parser2 = new ChangeLogParser();
                RedirectingStreamHandler handler = new RedirectingStreamHandler(parser2);
                this.log(this.getCommand(), 3);
                this.setDest(this.m_dir);
                this.setExecuteStreamHandler(handler);
                try {
                    super.execute();
                    Object var10_9 = null;
                    errors2 = handler.getErrors();
                    if (null == errors2) break block13;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    String errors2 = handler.getErrors();
                    if (null == errors2) throw throwable;
                    this.log(errors2, 0);
                    throw throwable;
                }
                this.log(errors2, 0);
            }
            CVSEntry[] entrySet = parser2.getEntrySetAsArray();
            CVSEntry[] filteredEntrySet = this.filterEntrySet(entrySet);
            this.replaceAuthorIdWithName(userList, filteredEntrySet);
            this.writeChangeLog(filteredEntrySet);
            Object var13_15 = null;
            this.m_dir = savedDir;
            return;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            this.m_dir = savedDir;
            throw throwable;
        }
    }

    private void validate() throws BuildException {
        if (null == this.m_dir) {
            this.m_dir = this.getProject().getBaseDir();
        }
        if (null == this.m_destfile) {
            String message = "Destfile must be set.";
            throw new BuildException("Destfile must be set.");
        }
        if (!this.m_dir.exists()) {
            String message = "Cannot find base dir " + this.m_dir.getAbsolutePath();
            throw new BuildException(message);
        }
        if (null != this.m_usersFile && !this.m_usersFile.exists()) {
            String message = "Cannot find user lookup list " + this.m_usersFile.getAbsolutePath();
            throw new BuildException(message);
        }
    }

    private void loadUserlist(Properties userList) throws BuildException {
        if (null != this.m_usersFile) {
            try {
                userList.load(new FileInputStream(this.m_usersFile));
            }
            catch (IOException ioe) {
                throw new BuildException(ioe.toString(), ioe);
            }
        }
    }

    private CVSEntry[] filterEntrySet(CVSEntry[] entrySet) {
        Vector<CVSEntry> results = new Vector<CVSEntry>();
        int i = 0;
        while (i < entrySet.length) {
            CVSEntry cvsEntry = entrySet[i];
            Date date = cvsEntry.getDate();
            if (!(null != this.m_start && this.m_start.after(date) || null != this.m_stop && this.m_stop.before(date))) {
                results.addElement(cvsEntry);
            }
            ++i;
        }
        Object[] resultArray = new CVSEntry[results.size()];
        results.copyInto(resultArray);
        return resultArray;
    }

    private void replaceAuthorIdWithName(Properties userList, CVSEntry[] entrySet) {
        int i = 0;
        while (i < entrySet.length) {
            CVSEntry entry = entrySet[i];
            if (userList.containsKey(entry.getAuthor())) {
                entry.setAuthor(userList.getProperty(entry.getAuthor()));
            }
            ++i;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeChangeLog(CVSEntry[] entrySet) throws BuildException {
        FileOutputStream output = null;
        output = new FileOutputStream(this.m_destfile);
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)output, "UTF-8"));
        ChangeLogWriter serializer = new ChangeLogWriter();
        serializer.printChangeLog(writer, entrySet);
        Object var6_7 = null;
        if (null == output) return;
        try {
            output.close();
            return;
        }
        catch (IOException ioe) {}
        return;
        {
            catch (UnsupportedEncodingException uee) {
                this.getProject().log(uee.toString(), 0);
                Object var6_8 = null;
                if (null == output) return;
                try {
                    output.close();
                    return;
                }
                catch (IOException ioe) {}
                return;
            }
            catch (IOException ioe) {
                throw new BuildException(ioe.toString(), ioe);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (null == output) throw throwable;
            try {
                output.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

