/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.test;

import java.io.FileInputStream;
import java.util.Properties;
import junit.framework.TestSuite;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.test.TemplateTestBase;
import org.apache.velocity.test.TemplateTestCase;

public class TemplateTestSuite
extends TestSuite
implements TemplateTestBase {
    private Properties testProperties;

    public TemplateTestSuite() {
        try {
            Velocity.setProperty("file.resource.loader.path", "../test/templates");
            Velocity.setProperty("runtime.log.error.stacktrace", "true");
            Velocity.setProperty("runtime.log.warn.stacktrace", "true");
            Velocity.setProperty("runtime.log.info.stacktrace", "true");
            Velocity.init();
            this.testProperties = new Properties();
            this.testProperties.load(new FileInputStream("../test/templates/templates.properties"));
        }
        catch (Exception e) {
            System.err.println("Cannot setup TemplateTestSuite!");
            e.printStackTrace();
            System.exit(1);
        }
        this.addTemplateTestCases();
    }

    private void addTemplateTestCases() {
        String template;
        int i = 1;
        while ((template = this.testProperties.getProperty(TemplateTestSuite.getTemplateTestKey(i))) != null) {
            System.out.println("Adding TemplateTestCase : " + template);
            this.addTest(new TemplateTestCase(template));
            ++i;
        }
    }

    private static final String getTemplateTestKey(int nbr) {
        return "test.template." + nbr;
    }
}

