/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.Map;
import net.sf.swarmcache.ObjectCache;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;

public class SwarmCache
implements Cache {
    private final ObjectCache cache;
    private final String regionName;

    public SwarmCache(ObjectCache cache, String regionName) {
        this.cache = cache;
        this.regionName = regionName;
    }

    public Object get(Object key) throws CacheException {
        if (key instanceof Serializable) {
            return this.cache.get((Serializable)key);
        }
        throw new CacheException("Keys must implement Serializable");
    }

    public Object read(Object key) throws CacheException {
        return this.get(key);
    }

    public void update(Object key, Object value) throws CacheException {
        this.put(key, value);
    }

    public void put(Object key, Object value) throws CacheException {
        if (!(key instanceof Serializable)) {
            throw new CacheException("Keys must implement Serializable");
        }
        this.cache.put((Serializable)key, value);
    }

    public void remove(Object key) throws CacheException {
        if (!(key instanceof Serializable)) {
            throw new CacheException("Keys must implement Serializable");
        }
        this.cache.clear((Serializable)key);
    }

    public void clear() throws CacheException {
        this.cache.clearAll();
    }

    public void destroy() throws CacheException {
        this.cache.clearAll();
    }

    public void lock(Object key) throws CacheException {
        throw new UnsupportedOperationException("SwarmCache does not support locking (use nonstrict-read-write)");
    }

    public void unlock(Object key) throws CacheException {
        throw new UnsupportedOperationException("SwarmCache does not support locking (use nonstrict-read-write)");
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return 600;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        return -1L;
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public Map toMap() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "SwarmCache(" + this.regionName + ')';
    }
}

