/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.LazyToOne;
import org.hibernate.annotations.LazyToOneOption;
import org.hibernate.annotations.MapKey;
import org.hibernate.annotations.MapKeyManyToMany;
import org.hibernate.annotations.NamedNativeQueries;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Parent;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.Tables;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Tuplizer;
import org.hibernate.annotations.Tuplizers;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.annotations.Where;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XPackage;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.CreateKeySecondPass;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3DiscriminatorColumn;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.cfg.IndexColumn;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.cfg.OneToOneSecondPass;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.PropertyInferredData;
import org.hibernate.cfg.PropertyPreloadedData;
import org.hibernate.cfg.WrappedInferredData;
import org.hibernate.cfg.annotations.CollectionBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.cfg.annotations.PropertyBinder;
import org.hibernate.cfg.annotations.QueryBinder;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.id.MultipleHiLoPerTableGenerator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationBinder {
    private static final Log log = LogFactory.getLog(AnnotationBinder.class);

    private AnnotationBinder() {
    }

    public static void bindDefaults(ExtendedMappings mappings) {
        IdGenerator idGen;
        Map defaults = mappings.getReflectionManager().getDefaults();
        List anns = (List)defaults.get(SequenceGenerator.class);
        if (anns != null) {
            for (Annotation ann : anns) {
                idGen = AnnotationBinder.buildIdGenerator(ann, mappings);
                if (idGen == null) continue;
                mappings.addDefaultGenerator(idGen);
            }
        }
        if ((anns = (List)defaults.get(TableGenerator.class)) != null) {
            for (Annotation ann : anns) {
                idGen = AnnotationBinder.buildIdGenerator(ann, mappings);
                if (idGen == null) continue;
                mappings.addDefaultGenerator(idGen);
            }
        }
        if ((anns = (List)defaults.get(NamedQuery.class)) != null) {
            for (Annotation ann : anns) {
                QueryBinder.bindQuery((NamedQuery)ann, mappings, true);
            }
        }
        if ((anns = (List)defaults.get(javax.persistence.NamedNativeQuery.class)) != null) {
            for (Annotation ann : anns) {
                QueryBinder.bindNativeQuery((javax.persistence.NamedNativeQuery)ann, mappings, true);
            }
        }
        if ((anns = (List)defaults.get(SqlResultSetMapping.class)) != null) {
            for (Annotation ann : anns) {
                QueryBinder.bindSqlResultsetMapping((SqlResultSetMapping)ann, mappings, true);
            }
        }
    }

    public static void bindPackage(String packageName, ExtendedMappings mappings) {
        IdGenerator idGen;
        Annotation ann;
        XPackage pckg = null;
        try {
            pckg = mappings.getReflectionManager().packageForName(packageName);
        }
        catch (ClassNotFoundException cnf) {
            log.warn("Package not found or wo package-info.java: " + packageName);
            return;
        }
        if (pckg.isAnnotationPresent(SequenceGenerator.class)) {
            ann = pckg.getAnnotation(SequenceGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator(ann, mappings);
            mappings.addGenerator(idGen);
            log.debug("Add sequence generator with name: " + idGen.getName());
        }
        if (pckg.isAnnotationPresent(TableGenerator.class)) {
            ann = pckg.getAnnotation(TableGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator(ann, mappings);
            mappings.addGenerator(idGen);
        }
        if (pckg.isAnnotationPresent(GenericGenerator.class)) {
            ann = pckg.getAnnotation(GenericGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator(ann, mappings);
            mappings.addGenerator(idGen);
        }
        AnnotationBinder.bindQueries(pckg, mappings);
        AnnotationBinder.bindFilterDefs(pckg, mappings);
        AnnotationBinder.bindTypeDefs(pckg, mappings);
    }

    private static void bindQueries(XAnnotatedElement annotatedElement, ExtendedMappings mappings) {
        Annotation ann = annotatedElement.getAnnotation(SqlResultSetMapping.class);
        QueryBinder.bindSqlResultsetMapping((SqlResultSetMapping)ann, mappings, false);
        ann = annotatedElement.getAnnotation(SqlResultSetMappings.class);
        if (ann != null) {
            for (SqlResultSetMapping current : ann.value()) {
                QueryBinder.bindSqlResultsetMapping(current, mappings, false);
            }
        }
        ann = annotatedElement.getAnnotation(NamedQuery.class);
        QueryBinder.bindQuery((NamedQuery)ann, mappings, false);
        ann = annotatedElement.getAnnotation(org.hibernate.annotations.NamedQuery.class);
        QueryBinder.bindQuery((org.hibernate.annotations.NamedQuery)ann, mappings);
        ann = annotatedElement.getAnnotation(javax.persistence.NamedQueries.class);
        QueryBinder.bindQueries((javax.persistence.NamedQueries)ann, mappings, false);
        ann = annotatedElement.getAnnotation(NamedQueries.class);
        QueryBinder.bindQueries((NamedQueries)ann, mappings);
        ann = annotatedElement.getAnnotation(javax.persistence.NamedNativeQuery.class);
        QueryBinder.bindNativeQuery((javax.persistence.NamedNativeQuery)ann, mappings, false);
        ann = annotatedElement.getAnnotation(NamedNativeQuery.class);
        QueryBinder.bindNativeQuery((NamedNativeQuery)ann, mappings);
        ann = annotatedElement.getAnnotation(javax.persistence.NamedNativeQueries.class);
        QueryBinder.bindNativeQueries((javax.persistence.NamedNativeQueries)ann, mappings, false);
        ann = annotatedElement.getAnnotation(NamedNativeQueries.class);
        QueryBinder.bindNativeQueries((NamedNativeQueries)ann, mappings);
    }

    private static IdGenerator buildIdGenerator(Annotation ann, Mappings mappings) {
        IdGenerator idGen = new IdGenerator();
        if (mappings.getSchemaName() != null) {
            idGen.addParam("schema", mappings.getSchemaName());
        }
        if (mappings.getCatalogName() != null) {
            idGen.addParam("catalog", mappings.getCatalogName());
        }
        if (ann == null) {
            idGen = null;
        } else if (ann instanceof TableGenerator) {
            TableGenerator tabGen = (TableGenerator)ann;
            idGen.setName(tabGen.name());
            idGen.setIdentifierGeneratorStrategy(MultipleHiLoPerTableGenerator.class.getName());
            if (!BinderHelper.isDefault(tabGen.table())) {
                idGen.addParam("table", tabGen.table());
            }
            if (!BinderHelper.isDefault(tabGen.catalog())) {
                idGen.addParam("catalog", tabGen.catalog());
            }
            if (!BinderHelper.isDefault(tabGen.schema())) {
                idGen.addParam("schema", tabGen.schema());
            }
            if (!BinderHelper.isDefault(tabGen.pkColumnName())) {
                idGen.addParam("primary_key_column", tabGen.pkColumnName());
            }
            if (!BinderHelper.isDefault(tabGen.valueColumnName())) {
                idGen.addParam("value_column", tabGen.valueColumnName());
            }
            if (!BinderHelper.isDefault(tabGen.pkColumnValue())) {
                idGen.addParam("primary_key_value", tabGen.pkColumnValue());
            }
            idGen.addParam("max_lo", String.valueOf(tabGen.allocationSize() - 1));
            log.debug("Add table generator with name: " + idGen.getName());
        } else if (ann instanceof SequenceGenerator) {
            SequenceGenerator seqGen = (SequenceGenerator)ann;
            idGen.setName(seqGen.name());
            idGen.setIdentifierGeneratorStrategy("seqhilo");
            if (!BinderHelper.isDefault(seqGen.sequenceName())) {
                idGen.addParam("sequence", seqGen.sequenceName());
            }
            if (seqGen.initialValue() != 1) {
                log.warn("Hibernate does not support SequenceGenerator.initialValue()");
            }
            idGen.addParam("max_lo", String.valueOf(seqGen.allocationSize() - 1));
            log.debug("Add sequence generator with name: " + idGen.getName());
        } else if (ann instanceof GenericGenerator) {
            Parameter[] params;
            GenericGenerator genGen = (GenericGenerator)ann;
            idGen.setName(genGen.name());
            idGen.setIdentifierGeneratorStrategy(genGen.strategy());
            for (Parameter parameter : params = genGen.parameters()) {
                idGen.addParam(parameter.name(), parameter.value());
            }
            log.debug("Add generic generator with name: " + idGen.getName());
        } else {
            throw new AssertionFailure("Unknown Generator annotation: " + ann);
        }
        return idGen;
    }

    public static void bindClass(XClass clazzToProcess, Map<XClass, InheritanceState> inheritanceStatePerClass, ExtendedMappings mappings) throws MappingException {
        Filters filtersAnn;
        PersistentClass persistentClass;
        boolean hasJoinedColumns;
        InheritanceState superEntityState;
        PersistentClass superEntity;
        InheritanceState inheritanceState = inheritanceStatePerClass.get(clazzToProcess);
        AnnotatedClassType classType = mappings.getClassType(clazzToProcess);
        if (AnnotatedClassType.EMBEDDABLE_SUPERCLASS.equals((Object)classType) || AnnotatedClassType.NONE.equals((Object)classType) || AnnotatedClassType.EMBEDDABLE.equals((Object)classType)) {
            if (AnnotatedClassType.NONE.equals((Object)classType) && clazzToProcess.isAnnotationPresent(org.hibernate.annotations.Entity.class)) {
                log.warn("Class annotated @org.hibernate.annotations.Entity but not javax.persistence.Entity (most likely a user error): " + clazzToProcess.getName());
            }
            return;
        }
        if (!classType.equals((Object)AnnotatedClassType.ENTITY)) {
            throw new AnnotationException("Annotated class should have a @javax.persistence.Entity, @javax.persistence.Embeddable or @javax.persistence.EmbeddedSuperclass annotation: " + clazzToProcess.getName());
        }
        XClass annotatedClass = clazzToProcess;
        if (log.isInfoEnabled()) {
            log.info("Binding entity from annotated class: " + clazzToProcess.getName());
        }
        PersistentClass persistentClass2 = superEntity = (superEntityState = InheritanceState.getSuperEntityInheritanceState(clazzToProcess, inheritanceStatePerClass, mappings.getReflectionManager())) != null ? mappings.getClass(superEntityState.clazz.getName()) : null;
        if (superEntity == null && inheritanceState.hasParents) {
            throw new AssertionFailure("Subclass has to be binded after it's mother class: " + superEntityState.clazz.getName());
        }
        AnnotationBinder.bindQueries(annotatedClass, mappings);
        AnnotationBinder.bindFilterDefs(annotatedClass, mappings);
        AnnotationBinder.bindTypeDefs(annotatedClass, mappings);
        String schema = "";
        String table = "";
        String catalog = "";
        String discrimValue = null;
        List<Object> uniqueConstraints = new ArrayList();
        Ejb3DiscriminatorColumn discriminatorColumn = null;
        Ejb3JoinColumn[] inheritanceJoinedColumns = null;
        if (annotatedClass.isAnnotationPresent(Table.class)) {
            Table tabAnn = annotatedClass.getAnnotation(Table.class);
            table = tabAnn.name();
            schema = tabAnn.schema();
            catalog = tabAnn.catalog();
            uniqueConstraints = TableBinder.buildUniqueConstraints(tabAnn.uniqueConstraints());
        }
        boolean bl = hasJoinedColumns = inheritanceState.hasParents && InheritanceType.JOINED.equals((Object)inheritanceState.type);
        if (hasJoinedColumns) {
            boolean explicitInheritanceJoinedColumns;
            PrimaryKeyJoinColumns jcsAnn = annotatedClass.getAnnotation(PrimaryKeyJoinColumns.class);
            boolean bl2 = explicitInheritanceJoinedColumns = jcsAnn != null && jcsAnn.value().length != 0;
            if (explicitInheritanceJoinedColumns) {
                int nbrOfInhJoinedColumns = jcsAnn.value().length;
                inheritanceJoinedColumns = new Ejb3JoinColumn[nbrOfInhJoinedColumns];
                for (int colIndex = 0; colIndex < nbrOfInhJoinedColumns; ++colIndex) {
                    PrimaryKeyJoinColumn jcAnn = jcsAnn.value()[colIndex];
                    inheritanceJoinedColumns[colIndex] = Ejb3JoinColumn.buildJoinColumn(jcAnn, null, superEntity.getIdentifier(), (Map<String, Join>)null, (PropertyHolder)null, mappings);
                }
            } else {
                PrimaryKeyJoinColumn jcAnn = annotatedClass.getAnnotation(PrimaryKeyJoinColumn.class);
                inheritanceJoinedColumns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn(jcAnn, null, superEntity.getIdentifier(), (Map<String, Join>)null, (PropertyHolder)null, mappings)};
            }
            log.debug("Subclass joined column(s) created");
        } else if (annotatedClass.isAnnotationPresent(PrimaryKeyJoinColumns.class) || annotatedClass.isAnnotationPresent(PrimaryKeyJoinColumn.class)) {
            log.warn("Root entity should not hold an PrimaryKeyJoinColum(s), will be ignored");
        }
        if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.type)) {
            Inheritance inhAnn = annotatedClass.getAnnotation(Inheritance.class);
            DiscriminatorColumn discAnn = annotatedClass.getAnnotation(DiscriminatorColumn.class);
            DiscriminatorType discriminatorType = discAnn != null ? discAnn.discriminatorType() : DiscriminatorType.STRING;
            DiscriminatorFormula discFormulaAnn = annotatedClass.getAnnotation(DiscriminatorFormula.class);
            if (!inheritanceState.hasParents) {
                discriminatorColumn = Ejb3DiscriminatorColumn.buildDiscriminatorColumn(discriminatorType, discAnn, discFormulaAnn, mappings);
            }
            if (discAnn != null && inheritanceState.hasParents) {
                log.warn("Discriminator column has to be defined in the root entity, it will be ignored in subclass: " + clazzToProcess.getName());
            }
            String string = discrimValue = annotatedClass.isAnnotationPresent(DiscriminatorValue.class) ? annotatedClass.getAnnotation(DiscriminatorValue.class).value() : null;
        }
        if (!inheritanceState.hasParents) {
            persistentClass = new RootClass();
        } else if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.type)) {
            persistentClass = new SingleTableSubclass(superEntity);
        } else if (InheritanceType.JOINED.equals((Object)inheritanceState.type)) {
            persistentClass = new JoinedSubclass(superEntity);
        } else if (InheritanceType.TABLE_PER_CLASS.equals((Object)inheritanceState.type)) {
            persistentClass = new UnionSubclass(superEntity);
        } else {
            throw new AssertionFailure("Unknown inheritance type: " + (Object)((Object)inheritanceState.type));
        }
        Proxy proxyAnn = annotatedClass.getAnnotation(Proxy.class);
        BatchSize sizeAnn = annotatedClass.getAnnotation(BatchSize.class);
        Where whereAnn = annotatedClass.getAnnotation(Where.class);
        Entity entityAnn = annotatedClass.getAnnotation(Entity.class);
        org.hibernate.annotations.Entity hibEntityAnn = annotatedClass.getAnnotation(org.hibernate.annotations.Entity.class);
        Cache cacheAnn = annotatedClass.getAnnotation(Cache.class);
        EntityBinder entityBinder = new EntityBinder(entityAnn, hibEntityAnn, clazzToProcess, persistentClass, mappings);
        entityBinder.setDiscriminatorValue(discrimValue);
        entityBinder.setBatchSize(sizeAnn);
        entityBinder.setProxy(proxyAnn);
        entityBinder.setWhere(whereAnn);
        entityBinder.setCache(cacheAnn);
        entityBinder.setInheritanceState(inheritanceState);
        Filter filterAnn = annotatedClass.getAnnotation(Filter.class);
        if (filterAnn != null) {
            entityBinder.addFilter(filterAnn.name(), filterAnn.condition());
        }
        if ((filtersAnn = annotatedClass.getAnnotation(Filters.class)) != null) {
            for (Filter filter : filtersAnn.value()) {
                entityBinder.addFilter(filter.name(), filter.condition());
            }
        }
        entityBinder.bindEntity();
        if (inheritanceState.hasTable()) {
            Check checkAnn = annotatedClass.getAnnotation(Check.class);
            String constraints = checkAnn == null ? null : checkAnn.constraints();
            entityBinder.bindTable(schema, catalog, table, uniqueConstraints, constraints, inheritanceState.hasDenormalizedTable() ? superEntity.getTable() : null);
        } else if (annotatedClass.isAnnotationPresent(Table.class)) {
            log.warn("Illegal use of @Table in a subclass of a SINGLE_TABLE hierarchy: " + clazzToProcess.getName());
        }
        PropertyHolder propertyHolder = PropertyHolderBuilder.buildPropertyHolder(clazzToProcess, persistentClass, entityBinder, mappings);
        SecondaryTable secTabAnn = annotatedClass.getAnnotation(SecondaryTable.class);
        SecondaryTables secTabsAnn = annotatedClass.getAnnotation(SecondaryTables.class);
        entityBinder.firstLevelSecondaryTablesBinding(secTabAnn, secTabsAnn);
        OnDelete onDeleteAnn = annotatedClass.getAnnotation(OnDelete.class);
        boolean onDeleteAppropriate = false;
        if (InheritanceType.JOINED.equals((Object)inheritanceState.type) && inheritanceState.hasParents) {
            onDeleteAppropriate = true;
            JoinedSubclass jsc = (JoinedSubclass)persistentClass;
            if (persistentClass.getEntityPersisterClass() == null) {
                persistentClass.getRootClass().setEntityPersisterClass(JoinedSubclassEntityPersister.class);
            }
            DependantValue key = new DependantValue(jsc.getTable(), jsc.getIdentifier());
            jsc.setKey(key);
            ForeignKey fk = annotatedClass.getAnnotation(ForeignKey.class);
            if (fk != null && !BinderHelper.isDefault(fk.name())) {
                key.setForeignKeyName(fk.name());
            }
            if (onDeleteAnn != null) {
                key.setCascadeDeleteEnabled(OnDeleteAction.CASCADE.equals((Object)onDeleteAnn.action()));
            } else {
                key.setCascadeDeleteEnabled(false);
            }
            TableBinder.bindFk(jsc.getSuperclass(), jsc, inheritanceJoinedColumns, key, false, mappings);
            mappings.addSecondPass(new CreateKeySecondPass(jsc));
        } else if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.type)) {
            if (inheritanceState.hasParents) {
                if (persistentClass.getEntityPersisterClass() == null) {
                    persistentClass.getRootClass().setEntityPersisterClass(SingleTableEntityPersister.class);
                }
            } else if (inheritanceState.hasSons || !discriminatorColumn.isImplicit()) {
                AnnotationBinder.bindDiscriminatorToPersistentClass((RootClass)persistentClass, discriminatorColumn, entityBinder.getSecondaryTables(), propertyHolder);
                entityBinder.bindDiscriminatorValue();
            }
        } else if (InheritanceType.TABLE_PER_CLASS.equals((Object)inheritanceState.type) && inheritanceState.hasParents && persistentClass.getEntityPersisterClass() == null) {
            persistentClass.getRootClass().setEntityPersisterClass(UnionSubclassEntityPersister.class);
        }
        if (onDeleteAnn != null && !onDeleteAppropriate) {
            log.warn("Inapropriate use of @OnDelete on entity, annotation ignored: " + propertyHolder.getEntityName());
        }
        HashMap<String, IdGenerator> classGenerators = AnnotationBinder.buildLocalGenerators(annotatedClass, mappings);
        List<PropertyData> elements = AnnotationBinder.getElementsToProcess(clazzToProcess, inheritanceStatePerClass, propertyHolder, entityBinder, mappings);
        if (elements == null) {
            throw new AnnotationException("No identifier specified for entity: " + propertyHolder.getEntityName());
        }
        boolean subclassAndSingleTableStrategy = inheritanceState.type == InheritanceType.SINGLE_TABLE && inheritanceState.hasParents;
        HashSet<String> idProperties = new HashSet<String>();
        IdClass idClass = null;
        if (!inheritanceState.hasParents) {
            XClass current = inheritanceState.clazz;
            InheritanceState state = inheritanceState;
            do {
                if (!(current = state.clazz).isAnnotationPresent(IdClass.class)) continue;
                idClass = current.getAnnotation(IdClass.class);
                break;
            } while ((state = InheritanceState.getSuperclassInheritanceState(current, inheritanceStatePerClass, mappings.getReflectionManager())) != null);
        }
        if (idClass != null) {
            XClass compositeClass = mappings.getReflectionManager().toXClass(idClass.value());
            boolean isComponent = true;
            boolean propertyAnnotated = entityBinder.isPropertyAnnotated(compositeClass);
            String propertyAccessor = entityBinder.getPropertyAccessor(compositeClass);
            String generatorType = "assigned";
            String generator = "";
            PropertyPreloadedData inferredData = new PropertyPreloadedData(entityBinder.getPropertyAccessor(), "id", compositeClass);
            HashMap<String, IdGenerator> localGenerators = new HashMap<String, IdGenerator>();
            boolean ignoreIdAnnotations = entityBinder.isIgnoreIdAnnotations();
            entityBinder.setIgnoreIdAnnotations(true);
            AnnotationBinder.bindId(generatorType, generator, inferredData, null, propertyHolder, localGenerators, isComponent, propertyAnnotated, propertyAccessor, entityBinder, null, true, false, mappings);
            inferredData = new PropertyPreloadedData(propertyAccessor, "_identifierMapper", compositeClass);
            Component mapper = AnnotationBinder.fillComponent(propertyHolder, inferredData, propertyAnnotated, propertyAccessor, false, entityBinder, true, true, false, mappings);
            entityBinder.setIgnoreIdAnnotations(ignoreIdAnnotations);
            persistentClass.setIdentifierMapper(mapper);
            Property property = new Property();
            property.setName("_identifierMapper");
            property.setNodeName("id");
            property.setUpdateable(false);
            property.setInsertable(false);
            property.setValue(mapper);
            property.setPropertyAccessorName("embedded");
            persistentClass.addProperty(property);
            entityBinder.setIgnoreIdAnnotations(true);
            Iterator properties = mapper.getPropertyIterator();
            while (properties.hasNext()) {
                idProperties.add(((Property)properties.next()).getName());
            }
        }
        HashSet missingIdProperties = new HashSet(idProperties);
        for (PropertyData propertyAnnotatedElement : elements) {
            String propertyName = propertyAnnotatedElement.getPropertyName();
            if (!idProperties.contains(propertyName)) {
                AnnotationBinder.processElementAnnotations(propertyHolder, subclassAndSingleTableStrategy ? Nullability.FORCED_NULL : Nullability.NO_CONSTRAINT, propertyAnnotatedElement.getProperty(), propertyAnnotatedElement, classGenerators, entityBinder, false, false, false, mappings);
                continue;
            }
            missingIdProperties.remove(propertyName);
        }
        if (missingIdProperties.size() != 0) {
            StringBuilder missings = new StringBuilder();
            for (String property : missingIdProperties) {
                missings.append(property).append(", ");
            }
            throw new AnnotationException("Unable to find properties (" + missings.substring(0, missings.length() - 2) + ") in entity annotated with @IdClass:" + persistentClass.getEntityName());
        }
        if (!inheritanceState.hasParents) {
            RootClass rootClass = (RootClass)persistentClass;
            mappings.addSecondPass(new CreateKeySecondPass(rootClass));
        } else {
            superEntity.addSubclass((Subclass)persistentClass);
        }
        mappings.addClass(persistentClass);
        entityBinder.finalSecondaryTableBinding(propertyHolder);
        entityBinder.processComplementaryTableDefinitions(annotatedClass.getAnnotation(org.hibernate.annotations.Table.class));
        entityBinder.processComplementaryTableDefinitions(annotatedClass.getAnnotation(Tables.class));
    }

    private static List<PropertyData> getElementsToProcess(XClass clazzToProcess, Map<XClass, InheritanceState> inheritanceStatePerClass, PropertyHolder propertyHolder, EntityBinder entityBinder, ExtendedMappings mappings) {
        boolean currentHasIdentifier;
        XClass clazz;
        int index;
        InheritanceState inheritanceState = inheritanceStatePerClass.get(clazzToProcess);
        List<XClass> classesToProcess = AnnotationBinder.orderClassesToBeProcessed(clazzToProcess, inheritanceStatePerClass, inheritanceState, mappings);
        ArrayList<PropertyData> elements = new ArrayList<PropertyData>();
        int deep = classesToProcess.size();
        boolean hasIdentifier = false;
        assert (!inheritanceState.isEmbeddableSuperclass);
        Boolean isExplicitPropertyAnnotated = null;
        String explicitAccessType = null;
        if (inheritanceState.hasParents) {
            InheritanceState superEntityState = InheritanceState.getSuperEntityInheritanceState(clazzToProcess, inheritanceStatePerClass, mappings.getReflectionManager());
            isExplicitPropertyAnnotated = superEntityState != null ? superEntityState.isPropertyAnnotated : null;
            explicitAccessType = superEntityState != null ? superEntityState.accessType : null;
        } else {
            AccessType access = clazzToProcess.getAnnotation(AccessType.class);
            String string = explicitAccessType = access != null ? access.value() : null;
            if ("property".equals(explicitAccessType)) {
                isExplicitPropertyAnnotated = Boolean.TRUE;
            } else if ("field".equals(explicitAccessType)) {
                isExplicitPropertyAnnotated = Boolean.FALSE;
            }
        }
        Boolean isPropertyAnnotated = isExplicitPropertyAnnotated == null ? Boolean.TRUE : isExplicitPropertyAnnotated;
        String accessType = explicitAccessType != null ? explicitAccessType : "property";
        for (index = 0; index < deep; ++index) {
            clazz = classesToProcess.get(index);
            currentHasIdentifier = AnnotationBinder.addElementsOfAClass(elements, propertyHolder, isPropertyAnnotated, accessType, clazz, mappings);
            hasIdentifier = hasIdentifier || currentHasIdentifier;
        }
        if (!hasIdentifier && !inheritanceState.hasParents) {
            if (isExplicitPropertyAnnotated != null) {
                return null;
            }
            isPropertyAnnotated = isPropertyAnnotated == false;
            accessType = "field";
            elements.clear();
            for (index = 0; index < deep; ++index) {
                clazz = classesToProcess.get(index);
                currentHasIdentifier = AnnotationBinder.addElementsOfAClass(elements, propertyHolder, isPropertyAnnotated, accessType, clazz, mappings);
                hasIdentifier = hasIdentifier || currentHasIdentifier;
            }
        }
        entityBinder.setPropertyAnnotated(isPropertyAnnotated);
        entityBinder.setPropertyAccessor(accessType);
        inheritanceState.isPropertyAnnotated = isPropertyAnnotated;
        inheritanceState.accessType = accessType;
        return hasIdentifier || inheritanceState.hasParents ? elements : null;
    }

    private static List<XClass> orderClassesToBeProcessed(XClass annotatedClass, Map<XClass, InheritanceState> inheritanceStatePerClass, InheritanceState inheritanceState, ExtendedMappings mappings) {
        InheritanceState superclassState;
        ArrayList<XClass> classesToProcess = new ArrayList<XClass>();
        XClass currentClassInHierarchy = annotatedClass;
        do {
            classesToProcess.add(0, currentClassInHierarchy);
            XClass superClass = currentClassInHierarchy;
            do {
                superClass = superClass.getSuperclass();
                superclassState = inheritanceStatePerClass.get(superClass);
            } while (superClass != null && !mappings.getReflectionManager().equals(superClass, Object.class) && superclassState == null);
            currentClassInHierarchy = superClass;
        } while (superclassState != null && superclassState.isEmbeddableSuperclass);
        return classesToProcess;
    }

    private static void bindFilterDefs(XAnnotatedElement annotatedElement, ExtendedMappings mappings) {
        FilterDef defAnn = annotatedElement.getAnnotation(FilterDef.class);
        FilterDefs defsAnn = annotatedElement.getAnnotation(FilterDefs.class);
        if (defAnn != null) {
            AnnotationBinder.bindFilterDef(defAnn, mappings);
        }
        if (defsAnn != null) {
            for (FilterDef def : defsAnn.value()) {
                AnnotationBinder.bindFilterDef(def, mappings);
            }
        }
    }

    private static void bindFilterDef(FilterDef defAnn, ExtendedMappings mappings) {
        HashMap<String, Type> params = new HashMap<String, Type>();
        for (ParamDef param : defAnn.parameters()) {
            params.put(param.name(), TypeFactory.heuristicType(param.type()));
        }
        FilterDefinition def = new FilterDefinition(defAnn.name(), defAnn.defaultCondition(), params);
        if (log.isInfoEnabled()) {
            log.info("Binding filter definition: " + def.getFilterName());
        }
        mappings.addFilterDefinition(def);
    }

    private static void bindTypeDefs(XAnnotatedElement annotatedElement, ExtendedMappings mappings) {
        TypeDef defAnn = annotatedElement.getAnnotation(TypeDef.class);
        TypeDefs defsAnn = annotatedElement.getAnnotation(TypeDefs.class);
        if (defAnn != null) {
            AnnotationBinder.bindTypeDef(defAnn, mappings);
        }
        if (defsAnn != null) {
            for (TypeDef def : defsAnn.value()) {
                AnnotationBinder.bindTypeDef(def, mappings);
            }
        }
    }

    private static void bindTypeDef(TypeDef defAnn, ExtendedMappings mappings) {
        Properties params = new Properties();
        for (Parameter param : defAnn.parameters()) {
            params.setProperty(param.name(), param.value());
        }
        if (log.isInfoEnabled()) {
            log.info("Binding type definition: " + defAnn.name());
        }
        mappings.addTypeDef(defAnn.name(), defAnn.typeClass().getName(), params);
    }

    private static void bindDiscriminatorToPersistentClass(RootClass rootClass, Ejb3DiscriminatorColumn discriminatorColumn, Map<String, Join> secondaryTables, PropertyHolder propertyHolder) {
        if (rootClass.getDiscriminator() == null) {
            if (discriminatorColumn == null) {
                throw new AssertionFailure("discriminator column should have been built");
            }
            discriminatorColumn.setJoins(secondaryTables);
            discriminatorColumn.setPropertyHolder(propertyHolder);
            SimpleValue discrim = new SimpleValue(rootClass.getTable());
            rootClass.setDiscriminator(discrim);
            discriminatorColumn.linkWithValue(discrim);
            discrim.setTypeName(discriminatorColumn.getDiscriminatorTypeName());
            rootClass.setPolymorphic(true);
            log.debug("Setting discriminator for entity " + rootClass.getEntityName());
        }
    }

    private static boolean addElementsOfAClass(List<PropertyData> elements, PropertyHolder propertyHolder, boolean isPropertyAnnotated, String propertyAccessor, XClass annotatedClass, ExtendedMappings mappings) {
        boolean hasIdentifier = false;
        AccessType access = annotatedClass.getAnnotation(AccessType.class);
        String localPropertyAccessor = access != null ? access.value() : null;
        String accessType = null;
        if ("property".equals(localPropertyAccessor) || "field".equals(localPropertyAccessor)) {
            accessType = localPropertyAccessor;
        } else {
            if (localPropertyAccessor == null) {
                localPropertyAccessor = propertyAccessor;
            }
            accessType = isPropertyAnnotated ? "property" : "field";
        }
        log.debug("Processing " + propertyHolder.getEntityName() + " " + accessType + " annotation");
        List<XProperty> properties = annotatedClass.getDeclaredProperties(accessType);
        Collections.sort(properties, new Comparator<XProperty>(){

            @Override
            public int compare(XProperty property1, XProperty property2) {
                return property1.getName().compareTo(property2.getName());
            }
        });
        for (XProperty p : properties) {
            if (!(p.isTypeResolved() || AnnotationBinder.discoverTypeWithoutReflection(p) || AnnotationBinder.mustBeSkipped(p, mappings))) {
                throw new AnnotationException("Property " + StringHelper.qualify(propertyHolder.getEntityName(), p.getName()) + " has an unbound type and no explicit target entity. Resolve this Generic usage issue" + " or set an explicit target attribute (eg @OneToMany(target=) or use an explicit @Type");
            }
            boolean currentHasIdentifier = AnnotationBinder.addProperty(p, elements, localPropertyAccessor, mappings);
            hasIdentifier = hasIdentifier || currentHasIdentifier;
        }
        return hasIdentifier;
    }

    private static boolean discoverTypeWithoutReflection(XProperty p) {
        if (p.isAnnotationPresent(OneToOne.class) && !p.getAnnotation(OneToOne.class).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (p.isAnnotationPresent(OneToMany.class) && !p.getAnnotation(OneToMany.class).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (p.isAnnotationPresent(javax.persistence.ManyToOne.class) && !p.getAnnotation(javax.persistence.ManyToOne.class).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (p.isAnnotationPresent(ManyToMany.class) && !p.getAnnotation(ManyToMany.class).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (p.isAnnotationPresent(org.hibernate.annotations.Type.class)) {
            return true;
        }
        return p.isAnnotationPresent(Target.class);
    }

    private static boolean addProperty(XProperty property, List<PropertyData> annElts, String propertyAccessor, ExtendedMappings mappings) {
        boolean hasIdentifier = false;
        PropertyInferredData propertyAnnotatedElement = new PropertyInferredData(property, propertyAccessor, mappings.getReflectionManager());
        if (!AnnotationBinder.mustBeSkipped(propertyAnnotatedElement.getProperty(), mappings)) {
            XProperty element = propertyAnnotatedElement.getProperty();
            if (element.isAnnotationPresent(Id.class) || element.isAnnotationPresent(EmbeddedId.class)) {
                annElts.add(0, propertyAnnotatedElement);
                hasIdentifier = true;
            } else {
                annElts.add(propertyAnnotatedElement);
                hasIdentifier = false;
            }
        }
        return hasIdentifier;
    }

    private static boolean mustBeSkipped(XProperty property, ExtendedMappings mappings) {
        return property.isAnnotationPresent(Transient.class) || "net.sf.cglib.transform.impl.InterceptFieldCallback".equals(property.getType().getName()) || "org.hibernate.tool.instrument.javassist.FieldHandler".equals(property.getType().getName());
    }

    private static void processElementAnnotations(PropertyHolder propertyHolder, Nullability nullability, XProperty property, PropertyData inferredData, HashMap<String, IdGenerator> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, boolean inSecondPass, ExtendedMappings mappings) throws MappingException {
        block65: {
            String mappedBy;
            JoinColumns ann;
            int length;
            Ejb3Column[] columns = null;
            Ejb3JoinColumn[] joinColumns = null;
            if (log.isDebugEnabled()) {
                log.debug("Processing annotations of " + propertyHolder.getEntityName() + "." + inferredData.getPropertyName());
            }
            if (property.isAnnotationPresent(Parent.class)) {
                if (!propertyHolder.isComponent()) {
                    throw new AnnotationException("@Parent cannot be applied outside an embeddable object: " + StringHelper.qualify(propertyHolder.getPath(), property.getName()));
                }
                propertyHolder.setParentProperty(property.getName());
                return;
            }
            Object anns = null;
            if (property.isAnnotationPresent(JoinColumn.class)) {
                anns = new JoinColumn[]{property.getAnnotation(JoinColumn.class)};
            } else if (property.isAnnotationPresent(JoinColumns.class) && (length = ((JoinColumn[])(anns = (ann = property.getAnnotation(JoinColumns.class)).value())).length) == 0) {
                throw new AnnotationException("Cannot bind an empty @JoinColumns");
            }
            if (anns != null) {
                joinColumns = Ejb3JoinColumn.buildJoinColumns((JoinColumn[])anns, null, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
            }
            if (property.isAnnotationPresent(javax.persistence.Column.class) || property.isAnnotationPresent(Formula.class)) {
                javax.persistence.Column ann2 = property.getAnnotation(javax.persistence.Column.class);
                Formula formulaAnn = property.getAnnotation(Formula.class);
                columns = Ejb3Column.buildColumnFromAnnotation(new javax.persistence.Column[]{ann2}, formulaAnn, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
            } else if (property.isAnnotationPresent(Columns.class)) {
                anns = property.getAnnotation(Columns.class);
                columns = Ejb3Column.buildColumnFromAnnotation(anns.columns(), null, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
            }
            if (joinColumns == null && (property.isAnnotationPresent(javax.persistence.ManyToOne.class) || property.isAnnotationPresent(OneToOne.class))) {
                if (property.isAnnotationPresent(JoinTable.class)) {
                    JoinTable joinTableAnn = property.getAnnotation(JoinTable.class);
                    joinColumns = Ejb3JoinColumn.buildJoinColumns(joinTableAnn.inverseJoinColumns(), null, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
                    if (StringHelper.isEmpty(joinTableAnn.name())) {
                        throw new AnnotationException("JoinTable.name() on a @ToOne association has to be explicit: " + StringHelper.qualify(propertyHolder.getPath(), inferredData.getPropertyName()));
                    }
                } else {
                    OneToOne oneToOneAnn = property.getAnnotation(OneToOne.class);
                    mappedBy = oneToOneAnn != null ? oneToOneAnn.mappedBy() : null;
                    joinColumns = Ejb3JoinColumn.buildJoinColumns(null, mappedBy, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
                }
            } else if (joinColumns == null && (property.isAnnotationPresent(OneToMany.class) || property.isAnnotationPresent(CollectionOfElements.class))) {
                OneToMany oneToMany = property.getAnnotation(OneToMany.class);
                mappedBy = oneToMany != null ? oneToMany.mappedBy() : "";
                joinColumns = Ejb3JoinColumn.buildJoinColumns(null, mappedBy, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
            }
            if (columns == null && !property.isAnnotationPresent(ManyToMany.class)) {
                columns = Ejb3Column.buildColumnFromAnnotation(null, null, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
            }
            if (nullability == Nullability.FORCED_NOT_NULL) {
                for (Ejb3Column col : columns) {
                    col.forceNotNull();
                }
            }
            XClass returnedClass = inferredData.getClassOrElement();
            if (!entityBinder.isIgnoreIdAnnotations() && (property.isAnnotationPresent(Id.class) || property.isAnnotationPresent(EmbeddedId.class))) {
                String generator;
                if (isIdentifierMapper) {
                    throw new AnnotationException("@IdClass class should not have @Id nor @EmbeddedId properties");
                }
                log.debug(inferredData.getPropertyName() + " is an id");
                HashMap localGenerators = (HashMap)classGenerators.clone();
                localGenerators.putAll(AnnotationBinder.buildLocalGenerators(property, mappings));
                boolean isComponent = returnedClass.isAnnotationPresent(Embeddable.class) || property.isAnnotationPresent(EmbeddedId.class);
                boolean propertyAnnotated = entityBinder.isPropertyAnnotated(returnedClass);
                String propertyAccessor = entityBinder.getPropertyAccessor(returnedClass);
                GeneratedValue generatedValue = property.getAnnotation(GeneratedValue.class);
                String generatorType = generatedValue != null ? AnnotationBinder.generatorType(generatedValue.strategy()) : "assigned";
                String string = generator = generatedValue != null ? generatedValue.generator() : "";
                if (isComponent) {
                    generatorType = "assigned";
                }
                org.hibernate.annotations.Type typeAnn = property.getAnnotation(org.hibernate.annotations.Type.class);
                AnnotationBinder.bindId(generatorType, generator, inferredData, columns, propertyHolder, localGenerators, isComponent, propertyAnnotated, propertyAccessor, entityBinder, typeAnn, false, isIdentifierMapper, mappings);
                if (log.isDebugEnabled()) {
                    log.debug("Bind " + (isComponent ? "@EmbeddedId" : "@Id") + " on " + inferredData.getPropertyName());
                }
            } else if (property.isAnnotationPresent(Version.class)) {
                if (isIdentifierMapper) {
                    throw new AnnotationException("@IdClass class should not have @Version property");
                }
                if (!(propertyHolder.getPersistentClass() instanceof RootClass)) {
                    throw new AnnotationException("Unable to define/override @Version on a subclass: " + propertyHolder.getEntityName());
                }
                log.debug(inferredData.getPropertyName() + " is a version property");
                RootClass rootClass = (RootClass)propertyHolder.getPersistentClass();
                boolean lazy = false;
                PropertyBinder propBinder = new PropertyBinder();
                propBinder.setName(inferredData.getPropertyName());
                propBinder.setReturnedClassName(inferredData.getTypeName());
                propBinder.setLazy(lazy);
                propBinder.setPropertyAccessorName(inferredData.getDefaultAccess());
                propBinder.setColumns(columns);
                propBinder.setHolder(propertyHolder);
                propBinder.setProperty(property);
                propBinder.setReturnedClass(inferredData.getPropertyClass());
                propBinder.setMappings(mappings);
                Property prop = propBinder.bind();
                rootClass.setVersion(prop);
                SimpleValue simpleValue = (SimpleValue)prop.getValue();
                if (!simpleValue.isTypeSpecified()) {
                    simpleValue.setTypeName("integer");
                }
                simpleValue.setNullValue("undefined");
                rootClass.setOptimisticLockMode(0);
                log.debug("Version name: " + rootClass.getVersion().getName() + ", unsavedValue: " + ((SimpleValue)rootClass.getVersion().getValue()).getNullValue());
            } else if (property.isAnnotationPresent(javax.persistence.ManyToOne.class)) {
                javax.persistence.ManyToOne ann3 = property.getAnnotation(javax.persistence.ManyToOne.class);
                if (property.isAnnotationPresent(javax.persistence.Column.class) || property.isAnnotationPresent(Columns.class)) {
                    throw new AnnotationException("@Column(s) not allowed on a @ManyToOne property: " + StringHelper.qualify(propertyHolder.getPath(), inferredData.getPropertyName()));
                }
                Cascade hibernateCascade = property.getAnnotation(Cascade.class);
                NotFound notFound = property.getAnnotation(NotFound.class);
                boolean ignoreNotFound = notFound != null && notFound.action().equals((Object)NotFoundAction.IGNORE);
                OnDelete onDeleteAnn = property.getAnnotation(OnDelete.class);
                boolean onDeleteCascade = onDeleteAnn != null && OnDeleteAction.CASCADE.equals((Object)onDeleteAnn.action());
                JoinTable assocTable = property.getAnnotation(JoinTable.class);
                if (assocTable != null) {
                    Join join = propertyHolder.addJoin(assocTable, false);
                    for (Ejb3JoinColumn joinColumn : joinColumns) {
                        joinColumn.setSecondaryTableName(join.getTable().getName());
                    }
                }
                AnnotationBinder.bindManyToOne(AnnotationBinder.getCascadeStrategy(ann3.cascade(), hibernateCascade), joinColumns, ann3.optional(), ignoreNotFound, onDeleteCascade, mappings.getReflectionManager().toXClass(ann3.targetEntity()), propertyHolder, inferredData, false, isIdentifierMapper, inSecondPass, mappings);
            } else if (property.isAnnotationPresent(OneToOne.class)) {
                OneToOne ann4 = property.getAnnotation(OneToOne.class);
                if (property.isAnnotationPresent(javax.persistence.Column.class) || property.isAnnotationPresent(Columns.class)) {
                    throw new AnnotationException("@Column(s) not allowed on a @OneToOne property: " + StringHelper.qualify(propertyHolder.getPath(), inferredData.getPropertyName()));
                }
                boolean trueOneToOne = property.isAnnotationPresent(PrimaryKeyJoinColumn.class) || property.isAnnotationPresent(PrimaryKeyJoinColumns.class);
                Cascade hibernateCascade = property.getAnnotation(Cascade.class);
                NotFound notFound = property.getAnnotation(NotFound.class);
                boolean ignoreNotFound = notFound != null && notFound.action().equals((Object)NotFoundAction.IGNORE);
                OnDelete onDeleteAnn = property.getAnnotation(OnDelete.class);
                boolean onDeleteCascade = onDeleteAnn != null && OnDeleteAction.CASCADE.equals((Object)onDeleteAnn.action());
                JoinTable assocTable = property.getAnnotation(JoinTable.class);
                if (assocTable != null) {
                    Join join = propertyHolder.addJoin(assocTable, false);
                    for (Ejb3JoinColumn joinColumn : joinColumns) {
                        joinColumn.setSecondaryTableName(join.getTable().getName());
                    }
                }
                AnnotationBinder.bindOneToOne(AnnotationBinder.getCascadeStrategy(ann4.cascade(), hibernateCascade), joinColumns, ann4.optional(), AnnotationBinder.getFetchMode(ann4.fetch()), ignoreNotFound, onDeleteCascade, mappings.getReflectionManager().toXClass(ann4.targetEntity()), propertyHolder, inferredData, ann4.mappedBy(), trueOneToOne, isIdentifierMapper, inSecondPass, mappings);
            } else if (property.isAnnotationPresent(OneToMany.class) || property.isAnnotationPresent(ManyToMany.class) || property.isAnnotationPresent(CollectionOfElements.class)) {
                OneToMany oneToManyAnn = property.getAnnotation(OneToMany.class);
                ManyToMany manyToManyAnn = property.getAnnotation(ManyToMany.class);
                CollectionOfElements collectionOfElementsAnn = property.getAnnotation(CollectionOfElements.class);
                org.hibernate.annotations.IndexColumn indexAnn = property.getAnnotation(org.hibernate.annotations.IndexColumn.class);
                JoinTable assocTable = property.getAnnotation(JoinTable.class);
                IndexColumn indexColumn = IndexColumn.buildColumnFromAnnotation(indexAnn, propertyHolder, inferredData, mappings);
                CollectionBinder collectionBinder = CollectionBinder.getCollectionBinder(propertyHolder.getEntityName(), property, !indexColumn.isImplicit());
                collectionBinder.setIndexColumn(indexColumn);
                javax.persistence.MapKey mapKeyAnn = property.getAnnotation(javax.persistence.MapKey.class);
                collectionBinder.setMapKey(mapKeyAnn);
                collectionBinder.setPropertyName(inferredData.getPropertyName());
                BatchSize batchAnn = property.getAnnotation(BatchSize.class);
                collectionBinder.setBatchSize(batchAnn);
                OrderBy ejb3OrderByAnn = property.getAnnotation(OrderBy.class);
                org.hibernate.annotations.OrderBy orderByAnn = property.getAnnotation(org.hibernate.annotations.OrderBy.class);
                collectionBinder.setEjb3OrderBy(ejb3OrderByAnn);
                collectionBinder.setSqlOrderBy(orderByAnn);
                Sort sortAnn = property.getAnnotation(Sort.class);
                collectionBinder.setSort(sortAnn);
                Cache cachAnn = property.getAnnotation(Cache.class);
                collectionBinder.setCache(cachAnn);
                collectionBinder.setPropertyHolder(propertyHolder);
                Cascade hibernateCascade = property.getAnnotation(Cascade.class);
                NotFound notFound = property.getAnnotation(NotFound.class);
                boolean ignoreNotFound = notFound != null && notFound.action().equals((Object)NotFoundAction.IGNORE);
                collectionBinder.setIgnoreNotFound(ignoreNotFound);
                collectionBinder.setCollectionType(inferredData.getProperty().getElementClass());
                collectionBinder.setMappings(mappings);
                collectionBinder.setPropertyAccessorName(inferredData.getDefaultAccess());
                Ejb3Column[] elementColumns = null;
                WrappedInferredData virtualProperty = new WrappedInferredData(inferredData, "element");
                if (property.isAnnotationPresent(javax.persistence.Column.class) || property.isAnnotationPresent(Formula.class)) {
                    javax.persistence.Column ann5 = property.getAnnotation(javax.persistence.Column.class);
                    Formula formulaAnn = property.getAnnotation(Formula.class);
                    elementColumns = Ejb3Column.buildColumnFromAnnotation(new javax.persistence.Column[]{ann5}, formulaAnn, nullability, propertyHolder, virtualProperty, entityBinder.getSecondaryTables(), mappings);
                } else if (property.isAnnotationPresent(Columns.class)) {
                    Columns anns2 = property.getAnnotation(Columns.class);
                    elementColumns = Ejb3Column.buildColumnFromAnnotation(anns2.columns(), null, nullability, propertyHolder, virtualProperty, entityBinder.getSecondaryTables(), mappings);
                } else {
                    elementColumns = Ejb3Column.buildColumnFromAnnotation(null, null, nullability, propertyHolder, virtualProperty, entityBinder.getSecondaryTables(), mappings);
                }
                MapKey hibMapKeyAnn = property.getAnnotation(MapKey.class);
                WrappedInferredData mapKeyVirtualProperty = new WrappedInferredData(inferredData, "mapkey");
                Ejb3Column[] mapColumns = Ejb3Column.buildColumnFromAnnotation(hibMapKeyAnn != null && hibMapKeyAnn.columns().length > 0 ? hibMapKeyAnn.columns() : null, null, Nullability.FORCED_NOT_NULL, propertyHolder, mapKeyVirtualProperty, entityBinder.getSecondaryTables(), mappings);
                collectionBinder.setMapKeyColumns(mapColumns);
                MapKeyManyToMany mapKeyManyToMany = property.getAnnotation(MapKeyManyToMany.class);
                Ejb3JoinColumn[] mapJoinColumns = Ejb3JoinColumn.buildJoinColumns(mapKeyManyToMany != null ? mapKeyManyToMany.joinColumns() : null, null, entityBinder.getSecondaryTables(), propertyHolder, mapKeyVirtualProperty.getPropertyName(), mappings);
                collectionBinder.setMapKeyManyToManyColumns(mapJoinColumns);
                collectionBinder.setEmbedded(property.isAnnotationPresent(Embedded.class));
                collectionBinder.setElementColumns(elementColumns);
                collectionBinder.setProperty(property);
                if (oneToManyAnn != null && manyToManyAnn != null) {
                    throw new AnnotationException("@OneToMany and @ManyToMany on the same property is not allowed: " + propertyHolder.getEntityName() + "." + inferredData.getPropertyName());
                }
                String mappedBy2 = null;
                if (oneToManyAnn != null) {
                    for (Ejb3JoinColumn column : joinColumns) {
                        if (!column.isSecondary()) continue;
                        throw new NotYetImplementedException("Collections having FK in secondary table");
                    }
                    collectionBinder.setFkJoinColumns(joinColumns);
                    mappedBy2 = oneToManyAnn.mappedBy();
                    collectionBinder.setTargetEntity(mappings.getReflectionManager().toXClass(oneToManyAnn.targetEntity()));
                    collectionBinder.setCascadeStrategy(AnnotationBinder.getCascadeStrategy(oneToManyAnn.cascade(), hibernateCascade));
                    collectionBinder.setOneToMany(true);
                } else if (collectionOfElementsAnn != null) {
                    for (Ejb3JoinColumn column : joinColumns) {
                        if (!column.isSecondary()) continue;
                        throw new NotYetImplementedException("Collections having FK in secondary table");
                    }
                    collectionBinder.setFkJoinColumns(joinColumns);
                    mappedBy2 = "";
                    collectionBinder.setTargetEntity(mappings.getReflectionManager().toXClass(collectionOfElementsAnn.targetElement()));
                    collectionBinder.setOneToMany(true);
                } else if (manyToManyAnn != null) {
                    mappedBy2 = manyToManyAnn.mappedBy();
                    collectionBinder.setTargetEntity(mappings.getReflectionManager().toXClass(manyToManyAnn.targetEntity()));
                    collectionBinder.setCascadeStrategy(AnnotationBinder.getCascadeStrategy(manyToManyAnn.cascade(), hibernateCascade));
                    collectionBinder.setOneToMany(false);
                }
                collectionBinder.setMappedBy(mappedBy2);
                AnnotationBinder.bindJoinedTableAssociation(assocTable, mappings, entityBinder, collectionBinder, propertyHolder, inferredData, mappedBy2);
                OnDelete onDeleteAnn = property.getAnnotation(OnDelete.class);
                boolean onDeleteCascade = onDeleteAnn != null && OnDeleteAction.CASCADE.equals((Object)onDeleteAnn.action());
                collectionBinder.setCascadeDeleteEnabled(onDeleteCascade);
                if (isIdentifierMapper) {
                    collectionBinder.setInsertable(false);
                    collectionBinder.setUpdatable(false);
                }
                if (property.isAnnotationPresent(CollectionId.class)) {
                    HashMap localGenerators = (HashMap)classGenerators.clone();
                    localGenerators.putAll(AnnotationBinder.buildLocalGenerators(property, mappings));
                    collectionBinder.setLocalGenerators(localGenerators);
                }
                collectionBinder.bind();
            } else {
                boolean isComponent = false;
                Embeddable embeddableAnn = returnedClass.getAnnotation(Embeddable.class);
                Embedded embeddedAnn = property.getAnnotation(Embedded.class);
                boolean bl = isComponent = embeddedAnn != null || embeddableAnn != null;
                if (isComponent) {
                    boolean propertyAnnotated = entityBinder.isPropertyAnnotated(property);
                    String propertyAccessor = entityBinder.getPropertyAccessor(property);
                    AnnotationBinder.bindComponent(inferredData, propertyHolder, propertyAnnotated, propertyAccessor, entityBinder, isIdentifierMapper, mappings, isComponentEmbedded);
                } else {
                    boolean optional = true;
                    boolean lazy = false;
                    if (property.isAnnotationPresent(Basic.class)) {
                        Basic ann6 = property.getAnnotation(Basic.class);
                        optional = ann6.optional();
                        boolean bl2 = lazy = ann6.fetch() == FetchType.LAZY;
                    }
                    if (!optional && nullability != Nullability.FORCED_NULL) {
                        for (Ejb3Column col : columns) {
                            col.forceNotNull();
                        }
                    }
                    PropertyBinder propBinder = new PropertyBinder();
                    propBinder.setName(inferredData.getPropertyName());
                    propBinder.setReturnedClassName(inferredData.getTypeName());
                    propBinder.setLazy(lazy);
                    propBinder.setPropertyAccessorName(inferredData.getDefaultAccess());
                    propBinder.setColumns(columns);
                    propBinder.setHolder(propertyHolder);
                    propBinder.setProperty(property);
                    propBinder.setReturnedClass(inferredData.getPropertyClass());
                    propBinder.setMappings(mappings);
                    if (isIdentifierMapper) {
                        propBinder.setInsertable(false);
                        propBinder.setUpdatable(false);
                    }
                    propBinder.bind();
                }
            }
            Index index = property.getAnnotation(Index.class);
            if (index == null) break block65;
            if (joinColumns != null) {
                for (Ejb3JoinColumn column : joinColumns) {
                    column.addIndex(index, inSecondPass);
                }
            } else {
                for (Ejb3Column column : columns) {
                    column.addIndex(index, inSecondPass);
                }
            }
        }
    }

    private static void bindJoinedTableAssociation(JoinTable joinTableAnn, ExtendedMappings mappings, EntityBinder entityBinder, CollectionBinder collectionBinder, PropertyHolder propertyHolder, PropertyData inferredData, String mappedBy) {
        JoinColumn[] annInverseJoins;
        JoinColumn[] annJoins;
        TableBinder associationTableBinder = new TableBinder();
        if (joinTableAnn != null) {
            collectionBinder.setExplicitAssociationTable(true);
            if (!BinderHelper.isDefault(joinTableAnn.schema())) {
                associationTableBinder.setSchema(joinTableAnn.schema());
            }
            if (!BinderHelper.isDefault(joinTableAnn.catalog())) {
                associationTableBinder.setCatalog(joinTableAnn.catalog());
            }
            if (!BinderHelper.isDefault(joinTableAnn.name())) {
                associationTableBinder.setName(joinTableAnn.name());
            }
            associationTableBinder.setUniqueConstraints(joinTableAnn.uniqueConstraints());
            JoinColumn[] joins = joinTableAnn.joinColumns();
            annJoins = joins.length == 0 ? null : joins;
            JoinColumn[] inverseJoins = joinTableAnn.inverseJoinColumns();
            annInverseJoins = inverseJoins.length == 0 ? null : inverseJoins;
        } else {
            annJoins = null;
            annInverseJoins = null;
        }
        Ejb3JoinColumn[] joinColumns = Ejb3JoinColumn.buildJoinTableJoinColumns(annJoins, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappedBy, mappings);
        Ejb3JoinColumn[] inverseJoinColumns = Ejb3JoinColumn.buildJoinTableJoinColumns(annInverseJoins, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappedBy, mappings);
        associationTableBinder.setMappings(mappings);
        collectionBinder.setTableBinder(associationTableBinder);
        collectionBinder.setJoinColumns(joinColumns);
        collectionBinder.setInverseJoinColumns(inverseJoinColumns);
    }

    private static void bindComponent(PropertyData inferredData, PropertyHolder propertyHolder, boolean propertyAnnotated, String propertyAccessor, EntityBinder entityBinder, boolean isIdentifierMapper, ExtendedMappings mappings, boolean isComponentEmbedded) {
        Component comp = AnnotationBinder.fillComponent(propertyHolder, inferredData, propertyAnnotated, propertyAccessor, true, entityBinder, isComponentEmbedded, isIdentifierMapper, false, mappings);
        XProperty property = inferredData.getProperty();
        AnnotationBinder.setupComponentTuplizer(property, comp);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(inferredData.getPropertyName());
        binder.setValue(comp);
        binder.setProperty(inferredData.getProperty());
        binder.setPropertyAccessorName(inferredData.getDefaultAccess());
        Property prop = binder.make();
        propertyHolder.addProperty(prop);
    }

    public static Component fillComponent(PropertyHolder propertyHolder, PropertyData inferredData, boolean propertyAnnotated, String propertyAccessor, boolean isNullable, EntityBinder entityBinder, boolean isComponentEmbedded, boolean isIdentifierMapper, boolean inSecondPass, ExtendedMappings mappings) {
        Component comp = new Component(propertyHolder.getPersistentClass());
        comp.setEmbedded(isComponentEmbedded);
        comp.setTable(propertyHolder.getTable());
        if (!isIdentifierMapper) {
            comp.setComponentClassName(inferredData.getClassOrElementName());
        } else {
            comp.setComponentClassName(comp.getOwner().getClassName());
        }
        comp.setNodeName(inferredData.getPropertyName());
        String subpath = StringHelper.qualify(propertyHolder.getPath(), inferredData.getPropertyName());
        log.debug("Binding component with path: " + subpath);
        PropertyHolder subHolder = PropertyHolderBuilder.buildPropertyHolder(comp, subpath, inferredData, propertyHolder, mappings);
        ArrayList<PropertyData> classElements = new ArrayList<PropertyData>();
        XClass returnedClassOrElement = inferredData.getClassOrElement();
        AnnotationBinder.addElementsOfAClass(classElements, subHolder, propertyAnnotated, propertyAccessor, returnedClassOrElement, mappings);
        for (XClass superClass = inferredData.getPropertyClass().getSuperclass(); superClass != null && superClass.isAnnotationPresent(MappedSuperclass.class); superClass = superClass.getSuperclass()) {
            AnnotationBinder.addElementsOfAClass(classElements, subHolder, entityBinder.isPropertyAnnotated(superClass), propertyAccessor, superClass, mappings);
        }
        for (PropertyData propertyAnnotatedElement : classElements) {
            AnnotationBinder.processElementAnnotations(subHolder, isNullable ? Nullability.NO_CONSTRAINT : Nullability.FORCED_NOT_NULL, propertyAnnotatedElement.getProperty(), propertyAnnotatedElement, new HashMap<String, IdGenerator>(), entityBinder, isIdentifierMapper, isComponentEmbedded, inSecondPass, mappings);
        }
        return comp;
    }

    private static void bindId(String generatorType, String generatorName, PropertyData inferredData, Ejb3Column[] columns, PropertyHolder propertyHolder, Map<String, IdGenerator> localGenerators, boolean isComposite, boolean isPropertyAnnotated, String propertyAccessor, EntityBinder entityBinder, org.hibernate.annotations.Type typeAnn, boolean isEmbedded, boolean isIdentifierMapper, ExtendedMappings mappings) {
        SimpleValue id;
        String persistentClassName;
        PersistentClass persistentClass = propertyHolder.getPersistentClass();
        if (!(persistentClass instanceof RootClass)) {
            throw new AnnotationException("Unable to define/override @Id(s) on a subclass: " + propertyHolder.getEntityName());
        }
        RootClass rootClass = (RootClass)persistentClass;
        String string = persistentClassName = rootClass == null ? null : rootClass.getClassName();
        if (isComposite) {
            Component componentId = id = AnnotationBinder.fillComponent(propertyHolder, inferredData, isPropertyAnnotated, propertyAccessor, false, entityBinder, isEmbedded, isIdentifierMapper, false, mappings);
            componentId.setKey(true);
            if (componentId.getPropertySpan() == 0) {
                throw new AnnotationException(componentId.getComponentClassName() + " has no persistent id property");
            }
            XProperty property = inferredData.getProperty();
            AnnotationBinder.setupComponentTuplizer(property, componentId);
        } else {
            for (Ejb3Column column : columns) {
                column.forceNotNull();
            }
            SimpleValueBinder value = new SimpleValueBinder();
            value.setPropertyName(inferredData.getPropertyName());
            value.setReturnedClassName(inferredData.getTypeName());
            value.setColumns(columns);
            value.setPersistentClassName(persistentClassName);
            value.setMappings(mappings);
            value.setExplicitType(typeAnn);
            id = value.make();
        }
        rootClass.setIdentifier(id);
        BinderHelper.makeIdGenerator(id, generatorType, generatorName, mappings, localGenerators);
        if (isEmbedded) {
            rootClass.setEmbeddedIdentifier(inferredData.getPropertyClass() == null);
        } else {
            PropertyBinder binder = new PropertyBinder();
            binder.setName(inferredData.getPropertyName());
            binder.setValue(id);
            binder.setPropertyAccessorName(inferredData.getDefaultAccess());
            binder.setProperty(inferredData.getProperty());
            Property prop = binder.make();
            rootClass.setIdentifierProperty(prop);
        }
    }

    private static void setupComponentTuplizer(XProperty property, Component component) {
        if (property == null) {
            return;
        }
        if (property.isAnnotationPresent(Tuplizers.class)) {
            for (Tuplizer tuplizer : property.getAnnotation(Tuplizers.class).value()) {
                EntityMode mode = EntityMode.parse(tuplizer.entityMode());
                component.addTuplizer(mode, tuplizer.impl().getName());
            }
        }
        if (property.isAnnotationPresent(Tuplizer.class)) {
            Tuplizer tuplizer = property.getAnnotation(Tuplizer.class);
            EntityMode mode = EntityMode.parse(tuplizer.entityMode());
            component.addTuplizer(mode, tuplizer.impl().getName());
        }
    }

    private static void bindManyToOne(String cascadeStrategy, Ejb3JoinColumn[] columns, boolean optional, boolean ignoreNotFound, boolean cascadeOnDelete, XClass targetEntity, PropertyHolder propertyHolder, PropertyData inferredData, boolean unique, boolean isIdentifierMapper, boolean inSecondPass, ExtendedMappings mappings) {
        String fkName;
        ManyToOne value = new ManyToOne(columns[0].getTable());
        if (AnnotationBinder.isDefault(targetEntity, mappings)) {
            value.setReferencedEntityName(inferredData.getClassOrElementName());
        } else {
            value.setReferencedEntityName(targetEntity.getName());
        }
        AnnotationBinder.defineFetchingStrategy(value, inferredData.getProperty());
        value.setIgnoreNotFound(ignoreNotFound);
        value.setCascadeDeleteEnabled(cascadeOnDelete);
        if (!optional) {
            for (Ejb3JoinColumn column : columns) {
                column.setNullable(false);
            }
        }
        value.setTypeName(inferredData.getClassOrElementName());
        String propertyName = inferredData.getPropertyName();
        value.setTypeUsingReflection(propertyHolder.getClassName(), propertyName);
        ForeignKey fk = inferredData.getProperty().getAnnotation(ForeignKey.class);
        String string = fkName = fk != null ? fk.name() : "";
        if (!BinderHelper.isDefault(fkName)) {
            value.setForeignKeyName(fkName);
        }
        String path = propertyHolder.getPath() + "." + propertyName;
        FkSecondPass secondPass = new FkSecondPass(value, columns, !optional && unique, propertyHolder.getEntityOwnerClassName(), path, mappings);
        if (inSecondPass) {
            secondPass.doSecondPass(mappings.getClasses());
        } else {
            mappings.addSecondPass(secondPass);
        }
        Ejb3Column.checkPropertyConsistency(columns, propertyHolder.getEntityName() + propertyName);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(propertyName);
        binder.setValue(value);
        if (isIdentifierMapper) {
            binder.setInsertable(false);
            binder.setInsertable(false);
        } else {
            binder.setInsertable(columns[0].isInsertable());
            binder.setUpdatable(columns[0].isUpdatable());
        }
        binder.setPropertyAccessorName(inferredData.getDefaultAccess());
        binder.setCascade(cascadeStrategy);
        Property prop = binder.make();
        propertyHolder.addProperty(prop, columns);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static void defineFetchingStrategy(ToOne toOne, XProperty property) {
        FetchType fetchType;
        LazyToOne lazy = property.getAnnotation(LazyToOne.class);
        Fetch fetch = property.getAnnotation(Fetch.class);
        javax.persistence.ManyToOne manyToOne = property.getAnnotation(javax.persistence.ManyToOne.class);
        OneToOne oneToOne = property.getAnnotation(OneToOne.class);
        if (manyToOne != null) {
            fetchType = manyToOne.fetch();
        } else {
            if (oneToOne == null) throw new AssertionFailure("Define fetch strategy on a property not annotated with @OneToMany nor @OneToOne");
            fetchType = oneToOne.fetch();
        }
        if (lazy != null) {
            toOne.setLazy(lazy.value() != LazyToOneOption.FALSE);
            toOne.setUnwrapProxy(lazy.value() == LazyToOneOption.NO_PROXY);
        } else {
            toOne.setLazy(fetchType == FetchType.LAZY);
            toOne.setUnwrapProxy(false);
        }
        if (fetch == null) {
            toOne.setFetchMode(AnnotationBinder.getFetchMode(fetchType));
            return;
        }
        if (fetch.value() == org.hibernate.annotations.FetchMode.JOIN) {
            toOne.setFetchMode(FetchMode.JOIN);
            toOne.setLazy(false);
            toOne.setUnwrapProxy(false);
            return;
        }
        if (fetch.value() == org.hibernate.annotations.FetchMode.SELECT) {
            toOne.setFetchMode(FetchMode.SELECT);
            return;
        }
        if (fetch.value() != org.hibernate.annotations.FetchMode.SUBSELECT) throw new AssertionFailure("Unknown FetchMode: " + (Object)((Object)fetch.value()));
        throw new AnnotationException("Use of FetchMode.SUBSELECT not allowed on ToOne associations");
    }

    private static void bindOneToOne(String cascadeStrategy, Ejb3JoinColumn[] joinColumns, boolean optional, FetchMode fetchMode, boolean ignoreNotFound, boolean cascadeOnDelete, XClass targetEntity, PropertyHolder propertyHolder, PropertyData inferredData, String mappedBy, boolean trueOneToOne, boolean isIdentifierMapper, boolean inSecondPass, ExtendedMappings mappings) {
        String propertyName = inferredData.getPropertyName();
        log.debug("Fetching " + propertyName + " with " + fetchMode);
        boolean mapToPK = true;
        if (!trueOneToOne) {
            Iterator idColumns = propertyHolder.getIdentifier().getColumnIterator();
            ArrayList<String> idColumnNames = new ArrayList<String>();
            while (idColumns.hasNext()) {
                Column currentColumn = (Column)idColumns.next();
                idColumnNames.add(currentColumn.getName());
            }
            for (Ejb3JoinColumn col : joinColumns) {
                if (idColumnNames.contains(col.getMappingColumn().getName())) continue;
                mapToPK = false;
                break;
            }
        }
        if (trueOneToOne || mapToPK || !BinderHelper.isDefault(mappedBy)) {
            OneToOneSecondPass secondPass = new OneToOneSecondPass(mappedBy, propertyHolder.getEntityName(), propertyName, propertyHolder, inferredData, targetEntity, ignoreNotFound, cascadeOnDelete, optional, cascadeStrategy, joinColumns, mappings);
            if (inSecondPass) {
                secondPass.doSecondPass(mappings.getClasses());
            } else {
                mappings.addSecondPass(secondPass, BinderHelper.isDefault(mappedBy));
            }
        } else {
            AnnotationBinder.bindManyToOne(cascadeStrategy, joinColumns, optional, ignoreNotFound, cascadeOnDelete, targetEntity, propertyHolder, inferredData, true, isIdentifierMapper, inSecondPass, mappings);
        }
    }

    private static String generatorType(GenerationType generatorEnum) {
        switch (generatorEnum) {
            case IDENTITY: {
                return "identity";
            }
            case AUTO: {
                return "native";
            }
            case TABLE: {
                return MultipleHiLoPerTableGenerator.class.getName();
            }
            case SEQUENCE: {
                return "seqhilo";
            }
        }
        throw new AssertionFailure("Unknown GeneratorType: " + (Object)((Object)generatorEnum));
    }

    private static EnumSet<org.hibernate.annotations.CascadeType> convertToHibernateCascadeType(CascadeType[] ejbCascades) {
        EnumSet<org.hibernate.annotations.CascadeType> hibernateCascadeSet = EnumSet.noneOf(org.hibernate.annotations.CascadeType.class);
        if (ejbCascades != null && ejbCascades.length > 0) {
            block7: for (CascadeType cascade : ejbCascades) {
                switch (cascade) {
                    case ALL: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.ALL);
                        continue block7;
                    }
                    case PERSIST: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.PERSIST);
                        continue block7;
                    }
                    case MERGE: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.MERGE);
                        continue block7;
                    }
                    case REMOVE: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.REMOVE);
                        continue block7;
                    }
                    case REFRESH: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.REFRESH);
                    }
                }
            }
        }
        return hibernateCascadeSet;
    }

    private static String getCascadeStrategy(CascadeType[] ejbCascades, Cascade hibernateCascadeAnnotation) {
        org.hibernate.annotations.CascadeType[] hibernateCascades;
        EnumSet<org.hibernate.annotations.CascadeType> hibernateCascadeSet = AnnotationBinder.convertToHibernateCascadeType(ejbCascades);
        org.hibernate.annotations.CascadeType[] cascadeTypeArray = hibernateCascades = hibernateCascadeAnnotation == null ? null : hibernateCascadeAnnotation.value();
        if (hibernateCascades != null && hibernateCascades.length > 0) {
            for (org.hibernate.annotations.CascadeType cascadeType : hibernateCascades) {
                hibernateCascadeSet.add(cascadeType);
            }
        }
        StringBuilder cascade = new StringBuilder();
        Iterator cascadeType = hibernateCascadeSet.iterator();
        while (cascadeType.hasNext()) {
            switch ((org.hibernate.annotations.CascadeType)((Object)cascadeType.next())) {
                case ALL: {
                    cascade.append(",").append("all");
                    break;
                }
                case SAVE_UPDATE: {
                    cascade.append(",").append("save-update");
                    break;
                }
                case PERSIST: {
                    cascade.append(",").append("persist");
                    break;
                }
                case MERGE: {
                    cascade.append(",").append("merge");
                    break;
                }
                case LOCK: {
                    cascade.append(",").append("lock");
                    break;
                }
                case REFRESH: {
                    cascade.append(",").append("refresh");
                    break;
                }
                case REPLICATE: {
                    cascade.append(",").append("replicate");
                    break;
                }
                case EVICT: {
                    cascade.append(",").append("evict");
                    break;
                }
                case DELETE: {
                    cascade.append(",").append("delete");
                    break;
                }
                case DELETE_ORPHAN: {
                    cascade.append(",").append("delete-orphan");
                    break;
                }
                case REMOVE: {
                    cascade.append(",").append("delete");
                }
            }
        }
        return cascade.length() > 0 ? cascade.substring(1) : "none";
    }

    public static FetchMode getFetchMode(FetchType fetch) {
        if (fetch == FetchType.EAGER) {
            return FetchMode.JOIN;
        }
        return FetchMode.SELECT;
    }

    private static HashMap<String, IdGenerator> buildLocalGenerators(XAnnotatedElement annElt, Mappings mappings) {
        IdGenerator idGen;
        HashMap<String, IdGenerator> generators = new HashMap<String, IdGenerator>();
        TableGenerator tabGen = annElt.getAnnotation(TableGenerator.class);
        SequenceGenerator seqGen = annElt.getAnnotation(SequenceGenerator.class);
        GenericGenerator genGen = annElt.getAnnotation(GenericGenerator.class);
        if (tabGen != null) {
            idGen = AnnotationBinder.buildIdGenerator(tabGen, mappings);
            generators.put(idGen.getName(), idGen);
        }
        if (seqGen != null) {
            idGen = AnnotationBinder.buildIdGenerator(seqGen, mappings);
            generators.put(idGen.getName(), idGen);
        }
        if (genGen != null) {
            idGen = AnnotationBinder.buildIdGenerator(genGen, mappings);
            generators.put(idGen.getName(), idGen);
        }
        return generators;
    }

    public static boolean isDefault(XClass clazz, ExtendedMappings mappings) {
        return mappings.getReflectionManager().equals(clazz, Void.TYPE);
    }

    public static Map<XClass, InheritanceState> buildInheritanceStates(List<XClass> orderedClasses, ReflectionManager reflectionManager) {
        HashMap<XClass, InheritanceState> inheritanceStatePerClass = new HashMap<XClass, InheritanceState>(orderedClasses.size());
        for (XClass clazz : orderedClasses) {
            InheritanceState superclassState = InheritanceState.getSuperclassInheritanceState(clazz, inheritanceStatePerClass, reflectionManager);
            InheritanceState state = new InheritanceState(clazz);
            if (superclassState != null) {
                boolean nonDefault;
                superclassState.hasSons = true;
                InheritanceState superEntityState = InheritanceState.getSuperEntityInheritanceState(clazz, inheritanceStatePerClass, reflectionManager);
                state.hasParents = superEntityState != null;
                boolean bl = nonDefault = state.type != null && !InheritanceType.SINGLE_TABLE.equals((Object)state.type);
                if (superclassState.type != null) {
                    boolean mixingStrategy;
                    boolean bl2 = mixingStrategy = state.type != null && !state.type.equals((Object)superclassState.type);
                    if (nonDefault && mixingStrategy) {
                        log.warn("Mixing inheritance strategy in a entity hierarchy is not allowed, ignoring sub strategy in: " + clazz.getName());
                    }
                    state.type = superclassState.type;
                }
            }
            inheritanceStatePerClass.put(clazz, state);
        }
        return inheritanceStatePerClass;
    }
}

