/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.loading;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.loading.CollectionLoadContext;
import org.hibernate.engine.loading.EntityLoadContext;
import org.hibernate.engine.loading.LoadingCollectionEntry;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.util.IdentityMap;

public class LoadContexts {
    private static final Log log = LogFactory.getLog(LoadContexts.class);
    private final PersistenceContext persistenceContext;
    private Map collectionLoadContexts;
    private Map entityLoadContexts;
    private Map xrefLoadingCollectionEntries;

    public LoadContexts(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    private SessionImplementor getSession() {
        return this.getPersistenceContext().getSession();
    }

    private EntityMode getEntityMode() {
        return this.getSession().getEntityMode();
    }

    public void cleanup(ResultSet resultSet) {
        if (this.collectionLoadContexts != null) {
            CollectionLoadContext collectionLoadContext = (CollectionLoadContext)this.collectionLoadContexts.remove(resultSet);
            collectionLoadContext.cleanup();
        }
        if (this.entityLoadContexts != null) {
            EntityLoadContext entityLoadContext = (EntityLoadContext)this.entityLoadContexts.remove(resultSet);
            entityLoadContext.cleanup();
        }
    }

    public void cleanup() {
        Iterator itr;
        if (this.collectionLoadContexts != null) {
            itr = this.collectionLoadContexts.values().iterator();
            while (itr.hasNext()) {
                CollectionLoadContext collectionLoadContext = (CollectionLoadContext)itr.next();
                log.warn("fail-safe cleanup (collections) : " + collectionLoadContext);
                collectionLoadContext.cleanup();
            }
            this.collectionLoadContexts.clear();
        }
        if (this.entityLoadContexts != null) {
            itr = this.entityLoadContexts.values().iterator();
            while (itr.hasNext()) {
                EntityLoadContext entityLoadContext = (EntityLoadContext)itr.next();
                log.warn("fail-safe cleanup (entities) : " + entityLoadContext);
                entityLoadContext.cleanup();
            }
            this.entityLoadContexts.clear();
        }
    }

    public boolean hasLoadingCollectionEntries() {
        return this.xrefLoadingCollectionEntries != null && !this.xrefLoadingCollectionEntries.isEmpty();
    }

    public CollectionLoadContext getCollectionLoadContext(ResultSet resultSet) {
        CollectionLoadContext context = null;
        if (this.collectionLoadContexts == null) {
            this.collectionLoadContexts = IdentityMap.instantiate(8);
        } else {
            context = (CollectionLoadContext)this.collectionLoadContexts.get(resultSet);
        }
        if (context == null) {
            if (log.isTraceEnabled()) {
                log.trace("constructing collection load context for result set [" + resultSet + "]");
            }
            context = new CollectionLoadContext(this, resultSet);
            this.collectionLoadContexts.put(resultSet, context);
        }
        return context;
    }

    public PersistentCollection locateLoadingCollection(CollectionPersister persister, Serializable ownerKey) {
        LoadingCollectionEntry lce = this.locateLoadingCollectionEntry(new CollectionKey(persister, ownerKey, this.getEntityMode()));
        if (lce != null) {
            if (log.isTraceEnabled()) {
                log.trace("returning loading collection:" + MessageHelper.collectionInfoString(persister, ownerKey, this.getSession().getFactory()));
            }
            return lce.getCollection();
        }
        if (log.isTraceEnabled()) {
            log.trace("creating collection wrapper:" + MessageHelper.collectionInfoString(persister, ownerKey, this.getSession().getFactory()));
        }
        return null;
    }

    void registerLoadingCollectionXRef(CollectionKey entryKey, LoadingCollectionEntry entry) {
        if (this.xrefLoadingCollectionEntries == null) {
            this.xrefLoadingCollectionEntries = new HashMap();
        }
        this.xrefLoadingCollectionEntries.put(entryKey, entry);
    }

    void unregisterLoadingCollectionXRef(CollectionKey key) {
        if (!this.hasLoadingCollectionEntries()) {
            return;
        }
        this.xrefLoadingCollectionEntries.remove(key);
    }

    Map getLoadingCollectionXRefs() {
        return this.xrefLoadingCollectionEntries;
    }

    LoadingCollectionEntry locateLoadingCollectionEntry(CollectionKey key) {
        if (this.xrefLoadingCollectionEntries == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("attempting to locate loading collection entry [" + key + "] in any result-set context");
        }
        LoadingCollectionEntry rtn = (LoadingCollectionEntry)this.xrefLoadingCollectionEntries.get(key);
        if (log.isTraceEnabled()) {
            if (rtn == null) {
                log.trace("collection [" + key + "] located in load context");
            } else {
                log.trace("collection [" + key + "] not located in load context");
            }
        }
        return rtn;
    }

    void cleanupCollectionXRefs(Set entryKeys) {
        Iterator itr = entryKeys.iterator();
        while (itr.hasNext()) {
            CollectionKey entryKey = (CollectionKey)itr.next();
            this.xrefLoadingCollectionEntries.remove(entryKey);
        }
    }

    public EntityLoadContext getEntityLoadContext(ResultSet resultSet) {
        EntityLoadContext context = null;
        if (this.entityLoadContexts == null) {
            this.entityLoadContexts = IdentityMap.instantiate(8);
        } else {
            context = (EntityLoadContext)this.entityLoadContexts.get(resultSet);
        }
        if (context == null) {
            context = new EntityLoadContext(this, resultSet);
            this.entityLoadContexts.put(resultSet, context);
        }
        return context;
    }
}

