/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.PersistentObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.entry.CacheEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.TwoPhaseLoad;
import org.hibernate.engine.Versioning;
import org.hibernate.event.EventSource;
import org.hibernate.event.LoadEvent;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.def.AbstractLockUpgradeEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class DefaultLoadEventListener
extends AbstractLockUpgradeEventListener
implements LoadEventListener {
    public static final Object REMOVED_ENTITY_MARKER = new Object();
    public static final Object INCONSISTENT_RTN_CLASS_MARKER = new Object();
    public static final LockMode DEFAULT_LOCK_MODE = LockMode.NONE;
    private static final Log log = LogFactory.getLog(DefaultLoadEventListener.class);

    public void onLoad(LoadEvent event, LoadEventListener.LoadType loadType) throws HibernateException {
        Class idClass;
        EntityPersister persister;
        EventSource source = event.getSession();
        if (event.getInstanceToLoad() != null) {
            persister = source.getEntityPersister(null, event.getInstanceToLoad());
            event.setEntityClassName(event.getInstanceToLoad().getClass().getName());
        } else {
            persister = source.getFactory().getEntityPersister(event.getEntityClassName());
        }
        if (persister == null) {
            throw new HibernateException("Unable to locate persister: " + event.getEntityClassName());
        }
        if (!(persister.getIdentifierType().isComponentType() && EntityMode.DOM4J == event.getSession().getEntityMode() || (idClass = persister.getIdentifierType().getReturnedClass()) == null || idClass.isInstance(event.getEntityId()))) {
            throw new TypeMismatchException("Provided id of the wrong type. Expected: " + idClass + ", got " + event.getEntityId().getClass());
        }
        EntityKey keyToLoad = new EntityKey(event.getEntityId(), persister, source.getEntityMode());
        try {
            if (loadType.isNakedEntityReturned()) {
                event.setResult(this.load(event, persister, keyToLoad, loadType));
            } else if (event.getLockMode() == LockMode.NONE) {
                event.setResult(this.proxyOrLoad(event, persister, keyToLoad, loadType));
            } else {
                event.setResult(this.lockAndLoad(event, persister, keyToLoad, loadType, source));
            }
        }
        catch (HibernateException e) {
            log.info("Error performing load command", e);
            throw e;
        }
    }

    protected Object load(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) throws HibernateException {
        boolean isOptionalInstance;
        if (event.getInstanceToLoad() != null) {
            if (event.getSession().getPersistenceContext().getEntry(event.getInstanceToLoad()) != null) {
                throw new PersistentObjectException("attempted to load into an instance that was already associated with the session: " + MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory()));
            }
            persister.setIdentifier(event.getInstanceToLoad(), event.getEntityId(), event.getSession().getEntityMode());
        }
        Object entity = this.doLoad(event, persister, keyToLoad, options);
        boolean bl = isOptionalInstance = event.getInstanceToLoad() != null;
        if ((!options.isAllowNulls() || isOptionalInstance) && entity == null) {
            event.getSession().getFactory().getEntityNotFoundDelegate().handleEntityNotFound(event.getEntityClassName(), event.getEntityId());
        }
        if (isOptionalInstance && entity != event.getInstanceToLoad()) {
            throw new NonUniqueObjectException(event.getEntityId(), event.getEntityClassName());
        }
        return entity;
    }

    protected Object proxyOrLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace("loading entity: " + MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory()));
        }
        if (!persister.hasProxy()) {
            return this.load(event, persister, keyToLoad, options);
        }
        PersistenceContext persistenceContext = event.getSession().getPersistenceContext();
        Object proxy = persistenceContext.getProxy(keyToLoad);
        if (proxy != null) {
            return this.returnNarrowedProxy(event, persister, keyToLoad, options, persistenceContext, proxy);
        }
        if (options.isAllowProxyCreation()) {
            return this.createProxyIfNecessary(event, persister, keyToLoad, options, persistenceContext);
        }
        return this.load(event, persister, keyToLoad, options);
    }

    private Object returnNarrowedProxy(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, PersistenceContext persistenceContext, Object proxy) {
        log.trace("entity proxy found in session cache");
        LazyInitializer li = ((HibernateProxy)proxy).getHibernateLazyInitializer();
        if (li.isUnwrap()) {
            return li.getImplementation();
        }
        Object impl = null;
        if (!options.isAllowProxyCreation() && (impl = this.load(event, persister, keyToLoad, options)) == null) {
            event.getSession().getFactory().getEntityNotFoundDelegate().handleEntityNotFound(persister.getEntityName(), keyToLoad.getIdentifier());
        }
        return persistenceContext.narrowProxy(proxy, persister, keyToLoad, impl);
    }

    private Object createProxyIfNecessary(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, PersistenceContext persistenceContext) {
        Object existing = persistenceContext.getEntity(keyToLoad);
        if (existing != null) {
            EntityEntry entry;
            Status status;
            log.trace("entity found in session cache");
            if (options.isCheckDeleted() && ((status = (entry = persistenceContext.getEntry(existing)).getStatus()) == Status.DELETED || status == Status.GONE)) {
                return null;
            }
            return existing;
        }
        log.trace("creating new proxy for entity");
        Object proxy = persister.createProxy(event.getEntityId(), event.getSession());
        persistenceContext.getBatchFetchQueue().addBatchLoadableEntityKey(keyToLoad);
        persistenceContext.addProxy(keyToLoad, proxy);
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object lockAndLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options, SessionImplementor source) throws HibernateException {
        Object entity;
        CacheKey ck;
        CacheConcurrencyStrategy.SoftLock lock = null;
        if (persister.hasCache()) {
            ck = new CacheKey(event.getEntityId(), persister.getIdentifierType(), persister.getRootEntityName(), source.getEntityMode(), source.getFactory());
            lock = persister.getCache().lock(ck, null);
        } else {
            ck = null;
        }
        try {
            entity = this.load(event, persister, keyToLoad, options);
            if (!persister.hasCache()) return event.getSession().getPersistenceContext().proxyFor(persister, keyToLoad, entity);
        }
        catch (Throwable throwable) {
            if (!persister.hasCache()) throw throwable;
            persister.getCache().release(ck, lock);
            throw throwable;
        }
        persister.getCache().release(ck, lock);
        return event.getSession().getPersistenceContext().proxyFor(persister, keyToLoad, entity);
    }

    protected Object doLoad(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) throws HibernateException {
        Object entity;
        if (log.isTraceEnabled()) {
            log.trace("attempting to resolve: " + MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory()));
        }
        if ((entity = this.loadFromSessionCache(event, keyToLoad, options)) == REMOVED_ENTITY_MARKER) {
            log.debug("load request found matching entity in context, but it is scheduled for removal; returning null");
            return null;
        }
        if (entity == INCONSISTENT_RTN_CLASS_MARKER) {
            log.debug("load request found matching entity in context, but the matched entity was of an inconsistent return type; returning null");
            return null;
        }
        if (entity != null) {
            if (log.isTraceEnabled()) {
                log.trace("resolved object in session cache: " + MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory()));
            }
            return entity;
        }
        entity = this.loadFromSecondLevelCache(event, persister, options);
        if (entity != null) {
            if (log.isTraceEnabled()) {
                log.trace("resolved object in second-level cache: " + MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory()));
            }
            return entity;
        }
        if (log.isTraceEnabled()) {
            log.trace("object not resolved in any cache: " + MessageHelper.infoString(persister, event.getEntityId(), event.getSession().getFactory()));
        }
        return this.loadFromDatasource(event, persister, keyToLoad, options);
    }

    protected Object loadFromDatasource(LoadEvent event, EntityPersister persister, EntityKey keyToLoad, LoadEventListener.LoadType options) throws HibernateException {
        EventSource source = event.getSession();
        Object entity = persister.load(event.getEntityId(), event.getInstanceToLoad(), event.getLockMode(), source);
        if (event.isAssociationFetch() && source.getFactory().getStatistics().isStatisticsEnabled()) {
            source.getFactory().getStatisticsImplementor().fetchEntity(event.getEntityClassName());
        }
        return entity;
    }

    protected Object loadFromSessionCache(LoadEvent event, EntityKey keyToLoad, LoadEventListener.LoadType options) throws HibernateException {
        EventSource session = event.getSession();
        Object old = session.getEntityUsingInterceptor(keyToLoad);
        if (old != null) {
            EntityPersister persister;
            Status status;
            EntityEntry oldEntry = session.getPersistenceContext().getEntry(old);
            if (options.isCheckDeleted() && ((status = oldEntry.getStatus()) == Status.DELETED || status == Status.GONE)) {
                return REMOVED_ENTITY_MARKER;
            }
            if (options.isAllowNulls() && !(persister = event.getSession().getFactory().getEntityPersister(event.getEntityClassName())).isInstance(old, event.getSession().getEntityMode())) {
                return INCONSISTENT_RTN_CLASS_MARKER;
            }
            this.upgradeLock(old, oldEntry, event.getLockMode(), session);
        }
        return old;
    }

    protected Object loadFromSecondLevelCache(LoadEvent event, EntityPersister persister, LoadEventListener.LoadType options) throws HibernateException {
        boolean useCache;
        EventSource source = event.getSession();
        boolean bl = useCache = persister.hasCache() && source.getCacheMode().isGetEnabled() && event.getLockMode().lessThan(LockMode.READ);
        if (useCache) {
            SessionFactoryImplementor factory = source.getFactory();
            CacheKey ck = new CacheKey(event.getEntityId(), persister.getIdentifierType(), persister.getRootEntityName(), source.getEntityMode(), source.getFactory());
            Object ce = persister.getCache().get(ck, source.getTimestamp());
            if (factory.getStatistics().isStatisticsEnabled()) {
                if (ce == null) {
                    factory.getStatisticsImplementor().secondLevelCacheMiss(persister.getCache().getRegionName());
                } else {
                    factory.getStatisticsImplementor().secondLevelCacheHit(persister.getCache().getRegionName());
                }
            }
            if (ce != null) {
                CacheEntry entry = (CacheEntry)persister.getCacheEntryStructure().destructure(ce, factory);
                return this.assembleCacheEntry(entry, event.getEntityId(), persister, event);
            }
        }
        return null;
    }

    private Object assembleCacheEntry(CacheEntry entry, Serializable id, EntityPersister persister, LoadEvent event) throws HibernateException {
        Object optionalObject = event.getInstanceToLoad();
        EventSource session = event.getSession();
        SessionFactoryImplementor factory = session.getFactory();
        if (log.isTraceEnabled()) {
            log.trace("assembling entity from second-level cache: " + MessageHelper.infoString(persister, id, factory));
        }
        EntityPersister subclassPersister = factory.getEntityPersister(entry.getSubclass());
        Object result = optionalObject == null ? session.instantiate(subclassPersister, id) : optionalObject;
        TwoPhaseLoad.addUninitializedCachedEntity(new EntityKey(id, subclassPersister, session.getEntityMode()), result, subclassPersister, LockMode.NONE, entry.areLazyPropertiesUnfetched(), entry.getVersion(), session);
        Type[] types = subclassPersister.getPropertyTypes();
        Object[] values = entry.assemble(result, id, subclassPersister, session.getInterceptor(), session);
        TypeFactory.deepCopy(values, types, subclassPersister.getPropertyUpdateability(), values, session);
        Object version2 = Versioning.getVersion(values, subclassPersister);
        if (log.isTraceEnabled()) {
            log.trace("Cached Version: " + version2);
        }
        PersistenceContext persistenceContext = session.getPersistenceContext();
        persistenceContext.addEntry(result, Status.MANAGED, values, null, id, version2, LockMode.NONE, true, subclassPersister, false, entry.areLazyPropertiesUnfetched());
        subclassPersister.afterInitialize(result, entry.areLazyPropertiesUnfetched(), session);
        persistenceContext.initializeNonLazyCollections();
        PostLoadEvent postLoadEvent = new PostLoadEvent(session).setEntity(result).setId(id).setPersister(persister);
        PostLoadEventListener[] listeners = session.getListeners().getPostLoadEventListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].onPostLoad(postLoadEvent);
        }
        return result;
    }
}

