/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.pretty;

import java.util.StringTokenizer;

public class DDLFormatter {
    private String sql;

    public DDLFormatter(String sql) {
        this.sql = sql;
    }

    public String format() {
        if (this.sql.toLowerCase().startsWith("create table")) {
            return this.formatCreateTable();
        }
        if (this.sql.toLowerCase().startsWith("alter table")) {
            return this.formatAlterTable();
        }
        if (this.sql.toLowerCase().startsWith("comment on")) {
            return this.formatCommentOn();
        }
        return "\n    " + this.sql;
    }

    private String formatCommentOn() {
        StringBuffer result = new StringBuffer(60).append("\n    ");
        StringTokenizer tokens = new StringTokenizer(this.sql, " '[]\"", true);
        boolean quoted = false;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            result.append(token);
            if (DDLFormatter.isQuote(token)) {
                quoted = !quoted;
                continue;
            }
            if (quoted || !"is".equals(token)) continue;
            result.append("\n       ");
        }
        return result.toString();
    }

    private String formatAlterTable() {
        StringBuffer result = new StringBuffer(60).append("\n    ");
        StringTokenizer tokens = new StringTokenizer(this.sql, " (,)'[]\"", true);
        boolean quoted = false;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (DDLFormatter.isQuote(token)) {
                quoted = !quoted;
            } else if (!quoted && DDLFormatter.isBreak(token)) {
                result.append("\n        ");
            }
            result.append(token);
        }
        return result.toString();
    }

    private String formatCreateTable() {
        StringBuffer result = new StringBuffer(60).append("\n    ");
        StringTokenizer tokens = new StringTokenizer(this.sql, "(,)'[]\"", true);
        int depth = 0;
        boolean quoted = false;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (DDLFormatter.isQuote(token)) {
                quoted = !quoted;
                result.append(token);
                continue;
            }
            if (quoted) {
                result.append(token);
                continue;
            }
            if (")".equals(token) && --depth == 0) {
                result.append("\n    ");
            }
            result.append(token);
            if (",".equals(token) && depth == 1) {
                result.append("\n       ");
            }
            if (!"(".equals(token) || ++depth != 1) continue;
            result.append("\n        ");
        }
        return result.toString();
    }

    private static boolean isBreak(String token) {
        return "drop".equals(token) || "add".equals(token) || "references".equals(token) || "foreign".equals(token) || "on".equals(token);
    }

    private static boolean isQuote(String tok) {
        return "\"".equals(tok) || "`".equals(tok) || "]".equals(tok) || "[".equals(tok) || "'".equals(tok);
    }
}

