/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class CSVWriter {
    private String newline = System.getProperty("line.separator");
    private OutputStreamWriter writer = null;
    private int nbrCols = 0;
    private int nbrRows = 0;

    public CSVWriter(File file, String string) throws IOException {
        if (string == null) {
            string = System.getProperty("file.encoding");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.writer = new OutputStreamWriter((OutputStream)fileOutputStream, string);
    }

    public void writeHeader(String[] stringArray) throws IOException {
        this.nbrCols = stringArray.length;
        this.doWriteData(stringArray);
    }

    public void writeData(String[] stringArray) throws IOException {
        this.doWriteData(stringArray);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    private void doWriteData(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                this.writer.write(";");
            }
            if (stringArray[i] == null) continue;
            this.writer.write("\"");
            this.writer.write(this.toCsvValue(stringArray[i]));
            this.writer.write("\"");
        }
        this.writer.write(this.newline);
        ++this.nbrRows;
    }

    private String toCsvValue(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append(c);
            switch (c) {
                case '\"': {
                    stringBuffer.append('\"');
                }
            }
        }
        return stringBuffer.toString();
    }
}

