/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class XsdElement {
    public static final QName QNAME_NAME = new QName("name");
    private final QName qName;
    private Map attributes = Collections.EMPTY_MAP;
    private Map children = Collections.EMPTY_MAP;
    private String data;

    public XsdElement(QName qName) {
        this.qName = qName;
    }

    public String getAttribute(QName qName) {
        return (String)this.attributes.get(qName);
    }

    public void addAttribute(QName qName, String value) {
        switch (this.attributes.size()) {
            case 0: {
                this.attributes = Collections.singletonMap(qName, value);
                break;
            }
            case 1: {
                this.attributes = new HashMap(this.attributes);
            }
            default: {
                this.attributes.put(qName, value);
            }
        }
    }

    public XsdElement getChild(QName qName) {
        return (XsdElement)this.children.get(qName);
    }

    public void addChild(XsdElement child) {
        switch (this.children.size()) {
            case 0: {
                this.children = Collections.singletonMap(child.qName, child);
                break;
            }
            case 1: {
                this.children = new HashMap(this.children);
            }
            default: {
                this.children.put(child.qName, child);
            }
        }
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public QName getQName() {
        return this.qName;
    }

    public String getNameAttribute() {
        return this.getAttribute(QNAME_NAME);
    }

    public void setNameAttribute(String name) {
        this.addAttribute(QNAME_NAME, name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XsdElement)) {
            return false;
        }
        XsdElement xsdElement = (XsdElement)o;
        return this.qName.equals(xsdElement.qName);
    }

    public int hashCode() {
        return this.qName.hashCode();
    }
}

