/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.InvalidFileSetException;
import org.objectweb.howl.log.InvalidLogBufferException;
import org.objectweb.howl.log.InvalidLogKeyException;
import org.objectweb.howl.log.LogBuffer;
import org.objectweb.howl.log.LogBufferManager;
import org.objectweb.howl.log.LogConfigurationException;
import org.objectweb.howl.log.LogEventListener;
import org.objectweb.howl.log.LogFile;
import org.objectweb.howl.log.LogFileOverflowException;
import org.objectweb.howl.log.LogObject;
import org.objectweb.howl.log.LogRecord;
import org.objectweb.howl.log.LogRecordSizeException;

class LogFileManager
extends LogObject {
    int maxBlocksPerFile = Integer.MAX_VALUE;
    long activeMark = 0L;
    boolean automark = false;
    boolean restartAutoMark = false;
    long currentKey = 0L;
    private long initialKey = 0L;
    final byte[] autoMarkOn = new byte[]{1};
    final byte[] autoMarkOff = new byte[]{0};
    private final Object fileManagerLock = new Object();
    LogFile[] fileSet = null;
    int lfIndex = 0;
    LogFile currentLogFile = null;
    byte[][] fileHeader = new byte[1][35];
    ByteBuffer fileHeaderBB = ByteBuffer.wrap(this.fileHeader[0]);
    byte[][] markRecord = new byte[1][19];
    ByteBuffer markRecordBB = ByteBuffer.wrap(this.markRecord[0]);
    byte[] crlf = "\r\n".getBytes();
    LogBufferManager bmgr;
    private LogEventListener eventListener = null;
    final Object eventManagerLock = new Object();
    Thread eventManagerThread = new EventManager("LogFileManager.EventManager");
    int event = 0;
    static final int LOG_OVERFLOW_EVENT = 1;
    private long lowestSafeLogKey = 0L;
    private int overflowNotificationCount = 0;
    private boolean initComplete = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    LogFileManager(Configuration config) {
        super(config);
        this.eventManagerThread.setDaemon(true);
        this.eventManagerThread.start();
    }

    LogFile getLogFileForMark(long mark) {
        LogFile lf = null;
        int requestBsn = this.bmgr.bsnFromMark(mark);
        int fsl = this.fileSet.length;
        if (mark == 0L) {
            int minBsn = Integer.MAX_VALUE;
            int minIndex = fsl;
            for (int i = 0; i < fsl; ++i) {
                lf = this.fileSet[i];
                if (lf.newFile || lf.firstBSN >= minBsn) continue;
                minBsn = lf.firstBSN;
                minIndex = i;
            }
            if (minIndex < fsl) {
                return this.fileSet[minIndex];
            }
            return null;
        }
        for (int i = 0; i < fsl; ++i) {
            lf = this.fileSet[i];
            if (lf.newFile || requestBsn < lf.firstBSN || mark >= lf.highMark) continue;
            return lf;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LogFile getLogFileForWrite(LogBuffer lb) throws LogFileOverflowException {
        block12: {
            try {
                Object object = this.fileManagerLock;
                synchronized (object) {
                    if (this.currentLogFile == null || (lb.bsn - 1) % this.maxBlocksPerFile == 0) {
                        int fsl = this.fileSet.length;
                        this.lfIndex %= fsl;
                        LogFile nextLogFile = this.fileSet[this.lfIndex];
                        if (!$assertionsDisabled && nextLogFile == null) {
                            throw new AssertionError((Object)"nextLogFile == null");
                        }
                        if (this.activeMark > 0L && this.activeMark < nextLogFile.highMark) {
                            throw new LogFileOverflowException(this.activeMark, nextLogFile.highMark, nextLogFile.file);
                        }
                        ++this.lfIndex;
                        nextLogFile.tod = System.currentTimeMillis();
                        nextLogFile.firstBSN = lb.bsn;
                        long highMark = this.bmgr.markFromBsn(lb.bsn, 0);
                        long switchTod = nextLogFile.tod;
                        if (this.currentLogFile != null) {
                            switchTod = this.currentLogFile.tod;
                            this.currentLogFile.highMark = highMark;
                        }
                        lb.rewind = true;
                        short type = 18432;
                        this.fileHeaderBB.clear();
                        this.fileHeaderBB.put(this.automark ? this.autoMarkOn : this.autoMarkOff);
                        this.fileHeaderBB.putLong(this.activeMark);
                        this.fileHeaderBB.putLong(highMark);
                        this.fileHeaderBB.putLong(switchTod);
                        this.fileHeaderBB.putInt(this.fileSet.length);
                        this.fileHeaderBB.putInt(this.maxBlocksPerFile);
                        this.fileHeaderBB.put(this.crlf);
                        if (!$assertionsDisabled && this.fileHeader[0].length != this.fileHeaderBB.position()) {
                            throw new AssertionError((Object)"byte[] fileHeader size error");
                        }
                        lb.lf = nextLogFile;
                        lb.put(type, this.fileHeader, false);
                        this.currentLogFile = nextLogFile;
                    } else {
                        short type = 17408;
                        this.setMarkData(this.markRecordBB);
                        if (!$assertionsDisabled && this.markRecord[0].length != this.markRecordBB.position()) {
                            throw new AssertionError((Object)"byte[] markRecord size error");
                        }
                        lb.lf = this.currentLogFile;
                        lb.put(type, this.markRecord, false);
                        lb.forceNow = lb.bsn % this.maxBlocksPerFile == 0;
                        this.detectLogOverflow(lb.bsn);
                    }
                }
            }
            catch (LogRecordSizeException e) {
                if ($assertionsDisabled) break block12;
                throw new AssertionError((Object)("Unhandled LogRecordSizeException" + e));
            }
        }
        this.currentLogFile.highMark = this.bmgr.markFromBsn(lb.bsn + 1, 0);
        this.currentLogFile.newFile = false;
        return this.currentLogFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectLogOverflow(int bsn) {
        if (bsn % this.maxBlocksPerFile > this.maxBlocksPerFile / 2) {
            LogFile nextLogFile = this.fileSet[this.lfIndex % this.fileSet.length];
            if (!$assertionsDisabled && nextLogFile == null) {
                throw new AssertionError((Object)"nextLogFile == null");
            }
            if (this.activeMark < nextLogFile.highMark) {
                Object object = this.eventManagerLock;
                synchronized (object) {
                    if ((this.event & 1) == 0) {
                        this.lowestSafeLogKey = nextLogFile.highMark;
                        this.event |= 1;
                        this.eventManagerLock.notifyAll();
                    }
                }
            }
        }
    }

    void setMarkData(ByteBuffer data) {
        data.clear();
        data.put(this.automark ? this.autoMarkOn : this.autoMarkOff);
        data.putLong(this.activeMark);
        data.putInt(this.fileSet.length);
        data.putInt(this.maxBlocksPerFile);
        data.put(this.crlf);
    }

    long mark(long key, boolean force) throws InvalidLogKeyException, IOException, InterruptedException {
        if (key < this.activeMark) {
            throw new InvalidLogKeyException(" key: " + Long.toHexString(key) + " less than activeMark: " + Long.toHexString(this.activeMark));
        }
        if (key > this.currentKey) {
            throw new InvalidLogKeyException(" key: " + Long.toHexString(key) + " greater than currentKey: " + Long.toHexString(this.currentKey));
        }
        byte[][] markData = new byte[1][this.markRecord[0].length];
        ByteBuffer markDataBuffer = ByteBuffer.wrap(markData[0]);
        short type = 17408;
        this.setMarkData(markDataBuffer);
        long markKey = 0L;
        try {
            markKey = this.bmgr.put(type, markData, force);
            this.activeMark = key;
        }
        catch (LogRecordSizeException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Unhandled LogRecordSizeException" + e));
            }
        }
        catch (LogFileOverflowException e) {
        }
        catch (IOException e) {
            IOException ioe = new IOException("LogFileManager.mark() [" + e.getMessage() + "]");
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
        return markKey;
    }

    long mark(long key) throws InvalidLogKeyException, IOException, InterruptedException {
        return this.mark(key, false);
    }

    int read(LogBuffer lb, int bsn) throws IOException, InvalidLogBufferException {
        LogFile lf;
        if (bsn < 0) {
            throw new IllegalArgumentException("BSN must be >= zero");
        }
        long mark = this.bmgr.markFromBsn(bsn, 0);
        lb.lf = lf = this.getLogFileForMark(mark);
        if (lf == null) {
            lb.bsn = -1;
            return -1;
        }
        long position = 0L;
        if (bsn > 0) {
            int blocksToSkip = bsn - lf.firstBSN;
            position = blocksToSkip * lb.buffer.capacity();
        }
        lb.read(lf, position);
        return lb.bsn < bsn ? -1 : lb.bsn;
    }

    long setAutoMark(boolean automark) throws InvalidLogKeyException, IOException, InterruptedException, LogFileOverflowException {
        this.automark = automark;
        return this.mark(automark ? this.currentKey : this.activeMark, false);
    }

    synchronized void setCurrentKey(long key) {
        if (key > this.currentKey) {
            this.currentKey = key;
            if (this.automark) {
                this.activeMark = this.currentKey;
            }
        }
    }

    long getHighMark() {
        if (this.currentLogFile == null) {
            throw new UnsupportedOperationException("LogFileManager.init() required");
        }
        return this.currentLogFile.highMark;
    }

    void setLogEventListener(LogEventListener eventListener) {
        this.eventListener = eventListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setLockOnFile(File name, boolean lock) {
        String property = "org.objectweb.howl." + name.getAbsolutePath() + ".locked";
        Class clazz = System.class;
        synchronized (clazz) {
            if (lock && Boolean.getBoolean(property)) {
                return false;
            }
            System.setProperty(property, Boolean.toString(lock));
            return true;
        }
    }

    void open() throws LogConfigurationException, IOException, FileNotFoundException, InvalidFileSetException {
        this.maxBlocksPerFile = this.config.getMaxBlocksPerFile();
        int maxLogFiles = this.config.getMaxLogFiles();
        if (maxLogFiles < 2) {
            throw new LogConfigurationException("Must configure two or more files");
        }
        String logDir = this.config.getLogFileDir();
        String logFileName = this.config.getLogFileName();
        String logFileExt = this.config.getLogFileExt();
        File dir2 = new File(logDir);
        dir2.mkdirs();
        int existingFiles = 0;
        this.fileSet = new LogFile[maxLogFiles];
        for (int i = 0; i < maxLogFiles; ++i) {
            File name = new File(logDir + "/" + logFileName + "_" + (i + 1) + "." + logFileExt);
            try {
                if (!this.setLockOnFile(name, true)) {
                    throw new LogConfigurationException("LogFileManager.open: unable to obtain lock on file " + name.getAbsolutePath());
                }
                this.fileSet[i] = new LogFile(name).open(this.config.getLogFileMode());
                if (this.fileSet[i].newFile) continue;
                if (existingFiles != i) {
                    throw new InvalidFileSetException();
                }
                ++existingFiles;
                continue;
            }
            catch (FileNotFoundException e) {
                this.setLockOnFile(name, false);
                while (--i >= 0) {
                    this.fileSet[i].close();
                    this.setLockOnFile(this.fileSet[i].file, false);
                    this.fileSet[i] = null;
                }
                System.err.println(this.getClass().getName() + ".open(); " + e);
                throw e;
            }
        }
        this.currentLogFile = null;
    }

    void init(LogBufferManager bmgr) throws IOException, LogConfigurationException, InvalidLogBufferException, InterruptedException {
        this.bmgr = bmgr;
        int lfIndex = 0;
        int bsn = 0;
        LogFile lf = null;
        LogBuffer lb = null;
        try {
            lb = bmgr.getLogBuffer(-1);
        }
        catch (ClassNotFoundException e) {
            throw new LogConfigurationException("LogBuffer.class not found", e);
        }
        for (int i = 0; i < this.fileSet.length; i = (int)((short)(i + 1))) {
            lf = this.fileSet[i];
            if (!$assertionsDisabled && lf == null) {
                throw new AssertionError((Object)"LogFile pointer lf is null");
            }
            if (lf.newFile) continue;
            try {
                lb.read(lf, 0L);
            }
            catch (IOException e) {
                IOException ioe = new IOException("LogFileManager.init(): error reading block zero " + lf.file.getName() + " [" + e.getMessage() + "]");
                ioe.setStackTrace(e.getStackTrace());
                throw ioe;
            }
            lf.firstBSN = lb.bsn;
            if (lb.bsn <= bsn) continue;
            bsn = lb.bsn;
            lfIndex = i;
        }
        int fsl = this.fileSet.length;
        for (int i = 0; i < fsl; ++i) {
            if (this.fileSet[i].newFile) continue;
            int next = (i + 1) % fsl;
            if (this.fileSet[next].newFile) continue;
            this.fileSet[i].highMark = bmgr.markFromBsn(this.fileSet[next].firstBSN, 0);
        }
        int blockSize = lb.buffer.capacity();
        lf = this.currentLogFile = this.fileSet[lfIndex];
        this.validateFileHeader(lb);
        long fpos = blockSize;
        if (lb.bsn > 0) {
            try {
                while (lb.read((LogFile)lf, (long)fpos).bsn > bsn) {
                    fpos += (long)blockSize;
                    bsn = lb.bsn;
                }
            }
            catch (InvalidLogBufferException e) {
                System.err.println(e);
            }
            catch (IOException e) {
                IOException ioe = new IOException("LogFileManager.init(): Attempting to loacate last block of file " + lf.file.getName() + " at position " + fpos + " [" + e.getMessage() + "]");
                ioe.setStackTrace(e.getStackTrace());
                ioe.printStackTrace();
                throw ioe;
            }
        }
        this.lfIndex = lf.newFile ? 0 : lfIndex + 1;
        bmgr.init(this, bsn);
        lf.highMark = this.initialKey = bmgr.markFromBsn(bsn + 1, 0);
        this.currentKey = this.initialKey;
        if (!$assertionsDisabled && fpos <= 0L) {
            throw new AssertionError((Object)("Unexpected file postion: " + fpos));
        }
        if (bsn > 0) {
            try {
                lb.read(lf, fpos - (long)blockSize);
            }
            catch (IOException e) {
                IOException ioe = new IOException("LogFileManager.init(): process MARK records in last block of file " + lf.file.getName() + " at position " + (fpos - (long)blockSize) + " [" + e.getMessage() + "]");
                ioe.setStackTrace(e.getStackTrace());
                throw ioe;
            }
            LogRecord record = new LogRecord(lb.buffer.capacity());
            ByteBuffer dataBuffer = record.dataBuffer;
            while (!record.get(lb).isEOB()) {
                if (record.type != 17408) continue;
                dataBuffer.clear();
                dataBuffer.getShort();
                this.automark = dataBuffer.get() == 1;
                this.activeMark = dataBuffer.getLong();
            }
            this.currentKey = record.key;
        } else {
            fpos = 0L;
            this.activeMark = bmgr.markFromBsn(1, 0);
        }
        if (this.automark) {
            this.activeMark = this.currentKey;
        }
        try {
            lf.channel.position(fpos);
        }
        catch (IOException e) {
            IOException ioe = new IOException("LogFileManager.init(): position log file " + lf.file.getName() + " for writing at position " + fpos + " [" + e.getMessage() + "]");
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
        this.initComplete = true;
    }

    void validateFileHeader(LogBuffer lb) throws LogConfigurationException, IOException, InvalidLogBufferException {
        LogFile lf = this.currentLogFile;
        lb.read(lf, 0L);
        if (lb.bsn == -1) {
            return;
        }
        LogRecord fh = new LogRecord(this.fileHeader[0].length);
        fh.get(lb);
        if (fh.type != 18432) {
            throw new InvalidLogBufferException("HEADER_TYPE: " + Integer.toHexString(fh.type));
        }
        if (fh.length != this.fileHeader[0].length + 2) {
            throw new InvalidLogBufferException("HEADER_SIZE: expected length(" + (this.fileHeader[0].length + 2) + ") found (" + fh.length + ")");
        }
        ByteBuffer dataBuffer = fh.dataBuffer;
        dataBuffer.clear();
        dataBuffer.getShort();
        this.automark = dataBuffer.get() == 1;
        this.activeMark = dataBuffer.getLong();
        dataBuffer.getLong();
        dataBuffer.getLong();
        int nFiles = dataBuffer.getInt();
        if (nFiles != this.fileSet.length) {
            throw new LogConfigurationException("Current configuration number of files [" + this.fileSet.length + "] not equal number of files in set [" + nFiles + "]");
        }
        int nBlocks = dataBuffer.getInt();
        if (nBlocks != this.maxBlocksPerFile) {
            throw new LogConfigurationException("Configured file size [" + this.maxBlocksPerFile + "] blocks not equal previous file size [" + nBlocks + "] blocks");
        }
        short crlf = dataBuffer.getShort();
        if (crlf != 3338) {
            throw new InvalidLogBufferException("FILE_HEADER: expecting CRLF found " + Integer.toHexString(crlf));
        }
        if (!$assertionsDisabled && dataBuffer.capacity() != dataBuffer.position()) {
            throw new AssertionError((Object)"byte[] fileHeader size error");
        }
    }

    void closeBufferManager() throws InterruptedException, IOException {
        this.bmgr.flushAll();
        byte[][] closeData = new byte[1][2];
        ByteBuffer closeDataBuffer = ByteBuffer.wrap(closeData[0]);
        closeDataBuffer.clear();
        closeDataBuffer.put(this.crlf);
        try {
            this.bmgr.put((short)16896, closeData, false);
        }
        catch (LogRecordSizeException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Unhandled LogRecordSizeException" + e));
            }
        }
        catch (LogFileOverflowException e) {
        }
        catch (IOException e) {
            IOException ioe = new IOException("LogFileManager.closeBufferManager(): error writing CLOSE record. [" + e.getMessage() + "]");
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
        this.bmgr.flushAll();
        this.bmgr.close();
    }

    void close() throws IOException, InterruptedException {
        boolean interrupted = false;
        InterruptedException exception = null;
        if (this.fileSet == null) {
            return;
        }
        try {
            if (this.initComplete) {
                this.closeBufferManager();
            }
            this.initComplete = false;
        }
        catch (InterruptedException e) {
            interrupted = true;
            exception = e;
        }
        if (this.eventManagerThread != null) {
            this.eventManagerThread.interrupt();
        }
        for (int i = 0; i < this.fileSet.length; ++i) {
            if (this.fileSet[i] == null) continue;
            this.fileSet[i].close();
            this.setLockOnFile(this.fileSet[i].file, false);
        }
        if (interrupted) {
            throw exception;
        }
    }

    String getStats() {
        int i;
        String name = this.getClass().getName();
        StringBuffer stats = new StringBuffer("\n<LogFileManager  class='" + name + "'>");
        stats.append("\n<initialKey value='" + Long.toHexString(this.initialKey) + "'>" + "Initial Log Key" + "</initialKey>" + "\n<currentKey value='" + Long.toHexString(this.currentKey) + "'>" + "Current Log Key" + "</currentKey>" + "\n<restartAutoMark value='" + this.restartAutoMark + "'>" + "automark value restored from prior log file" + "</restartAutoMark>" + "\n<overflowNotificationCount value='" + this.overflowNotificationCount + "'>" + "number of times LogEventListener.logOverflowNotification was called" + "</overflowNotificationCount>");
        long totalBytesWritten = 0L;
        for (i = 0; i < this.fileSet.length; ++i) {
            totalBytesWritten += this.fileSet[i].bytesWritten;
        }
        stats.append("\n<LogFiles class='" + this.fileSet[0].getClass().getName() + "' mode='" + this.fileSet[0].fileMode + "' bytesWritten='" + totalBytesWritten + "'>");
        for (i = 0; i < this.fileSet.length; ++i) {
            stats.append(this.fileSet[i].getStats());
        }
        stats.append("\n</LogFiles>");
        stats.append("\n</LogFileManager>");
        return stats.toString();
    }

    static {
        $assertionsDisabled = !LogFileManager.class.desiredAssertionStatus();
    }

    class EventManager
    extends Thread {
        static final /* synthetic */ boolean $assertionsDisabled;

        EventManager(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int event;
            LogFileManager parent = LogFileManager.this;
            while (true) {
                long lowestSafeLogKey;
                if (EventManager.interrupted()) {
                    return;
                }
                Object object = LogFileManager.this.eventManagerLock;
                synchronized (object) {
                    try {
                        while ((event = parent.event) == 0) {
                            LogFileManager.this.eventManagerLock.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    lowestSafeLogKey = parent.lowestSafeLogKey;
                }
                if ((event & 1) != 0) {
                    if (LogFileManager.this.eventListener != null) {
                        try {
                            LogFileManager.this.eventListener.logOverflowNotification(lowestSafeLogKey);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        parent.overflowNotificationCount += 1;
                    }
                    object = LogFileManager.this.eventManagerLock;
                    synchronized (object) {
                        parent.lowestSafeLogKey = 0L;
                        parent.event ^= 1;
                    }
                }
                if (!$assertionsDisabled) break;
            }
            throw new AssertionError((Object)("unexpected event type [" + event + "] in LogFileManager eventManagetThread"));
        }

        static {
            $assertionsDisabled = !(class$org$objectweb$howl$log$LogFileManager == null ? (class$org$objectweb$howl$log$LogFileManager = LogFileManager.class$("org.objectweb.howl.log.LogFileManager")) : class$org$objectweb$howl$log$LogFileManager).desiredAssertionStatus();
        }
    }
}

