/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import fr.dyade.aaa.util.management.MXWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.jms.TopicConnectionFactory;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.DeadMQueue;
import org.objectweb.joram.client.jms.admin.JoramAdminMBean;
import org.objectweb.joram.client.jms.admin.PlatformAdmin;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.util.monolog.api.BasicLevel;

public class JoramAdmin
implements JoramAdminMBean {
    public long timeOut = 1000L;
    public PlatformAdmin platformAdmin;
    static boolean isHa = false;
    private String adminFileExportXML = null;

    public JoramAdmin() throws UnknownHostException, ConnectException, AdminException {
        this.platformAdmin = new PlatformAdmin();
        this.registerMBean();
    }

    public JoramAdmin(String hostName, int port, String name, String password, int cnxTimer, String reliableClass) throws UnknownHostException, ConnectException, AdminException {
        this.platformAdmin = new PlatformAdmin(hostName, port, name, password, cnxTimer, reliableClass);
        this.registerMBean();
    }

    public JoramAdmin(String hostName, int port, String name, String password, int cnxTimer) throws UnknownHostException, ConnectException, AdminException {
        this.platformAdmin = new PlatformAdmin(hostName, port, name, password, cnxTimer);
        this.registerMBean();
    }

    public JoramAdmin(String name, String password) throws ConnectException, AdminException {
        this.platformAdmin = new PlatformAdmin(name, password);
        this.registerMBean();
    }

    public JoramAdmin(TopicConnectionFactory cnxFact, String name, String password) throws ConnectException, AdminException {
        this.platformAdmin = new PlatformAdmin(cnxFact, name, password);
        this.registerMBean();
    }

    private void registerMBean() {
        block2: {
            try {
                MXWrapper.registerMBean(this, "joramClient", "type=JoramAdmin");
            }
            catch (Exception e) {
                if (!JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) break block2;
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"registerMBean", (Throwable)e);
            }
        }
    }

    private void unregisterMBean() {
        block2: {
            try {
                MXWrapper.unregisterMBean("joramClient", "type=JoramAdmin");
            }
            catch (Exception e) {
                if (!JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) break block2;
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"unregisterMBean", (Throwable)e);
            }
        }
    }

    public PlatformAdmin getPlatformAdmin() {
        return this.platformAdmin;
    }

    public void exit() {
        this.platformAdmin.exit();
        this.unregisterMBean();
    }

    public void setTimeOutToAbortRequest(long timeOut) {
        this.timeOut = timeOut;
    }

    public long getTimeOutToAbortRequest() {
        return this.timeOut;
    }

    public void setDefaultDMQ(int serverId, DeadMQueue dmq) throws ConnectException, AdminException {
        AdminModule.setDefaultDMQ(serverId, dmq);
    }

    public void setDefaultDMQId(int serverId, String dmqId) throws ConnectException, AdminException {
        AdminModule.setDefaultDMQId(serverId, dmqId);
    }

    public DeadMQueue getDefaultDMQ(int serverId) throws ConnectException, AdminException {
        return AdminModule.getDefaultDMQ(serverId);
    }

    public String getDefaultDMQId(int serverId) throws ConnectException, AdminException {
        return AdminModule.getDefaultDMQId(serverId);
    }

    public DeadMQueue getDefaultDMQ() throws ConnectException, AdminException {
        return AdminModule.getDefaultDMQ();
    }

    public String getDefaultDMQId() throws ConnectException, AdminException {
        return AdminModule.getDefaultDMQId();
    }

    public List getDestinations(int serverId) {
        Vector<String> destinations = new Vector<String>();
        try {
            List destList = AdminModule.getDestinations(serverId, this.timeOut);
            Iterator destIt = destList.iterator();
            while (destIt.hasNext()) {
                Destination dest = (Destination)destIt.next();
                destinations.add(new String("type=" + dest.getType() + ", name=" + dest.getAdminName() + ", id=" + dest.getName()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return destinations;
    }

    public List getDestinations() {
        Vector<String> destinations = new Vector<String>();
        List list = this.platformAdmin.getServersIds();
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                try {
                    Integer sid = (Integer)it.next();
                    List destList = AdminModule.getDestinations(sid, this.timeOut);
                    Iterator destIt = destList.iterator();
                    while (destIt.hasNext()) {
                        Destination dest = (Destination)destIt.next();
                        destinations.add(new String("type=" + dest.getType() + ", name=" + dest.getAdminName() + ", id=" + dest.getName()));
                    }
                }
                catch (Exception exc) {
                }
            }
        }
        return destinations;
    }

    public List getUsers(int serverId) {
        Vector<String> users = new Vector<String>();
        try {
            List userList = AdminModule.getUsers(serverId, this.timeOut);
            Iterator userIt = userList.iterator();
            while (userIt.hasNext()) {
                User dest = (User)userIt.next();
                users.add(dest.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return users;
    }

    public List getUsers() {
        Vector<String> users = new Vector<String>();
        List list = this.platformAdmin.getServersIds();
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                try {
                    Integer sid = (Integer)it.next();
                    List userList = AdminModule.getUsers(sid, this.timeOut);
                    Iterator userIt = userList.iterator();
                    while (userIt.hasNext()) {
                        User dest = (User)userIt.next();
                        users.add(dest.toString());
                    }
                }
                catch (Exception exc) {
                }
            }
        }
        return users;
    }

    public void createUser(String name, String password) throws AdminException {
        try {
            User.create(name, password);
        }
        catch (ConnectException exc) {
            throw new AdminException("createUser() failed: admin connection has been lost.");
        }
    }

    public void createUser(String name, String password, int serverId) throws AdminException {
        try {
            User.create(name, password, serverId);
        }
        catch (ConnectException exc) {
            throw new AdminException("createUser() failed: admin connection has been lost.");
        }
    }

    public javax.jms.Destination createQueue(String name) throws AdminException {
        try {
            return this.createQueue(this.platformAdmin.getLocalServerId(), name, "org.objectweb.joram.mom.dest.Queue", null);
        }
        catch (ConnectException exc) {
            throw new AdminException("createQueue() failed: admin connection has been lost.");
        }
    }

    public javax.jms.Destination createQueue(int serverId, String name) throws AdminException {
        return this.createQueue(serverId, name, "org.objectweb.joram.mom.dest.Queue", null);
    }

    public javax.jms.Destination createQueue(int serverId, String name, String className, Properties prop) throws AdminException {
        try {
            Queue queue = Queue.create(serverId, name, className, prop);
            return queue;
        }
        catch (ConnectException exc) {
            throw new AdminException("createQueue() failed: admin connection has been lost.");
        }
    }

    public javax.jms.Destination createTopic(String name) throws AdminException {
        try {
            return this.createTopic(this.platformAdmin.getLocalServerId(), name, "org.objectweb.joram.mom.dest.Topic", null);
        }
        catch (ConnectException exc) {
            throw new AdminException("createTopic() failed: admin connection has been lost.");
        }
    }

    public javax.jms.Destination createTopic(int serverId, String name) throws AdminException {
        return this.createTopic(serverId, name, "org.objectweb.joram.mom.dest.Topic", null);
    }

    public javax.jms.Destination createTopic(int serverId, String name, String className, Properties prop) throws AdminException {
        try {
            Topic topic = Topic.create(serverId, name, className, prop);
            return topic;
        }
        catch (ConnectException exc) {
            throw new AdminException("createTopic() failed: admin connection has been lost.");
        }
    }

    public static boolean executeXMLAdmin(String cfgDir, String cfgFileName) throws Exception {
        return AdminModule.executeXMLAdmin(cfgDir, cfgFileName);
    }

    public static boolean executeXMLAdmin(String path) throws Exception {
        return AdminModule.executeXMLAdmin(path);
    }

    public boolean executeXMLAdminJMX(String path) throws Exception {
        throw new Exception("Not implemented yet");
    }

    public void exportRepositoryToFile(String exportDir) throws AdminException {
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("export repository to " + exportDir.toString()));
        }
        StringBuffer strbuf = new StringBuffer();
        int indent = 0;
        strbuf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        strbuf.append("<!--\n");
        strbuf.append(" Exported JMS objects : \n");
        strbuf.append(" - destinations : Topic/Queue \n");
        strbuf.append(" The file can be reloaded through the admin interface (joramAdmin.executeXMLAdmin())\n");
        strbuf.append("-->\n");
        strbuf.append("<JoramAdmin>\n");
        indent += 2;
        List srvList = this.platformAdmin.getServersIds();
        if (srvList != null) {
            Iterator it = srvList.iterator();
            while (it.hasNext()) {
                try {
                    Integer sid = (Integer)it.next();
                    List destList = AdminModule.getDestinations(sid, this.timeOut);
                    Iterator destIt = destList.iterator();
                    while (destIt.hasNext()) {
                        Destination dest = (Destination)destIt.next();
                        strbuf.append(dest.toXml(indent, sid));
                    }
                }
                catch (Exception exc) {
                    throw new AdminException("exportRepositoryToFile() failed - " + exc);
                }
            }
            if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("exported objects : \n" + strbuf.toString()));
            }
        }
        indent -= 2;
        strbuf.append("</JoramAdmin>");
        File exportFile = null;
        FileOutputStream fos = null;
        try {
            exportFile = new File(exportDir, this.getAdminFileExportXML());
            fos = new FileOutputStream(exportFile);
            fos.write(strbuf.toString().getBytes());
        }
        catch (Exception ioe) {
            throw new AdminException("exportRepositoryToFile() failed - " + ioe);
        }
        finally {
            block18: {
                try {
                    exportFile = null;
                    fos.close();
                }
                catch (Exception e) {
                    if (!JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) break block18;
                    JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("Unable to close the file  : " + fos));
                }
            }
            if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("File : " + exportDir + "/" + this.getAdminFileExportXML() + " created"));
            }
        }
    }

    public String getAdminFileExportXML() {
        return this.adminFileExportXML;
    }

    public void setAdminFileExportXML(String adminFileExportXML) {
        this.adminFileExportXML = adminFileExportXML;
    }

    public static boolean isHa() {
        return isHa;
    }

    public static void setHa(boolean isHa) {
        JoramAdmin.isHa = isHa;
        AdminModule.setHa(isHa);
    }
}

