/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.dest;

import fr.dyade.aaa.agent.AgentId;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.objectweb.joram.mom.dest.ClusterQueueImpl;
import org.objectweb.joram.mom.notifications.LBMessageGive;
import org.objectweb.joram.mom.notifications.LBMessageHope;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.util.monolog.api.BasicLevel;

public class LoadingFactor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int status;
    private long statusTime;
    private int consumerStatus = 0;
    private int producerStatus = 0;
    public ClusterQueueImpl clusterQueueImpl;
    public int producThreshold = -1;
    public int consumThreshold = -1;
    public boolean autoEvalThreshold = false;
    public long validityPeriod = -1L;
    private float rateOfFlow;
    private boolean overLoaded;
    private int nbOfPendingMessages;
    private int nbOfPendingRequests;

    public LoadingFactor(ClusterQueueImpl clusterQueueImpl, int producThreshold, int consumThreshold, boolean autoEvalThreshold, long validityPeriod) {
        this.clusterQueueImpl = clusterQueueImpl;
        this.producThreshold = producThreshold;
        this.consumThreshold = consumThreshold;
        this.autoEvalThreshold = autoEvalThreshold;
        this.validityPeriod = validityPeriod;
        this.rateOfFlow = 1.0f;
        this.status = 0;
    }

    public void setRateOfFlow(float rateOfFlow) {
        this.rateOfFlow = rateOfFlow;
    }

    public float getRateOfFlow() {
        return this.rateOfFlow;
    }

    public void setWait() {
        this.status = 2;
        this.statusTime = System.currentTimeMillis() + this.validityPeriod;
    }

    private void evalActivity() {
        this.producerStatus = this.nbOfPendingMessages == 0 ? 0 : (this.nbOfPendingMessages > this.producThreshold ? 1 : 2);
        this.consumerStatus = this.nbOfPendingRequests == 0 ? 0 : (this.nbOfPendingRequests > this.consumThreshold ? 1 : 2);
    }

    private void updateThreshol() {
        if (this.autoEvalThreshold) {
            int deltaCons;
            int deltaProd;
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)("LoadingFactor.updateThreshol before rateOfFlow=" + this.rateOfFlow + ", producThreshold=" + this.producThreshold + ", consumThreshold=" + this.consumThreshold));
            }
            if (this.rateOfFlow < 1.0f) {
                deltaProd = (int)((float)(this.nbOfPendingMessages - this.producThreshold) * this.rateOfFlow);
                deltaCons = (int)((float)(this.nbOfPendingRequests - this.consumThreshold) * this.rateOfFlow);
            } else {
                deltaProd = (int)((float)(this.nbOfPendingMessages - this.producThreshold) / this.rateOfFlow);
                deltaCons = (int)((float)(this.nbOfPendingRequests - this.consumThreshold) / this.rateOfFlow);
            }
            if (this.nbOfPendingMessages > 0) {
                this.producThreshold = deltaProd < this.producThreshold ? (this.producThreshold += deltaProd) : deltaProd;
            }
            if (this.nbOfPendingRequests > 0) {
                this.consumThreshold = deltaCons < this.consumThreshold ? (this.consumThreshold += deltaCons) : deltaCons;
            }
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)("LoadingFactor.updateThreshol after rateOfFlow=" + this.rateOfFlow + ", producThreshold=" + this.producThreshold + ", consumThreshold=" + this.consumThreshold));
            }
        }
    }

    public float evalRateOfFlow(int pendingMessages, int pendingRequests) {
        this.nbOfPendingMessages = pendingMessages;
        this.nbOfPendingRequests = pendingRequests;
        float currentROF = pendingMessages == 0 && pendingRequests == 0 ? 1.0f : (pendingMessages == 0 && pendingRequests != 0 ? (float)(pendingRequests + 1) : new Float(pendingRequests).floatValue() / new Float(pendingMessages).floatValue());
        this.rateOfFlow = (currentROF + this.rateOfFlow) / 2.0f;
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)("LoadingFactor.evalRateOfFlow pendingMessages = " + pendingMessages + ", pendingRequests = " + pendingRequests + ", rateOfFlow = " + this.rateOfFlow + ", currentROF = " + currentROF));
        }
        return this.rateOfFlow;
    }

    public void factorCheck(Hashtable clusters, int pendingMessages, int pendingRequests) {
        this.nbOfPendingMessages = pendingMessages;
        this.nbOfPendingRequests = pendingRequests;
        if (this.status == 2 && this.statusTime < System.currentTimeMillis()) {
            this.status = 1;
        }
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)(">> LoadingFactor.factorCheck " + this + "\nclusters = " + clusters));
        }
        this.evalRateOfFlow(pendingMessages, pendingRequests);
        this.evalActivity();
        if ((this.status == 0 || this.status == 1) && this.isOverloaded()) {
            this.dispatchAndSendTo(clusters, pendingMessages, pendingRequests);
            this.status = 2;
            this.statusTime = System.currentTimeMillis() + this.validityPeriod;
        }
        this.updateThreshol();
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)("<< LoadingFactor.factorCheck " + this));
        }
    }

    public boolean isOverloaded() {
        this.overLoaded = false;
        if (this.consumerStatus == 1 || this.producerStatus == 1) {
            this.overLoaded = true;
        }
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)("LoadingFactor.isOverloaded " + this.overLoaded));
        }
        return this.overLoaded;
    }

    private void dispatchAndSendTo(Hashtable clusters, int nbOfPendingMessages, int nbOfPendingRequests) {
        int nbMsgHope = -1;
        int nbMsgGive = -1;
        if (this.consumerStatus == 0 && this.producerStatus == 0) {
            return;
        }
        if (this.producThreshold < nbOfPendingMessages) {
            nbMsgGive = nbOfPendingMessages - this.producThreshold;
        }
        if (this.consumThreshold < nbOfPendingRequests) {
            nbMsgHope = nbOfPendingRequests;
        }
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)("LoadingFactor.dispatchAndSendTo\nnbMsgHope=" + nbMsgHope + ", nbMsgGive=" + nbMsgGive));
        }
        if (this.consumerStatus == 1) {
            this.processHope(nbMsgHope, clusters);
        }
        if (this.producerStatus == 1) {
            this.processGive(nbMsgGive, clusters);
        }
    }

    private void processGive(int nbMsgGive, Hashtable clusters) {
        if (nbMsgGive < 1) {
            return;
        }
        Vector<AgentId> selected = new Vector<AgentId>();
        Enumeration e = clusters.keys();
        while (e.hasMoreElements()) {
            AgentId id = (AgentId)e.nextElement();
            if (!(((Float)clusters.get(id)).floatValue() >= 1.0f) || id.equals(this.clusterQueueImpl.destId)) continue;
            selected.add(id);
        }
        if (selected.size() == 0) {
            return;
        }
        int nbGivePerQueue = nbMsgGive / selected.size();
        LBMessageGive msgGive = new LBMessageGive(this.validityPeriod, this.rateOfFlow);
        if (nbGivePerQueue == 0 && nbMsgGive > 0) {
            AgentId id = (AgentId)selected.get(0);
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)("LoadingFactor.processGive nbMsgGive = " + nbMsgGive + ", id = " + id));
            }
            msgGive.setClientMessages(this.clusterQueueImpl.getClientMessages(nbMsgGive, null, true));
            this.clusterQueueImpl.forward(id, msgGive);
        } else {
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)("LoadingFactor.processGive givePerQueue = " + nbGivePerQueue + ", selected = " + selected));
            }
            Enumeration e2 = selected.elements();
            while (e2.hasMoreElements()) {
                AgentId id = (AgentId)e2.nextElement();
                msgGive.setClientMessages(this.clusterQueueImpl.getClientMessages(nbGivePerQueue, null, true));
                this.clusterQueueImpl.forward(id, msgGive);
            }
        }
    }

    private void processHope(int nbMsgHope, Hashtable clusters) {
        AgentId id;
        if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)("LoadingFactor.processHope nbMsgHope = " + nbMsgHope));
        }
        if (nbMsgHope < 1) {
            return;
        }
        Vector<AgentId> selected = new Vector<AgentId>();
        Enumeration e = clusters.keys();
        while (e.hasMoreElements()) {
            id = (AgentId)e.nextElement();
            if (!(((Float)clusters.get(id)).floatValue() <= 1.0f) || id.equals(this.clusterQueueImpl.destId)) continue;
            selected.add(id);
        }
        if (selected.size() == 0) {
            return;
        }
        int nbHopePerQueue = nbMsgHope / selected.size();
        if (nbHopePerQueue == 0 && nbMsgHope > 0) {
            id = (AgentId)selected.get(0);
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)("LoadingFactor.processHope nbMsgHope = " + nbMsgHope + ", id = " + id));
            }
            LBMessageHope msgHope = new LBMessageHope(this.validityPeriod, this.rateOfFlow);
            msgHope.setNbMsg(nbMsgHope);
            this.clusterQueueImpl.forward(id, msgHope);
        } else {
            if (JoramTracing.dbgDestination.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgDestination.log(BasicLevel.DEBUG, (Object)("LoadingFactor.processHope hopePerQueue = " + nbHopePerQueue + ", selected = " + selected));
            }
            LBMessageHope msgHope = new LBMessageHope(this.validityPeriod, this.rateOfFlow);
            Enumeration e2 = selected.elements();
            while (e2.hasMoreElements()) {
                AgentId id2 = (AgentId)e2.nextElement();
                msgHope.setNbMsg(nbHopePerQueue);
                this.clusterQueueImpl.forward(id2, msgHope);
            }
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("LoadingFactor (status=");
        str.append(Status.names[this.status]);
        str.append(", consumerStatus=");
        str.append(ConsumerStatus.names[this.consumerStatus]);
        str.append(", producerStatus=");
        str.append(ProducerStatus.names[this.producerStatus]);
        str.append(", producThreshold=");
        str.append(this.producThreshold);
        str.append(", consumThreshold=");
        str.append(this.consumThreshold);
        str.append(", autoEvalThreshold=");
        str.append(this.autoEvalThreshold);
        str.append(", nbOfPendingMessages=");
        str.append(this.nbOfPendingMessages);
        str.append(", nbOfPendingRequests=");
        str.append(this.nbOfPendingRequests);
        str.append(", rateOfFlow=");
        str.append(this.rateOfFlow);
        str.append(", overLoaded=");
        str.append(this.overLoaded);
        str.append(")");
        return str.toString();
    }

    public static class ProducerStatus {
        public static final int PRODUCER_NO_ACTIVITY = 0;
        public static final int PRODUCER_HIGH_ACTIVITY = 1;
        public static final int PRODUCER_NORMAL_ACTIVITY = 2;
        public static final String[] names = new String[]{"PRODUCER_NO_ACTIVITY", "PRODUCER_HIGH_ACTIVITY", "PRODUCER_NORMAL_ACTIVITY"};
    }

    public static class ConsumerStatus {
        public static final int CONSUMER_NO_ACTIVITY = 0;
        public static final int CONSUMER_HIGH_ACTIVITY = 1;
        public static final int CONSUMER_NORMAL_ACTIVITY = 2;
        public static final String[] names = new String[]{"CONSUMER_NO_ACTIVITY", "CONSUMER_HIGH_ACTIVITY", "CONSUMER_NORMAL_ACTIVITY"};
    }

    public static class Status {
        public static final int INIT = 0;
        public static final int RUN = 1;
        public static final int WAIT = 2;
        public static final String[] names = new String[]{"INIT", "RUN", "WAIT"};
    }
}

