/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies;

import java.io.Serializable;
import org.objectweb.joram.mom.proxies.AckedQueue;
import org.objectweb.joram.mom.proxies.ConnectionContext;
import org.objectweb.joram.mom.proxies.ProxyImpl;
import org.objectweb.joram.mom.proxies.ProxyMessage;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.CnxCloseRequest;
import org.objectweb.joram.shared.client.MomExceptionReply;
import org.objectweb.joram.shared.excepts.MomException;

public class ReliableConnectionContext
implements ConnectionContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private int key;
    private long inputCounter;
    private long outputCounter;
    private AckedQueue queue;
    private int heartBeat;
    private ProxyImpl proxyImpl;
    private boolean closed;

    ReliableConnectionContext(ProxyImpl proxyImpl, int key, int heartBeat) {
        this.key = key;
        this.heartBeat = heartBeat;
        this.proxyImpl = proxyImpl;
        this.inputCounter = -1L;
        this.outputCounter = 0L;
        this.queue = new AckedQueue();
        this.closed = false;
    }

    public int getKey() {
        return this.key;
    }

    public AckedQueue getQueue() {
        return this.queue;
    }

    public int getHeartBeat() {
        return this.heartBeat;
    }

    public long getInputCounter() {
        return this.inputCounter;
    }

    public AbstractJmsRequest getRequest(Object obj) {
        ProxyMessage msg = (ProxyMessage)obj;
        this.inputCounter = msg.getId();
        AbstractJmsRequest request = (AbstractJmsRequest)msg.getObject();
        this.queue.ack(msg.getAckId());
        if (request instanceof CnxCloseRequest) {
            this.closed = true;
        }
        return request;
    }

    public void pushReply(AbstractJmsReply reply) {
        ProxyMessage msg = new ProxyMessage(this.outputCounter, this.inputCounter, reply);
        this.queue.push(msg);
        ++this.outputCounter;
    }

    public void pushError(MomException exc) {
        this.queue.push(new ProxyMessage(-1L, -1L, new MomExceptionReply(exc)));
    }

    public boolean isClosed() {
        return this.closed;
    }
}

