/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.mom.proxies.tcp;

import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.StringTokenizer;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.objectweb.joram.mom.proxies.tcp.TcpProxyService;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.util.monolog.api.BasicLevel;

public class SSLTcpProxyService
extends TcpProxyService {
    private static final String CIPHER = "org.objectweb.joram.cipherList";
    private static final String KS = "org.objectweb.joram.keystore";
    private static final String KS_PASS = "org.objectweb.joram.keystorepass";
    private static final String KS_TYPE = "org.objectweb.joram.keystoretype";
    private static final String SSLCONTEXT = "org.objectweb.joram.sslCtx";

    public static void init(String args, boolean firstTime) throws Exception {
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("SSLTcpProxyService.init(" + args + ',' + firstTime + ')'));
        }
        int port = 16010;
        String address = "0.0.0.0";
        if (args != null) {
            StringTokenizer st = new StringTokenizer(args);
            port = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                address = st.nextToken();
            }
        }
        int backlog = Integer.getInteger("org.objectweb.joram.mom.proxies.tcp.backlog", 10);
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("SSLTcpProxyService.init() - binding to address " + address + ", port " + port));
        }
        ServerSocket serverSocket = SSLTcpProxyService.createServerSocket(port, backlog, address);
        int poolSize = Integer.getInteger("org.objectweb.joram.mom.proxies.tcp.poolSize", 1);
        int timeout = Integer.getInteger("org.objectweb.joram.mom.proxies.tcp.soTimeout", 10000);
        proxyService = new SSLTcpProxyService(serverSocket, poolSize, timeout);
        proxyService.start();
    }

    public SSLTcpProxyService(ServerSocket serverSocket, int poolSize, int timeout) {
        super(serverSocket, poolSize, timeout);
    }

    private static ServerSocketFactory createServerSocketFactory() throws Exception {
        char[] keyStorePass = System.getProperty(KS_PASS, "jorampass").toCharArray();
        String keystoreFile = System.getProperty(KS, "./joram_ks");
        String sslContext = System.getProperty(SSLCONTEXT, "SSL");
        String ksType = System.getProperty(KS_TYPE, "JKS");
        if (JoramTracing.dbgProxy.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgProxy.log(BasicLevel.DEBUG, (Object)("SSLTcpProxyService.createServerSocketFactory:" + keystoreFile + ':' + keyStorePass));
        }
        KeyStore keystore = KeyStore.getInstance(ksType);
        keystore.load(new FileInputStream(keystoreFile), keyStorePass);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keystore, keyStorePass);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(keystore);
        TrustManager[] trustManagers = tmf.getTrustManagers();
        SSLContext ctx = SSLContext.getInstance(sslContext);
        SecureRandom securerandom = SecureRandom.getInstance("SHA1PRNG");
        ctx.init(kmf.getKeyManagers(), trustManagers, securerandom);
        return ctx.getServerSocketFactory();
    }

    private static ServerSocket createServerSocket(int port, int backlog, String address) throws Exception {
        ServerSocketFactory serverSocketFactory = SSLTcpProxyService.createServerSocketFactory();
        SSLServerSocket serverSocket = null;
        serverSocket = address.equals("0.0.0.0") ? (SSLServerSocket)serverSocketFactory.createServerSocket(port, backlog) : (SSLServerSocket)serverSocketFactory.createServerSocket(port, backlog, InetAddress.getByName(address));
        serverSocket.setNeedClientAuth(true);
        String[] cipherTable = SSLTcpProxyService.getCipherList();
        if (cipherTable != null && cipherTable.length > 0) {
            serverSocket.setEnabledCipherSuites(cipherTable);
        }
        return serverSocket;
    }

    private static String[] getCipherList() throws Exception {
        StringTokenizer tokenizer;
        int tokens;
        String cipherList = System.getProperty(CIPHER, null);
        String[] cipherTable = null;
        if (cipherList != null && (tokens = (tokenizer = new StringTokenizer(cipherList, ",")).countTokens()) > 0) {
            cipherTable = new String[tokens];
            while (tokenizer.hasMoreElements()) {
                cipherTable[--tokens] = tokenizer.nextToken();
            }
        }
        return cipherTable;
    }
}

