/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.facility.naming.generator;

import org.objectweb.jorm.api.PAccessor;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.facility.naming.generator.LongGenIncrAccessor;
import org.objectweb.jorm.facility.naming.generator.LongGenIncrMgr;
import org.objectweb.jorm.facility.naming.generator.LongGenMgr;
import org.objectweb.jorm.facility.naming.generator.PLongGen;
import org.objectweb.jorm.lib.PBindingImpl;
import org.objectweb.jorm.naming.api.PName;

public class LongGenIncr
extends PBindingImpl
implements PLongGen,
PAccessor,
LongGenIncrAccessor {
    private LongGenIncrMgr mgr;
    private long nextId = 0L;
    private int increment = 1;
    private int hint = 10;
    private long memoryCounter = 0L;

    public void init(String name, PClassMapping pcm, LongGenMgr mgr) throws PException {
        this.mgr = (LongGenIncrMgr)mgr;
        this.init(pcm);
        PName lgpn = pcm.getPBinder().decodeString(name);
        Object conn = mgr.getPMapper().getConnection();
        try {
            this.bind(lgpn);
            if (this.exist(conn)) {
                this.read(conn, this);
            } else {
                this.export(conn, name);
                this.write(conn, this);
            }
        }
        catch (PException pe) {
            mgr.getPMapper().closeConnection(conn);
            throw pe;
        }
        mgr.getPMapper().closeConnection(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long genId() throws PException {
        Object conn = this.mgr.getPMapper().getConnection();
        try {
            long l = this.genId(conn);
            return l;
        }
        finally {
            this.mgr.getPMapper().closeConnection(conn);
        }
    }

    public synchronized long genId(Object conn) throws PException {
        long res = this.memoryCounter;
        this.memoryCounter += (long)this.increment;
        if (this.memoryCounter >= this.nextId) {
            this.allocateIds(this.hint);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long allocateIds(int allocate) throws PException {
        Object conn = this.mgr.getPMapper().getConnection();
        try {
            long l = this.allocateIds(allocate, conn);
            return l;
        }
        finally {
            this.mgr.getPMapper().closeConnection(conn);
        }
    }

    private long allocateIds(int allocate, Object conn) throws PException {
        this.nextId += (long)(allocate * this.increment);
        this.write(conn, this);
        return this.nextId;
    }

    public void setIncrement(int incr) {
        this.increment = incr;
    }

    public int getIncrement() {
        return this.increment;
    }

    public long current() {
        return this.memoryCounter;
    }

    public Object getMemoryInstance() {
        return this;
    }

    public long paGetNextId() {
        return this.nextId;
    }

    public void paSetNextId(long val) {
        this.nextId = this.memoryCounter = val;
    }
}

