/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.generator.lib;

import java.util.Set;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeAdapter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.jorm.generator.lib.LoggedClassAdapter;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ClassRenamer
extends LoggedClassAdapter {
    private Set oldNames;
    private final String newName;

    public ClassRenamer(ClassVisitor cv, Set oldNames, String newName, Logger logger) {
        super(cv, logger);
        this.oldNames = oldNames;
        this.newName = newName;
    }

    public void visit(int version2, int access, String name, String superName, String[] interfaces, String sourceFile) {
        this.oldNames.add(name);
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Rename the class '" + name + "' to '" + this.newName + "'"));
        }
        this.cv.visit(version2, access, this.newName, superName, interfaces, sourceFile);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.cv.visitInnerClass(name, outerName, innerName, access);
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        CodeVisitor _cv = this.cv.visitMethod(access, name, desc, exceptions, attrs);
        if (_cv != null && (access & 0x400) == 0) {
            _cv = new CodeRenamer(_cv);
        }
        return _cv;
    }

    class CodeRenamer
    extends CodeAdapter {
        public CodeRenamer(CodeVisitor cv) {
            super(cv);
        }

        public void visitTypeInsn(int i, String s) {
            if (ClassRenamer.this.oldNames.contains(s)) {
                s = ClassRenamer.this.newName;
            }
            this.cv.visitTypeInsn(i, s);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (ClassRenamer.this.oldNames.contains(owner)) {
                this.cv.visitFieldInsn(opcode, ClassRenamer.this.newName, name, desc);
            } else {
                this.cv.visitFieldInsn(opcode, owner, name, desc);
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (ClassRenamer.this.oldNames.contains(owner)) {
                this.cv.visitMethodInsn(opcode, ClassRenamer.this.newName, name, desc);
            } else {
                this.cv.visitMethodInsn(opcode, owner, name, desc);
            }
        }
    }
}

