/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.generator.lib;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Constants;
import org.objectweb.asm.Type;
import org.objectweb.jorm.compiler.api.PExceptionCompiler;
import org.objectweb.jorm.generator.lib.CommonHelper;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.CompositeName;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.jorm.naming.api.PNameManager;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.util.io.api.TargetHolder;
import org.objectweb.jorm.util.lib.StringReplace;

public class CommonJVMHelper
extends CommonHelper
implements Constants {
    public static final String getJVMClassName(String className) {
        return StringReplace.replaceChar('.', '/', className);
    }

    public static final String getJVMClassName(java.lang.Class clazz) {
        return CommonJVMHelper.getJVMClassName(clazz.getName());
    }

    public static final String getJVMClassName(Class clazz) {
        return CommonJVMHelper.getJVMClassName(clazz.getFQName());
    }

    public static final String getJVMType(java.lang.Class clazz) {
        return CommonJVMHelper.getJVMType(clazz.getName());
    }

    public static final String getJVMType(String className) {
        return "L" + CommonJVMHelper.getJVMClassName(className) + ";";
    }

    public static final String getJVMType(PType pt) {
        return Type.getType(pt.getJavaClass()).getDescriptor();
    }

    public static void write(ClassWriter cw, String name, TargetHolder holder) throws PExceptionCompiler {
        try {
            String fileName = StringReplace.replaceChar('/', File.separatorChar, name) + ".class";
            FileOutputStream fos = holder.getFileOutputStream(fileName);
            fos.write(cw.toByteArray());
            fos.close();
        }
        catch (Exception e) {
            throw new PExceptionCompiler(e, "Problem while generating PAccessor.");
        }
    }

    public static void writeJavaClass(String name, ClassWriter jclass, String srcFiles) throws IOException {
        String clas;
        String pkg;
        int p = name.lastIndexOf(File.separatorChar);
        if (p == -1) {
            pkg = "";
            clas = name;
        } else {
            pkg = name.substring(0, p);
            clas = name.substring(p + 1);
        }
        File outputDir = srcFiles == null ? new File(pkg) : new File(srcFiles + File.separatorChar + pkg);
        outputDir.mkdirs();
        File outputFile = new File(outputDir, clas + ".class");
        outputFile.createNewFile();
        FileOutputStream fos = new FileOutputStream(outputFile);
        fos.write(jclass.toByteArray());
        fos.close();
    }

    public final String getConstructorFieldsPncParam(CompositeName co) {
        StringBuffer constructParam = new StringBuffer();
        Iterator it = co.getAllFields().iterator();
        while (it.hasNext()) {
            TypedElement te = (TypedElement)it.next();
            constructParam.append(CommonJVMHelper.getJVMType(te.getType()));
        }
        constructParam.append(CommonJVMHelper.getJVMType(PNameManager.class));
        return constructParam.toString();
    }

    public static final void loadNull(CodeVisitor cv, PType type) {
        switch (type.getTypeCode()) {
            case 0: {
                cv.visitInsn(3);
                break;
            }
            case 1: {
                cv.visitIntInsn(16, 48);
                break;
            }
            case 2: {
                cv.visitInsn(2);
                cv.visitInsn(145);
                break;
            }
            case 3: {
                cv.visitInsn(2);
                cv.visitInsn(147);
                break;
            }
            case 4: {
                cv.visitInsn(2);
                break;
            }
            case 5: {
                cv.visitInsn(2);
                cv.visitInsn(133);
                break;
            }
            case 6: {
                cv.visitInsn(2);
                cv.visitInsn(134);
                break;
            }
            case 7: {
                cv.visitInsn(2);
                cv.visitInsn(135);
                break;
            }
            default: {
                cv.visitInsn(1);
            }
        }
    }

    public static final void any2I(CodeVisitor cv, String type) {
        CommonJVMHelper.any2I(cv, Type.getType(type));
    }

    public static final void any2I(CodeVisitor cv, Type type) {
        switch (type.getSort()) {
            case 8: {
                cv.visitInsn(142);
                break;
            }
            case 6: {
                cv.visitInsn(139);
                break;
            }
            case 7: {
                cv.visitInsn(136);
                break;
            }
        }
    }
}

