/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.generator.lib;

import java.io.File;
import java.io.FileWriter;
import java.util.Collection;
import java.util.Iterator;
import org.apache.velocity.VelocityContext;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.compiler.api.JormCompilerParameter;
import org.objectweb.jorm.compiler.api.PExceptionCompiler;
import org.objectweb.jorm.generator.lib.CommonGenerator;
import org.objectweb.jorm.generator.lib.CommonHelper;
import org.objectweb.jorm.generator.lib.NamingFilterExpressionHelper;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.Package;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.util.io.api.TargetHolder;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class FPNCGenerator
extends CommonGenerator {
    public CommonHelper helper;

    public void generate(Class clazz, TargetHolder holder, JormCompilerParameter cp) throws PException {
        Collection nds = clazz.getNameDefs();
        Class classWithNd = clazz;
        while (nds.size() < 1 && classWithNd.getInheritedClassNumber() > 0) {
            classWithNd = (Class)classWithNd.getSuperClasses().iterator().next();
            nds = classWithNd.getNameDefs();
        }
        if (nds.size() < 1) {
            this.logger.log(BasicLevel.WARN, (Object)("FPNC: No NameDef defined for the class " + clazz.getFQName()));
            return;
        }
        if (nds.size() == 1) {
            this.generate(clazz, (NameDef)nds.iterator().next(), null, holder);
        } else {
            Iterator it = nds.iterator();
            while (it.hasNext()) {
                NameDef nd = (NameDef)it.next();
                String ndName = nd.getName() != null && nd.getName().length() == 0 ? null : nd.getName();
                this.generate(clazz, nd, ndName, holder);
            }
        }
    }

    private void generate(Class clazz, NameDef nd, String ndName, TargetHolder holder) throws PException {
        FPNCMatchInfo mi;
        String className;
        Expression exp;
        try {
            exp = clazz.getInheritanceFilter(nd);
        }
        catch (ExpressionException e) {
            throw new PException(e);
        }
        if (exp == null) {
            return;
        }
        PType expType = exp.getType();
        if (expType.getTypeCode() != 0 && expType.getTypeCode() != 8) {
            return;
        }
        String packName = ((Package)clazz.getParent()).getName();
        if (ndName != null) {
            packName = packName != null && packName.length() > 0 ? packName + "." + ndName : ndName;
        }
        String fileName = className = clazz.getName() + "FPNC";
        if (packName != null && packName.length() > 0) {
            fileName = packName + "." + fileName;
            fileName = fileName.replace('.', File.separatorChar);
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("Generate the " + fileName));
        VelocityContext ctx = new VelocityContext();
        ctx.put("class", clazz);
        ctx.put("helper", this);
        ctx.put("header", "org/objectweb/jorm/generator/lib/Header.vm");
        ctx.put("className", className);
        ctx.put("packName", packName);
        boolean isComposite = false;
        if (nd.isNameRef()) {
            isComposite = true;
            ctx.put("isComposite", Boolean.TRUE);
            ctx.put("codingType", "PNameCoder.CTCOMPOSITE");
            ctx.put("compositeName", nd.getNameRef().getCompositeName());
        } else if (nd.isFieldName()) {
            isComposite = false;
            ctx.put("isComposite", Boolean.FALSE);
            TypedElement te = clazz.getTypedElement(nd.getFieldName());
            if (te == null) {
                throw new PException("The field '" + nd.getFieldName() + "' used in the namedef of the class '" + clazz.getFQName() + "' is not defined.");
            }
            if (!(te instanceof PrimitiveElement)) {
                throw new PException("MalFormed Meta information: the field '" + nd.getFieldName() + "' used in the namedef of the class '" + clazz.getFQName() + "' is not a primitive element.");
            }
            ctx.put("codingType", this.getCTDeclaration(te.getType()));
        }
        try {
            mi = new FPNCMatchInfo(exp, isComposite, this.logger);
        }
        catch (ExpressionException e) {
            throw new PException(e, "Generation of " + fileName);
        }
        if (mi.filter.length() == 0) {
            mi.filter.append("true");
        }
        ctx.put("mi", mi);
        try {
            FileWriter fw = holder.getFileWriter(fileName + ".java");
            if (this.template == null) {
                this.template = this.velocityEngine.getTemplate("org/objectweb/jorm/generator/lib/FPNC.vm");
            }
            this.template.merge(ctx, fw);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            throw new PExceptionCompiler(e, "Problem while generating " + fileName + ".java");
        }
    }

    public class FPNCMatchInfo
    extends NamingFilterExpressionHelper {
        public boolean isComposite;
        public PType singleFieldPType;
        public String singleFieldName;

        public FPNCMatchInfo(Expression e, boolean isComposite, Logger logger) throws PException, ExpressionException {
            super(logger);
            this.singleFieldPType = null;
            this.singleFieldName = "o";
            this.isComposite = isComposite;
            this.fillMatchInfo(e);
        }

        public PType getSingleFieldPType() {
            return this.singleFieldPType;
        }

        public String getSingleFieldName() {
            return this.singleFieldName;
        }

        public String toString() {
            return super.toString() + " / singleFieldName=" + this.singleFieldName + " / singleFieldPType=" + this.singleFieldPType;
        }

        protected void fillMatchInfo(ParameterOperand po) throws PException, ExpressionException {
            this.logger.log(BasicLevel.DEBUG, (Object)("ParameterOperand " + po.getName()));
            if (this.isComposite) {
                if (this.field2declarations.get(po.getName()) == null) {
                    if (this.field2declarations.size() == 0) {
                        this.field2declarations.put("", "PNameGetter png = (PNameGetter) o;");
                    }
                    StringBuffer declaration = new StringBuffer();
                    declaration.append(po.getType().getJavaName());
                    declaration.append(' ');
                    declaration.append(po.getName());
                    declaration.append(" = png.pnGet");
                    declaration.append(this.getCoderName(po.getType()));
                    declaration.append("Field(\"");
                    declaration.append(po.getName());
                    declaration.append("\");");
                    this.field2declarations.put(po.getName(), declaration);
                    if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("Add declaration: " + declaration));
                    }
                }
                this.filter.append(po.getName());
            } else {
                if (this.singleFieldPType != null && this.singleFieldPType != po.getType()) {
                    throw new ExpressionException("Several parameters with a non composite name");
                }
                this.singleFieldPType = po.getType();
                this.singleFieldName = po.getName();
                this.filter.append(this.singleFieldName);
                this.logger.log(BasicLevel.DEBUG, (Object)("singleFieldPType " + this.singleFieldPType));
                this.logger.log(BasicLevel.DEBUG, (Object)("singleFieldName " + this.singleFieldName));
            }
        }
    }
}

