/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.generator.lib;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.util.Collection;
import java.util.Iterator;
import org.apache.velocity.VelocityContext;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.compiler.api.JormCompilerParameter;
import org.objectweb.jorm.compiler.api.PExceptionCompiler;
import org.objectweb.jorm.generator.lib.CNGenContext;
import org.objectweb.jorm.generator.lib.CommonGenerator;
import org.objectweb.jorm.generator.lib.CommonJVMHelper;
import org.objectweb.jorm.generator.lib.NamingFilterExpressionHelper;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.CompositeName;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.Package;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.ScalarField;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.jorm.naming.api.PNameCoder;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.util.io.api.TargetHolder;
import org.objectweb.jorm.util.lib.StringReplace;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class KFPNCGenerator
extends CommonGenerator {
    static /* synthetic */ java.lang.Class class$org$objectweb$jorm$naming$lib$AbstractInheritKeyFilteredPNamingContext;

    public void generate(Class clazz, TargetHolder holder, JormCompilerParameter cp) throws PException {
        if (!clazz.getSuperClasses().isEmpty()) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("KFPNC: No generation done because " + clazz.getFQName() + " is not the ancestor"));
            }
            return;
        }
        Collection nds = clazz.getNameDefs();
        if (nds.size() < 1) {
            this.logger.log(BasicLevel.WARN, (Object)("FPNC: No NameDef defined for the class " + clazz.getFQName()));
            return;
        }
        if (nds.size() == 1) {
            NameDef nd = (NameDef)nds.iterator().next();
            this.generate(clazz, nd, null, holder);
        } else {
            Iterator it = nds.iterator();
            while (it.hasNext()) {
                NameDef nd = (NameDef)it.next();
                String ndName = nd.getName() != null && nd.getName().length() == 0 ? null : nd.getName();
                this.generate(clazz, nd, ndName, holder);
            }
        }
    }

    private void generate(Class clazz, NameDef nd, String ndName, TargetHolder holder) throws PException {
        Expression exp;
        if (!this.mustGeneratedKFPNC(clazz, nd)) {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("KFPNC: No generation done because " + clazz.getFQName() + " has no inheritance filter based on keys"));
            }
            return;
        }
        try {
            exp = clazz.getInheritanceFilter(nd);
        }
        catch (ExpressionException e) {
            throw new PException(e);
        }
        if (exp == null) {
            this.logger.log(BasicLevel.WARN, (Object)("KFPNC: No generation done because " + clazz.getFQName() + " has no inheritance filter"));
            return;
        }
        this.generate(clazz, nd, ndName, exp, holder);
    }

    /*
     * WARNING - void declaration
     */
    private void generate(Class clazz, NameDef nd, String ndName, Expression exp, TargetHolder holder) throws PException {
        NamingKeyFilterExpressionHelper mi;
        void var11_20;
        void var12_19;
        String codingType;
        String nullValueStr;
        String className;
        String packName = ((Package)clazz.getParent()).getName();
        if (ndName != null) {
            packName = packName != null && packName.length() > 0 ? packName + "." + ndName : ndName;
        }
        String fileName = className = clazz.getName() + "KFPNC";
        if (packName != null && packName.length() > 0) {
            fileName = packName + "." + fileName;
            fileName = fileName.replace('.', File.separatorChar);
        }
        this.logger.log(BasicLevel.DEBUG, (Object)("Generate the " + fileName));
        VelocityContext ctx = new VelocityContext();
        ctx.put("class", clazz);
        ctx.put("helper", this);
        ctx.put("header", "org/objectweb/jorm/generator/lib/Header.vm");
        ctx.put("className", className);
        ctx.put("packName", packName);
        PType expressionType = exp.getType();
        ctx.put("expressionType", expressionType.getProgName());
        CompositeName cn = null;
        ctx.put("isComposite", nd.isNameRef() ? Boolean.TRUE : Boolean.FALSE);
        if (nd.isNameRef()) {
            cn = nd.getNameRef().getCompositeName();
            ctx.put("compositeName", cn);
            Collection fields = nd.getNameRef().getCompositeName().getAllFields();
            StringBuffer sb = new StringBuffer();
            sb.append("new ");
            sb.append(cn.getName());
            sb.append("PName(");
            Iterator it = fields.iterator();
            it = fields.iterator();
            while (it.hasNext()) {
                ScalarField sf = (ScalarField)it.next();
                String nullValue = sf.getNullValue();
                if (nullValue == null) {
                    nullValue = this.getDefaultNullValueAsString(sf.getType());
                }
                sb.append(nullValue);
                sb.append(", ");
            }
            sb.append("this)");
            nullValueStr = sb.toString();
            codingType = "CTCOMPOSITE";
        } else if (nd.isFieldName()) {
            TypedElement te = clazz.getTypedElement(nd.getFieldName());
            nullValueStr = this.getStrNullValueAsObject(te.getType());
            codingType = this.getCTDeclaration(te.getType());
        } else {
            return;
        }
        ctx.put("nullValue", var12_19);
        ctx.put("codingType", var11_20);
        try {
            mi = new NamingKeyFilterExpressionHelper(exp, cn, this.logger);
        }
        catch (ExpressionException e) {
            throw new PException(e);
        }
        ctx.put("mi", mi);
        try {
            FileWriter fw = holder.getFileWriter(fileName + ".java");
            if (this.template == null) {
                this.template = this.velocityEngine.getTemplate("org/objectweb/jorm/generator/lib/KFPNC.vm");
            }
            this.template.merge(ctx, fw);
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            throw new PExceptionCompiler(e, "Problem while generating " + fileName + ".java");
        }
    }

    private String getStrNullValueAsObject(PType type) {
        StringBuffer sb = new StringBuffer();
        sb.append("new org.objectweb.jorm.facility.naming.basidir.BasidName(");
        sb.append(this.getValueAsObjectForGen(this.getDefaultNullValueAsString(type), type));
        sb.append(", new org.objectweb.jorm.facility.naming.basidir.BasidBinder(");
        sb.append(this.getCTDeclaration(type));
        sb.append("))");
        return sb.toString();
    }

    private boolean mustGeneratedKFPNC(Class clazz, NameDef nd) {
        if (!clazz.getSuperClasses().isEmpty()) {
            this.logger.log(BasicLevel.DEBUG, (Object)("class " + clazz.getName() + " has parent => no KFPNC"));
            return false;
        }
        try {
            if (clazz.getInheritanceFilter(nd) == null) {
                this.logger.log(BasicLevel.DEBUG, (Object)("class " + clazz.getName() + " has no filter => no KFPNC"));
                return false;
            }
        }
        catch (ExpressionException e) {
            this.logger.log(BasicLevel.ERROR, (Object)"Error during the fetching of the key naming inheritance filter: ", (Throwable)e);
            return false;
        }
        return this.hasNamingKey(clazz, nd);
    }

    private boolean hasNamingKey(Class clazz, NameDef nd) {
        if (clazz.isAbstract()) {
            this.logger.log(BasicLevel.DEBUG, (Object)("class " + clazz.getName() + " is abstract"));
            Iterator it = clazz.getSubClasses().iterator();
            while (it.hasNext()) {
                Class subclazz = (Class)it.next();
                if (!this.hasNamingKey(subclazz, nd)) continue;
                return true;
            }
            return false;
        }
        Object key = clazz.getInheritanceNamingKey(nd);
        this.logger.log(BasicLevel.DEBUG, (Object)("class " + clazz.getName() + " key: " + key));
        return key != null;
    }

    private void generate2(Class clazz, NameDef nd, String ndName, Expression exp, TargetHolder holder) throws PException {
        ClassWriter cv = new ClassWriter(true);
        KFPNCGenContext gc = nd.isNameRef() ? new KFPNCGenContext(nd.getNameRef().getCompositeName(), nd, clazz, exp, cv, this) : new KFPNCGenContext(nd, clazz, exp, cv, this);
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Generate the class '" + gc.classToWrite + "'."));
        }
        cv.visit(196653, 33, gc.classToWrite, gc.superClassJCN, new String[0], gc.classToWrite);
        this.generateFields(gc);
        this.generateNoArgConstructor(gc);
        cv.visitEnd();
        try {
            String fileName = gc.classToWrite;
            fileName = StringReplace.replaceChar('/', File.separatorChar, fileName) + ".class";
            FileOutputStream fos = holder.getFileOutputStream(fileName);
            fos.write(cv.toByteArray());
            fos.close();
        }
        catch (Exception e) {
            throw new PExceptionCompiler(e, "Problem while generating PAccessor.");
        }
    }

    private void generateFields(KFPNCGenContext gc) {
        Iterator it = gc.coAllFields.iterator();
        while (it.hasNext()) {
            PrimitiveElement pe = (PrimitiveElement)it.next();
            gc.clav.visitField(2, pe.getName(), KFPNCGenerator.getJVMType(pe.getType()), null, null);
        }
    }

    private void generateNoArgConstructor(KFPNCGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(1, "<init>", "()V", null, null);
        PType expType = gc.exp.getType();
        String codingType = gc.co == null ? this.getCodingTypeAsString(expType.getTypeCode()) : "CTCOMPOSITE";
        cv.visitVarInsn(25, 0);
        cv.visitLdcInsn(new Integer(codingType));
        cv.visitFieldInsn(178, gc.ptypespaceJCN, this.getPTypeSpaceFieldName(expType), gc.ptypeJT);
        cv.visitFieldInsn(178, KFPNCGenerator.getJVMClassName(PNameCoder.class), codingType, "I");
        cv.visitMethodInsn(183, gc.superClassJCN, "<init>", "(" + gc.ptypeJT + "I)V");
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
    }

    private void generateEvaluateMethod(KFPNCGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(1, "evaluate", "(" + gc.objectJT + gc.objectJT + ")" + gc.objectJT, new String[]{gc.pexceptionJCN}, null);
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
    }

    private static final class KFPNCGenContext
    extends CNGenContext {
        public final String classToWrite;
        public final String superClassJCN;
        public final Class clazz;
        public final NameDef nd;
        public final Expression exp;

        public KFPNCGenContext(CompositeName _co, NameDef _nd, Class _c, Expression _e, ClassVisitor _clav, CommonJVMHelper h) {
            super(_co, _clav, h);
            this.clazz = _c;
            this.nd = _nd;
            this.exp = _e;
            this.classToWrite = CommonJVMHelper.getJVMClassName(this.clazz.getFQName() + "KFPNC");
            this.superClassJCN = CommonJVMHelper.getJVMClassName(class$org$objectweb$jorm$naming$lib$AbstractInheritKeyFilteredPNamingContext == null ? (class$org$objectweb$jorm$naming$lib$AbstractInheritKeyFilteredPNamingContext = KFPNCGenerator.class$("org.objectweb.jorm.naming.lib.AbstractInheritKeyFilteredPNamingContext")) : class$org$objectweb$jorm$naming$lib$AbstractInheritKeyFilteredPNamingContext);
        }

        public KFPNCGenContext(NameDef _nd, Class _c, Expression _e, ClassVisitor _clav, CommonJVMHelper h) {
            super(_clav, h);
            this.clazz = _c;
            this.nd = _nd;
            this.exp = _e;
            this.classToWrite = CommonJVMHelper.getJVMClassName(this.clazz.getFQName() + "KFPNC");
            this.superClassJCN = CommonJVMHelper.getJVMClassName(class$org$objectweb$jorm$naming$lib$AbstractInheritKeyFilteredPNamingContext == null ? (class$org$objectweb$jorm$naming$lib$AbstractInheritKeyFilteredPNamingContext = KFPNCGenerator.class$("org.objectweb.jorm.naming.lib.AbstractInheritKeyFilteredPNamingContext")) : class$org$objectweb$jorm$naming$lib$AbstractInheritKeyFilteredPNamingContext);
        }
    }

    public class NamingKeyFilterExpressionHelper
    extends NamingFilterExpressionHelper {
        private PType filterType;
        private CompositeName co;

        public NamingKeyFilterExpressionHelper(Expression e, CompositeName co, Logger logger) throws PException, ExpressionException {
            super(logger);
            this.filterType = e.getType();
            this.co = co;
            this.fillMatchInfo(e);
        }

        public String getFilter() {
            return this.getValueAsObjectForGen(super.getFilter(), this.filterType);
        }

        protected void fillMatchInfo(ParameterOperand po) throws PException, ExpressionException {
            this.logger.log(BasicLevel.DEBUG, (Object)("ParameterOperand " + po.getName()));
            if (this.field2declarations.get(po.getName()) == null) {
                StringBuffer declaration = new StringBuffer();
                declaration.append(po.getType().getJavaName());
                declaration.append(' ');
                declaration.append(po.getName());
                declaration.append(" = ");
                if (this.co == null) {
                    declaration.append("((PNameGetter) png).");
                    declaration.append(this.getPNameGetterGetFunction(po.getType()));
                    declaration.append("(\"");
                    declaration.append(po.getName());
                    declaration.append("\", ctx)");
                } else {
                    declaration.append("(isSpecific ? ((");
                    declaration.append(this.co.getName());
                    declaration.append("PNG) png).pnGet");
                    declaration.append(this.upperFL(po.getName()));
                    declaration.append("(ctx) : ((PNameGetter) png).");
                    declaration.append(this.getPNameGetterGetFunction(po.getType()));
                    declaration.append("(\"");
                    declaration.append(po.getName());
                    declaration.append("\", ctx))");
                }
                declaration.append(";");
                this.field2declarations.put(po.getName(), declaration);
                if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Add declaration: " + declaration));
                }
            }
            this.filter.append(po.getName());
        }
    }
}

