/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.generator.lib;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.compiler.api.JormCompilerParameter;
import org.objectweb.jorm.compiler.api.PExceptionCompiler;
import org.objectweb.jorm.generator.lib.CNGenContext;
import org.objectweb.jorm.generator.lib.CommonGenerator;
import org.objectweb.jorm.generator.lib.CommonJVMHelper;
import org.objectweb.jorm.metainfo.api.CompositeName;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.jorm.naming.lib.BasicCompositePName;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.util.io.api.TargetHolder;
import org.objectweb.jorm.util.lib.StringReplace;
import org.objectweb.util.monolog.api.BasicLevel;

public class PNameGenerator
extends CommonGenerator {
    final String PARENT_CLASS_NAME = PNameGenerator.getJVMClassName(BasicCompositePName.class);
    static final String NULLVALUE = "NULLVALUE";
    static final String NULLOVALUE = "NULLOVALUE";
    static final String NULL_CHAR_VALUE = "NULL_CHAR_VALUE";
    static /* synthetic */ Class class$java$lang$StringBuffer;

    public void generate(CompositeName co, TargetHolder holder, JormCompilerParameter cp) throws PException {
        ClassWriter cv = new ClassWriter(true);
        PNameGenContext gc = new PNameGenContext(co, cv, this);
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Generate the class '" + gc.classToWrite + "'."));
        }
        cv.visit(196653, 33, gc.classToWrite, PNameGenerator.getJVMClassName(BasicCompositePName.class), new String[]{PNameGenerator.getJVMClassName(co.getFQName() + "PNG")}, gc.classToWrite);
        this.generateFields(gc);
        this.generateConstructorPnc(gc);
        this.generateConstructorPncPn(gc);
        this.generateConstructorFieldsPnc(gc);
        this.generateInit(gc);
        this.generateToString(gc);
        this.generateCheckPName(gc);
        this.generateValuesEqual(gc);
        this.generateHashCode(gc);
        this.generateNullPName(gc);
        this.generatePnGetSpecific(gc);
        this.generatePnGetGeneric(gc);
        try {
            String fileName = gc.classToWrite;
            fileName = StringReplace.replaceChar('/', File.separatorChar, fileName) + ".class";
            FileOutputStream fos = holder.getFileOutputStream(fileName);
            fos.write(cv.toByteArray());
            fos.close();
        }
        catch (Exception e) {
            throw new PExceptionCompiler(e, "Problem while generating PAccessor.");
        }
    }

    private void generateFields(PNameGenContext gc) {
        gc.clav.visitField(9, NULLVALUE, Type.LONG_TYPE.getDescriptor(), new Long(-1L), null);
        gc.clav.visitField(9, NULL_CHAR_VALUE, Type.CHAR_TYPE.getDescriptor(), new Character('0'), null);
        gc.clav.visitField(9, NULLOVALUE, PNameGenerator.getJVMType(Object.class), null, null);
        Iterator it = gc.coAllFields.iterator();
        while (it.hasNext()) {
            TypedElement te = (TypedElement)it.next();
            String jvmFieldType = PNameGenerator.getJVMType(te.getType());
            gc.clav.visitField(4, te.getName(), jvmFieldType, null, null);
        }
    }

    private void generateConstructorPnc(PNameGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(1, "<init>", "(" + gc.pnameManagerJT + ")V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(183, this.PARENT_CLASS_NAME, "<init>", "()V");
        this.assignPNC(cv, gc, 1);
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
    }

    private void generateConstructorPncPn(PNameGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(1, "<init>", "(" + gc.pnameManagerJT + gc.pnameJT + ")V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(183, this.PARENT_CLASS_NAME, "<init>", "()V");
        cv.visitVarInsn(25, 2);
        cv.visitTypeInsn(193, gc.classToWrite);
        Label labelElse = new Label();
        Label labelEnd = new Label();
        cv.visitJumpInsn(153, labelElse);
        Iterator it = gc.coAllFields.iterator();
        while (it.hasNext()) {
            TypedElement te = (TypedElement)it.next();
            String jvmFieldType = PNameGenerator.getJVMType(te.getType());
            cv.visitVarInsn(25, 0);
            cv.visitVarInsn(25, 2);
            cv.visitTypeInsn(192, gc.classToWrite);
            cv.visitFieldInsn(180, gc.classToWrite, te.getName(), jvmFieldType);
            cv.visitFieldInsn(181, gc.classToWrite, te.getName(), jvmFieldType);
        }
        cv.visitJumpInsn(167, labelEnd);
        cv.visitLabel(labelElse);
        cv.visitVarInsn(25, 2);
        cv.visitMethodInsn(185, gc.pnameJCN, "encodeAbstract", "()" + gc.objectJT);
        cv.visitTypeInsn(192, gc.pngJCN);
        cv.visitVarInsn(58, 3);
        cv.visitVarInsn(25, 3);
        cv.visitTypeInsn(193, gc.xpngJCN);
        Label labelElse2 = new Label();
        cv.visitJumpInsn(153, labelElse2);
        Iterator it2 = gc.coAllFields.iterator();
        while (it2.hasNext()) {
            TypedElement te = (TypedElement)it2.next();
            String jvmFieldType = PNameGenerator.getJVMType(te.getType());
            cv.visitVarInsn(25, 0);
            cv.visitVarInsn(25, 3);
            cv.visitTypeInsn(192, gc.xpngJCN);
            cv.visitMethodInsn(185, gc.xpngJCN, "pnGet" + this.upperFL(te.getName()), "()" + jvmFieldType);
            cv.visitFieldInsn(181, gc.classToWrite, te.getName(), jvmFieldType);
        }
        cv.visitJumpInsn(167, labelEnd);
        cv.visitLabel(labelElse2);
        cv.visitTypeInsn(187, gc.pexceptionJCN);
        cv.visitInsn(89);
        cv.visitMethodInsn(183, gc.pexceptionJCN, "<init>", "()V");
        cv.visitInsn(191);
        cv.visitLabel(labelEnd);
        this.assignPNC(cv, gc, 1);
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
    }

    private void generateConstructorFieldsPnc(PNameGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(1, "<init>", "(" + gc.xconstructorFieldsPnc + ")V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(183, this.PARENT_CLASS_NAME, "<init>", "()V");
        int idx = this.assignFields(gc, cv);
        this.assignPNC(cv, gc, idx);
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
    }

    private void generateInit(PNameGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(1, "init", "(" + gc.xconstructorFieldsPnc + ")V", null, null);
        int idx = this.assignFields(gc, cv);
        this.assignPNC(cv, gc, idx);
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
    }

    private void generateNullPName(PNameGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(9, "nullPName", "(" + gc.pnameManagerJT + ")" + gc.pnameJT, null, null);
        cv.visitTypeInsn(187, gc.classToWrite);
        cv.visitInsn(89);
        Iterator it = gc.coAllFields.iterator();
        while (it.hasNext()) {
            TypedElement te = (TypedElement)it.next();
            PType type = te.getType();
            if (this.isObjectType(type)) {
                cv.visitFieldInsn(178, gc.classToWrite, NULLOVALUE, gc.objectJT);
                cv.visitTypeInsn(192, PNameGenerator.getJVMClassName(te.getType().getJavaClass()));
                continue;
            }
            switch (type.getTypeCode()) {
                case 1: {
                    cv.visitFieldInsn(178, gc.classToWrite, NULL_CHAR_VALUE, Type.CHAR_TYPE.getDescriptor());
                    break;
                }
                case 2: {
                    cv.visitFieldInsn(178, gc.classToWrite, NULLVALUE, Type.LONG_TYPE.getDescriptor());
                    cv.visitInsn(136);
                    cv.visitInsn(145);
                    break;
                }
                case 3: {
                    cv.visitFieldInsn(178, gc.classToWrite, NULLVALUE, Type.LONG_TYPE.getDescriptor());
                    cv.visitInsn(136);
                    cv.visitInsn(145);
                    break;
                }
                case 4: {
                    cv.visitFieldInsn(178, gc.classToWrite, NULLVALUE, Type.LONG_TYPE.getDescriptor());
                    cv.visitInsn(136);
                    break;
                }
                case 5: {
                    cv.visitFieldInsn(178, gc.classToWrite, NULLVALUE, Type.LONG_TYPE.getDescriptor());
                }
            }
        }
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(183, gc.classToWrite, "<init>", "(" + gc.xconstructorFieldsPnc + ")V");
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
    }

    private void generatePnGetSpecific(PNameGenContext gc) {
        Iterator it = gc.coAllFields.iterator();
        while (it.hasNext()) {
            TypedElement te = (TypedElement)it.next();
            String jvmFieldType = PNameGenerator.getJVMType(te.getType());
            CodeVisitor cv = gc.clav.visitMethod(1, "pnGet" + this.upperFL(te.getName()), "(" + gc.objectJT + ")" + jvmFieldType, new String[]{gc.pexceptionJCN}, null);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, gc.classToWrite, te.getName(), jvmFieldType);
            cv.visitInsn(Type.getType(te.getType().getJavaClass()).getOpcode(172));
            cv.visitMaxs(0, 0);
        }
    }

    private void generatePnGetGeneric(PNameGenContext gc) throws PException {
        HashMap<PType, ArrayList<TypedElement>> pt2fieldlist = new HashMap<PType, ArrayList<TypedElement>>();
        Iterator it = gc.coAllFields.iterator();
        while (it.hasNext()) {
            TypedElement te = (TypedElement)it.next();
            int tc = te.getType().getTypeCode();
            ArrayList<TypedElement> fs = (ArrayList<TypedElement>)pt2fieldlist.get(te.getType());
            if (fs == null) {
                fs = new ArrayList<TypedElement>();
                pt2fieldlist.put(te.getType(), fs);
            }
            fs.add(te);
        }
        Iterator mapit = pt2fieldlist.entrySet().iterator();
        while (mapit.hasNext()) {
            Map.Entry me = mapit.next();
            PType type = (PType)me.getKey();
            String jvmFieldType = PNameGenerator.getJVMType(type);
            String methodName = this.getPNameGetterGetFunction(type);
            String methodDesc = "(" + gc.stringJT + gc.objectJT + ")" + jvmFieldType;
            int methodReturnType = Type.getType(type.getJavaClass()).getOpcode(172);
            CodeVisitor cv = gc.clav.visitMethod(1, methodName, methodDesc, new String[]{gc.pexceptionJCN}, null);
            Iterator fieldIt = ((List)me.getValue()).iterator();
            while (fieldIt.hasNext()) {
                TypedElement te = (TypedElement)fieldIt.next();
                cv.visitLdcInsn(te.getName());
                cv.visitVarInsn(25, 1);
                cv.visitMethodInsn(182, gc.stringJCN, "equals", "(" + gc.objectJT + ")Z");
                Label labelElse = new Label();
                cv.visitJumpInsn(153, labelElse);
                cv.visitVarInsn(25, 0);
                cv.visitFieldInsn(180, gc.classToWrite, te.getName(), jvmFieldType);
                cv.visitInsn(methodReturnType);
                cv.visitLabel(labelElse);
            }
            cv.visitVarInsn(25, 0);
            cv.visitVarInsn(25, 1);
            cv.visitVarInsn(25, 2);
            cv.visitMethodInsn(183, this.PARENT_CLASS_NAME, methodName, methodDesc);
            cv.visitInsn(methodReturnType);
            cv.visitMaxs(0, 0);
        }
    }

    private void generateCheckPName(PNameGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(1, "checkPName", "(" + gc.objectJT + ")Z", null, null);
        cv.visitVarInsn(25, 1);
        cv.visitTypeInsn(193, gc.classToWrite);
        cv.visitInsn(172);
        cv.visitMaxs(0, 0);
    }

    private void generateToString(PNameGenContext gc) {
        String toStringMDesc = "()" + gc.stringJT;
        CodeVisitor cv = gc.clav.visitMethod(1, "toString", toStringMDesc, null, null);
        cv.visitTypeInsn(187, gc.stringBufferJCN);
        cv.visitInsn(89);
        cv.visitMethodInsn(183, gc.stringBufferJCN, "<init>", "()V");
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(183, this.PARENT_CLASS_NAME, "toString", toStringMDesc);
        String mas = "(" + gc.stringJT + ")" + gc.stringBufferJT;
        cv.visitMethodInsn(182, gc.stringBufferJCN, "append", mas);
        Iterator it = gc.coAllFields.iterator();
        while (it.hasNext()) {
            TypedElement te = (TypedElement)it.next();
            PType type = te.getType();
            cv.visitLdcInsn(" / " + te.getName() + "=");
            cv.visitMethodInsn(182, gc.stringBufferJCN, "append", mas);
            cv.visitVarInsn(25, 0);
            cv.visitFieldInsn(180, gc.classToWrite, te.getName(), PNameGenerator.getJVMType(type));
            String amd = "(";
            amd = this.isObjectType(type) ? amd + gc.objectJT : amd + PNameGenerator.getJVMType(type);
            amd = amd + ")" + PNameGenerator.getJVMType(class$java$lang$StringBuffer == null ? PNameGenerator.class$("java.lang.StringBuffer") : class$java$lang$StringBuffer);
            cv.visitMethodInsn(182, gc.stringBufferJCN, "append", amd);
        }
        cv.visitMethodInsn(182, gc.stringBufferJCN, "toString", toStringMDesc);
        cv.visitInsn(176);
        cv.visitMaxs(0, 0);
    }

    private void generateHashCode(PNameGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(1, "hashCode", "()I", null, null);
        cv.visitInsn(3);
        Iterator it = gc.coAllFields.iterator();
        while (it.hasNext()) {
            TypedElement te = (TypedElement)it.next();
            PType type = te.getType();
            switch (te.getType().getTypeCode()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    cv.visitVarInsn(25, 0);
                    cv.visitFieldInsn(180, gc.classToWrite, te.getName(), PNameGenerator.getJVMType(type));
                    break;
                }
                case 5: {
                    cv.visitVarInsn(25, 0);
                    cv.visitFieldInsn(180, gc.classToWrite, te.getName(), PNameGenerator.getJVMType(type));
                    cv.visitInsn(136);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 21: 
                case 22: {
                    cv.visitVarInsn(25, 0);
                    cv.visitFieldInsn(180, gc.classToWrite, te.getName(), PNameGenerator.getJVMType(type));
                    Label l1 = new Label();
                    Label l2 = new Label();
                    cv.visitJumpInsn(198, l1);
                    cv.visitVarInsn(25, 0);
                    cv.visitFieldInsn(180, gc.classToWrite, te.getName(), PNameGenerator.getJVMType(type));
                    cv.visitMethodInsn(182, PNameGenerator.getJVMClassName(te.getType().getJavaName()), "hashCode", "()I");
                    cv.visitJumpInsn(167, l2);
                    cv.visitLabel(l1);
                    cv.visitInsn(3);
                    cv.visitLabel(l2);
                    break;
                }
                default: {
                    cv.visitInsn(3);
                }
            }
            cv.visitInsn(96);
        }
        cv.visitInsn(172);
        cv.visitMaxs(0, 0);
    }

    private void generateValuesEqual(PNameGenContext gc) {
        CodeVisitor cv = gc.clav.visitMethod(4, "valuesEqual", "(" + gc.pnameJT + ")Z", null, null);
        cv.visitVarInsn(25, 1);
        cv.visitTypeInsn(192, gc.classToWrite);
        cv.visitVarInsn(58, 2);
        Label labelFalse = new Label();
        Iterator it = gc.coAllFields.iterator();
        block6: while (it.hasNext()) {
            TypedElement te = (TypedElement)it.next();
            PType type = te.getType();
            String jvmFieldType = PNameGenerator.getJVMType(type);
            Type asmType = Type.getType(type.getJavaClass());
            switch (type.getTypeCode()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    cv.visitVarInsn(25, 0);
                    cv.visitFieldInsn(180, gc.classToWrite, te.getName(), jvmFieldType);
                    cv.visitVarInsn(25, 2);
                    cv.visitFieldInsn(180, gc.classToWrite, te.getName(), jvmFieldType);
                    cv.visitJumpInsn(160, labelFalse);
                    continue block6;
                }
                case 5: {
                    cv.visitVarInsn(25, 0);
                    cv.visitFieldInsn(180, gc.classToWrite, te.getName(), jvmFieldType);
                    cv.visitVarInsn(25, 2);
                    cv.visitFieldInsn(180, gc.classToWrite, te.getName(), jvmFieldType);
                    cv.visitInsn(148);
                    cv.visitJumpInsn(154, labelFalse);
                    continue block6;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 21: 
                case 22: {
                    cv.visitVarInsn(25, 0);
                    cv.visitFieldInsn(180, gc.classToWrite, te.getName(), jvmFieldType);
                    Label labelNull = new Label();
                    Label labelNextTest = new Label();
                    cv.visitJumpInsn(198, labelNull);
                    cv.visitVarInsn(25, 0);
                    cv.visitFieldInsn(180, gc.classToWrite, te.getName(), jvmFieldType);
                    cv.visitVarInsn(25, 2);
                    cv.visitFieldInsn(180, gc.classToWrite, te.getName(), jvmFieldType);
                    cv.visitMethodInsn(182, PNameGenerator.getJVMClassName(class$java$lang$Object == null ? PNameGenerator.class$("java.lang.Object") : class$java$lang$Object), "equals", "(" + gc.objectJT + ")Z");
                    cv.visitJumpInsn(153, labelFalse);
                    cv.visitJumpInsn(167, labelNextTest);
                    cv.visitLabel(labelNull);
                    cv.visitVarInsn(25, 2);
                    cv.visitFieldInsn(180, gc.classToWrite, te.getName(), jvmFieldType);
                    cv.visitJumpInsn(198, labelNextTest);
                    cv.visitJumpInsn(167, labelFalse);
                    cv.visitLabel(labelNextTest);
                    continue block6;
                }
                case 18: 
                case 19: {
                    cv.visitVarInsn(25, 0);
                    cv.visitVarInsn(25, 0);
                    cv.visitFieldInsn(180, gc.classToWrite, te.getName(), jvmFieldType);
                    cv.visitVarInsn(25, 2);
                    cv.visitFieldInsn(180, gc.classToWrite, te.getName(), jvmFieldType);
                    cv.visitMethodInsn(182, this.PARENT_CLASS_NAME, "equal", "(" + jvmFieldType + jvmFieldType + ")Z");
                    cv.visitJumpInsn(153, labelFalse);
                    continue block6;
                }
            }
            this.logger.log(BasicLevel.WARN, (Object)("Type '" + type.getJavaName() + "' occurs a problem with this visitor"));
        }
        cv.visitInsn(4);
        Label labelEnd = new Label();
        cv.visitJumpInsn(167, labelEnd);
        cv.visitLabel(labelFalse);
        cv.visitInsn(3);
        cv.visitLabel(labelEnd);
        cv.visitInsn(Type.BOOLEAN_TYPE.getOpcode(172));
        cv.visitMaxs(0, 0);
    }

    private int assignFields(PNameGenContext gc, CodeVisitor cv) {
        int i = 1;
        Iterator it = gc.coAllFields.iterator();
        block3: while (it.hasNext()) {
            TypedElement te = (TypedElement)it.next();
            cv.visitVarInsn(25, 0);
            cv.visitVarInsn(Type.getType(te.getType().getJavaClass()).getOpcode(21), i);
            cv.visitFieldInsn(181, gc.classToWrite, te.getName(), PNameGenerator.getJVMType(te.getType()));
            switch (te.getType().getTypeCode()) {
                case 5: 
                case 7: {
                    i += 2;
                    continue block3;
                }
            }
            ++i;
        }
        return i;
    }

    private void assignPNC(CodeVisitor cv, PNameGenContext gc, int paramIdx) {
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, paramIdx);
        cv.visitFieldInsn(181, gc.classToWrite, "pnc", gc.pnameManagerJT);
    }

    private static final class PNameGenContext
    extends CNGenContext {
        public final String classToWrite;

        public PNameGenContext(CompositeName _co, ClassVisitor _clav, CommonJVMHelper h) {
            super(_co, _clav, h);
            this.classToWrite = this.xpnameJCN;
        }
    }
}

