/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.lib;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import org.objectweb.jorm.api.ClassMappedEvent;
import org.objectweb.jorm.api.JormConfigurator;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PExceptionProtocol;
import org.objectweb.jorm.api.PMapCluster;
import org.objectweb.jorm.api.PMapper;
import org.objectweb.jorm.api.PMapperListener;
import org.objectweb.jorm.api.PMappingCallback;
import org.objectweb.jorm.api.PMappingRequiredEvent;
import org.objectweb.jorm.api.PMappingStructuresManager;
import org.objectweb.jorm.lib.JormConfiguratorImpl;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.jorm.type.api.PTypeSpace;
import org.objectweb.jorm.type.lib.PTypeSpacePAAH;
import org.objectweb.jorm.util.api.Loggable;
import org.objectweb.jorm.util.io.api.PathExplorer;
import org.objectweb.jorm.xml2mi.api.Parser;
import org.objectweb.medor.eval.prefetch.api.PrefetchCache;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;

public abstract class Mapper
implements PMapper,
Loggable,
PMappingCallback {
    static final int INITIALMAPSIZE = 100;
    String mapperName = null;
    Manager metainfoManager = null;
    Parser parser = null;
    ArrayList dtdLocations = null;
    PathExplorer pathToPdFiles = null;
    PTypeSpace typeSpace = null;
    HashMap mappedClasses = new HashMap(100);
    PrefetchCache prefetchCache = null;
    protected Logger logger = null;
    protected LoggerFactory loggerFactory = null;
    private JormConfigurator jormConfigurator = null;
    private Class gcmClass = null;
    PMappingStructuresManager pMappingStructuresManager = null;
    private ArrayList listenerList = new ArrayList();

    public Mapper() throws PException {
        this.jormConfigurator = new JormConfiguratorImpl();
        this.jormConfigurator.configure("jorm.properties");
        this.jormConfigurator.configureLog("jorm.properties");
    }

    public Mapper(JormConfigurator c) {
        this.jormConfigurator = c;
    }

    public void setJormConfigurator(JormConfigurator jormConfigurator) {
        this.jormConfigurator = jormConfigurator;
    }

    public JormConfigurator getJormConfigurator() {
        return this.jormConfigurator;
    }

    public void scheduleEvent(EventObject e) throws PException {
        Iterator it = this.listenerList.iterator();
        while (it.hasNext()) {
            PMapperListener l = (PMapperListener)it.next();
            if (e instanceof PMappingRequiredEvent) {
                l.mappingRequired((PMappingRequiredEvent)e);
                continue;
            }
            if (e instanceof ClassMappedEvent) {
                l.classMapped((ClassMappedEvent)e);
                continue;
            }
            throw new PException("Mapper cannot schedule this kind of event: " + e);
        }
    }

    public String getMapperName() {
        return this.mapperName;
    }

    public PMappingStructuresManager getPMappingStructuresManager() {
        return this.pMappingStructuresManager;
    }

    public PClassMapping lookup(String classname) {
        return (PClassMapping)this.mappedClasses.get(classname);
    }

    public void map(PClassMapping pcm) throws PException {
        this.map(null, pcm);
    }

    public void map(Object conn, PClassMapping pcm) throws PException {
        if (pcm == null) {
            throw new PExceptionProtocol("Cannot map null class mapping.");
        }
        PClassMapping ecm = (PClassMapping)this.mappedClasses.get(pcm.getClassName());
        if (ecm == pcm) {
            return;
        }
        if (ecm != null) {
            throw new PExceptionProtocol("Class already mapped within this mapper.");
        }
        if (!pcm.isConform(this.mapperName)) {
            throw new PExceptionProtocol("Class mapping (" + pcm.getClass().getName() + ") cannot be managed by this mapper (" + this.mapperName + ").");
        }
        if (this.typeSpace == null) {
            this.typeSpace = new PTypeSpacePAAH();
        }
        ((Loggable)((Object)pcm)).setLogger(this.loggerFactory.getLogger("org.objectweb.jorm." + this.mapperName + "." + pcm.getClassName()));
        pcm.init(this, null);
        this.mappedClasses.put(pcm.getClassName(), pcm);
        this.scheduleEvent(new ClassMappedEvent(this, pcm.getClassName()));
        if (this.logger != null) {
            this.logger.log(BasicLevel.INFO, (Object)("New mapped class: " + pcm.getClassName()));
        }
    }

    public void map(Object conn, PClassMapping pcm, boolean loadmeta) throws PException {
        if (loadmeta && (this.metainfoManager == null || this.parser == null)) {
            throw new PExceptionProtocol("Not enough means to load meta-information.");
        }
        this.map(pcm);
        if (!loadmeta) {
            return;
        }
        this.parser.parse(pcm.getClassName().replace('.', File.separatorChar) + ".pd");
    }

    public void setMapperName(String mappername) {
        this.mapperName = mappername;
    }

    public void setDTDLocations(ArrayList dtdlocs) {
        this.dtdLocations = dtdlocs;
    }

    public void setPathsToPdFiles(PathExplorer paths) {
        this.pathToPdFiles = paths;
    }

    public PClassMapping createGenClassMapping() throws PException {
        try {
            return (PClassMapping)this.gcmClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new PException(e, "Cannot instanciate gen class mapping Class.");
        }
        catch (IllegalAccessException e) {
            throw new PException(e, "Cannot access to gen class mapping Class.");
        }
    }

    public Manager getMetaInfoManager() {
        return this.metainfoManager;
    }

    public PTypeSpace getPTypeSpace() {
        return this.typeSpace;
    }

    public void start() throws PException {
        String basemn = this.mapperName;
        int ind = this.mapperName.indexOf(".");
        if (ind != -1) {
            basemn = this.mapperName.substring(0, ind);
        }
        this.metainfoManager = this.jormConfigurator.getMIManager();
        this.jormConfigurator.configureMIManager(this.metainfoManager);
        this.parser = this.jormConfigurator.getParser();
        this.jormConfigurator.configureParser(this.parser, this.dtdLocations, this.pathToPdFiles, this.metainfoManager);
        this.pMappingStructuresManager = this.jormConfigurator.getSchMgr(basemn);
        this.pMappingStructuresManager.setPMapper(this);
        this.pMappingStructuresManager.setLogger(this.logger);
        this.typeSpace = this.metainfoManager.getPTypeSpace();
        this.gcmClass = this.jormConfigurator.getGcmClass(basemn);
    }

    public void stop() throws PException {
    }

    public void unmap(String classname) throws PException {
        this.mappedClasses.remove(classname);
    }

    public void setPrefetchCache(PrefetchCache pc) throws PException {
        if (this.prefetchCache != null) {
            throw new PExceptionProtocol("A prefetch cache has already been assigned to this mapper");
        }
        this.prefetchCache = pc;
    }

    public PrefetchCache getPrefetchCache() {
        return this.prefetchCache;
    }

    public void clean() throws PException {
        this.mappedClasses.clear();
        this.typeSpace.clean();
        this.prefetchCache.clean();
        this.pMappingStructuresManager.clear();
    }

    public PMapCluster getPMapCluster(String jcname) throws PException {
        if (this.pMappingStructuresManager == null) {
            throw new PException("No pMappingStructuresManager associated with this mapper");
        }
        return this.pMappingStructuresManager.getPMapCluster(jcname);
    }

    public Collection getPMapClusters() {
        if (this.pMappingStructuresManager == null) {
            return new ArrayList();
        }
        return this.pMappingStructuresManager.getPMapClusters();
    }

    public void addDependency(String jcname1, String jcname2) throws PException {
        if (this.pMappingStructuresManager == null) {
            throw new PException("No pMappingStructuresManager associated with this mapper");
        }
        this.pMappingStructuresManager.addDependency(jcname1, jcname2);
    }

    public void declareClass(String jcname) {
        this.pMappingStructuresManager.declareClass(jcname);
    }

    public void classDefined(String jcname) throws PException {
        if (this.pMappingStructuresManager == null) {
            throw new PException("No pMappingStructuresManager associated with this mapper");
        }
        this.pMappingStructuresManager.classDefined(jcname);
    }

    public synchronized void addMapperEventListener(PMapperListener listener) {
        if (this.listenerList.indexOf(listener) == -1) {
            this.listenerList.add(listener);
        }
    }

    public synchronized void removeMapperEventListener(PMapperListener listener) {
        if (this.listenerList.indexOf(listener) != -1) {
            this.listenerList.remove(listener);
        }
    }

    public String[] getMappedClasses() {
        return this.mappedClasses.keySet().toArray(new String[this.mappedClasses.size()]);
    }

    public void setPMapper(PMapper pm) {
    }

    public void clear() throws PException {
        if (this.pMappingStructuresManager == null) {
            throw new PException("No pMappingStructuresManager associated with this mapper");
        }
        this.pMappingStructuresManager.clear();
    }

    public void setLogger(Logger logger) {
    }

    public void setLoggerFactory(LoggerFactory loggerfactory) {
        this.loggerFactory = loggerfactory;
        this.logger = this.loggerFactory.getLogger("org.objectweb.jorm." + this.mapperName);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String cn2mn(String cn) {
        int ldot;
        String shortMapperName = this.getMapperName();
        int idx = shortMapperName.indexOf(".");
        if (idx != -1) {
            shortMapperName = shortMapperName.substring(0, idx);
        }
        if ((ldot = cn.lastIndexOf(46)) == -1) {
            return shortMapperName + "." + cn;
        }
        return cn.substring(0, ldot + 1) + shortMapperName + cn.substring(ldot);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PMapper)) {
            return false;
        }
        PMapper m = (PMapper)o;
        return m.getMapperName().equals(this.mapperName);
    }

    public int hashCode() {
        return this.mapperName.hashCode();
    }
}

