/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.adapter;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.objectweb.jorm.mapper.rdb.adapter.BasicArray;
import org.objectweb.jorm.mapper.rdb.adapter.api.JoinedTable;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapter;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapterException;
import org.objectweb.jorm.mapper.rdb.lib.RdbBlob;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class BasicRdbAdapter
implements RdbAdapter {
    private static final String CONCAT = "concat";
    private static final String INDEXEDLOCATE = "instr";
    protected Logger logger;
    protected String name;
    private static final boolean accountForNanos;

    public BasicRdbAdapter() {
    }

    public BasicRdbAdapter(String _name) {
        this.name = _name;
    }

    public boolean supportBatchPreparedStatement() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public int getSqlTypeCode(int typeCode) throws RdbAdapterException {
        return this.getSqlTypeCode(typeCode, null);
    }

    public int getSqlTypeCode(int typeCode, String sqlColumnType) throws RdbAdapterException {
        if (BasicArray.isArray(typeCode)) {
            return 2003;
        }
        switch (typeCode) {
            case 0: 
            case 8: {
                return -7;
            }
            case 1: 
            case 9: {
                return 1;
            }
            case 2: 
            case 10: {
                return -6;
            }
            case 3: 
            case 11: {
                return 5;
            }
            case 4: 
            case 12: {
                return 4;
            }
            case 5: 
            case 13: {
                return -5;
            }
            case 6: 
            case 14: {
                return 7;
            }
            case 7: 
            case 15: {
                return 8;
            }
            case 16: {
                return 12;
            }
            case 17: {
                if (sqlColumnType == null) {
                    return 93;
                }
                String str = sqlColumnType.toUpperCase();
                if (str.startsWith("DATE")) {
                    return 91;
                }
                if (str.startsWith("TIMESTAMP")) {
                    return 93;
                }
                if (str.startsWith("TIME")) {
                    return 92;
                }
                return 93;
            }
            case 18: {
                return 12;
            }
            case 19: 
            case 20: {
                return -3;
            }
            case 21: {
                return 3;
            }
            case 22: {
                return 3;
            }
        }
        throw new RdbAdapterException("No sql type exist for the type code " + typeCode);
    }

    public String getSqlType(int typeCode, boolean usedInPK, int size, int scale) throws RdbAdapterException {
        if (BasicArray.isArray(typeCode)) {
            return this.getSqlType(typeCode - 100, usedInPK, size, scale) + "[]";
        }
        switch (typeCode) {
            case 0: 
            case 8: {
                return "BIT";
            }
            case 1: 
            case 9: {
                return "CHAR(1)";
            }
            case 2: 
            case 10: {
                return "TINYINT";
            }
            case 3: 
            case 11: {
                return "SMALLINT";
            }
            case 4: 
            case 12: {
                return "INTEGER";
            }
            case 5: 
            case 13: {
                return "BIGINT";
            }
            case 6: 
            case 14: {
                return "REAL";
            }
            case 7: 
            case 15: {
                return "DOUBLE";
            }
            case 16: 
            case 18: {
                if (size != -1) {
                    return "VARCHAR(" + size + ")";
                }
                return "VARCHAR";
            }
            case 17: {
                return "TIMESTAMP";
            }
            case 19: 
            case 20: {
                if (size != -1) {
                    return "VARBINARY(" + size + ")";
                }
                return "VARBINARY";
            }
            case 21: 
            case 22: {
                if (size != -1) {
                    if (scale != -1) {
                        return "NUMERIC(" + size + ", " + scale + ")";
                    }
                    return "NUMERIC(" + size + ")";
                }
                return "NUMERIC";
            }
        }
        throw new RdbAdapterException("No sql type exist for the type code" + typeCode);
    }

    public void setNull(PreparedStatement ps, int idx, int sqlType) throws SQLException {
        ps.setNull(idx, sqlType);
    }

    public int fetchResultSetSize(ResultSet rs) throws SQLException {
        return -1;
    }

    public String getValueAsSQLString(Object value, int typeCode) {
        if (BasicArray.isArray(typeCode)) {
            String res = this.getArrayValueAsSQLString(value, typeCode);
            return res;
        }
        switch (typeCode) {
            case 0: 
            case 8: {
                return (Boolean)value != false ? "1" : "0";
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return value.toString();
            }
            case 9: 
            case 16: 
            case 17: 
            case 21: 
            case 22: {
                return "'" + value.toString() + "'";
            }
        }
        return null;
    }

    public String getArrayToStringBegin() {
        return "{";
    }

    public String getArrayToStringEnd() {
        return "}";
    }

    public String getArrayToStringSeparator() {
        return ",";
    }

    public String getArrayToString(Object array, int typeCode) {
        return this.getArrayValueAsSQLString(array, typeCode, this.getArrayToStringBegin(), this.getArrayToStringSeparator(), this.getArrayToStringEnd());
    }

    public String getArrayValueAsSQLStringBegin() {
        return "'{";
    }

    public String getArrayValueAsSQLStringEnd() {
        return "}'";
    }

    public String getArrayValueAsSQLStringSeparator() {
        return ",";
    }

    public String getArrayElementAsSQLString(Object elem, int elemTypeCode) {
        return this.getValueAsSQLString(elem, elemTypeCode);
    }

    public String getArrayValueAsSQLString(Object array, int typeCode) {
        return this.getArrayValueAsSQLString(array, typeCode, this.getArrayValueAsSQLStringBegin(), this.getArrayValueAsSQLStringSeparator(), this.getArrayValueAsSQLStringEnd());
    }

    public String getArrayValueAsSQLString(Object array, int typeCode, String begin, String realsep, String end) {
        if (array == null) {
            return "NULL";
        }
        int innerTypeCode = BasicArray.getElementArrayTypeCode(typeCode);
        StringBuffer sb = new StringBuffer();
        sb.append(begin);
        String sep = "";
        switch (innerTypeCode) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: {
                Object[] tab = (Object[])array;
                for (int i = 0; i < tab.length; ++i) {
                    sb.append(sep);
                    sep = realsep;
                    sb.append(this.getArrayElementAsSQLString(tab[i], innerTypeCode));
                }
                break;
            }
            case 0: {
                boolean[] tab = (boolean[])array;
                for (int i = 0; i < tab.length; ++i) {
                    sb.append(sep);
                    sep = realsep;
                    sb.append(this.getValueAsSQLString(tab[i]));
                }
                break;
            }
            case 2: {
                byte[] tab = (byte[])array;
                for (int i = 0; i < tab.length; ++i) {
                    sb.append(sep);
                    sep = realsep;
                    sb.append(this.getValueAsSQLString(tab[i]));
                }
                break;
            }
            case 1: {
                char[] tab = (char[])array;
                for (int i = 0; i < tab.length; ++i) {
                    sb.append(sep);
                    sep = realsep;
                    sb.append(this.getValueAsSQLString(tab[i]));
                }
                break;
            }
            case 3: {
                short[] tab = (short[])array;
                for (int i = 0; i < tab.length; ++i) {
                    sb.append(sep);
                    sep = realsep;
                    sb.append(this.getValueAsSQLString(tab[i]));
                }
                break;
            }
            case 4: {
                int[] tab = (int[])array;
                for (int i = 0; i < tab.length; ++i) {
                    sb.append(sep);
                    sep = realsep;
                    sb.append(this.getValueAsSQLString(tab[i]));
                }
                break;
            }
            case 5: {
                long[] tab = (long[])array;
                for (int i = 0; i < tab.length; ++i) {
                    sb.append(sep);
                    sep = realsep;
                    sb.append(this.getValueAsSQLString(tab[i]));
                }
                break;
            }
            case 6: {
                float[] tab = (float[])array;
                for (int i = 0; i < tab.length; ++i) {
                    sb.append(sep);
                    sep = realsep;
                    sb.append(this.getValueAsSQLString(tab[i]));
                }
                break;
            }
            case 7: {
                double[] tab = (double[])array;
                for (int i = 0; i < tab.length; ++i) {
                    sb.append(sep);
                    sep = realsep;
                    sb.append(this.getValueAsSQLString(tab[i]));
                }
                break;
            }
        }
        sb.append(end);
        return sb.toString();
    }

    public String getValueAsSQLString(boolean value) {
        StringBuffer sb = new StringBuffer();
        if (value) {
            return sb.append("1").toString();
        }
        return sb.append("0").toString();
    }

    public String getValueAsSQLString(byte value) {
        StringBuffer sb = new StringBuffer();
        return sb.append("").append(value).toString();
    }

    public String getValueAsSQLString(char value) {
        StringBuffer sb = new StringBuffer();
        return sb.append("'").append(value).append("'").toString();
    }

    public String getValueAsSQLString(short value) {
        StringBuffer sb = new StringBuffer();
        return sb.append("").append(value).toString();
    }

    public String getValueAsSQLString(int value) {
        StringBuffer sb = new StringBuffer();
        return sb.append("").append(value).toString();
    }

    public String getValueAsSQLString(long value) {
        StringBuffer sb = new StringBuffer();
        return sb.append("").append(value).toString();
    }

    public String getValueAsSQLString(float value) {
        StringBuffer sb = new StringBuffer();
        return sb.append("").append(value).toString();
    }

    public String getValueAsSQLString(double value) {
        StringBuffer sb = new StringBuffer();
        return sb.append("").append(value).toString();
    }

    public boolean getBoolean(ResultSet rs, int idx, boolean nullValue) throws SQLException {
        boolean res = rs.getBoolean(idx);
        return rs.wasNull() ? nullValue : res;
    }

    public Boolean getOboolean(ResultSet rs, int idx, Boolean nullValue) throws SQLException {
        boolean res = rs.getBoolean(idx);
        return rs.wasNull() ? null : new Boolean(res);
    }

    public char getChar(ResultSet rs, int idx, char nullValue) throws SQLException {
        char res = rs.getString(idx).charAt(0);
        return rs.wasNull() ? nullValue : res;
    }

    public Character getOchar(ResultSet rs, int idx, Character nullValue) throws SQLException {
        String s = rs.getString(idx);
        return rs.wasNull() ? nullValue : new Character(s.charAt(0));
    }

    public byte getByte(ResultSet rs, int idx, byte nullValue) throws SQLException {
        byte res = rs.getByte(idx);
        return rs.wasNull() ? nullValue : res;
    }

    public Byte getObyte(ResultSet rs, int idx, Byte nullValue) throws SQLException {
        byte res = rs.getByte(idx);
        return rs.wasNull() ? null : new Byte(res);
    }

    public short getShort(ResultSet rs, int idx, short nullValue) throws SQLException {
        short res = rs.getShort(idx);
        return rs.wasNull() ? nullValue : res;
    }

    public Short getOshort(ResultSet rs, int idx, Short nullValue) throws SQLException {
        short res = rs.getShort(idx);
        return rs.wasNull() ? nullValue : new Short(res);
    }

    public int getInt(ResultSet rs, int idx, int nullValue) throws SQLException {
        int res = rs.getInt(idx);
        return rs.wasNull() ? nullValue : res;
    }

    public Integer getOint(ResultSet rs, int idx, Integer nullValue) throws SQLException {
        int res = rs.getInt(idx);
        return rs.wasNull() ? nullValue : new Integer(res);
    }

    public long getLong(ResultSet rs, int idx, long nullValue) throws SQLException {
        long res = rs.getLong(idx);
        return rs.wasNull() ? nullValue : res;
    }

    public Long getOlong(ResultSet rs, int idx, Long nullValue) throws SQLException {
        long res = rs.getLong(idx);
        return rs.wasNull() ? nullValue : new Long(res);
    }

    public float getFloat(ResultSet rs, int idx, float nullValue) throws SQLException {
        float res = rs.getFloat(idx);
        return rs.wasNull() ? nullValue : res;
    }

    public Float getOfloat(ResultSet rs, int idx, Float nullValue) throws SQLException {
        float res = rs.getFloat(idx);
        return rs.wasNull() ? null : new Float(res);
    }

    public double getDouble(ResultSet rs, int idx, double nullValue) throws SQLException {
        double res = rs.getDouble(idx);
        return rs.wasNull() ? nullValue : res;
    }

    public Double getOdouble(ResultSet rs, int idx, Double nullValue) throws SQLException {
        double res = rs.getDouble(idx);
        return rs.wasNull() ? nullValue : new Double(res);
    }

    public String getString(ResultSet rs, int idx, String nullValue) throws SQLException {
        String res = rs.getString(idx);
        return rs.wasNull() ? nullValue : res;
    }

    public java.util.Date getDate(ResultSet rs, int idx, java.util.Date nullValue) throws SQLException {
        return this.getDate(rs, idx, null, nullValue);
    }

    private static java.util.Date timestamp2date(Timestamp tstamp) {
        if (tstamp == null) {
            return null;
        }
        if (accountForNanos) {
            return new java.util.Date(tstamp.getTime() + (long)(tstamp.getNanos() / 1000000));
        }
        return new java.util.Date(tstamp.getTime());
    }

    private static java.util.Date sqldate2date(Date d) {
        if (d == null) {
            return null;
        }
        return new java.util.Date(d.getTime());
    }

    private static java.util.Date time2date(Time t) {
        if (t == null) {
            return null;
        }
        return new java.util.Date(t.getTime());
    }

    public java.util.Date getDate(ResultSet rs, int idx, String sqlColumnType, java.util.Date nullValue) throws SQLException {
        String str;
        java.util.Date res = null;
        res = sqlColumnType == null || sqlColumnType.length() == 0 ? BasicRdbAdapter.timestamp2date(rs.getTimestamp(idx)) : ((str = sqlColumnType.toUpperCase()).startsWith("DATE") ? BasicRdbAdapter.sqldate2date(rs.getDate(idx)) : (str.startsWith("TIMESTAMP") ? BasicRdbAdapter.timestamp2date(rs.getTimestamp(idx)) : (str.startsWith("TIME") ? BasicRdbAdapter.time2date(rs.getTime(idx)) : BasicRdbAdapter.timestamp2date(rs.getTimestamp(idx)))));
        if (rs.wasNull()) {
            return nullValue;
        }
        return res;
    }

    public char[] getCharArray(ResultSet rs, int idx, char[] nullValue) throws SQLException {
        Reader r = rs.getCharacterStream(idx);
        if (rs.wasNull()) {
            return nullValue;
        }
        try {
            return BasicRdbAdapter.getCharArray(r);
        }
        catch (IOException e) {
            throw new SQLException("Impossible to build a char[]: " + e.getMessage());
        }
    }

    private static char[] getCharArray(Reader reader) throws IOException {
        int size = 0;
        long skipped = 0L;
        while ((skipped = reader.skip(50L)) == 50L) {
            size += 50;
        }
        char[] res = new char[size += (int)skipped];
        reader.reset();
        reader.read(res);
        return res;
    }

    public byte[] getByteArray(ResultSet rs, int idx, byte[] nullValue) throws SQLException {
        byte[] res = rs.getBytes(idx);
        return rs.wasNull() ? nullValue : res;
    }

    public Serializable getSerialized(ResultSet rs, int idx, Serializable nullValue) throws SQLException, IOException, ClassNotFoundException {
        InputStream is = rs.getBinaryStream(idx);
        class Specialized_OIS
        extends ObjectInputStream {
            Specialized_OIS(InputStream is) throws IOException {
                super(is);
            }

            protected Class resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
                try {
                    return super.resolveClass(osc);
                }
                catch (ClassNotFoundException e) {
                    return Thread.currentThread().getContextClassLoader().loadClass(osc.getName());
                }
            }
        }
        return rs.wasNull() ? nullValue : (Serializable)new Specialized_OIS(is).readObject();
    }

    public BigDecimal getBigDecimal(ResultSet rs, int idx, BigDecimal nullValue) throws SQLException {
        BigDecimal res = rs.getBigDecimal(idx);
        return rs.wasNull() ? nullValue : res;
    }

    public BigInteger getBigInteger(ResultSet rs, int idx, BigInteger nullValue) throws SQLException {
        BigDecimal bd = this.getBigDecimal(rs, idx, null);
        if (bd == null) {
            return nullValue;
        }
        return bd.toBigInteger();
    }

    public Object getArray(ResultSet rs, int idx, Object nullValue, int typeCode) throws SQLException {
        Array a = rs.getArray(idx);
        if (a == null || rs.wasNull()) {
            return nullValue;
        }
        Object v = a.getArray();
        if (v == null) {
            return nullValue;
        }
        switch (BasicArray.getElementArrayTypeCode(typeCode)) {
            case 8: {
                boolean[] tab = (boolean[])v;
                Boolean[] res = new Boolean[tab.length];
                for (int i = 0; i < tab.length; ++i) {
                    res[i] = tab[i];
                }
                return res;
            }
            case 10: {
                byte[] tab = (byte[])v;
                Byte[] res = new Byte[tab.length];
                for (int i = 0; i < tab.length; ++i) {
                    res[i] = new Byte(tab[i]);
                }
                return res;
            }
            case 11: {
                short[] tab = (short[])v;
                Short[] res = new Short[tab.length];
                for (int i = 0; i < tab.length; ++i) {
                    res[i] = new Short(tab[i]);
                }
                return res;
            }
            case 12: {
                int[] tab = (int[])v;
                Integer[] res = new Integer[tab.length];
                for (int i = 0; i < tab.length; ++i) {
                    res[i] = new Integer(tab[i]);
                }
                return res;
            }
            case 13: {
                long[] tab = (long[])v;
                Long[] res = new Long[tab.length];
                for (int i = 0; i < tab.length; ++i) {
                    res[i] = new Long(tab[i]);
                }
                return res;
            }
            case 14: {
                short[] tab = (short[])v;
                Short[] res = new Short[tab.length];
                for (int i = 0; i < tab.length; ++i) {
                    res[i] = new Short(tab[i]);
                }
                return res;
            }
            case 15: {
                double[] tab = (double[])v;
                Double[] res = new Double[tab.length];
                for (int i = 0; i < tab.length; ++i) {
                    res[i] = new Double(tab[i]);
                }
                return res;
            }
            case 9: {
                char[] tab = (char[])v;
                Character[] res = new Character[tab.length];
                for (int i = 0; i < tab.length; ++i) {
                    res[i] = new Character(tab[i]);
                }
                return res;
            }
        }
        return v;
    }

    public void setBoolean(PreparedStatement ps, int idx, boolean o) throws SQLException {
        ps.setBoolean(idx, o);
    }

    public void setOboolean(PreparedStatement ps, int idx, Boolean o) throws SQLException {
        if (o == null) {
            ps.setNull(idx, -7);
        } else {
            ps.setBoolean(idx, o);
        }
    }

    public void setChar(PreparedStatement ps, int idx, char c) throws SQLException {
        ps.setString(idx, String.valueOf(c));
    }

    public void setOchar(PreparedStatement ps, int idx, Character o) throws SQLException {
        if (o == null) {
            ps.setNull(idx, 1);
        } else {
            ps.setString(idx, String.valueOf(o.charValue()));
        }
    }

    public void setByte(PreparedStatement ps, int idx, byte o) throws SQLException {
        ps.setByte(idx, o);
    }

    public void setObyte(PreparedStatement ps, int idx, Byte o) throws SQLException {
        if (o == null) {
            ps.setNull(idx, 5);
        } else {
            ps.setByte(idx, o);
        }
    }

    public void setShort(PreparedStatement ps, int idx, short o) throws SQLException {
        ps.setShort(idx, o);
    }

    public void setOshort(PreparedStatement ps, int idx, Short o) throws SQLException {
        if (o == null) {
            ps.setNull(idx, 5);
        } else {
            ps.setShort(idx, o);
        }
    }

    public void setInt(PreparedStatement ps, int idx, int o) throws SQLException {
        ps.setInt(idx, o);
    }

    public void setOint(PreparedStatement ps, int idx, Integer o) throws SQLException {
        if (o == null) {
            ps.setNull(idx, 4);
        } else {
            ps.setInt(idx, o);
        }
    }

    public void setLong(PreparedStatement ps, int idx, long o) throws SQLException {
        ps.setLong(idx, o);
    }

    public void setOlong(PreparedStatement ps, int idx, Long o) throws SQLException {
        if (o == null) {
            ps.setNull(idx, -5);
        } else {
            ps.setLong(idx, o);
        }
    }

    public void setFloat(PreparedStatement ps, int idx, float o) throws SQLException {
        ps.setFloat(idx, o);
    }

    public void setOfloat(PreparedStatement ps, int idx, Float o) throws SQLException {
        if (o == null) {
            ps.setNull(idx, 6);
        } else {
            ps.setFloat(idx, o.floatValue());
        }
    }

    public void setDouble(PreparedStatement ps, int idx, double o) throws SQLException {
        ps.setDouble(idx, o);
    }

    public void setOdouble(PreparedStatement ps, int idx, Double o) throws SQLException {
        if (o == null) {
            ps.setNull(idx, 8);
        } else {
            ps.setDouble(idx, o);
        }
    }

    public void setString(PreparedStatement ps, int idx, String o) throws SQLException {
        if (o == null) {
            ps.setNull(idx, 12);
        } else {
            ps.setString(idx, o);
        }
    }

    public void setDate(PreparedStatement ps, int idx, java.util.Date o, String columnType) throws SQLException {
        if (columnType == null) {
            if (o == null) {
                ps.setNull(idx, 93);
            } else if (o instanceof Timestamp) {
                ps.setTimestamp(idx, (Timestamp)o);
            } else {
                ps.setTimestamp(idx, new Timestamp(o.getTime()));
            }
        } else if (columnType.startsWith("DATE")) {
            if (o == null) {
                ps.setNull(idx, 91);
            } else if (o instanceof Date) {
                ps.setDate(idx, (Date)o);
            } else {
                ps.setDate(idx, new Date(o.getTime()));
            }
        } else if (columnType.startsWith("TIMESTAMP")) {
            if (o == null) {
                ps.setNull(idx, 93);
            } else if (o instanceof Timestamp) {
                ps.setTimestamp(idx, (Timestamp)o);
            } else {
                ps.setTimestamp(idx, new Timestamp(o.getTime()));
            }
        } else if (columnType.startsWith("TIME")) {
            if (o == null) {
                ps.setNull(idx, 92);
            } else if (o instanceof Time) {
                ps.setTime(idx, (Time)o);
            } else {
                ps.setTime(idx, new Time(o.getTime()));
            }
        }
    }

    public void setCharArray(PreparedStatement ps, int idx, char[] o) throws SQLException {
        if (o == null) {
            ps.setNull(idx, -3);
        } else {
            ps.setCharacterStream(idx, (Reader)new CharArrayReader(o), o.length);
        }
    }

    public void setByteArray(PreparedStatement ps, int idx, byte[] o) throws SQLException {
        if (o == null) {
            ps.setNull(idx, -3);
        } else {
            ps.setBytes(idx, o);
        }
    }

    public void setBigInteger(PreparedStatement ps, int idx, BigInteger o) throws SQLException {
        if (o == null) {
            ps.setNull(idx, 3);
        } else {
            ps.setBigDecimal(idx, new BigDecimal(o));
        }
    }

    public void setBigDecimal(PreparedStatement ps, int idx, BigDecimal o) throws SQLException {
        if (o == null) {
            ps.setNull(idx, 3);
        } else {
            ps.setBigDecimal(idx, o);
        }
    }

    public void setSerialized(PreparedStatement ps, int idx, Serializable o) throws SQLException, IOException {
        if (o == null) {
            ps.setNull(idx, -3);
        } else {
            RdbBlob blob = new RdbBlob(o);
            ps.setBinaryStream(idx, blob.getBinaryStream(), (int)blob.length());
        }
    }

    public void setArray(PreparedStatement ps, int idx, Object o, int typeCode) throws SQLException {
        if (o == null) {
            ps.setNull(idx, 2003);
        } else {
            try {
                ps.setArray(idx, new BasicArray(o, typeCode, this, null));
            }
            catch (RdbAdapterException e) {
                throw new SQLException(e.getMessage());
            }
        }
    }

    public void escapeFunctionOpen(StringBuffer sb) {
        sb.append("{fn ");
    }

    public void escapeFunctionClose(StringBuffer sb) {
        sb.append("}");
    }

    public String getConcatExpression(String op1, String op2) {
        StringBuffer sb = new StringBuffer();
        sb.append(CONCAT).append("(").append(op1);
        sb.append(", ").append(op2).append(")");
        return sb.toString();
    }

    public String getFirstLocateExpression(String substring, String instring) throws RdbAdapterException {
        StringBuffer sb = new StringBuffer();
        this.escapeFunctionOpen(sb);
        sb.append("locate(").append(substring).append(", ").append(instring);
        sb.append(")");
        this.escapeFunctionClose(sb);
        return sb.toString();
    }

    public String getIndexedLocateExpression(String instring, String substring, String fromIndex) throws RdbAdapterException {
        StringBuffer sb = new StringBuffer();
        sb.append(INDEXEDLOCATE).append("(").append(instring).append(", ");
        sb.append(substring).append(", ").append(fromIndex).append(")");
        return sb.toString();
    }

    public String getLengthOperator() throws RdbAdapterException {
        return "length";
    }

    public String getQuery(String selectClause, List jts, String whereClause, boolean rangeStart, boolean rangeSize) {
        return this.getQuery(selectClause, this.getFromClause(jts), whereClause, null, null, rangeStart, rangeSize);
    }

    public String getFromClause(List jts) {
        StringBuffer sb = new StringBuffer();
        String sep = "";
        for (int i = 0; i < jts.size(); ++i) {
            JoinedTable jt = (JoinedTable)jts.get(i);
            sb.append(sep);
            sep = ", ";
            this.getFromClause(jt, sb);
        }
        return sb.toString();
    }

    protected void appendClause(StringBuffer sb, String clause, String value) {
        if (value != null && value.length() > 0) {
            sb.append(clause);
            sb.append(value);
        }
    }

    public String getQuery(String selectClause, String fromClause, String whereClause, String orderBy, String groupBy, boolean rangeStart, boolean rangeSize) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ");
        if (rangeStart || rangeSize) {
            this.modifySelectClauseWithRange(sb, rangeStart, rangeSize);
        }
        sb.append(selectClause);
        this.appendClause(sb, " FROM ", fromClause);
        this.appendClause(sb, " WHERE ", whereClause);
        this.appendClause(sb, " ORDER BY ", orderBy);
        this.appendClause(sb, " GROUP BY ", groupBy);
        if (rangeStart || rangeSize) {
            this.modifyQueryWithRange(sb, rangeStart, rangeSize);
        }
        return sb.toString();
    }

    protected void getFromClause(JoinedTable jt, StringBuffer sb) {
        sb.append(jt.tableName);
        if (jt.alias != null && jt.alias.length() > 0) {
            this.writeTableAlias(jt.alias, sb);
        }
        for (int i = 0; i < jt.joinedTables.size(); ++i) {
            this.getFromClause(jt, (JoinedTable)jt.joinedTables.get(i), (JoinedTable.Join)jt.joins.get(i), sb);
        }
    }

    public void writeTableAlias(String alias, StringBuffer sb) {
        sb.append(" as ");
        sb.append(alias);
    }

    public void writeColumnAlias(String alias, StringBuffer sb) {
        sb.append(" as ");
        sb.append(alias);
    }

    public String getColumnAliasExpr(String aliasName) {
        return " as " + aliasName;
    }

    public String handleOrderBy(String query) {
        return query;
    }

    public String getCreateSequence(String seqName) throws UnsupportedOperationException {
        return "CREATE SEQUENCE " + seqName;
    }

    public String getDropSequence(String seqName) throws UnsupportedOperationException {
        return "DROP SEQUENCE " + seqName;
    }

    public String getNextValInSequence(String seqName) {
        return "select nextVal('" + seqName + "')";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getManyNextValInSequence(Connection conn, String seqName, int numberOfNextVal) throws RdbAdapterException {
        StringBuffer sb = new StringBuffer();
        sb.append("select ");
        for (int i = 0; i < numberOfNextVal - 1; ++i) {
            sb.append("nextVal('" + seqName + "'), ");
        }
        sb.append("nextVal('" + seqName + "')");
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(sb.toString());
                ps.executeQuery();
            }
            catch (SQLException e) {
                throw new RdbAdapterException(e, "Impossible to allocate " + numberOfNextVal + " identifier" + " on the sequence: " + seqName);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (ps == null) throw throwable;
                ps.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        if (ps == null) return;
        ps.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean existRelation(Connection connection, String relName, String[] relationTypes) throws SQLException {
        boolean existtable = false;
        ResultSet rs = null;
        if (relationTypes == null) {
            relationTypes = new String[]{"TABLE", "VIEW"};
        }
        String schema = null;
        if (relName.indexOf(46) != -1) {
            schema = relName.substring(0, relName.indexOf(46));
            relName = relName.substring(relName.indexOf(46) + 1);
        }
        try {
            rs = connection.getMetaData().getTables(null, schema, relName, relationTypes);
            while (rs.next() && !existtable) {
                existtable = relName.equalsIgnoreCase(rs.getString(3));
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return existtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existSchema(Connection connection, String schemaName) throws SQLException {
        ResultSet rs = null;
        try {
            rs = connection.getMetaData().getSchemas();
            while (rs.next()) {
                if (!rs.getString(1).equals(schemaName)) continue;
                rs.close();
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return false;
    }

    public boolean existTable(Connection connection, String tableName) throws SQLException {
        return this.existRelation(connection, tableName, new String[]{"TABLE"});
    }

    public boolean existView(Connection connection, String viewName) throws SQLException {
        return this.existRelation(connection, viewName, new String[]{"VIEW"});
    }

    public boolean existSequence(Connection connection, String seqName) throws SQLException {
        return this.existTable(connection, seqName);
    }

    protected void getFromClause(JoinedTable jtMain, JoinedTable jt, JoinedTable.Join join, StringBuffer sb) {
        int i;
        if (join.outer) {
            sb.append(" left outer join ");
        } else {
            sb.append(" join ");
        }
        sb.append(jt.tableName);
        if (jt.alias != null && jt.alias.length() > 0) {
            this.writeTableAlias(jt.alias, sb);
        }
        sb.append(" on ");
        String sep = "";
        String main = jtMain.alias != null && jtMain.alias.length() > 0 ? jtMain.alias : jtMain.tableName;
        String ext = jt.alias != null && jt.alias.length() > 0 ? jt.alias : jt.tableName;
        for (i = 0; i < join.colT1.size(); ++i) {
            sb.append(sep);
            sep = " AND ";
            sb.append(main);
            sb.append(".");
            sb.append(join.colT1.get(i));
            sb.append(" = ");
            sb.append(ext);
            sb.append(".");
            sb.append(join.colT2.get(i));
        }
        for (i = 0; i < jt.joinedTables.size(); ++i) {
            this.getFromClause(jt, (JoinedTable)jt.joinedTables.get(i), (JoinedTable.Join)jt.joins.get(i), sb);
        }
    }

    public static char[] getCharArray(Object o) throws IOException, RdbAdapterException {
        if (o instanceof Reader) {
            Reader reader = (Reader)o;
            int size = 0;
            long skipped = 0L;
            while ((skipped = reader.skip(50L)) == 50L) {
                size += 50;
            }
            char[] res = new char[size += (int)skipped];
            reader.reset();
            reader.read(res);
            return res;
        }
        if (o instanceof String) {
            return ((String)o).toCharArray();
        }
        throw new RdbAdapterException("Unknown type to convert to char[]");
    }

    public String getSubqueryAlias() {
        return "foo";
    }

    public String getCreateSequence(String seqName, Integer startid, Integer inc, Integer cache) throws UnsupportedOperationException {
        StringBuffer sb = new StringBuffer("CREATE SEQUENCE ");
        sb.append(seqName);
        if (inc != null) {
            sb.append(" ");
            sb.append(this.getINCREMENTkeyWord());
            sb.append(" ");
            sb.append(inc);
        }
        if (startid != null) {
            sb.append(" ");
            sb.append(this.getSTARTkeyWord());
            sb.append(" ");
            sb.append(startid);
        }
        if (cache != null) {
            sb.append(" ");
            sb.append(this.getCACHEkeyWord());
            sb.append(" ");
            sb.append(cache);
        }
        return sb.toString();
    }

    public void setLogger(Logger _logger) {
        this.logger = _logger;
    }

    protected String getINCREMENTkeyWord() {
        return "INCREMENT BY";
    }

    protected String getSTARTkeyWord() {
        return "START WITH";
    }

    protected String getCACHEkeyWord() {
        return "CACHE";
    }

    protected void modifySelectClauseWithRange(StringBuffer sb, boolean rangeStart, boolean rangeSize) {
        if (this.logger != null) {
            this.logger.log(BasicLevel.WARN, (Object)("Range queries not suppoted by this adapter (" + this.name + ") , leaving select clause unchanged."));
        }
    }

    protected void modifyQueryWithRange(StringBuffer sb, boolean rangeStart, boolean rangeSize) {
        if (this.logger != null) {
            this.logger.log(BasicLevel.WARN, (Object)("Range queries not suppoted by this adapter (" + this.name + ") , leaving query unchanged."));
        }
    }

    public int getRangeParametersAtStart() {
        if (this.logger != null) {
            this.logger.log(BasicLevel.WARN, (Object)("Range queries not suppoted by this adapter (" + this.name + ") , leaving query unchanged."));
        }
        return -1;
    }

    public boolean supportArray(int elemTypeCode) {
        return true;
    }

    public String getDropIndex(String name, String tableName) throws UnsupportedOperationException {
        return "DROP INDEX " + name;
    }

    public String getCreateIndex(String name, String tableName, List fieldNames, boolean unique) throws UnsupportedOperationException {
        StringBuffer sb = new StringBuffer("CREATE");
        if (unique) {
            sb.append(" UNIQUE");
        }
        sb.append(" INDEX " + name + " ON " + tableName + "(");
        for (int i = 0; i < fieldNames.size(); ++i) {
            if (i == 0) {
                sb.append(fieldNames.get(i));
                continue;
            }
            sb.append("," + fieldNames.get(i));
        }
        sb.append(")");
        return sb.toString();
    }

    static {
        int minor;
        String version2 = System.getProperty("java.specification.version");
        accountForNanos = version2.startsWith("1.") ? (minor = new Integer(version2.charAt(2)).intValue()) < 4 : false;
    }
}

