/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.generator;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenColumn;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenTable;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbJoin;

public class RdbGenJoin {
    public RdbGenTable mainTable = null;
    public RdbGenTable table = null;
    public int joinIdx = 0;
    public List joinColumnsInMain = null;
    public List joinColumnsInExt = null;

    public int getJoinIdx() {
        return this.joinIdx;
    }

    public List getJoinColumnsInMain() {
        return this.joinColumnsInMain;
    }

    public List getJoinColumnsInExt() {
        return this.joinColumnsInExt;
    }

    public RdbGenTable getMainTable() {
        return this.mainTable;
    }

    public RdbGenTable getTable() {
        return this.table;
    }

    public RdbGenJoin(RdbGenTable mainTable, RdbGenTable extTable, RdbJoin j, int idx) throws PException {
        this.joinIdx = idx;
        this.table = extTable;
        this.mainTable = mainTable;
        List pcns = j.getPTJoinColumnNames();
        List ecns = j.getETJoinColumnNames();
        this.joinColumnsInMain = new ArrayList(pcns.size());
        this.joinColumnsInExt = new ArrayList(pcns.size());
        for (int i = 0; i < pcns.size(); ++i) {
            String pcn = (String)pcns.get(i);
            String ecn = (String)ecns.get(i);
            RdbGenColumn pjcol = mainTable.getColumn(pcn);
            if (pjcol == null) {
                throw new PException("In the join between tables " + mainTable.tableName + " and " + extTable.tableName + ", " + "the column '" + pcn + "' was not found in extTable " + mainTable.tableName);
            }
            this.joinColumnsInMain.add(pjcol);
            RdbGenColumn ejcol = extTable.getColumn(ecn);
            if (ejcol == null) {
                ejcol = new RdbGenColumn();
                ejcol.columnName = ecn;
                ejcol.joinCol = pjcol;
                ejcol.columnType = pjcol.columnType;
                ejcol.columnSqlType = pjcol.columnSqlType;
                ejcol.table = extTable;
                ejcol.fieldName = pjcol.fieldName;
                ejcol.columnNotNull = pjcol.columnNotNull;
                ejcol.joins = null;
                ejcol.pes = null;
                extTable.columns.add(ejcol);
            }
            this.joinColumnsInExt.add(ejcol);
        }
    }
}

