/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.generator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenColumn;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenInfos;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenJoin;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;

public class RdbGenRef {
    public String cnName = null;
    public int cnId = -1;
    public String cnPackage = null;
    public Map cnFieldColumns = null;
    public RdbGenColumn refColumn = null;
    public NameDef nd = null;
    public String fieldName = null;
    public RdbGenJoin join = null;

    public String getFieldName() {
        return this.fieldName;
    }

    public NameDef getNd() {
        return this.nd;
    }

    public String getCnName() {
        return this.cnName;
    }

    public int getCnId() {
        return this.cnId;
    }

    public String getCnPackage() {
        return this.cnPackage;
    }

    public String getCnFQName() {
        return this.cnPackage == null ? this.cnName : this.cnPackage + "." + this.cnName;
    }

    public Map getCnFieldColumns() {
        return this.cnFieldColumns;
    }

    public RdbGenColumn getRefColumn() {
        return this.refColumn;
    }

    public String getFieldName(RdbGenColumn rgc) {
        if (rgc.joinCol != null) {
            return this.getFieldName(rgc.joinCol);
        }
        if (this.refColumn != null) {
            return null;
        }
        Iterator it = this.cnFieldColumns.keySet().iterator();
        while (it.hasNext()) {
            String res = (String)it.next();
            if (this.cnFieldColumns.get(res) != rgc) continue;
            return res;
        }
        return null;
    }

    public String getClassFieldName(String compositeFieldName) {
        return (String)this.nd.getNameRef().getProjection().get(compositeFieldName);
    }

    public String getAccessorValue(boolean isSpecific) {
        if (isSpecific) {
            return "paccessor.paGet" + RdbGenInfos.commonHelper.upperFL(this.fieldName) + "(conn)";
        }
        return "paccessorGen.paGetRefField(" + this.fieldName + "_NAME, conn)";
    }

    public RdbGenJoin getJoin(RdbGenColumn rgc) throws PException {
        return this.getJoin(rgc, this.nd.getFieldName());
    }

    public RdbGenJoin getJoin(RdbGenColumn rgc, String fn) throws PException {
        try {
            int i;
            if (rgc.pes == null) {
                throw new PException("No join needed to reach the field " + fn + " over the " + rgc.columnName + " column.");
            }
            for (i = 0; i < rgc.pes.size() && !fn.equals(((PrimitiveElement)rgc.pes.get(i)).getName()); ++i) {
            }
            if (i < rgc.pes.size()) {
                RdbGenJoin rgj = (RdbGenJoin)rgc.joins.get(i);
                if (rgj == null) {
                    new PException("No RdbGenJoin found for the field '" + fn + "' and the column '" + rgc.columnName + "'.").printStackTrace();
                }
                return rgj;
            }
            throw new PException("Field " + fn + " is not mapped over the " + rgc.columnName + " column.");
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public Set getcnField2ColumnName() {
        HashMap<String, String> p = new HashMap<String, String>();
        try {
            if (this.nd.isFieldName()) {
                p.put("", this.refColumn.table.tableName + "." + this.refColumn.columnName);
            } else if (this.nd.isNameRef()) {
                Iterator iter = this.cnFieldColumns.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry me = iter.next();
                    RdbGenColumn rgc = (RdbGenColumn)me.getValue();
                    p.put((String)me.getKey(), rgc.table.tableName + "." + rgc.columnName);
                }
            }
        }
        catch (RuntimeException e) {
            System.out.println(this);
            e.printStackTrace();
            throw e;
        }
        return p.entrySet();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(" / cnId=").append(this.cnId);
        sb.append(" / cnPackage=").append(this.cnPackage);
        sb.append(" / cnFieldColumns=").append(this.cnFieldColumns);
        sb.append(" / refColumn=").append(this.refColumn);
        sb.append(" / nd=").append(this.nd);
        if (this.nd != null && this.nd.isNameRef()) {
            sb.append(" / nd.nr.cn=").append(this.nd.getNameRef().getCompositeName());
            sb.append(" / nd.nr.cn=").append(this.nd.getNameRef().getProjection());
        }
        sb.append(" / fieldName=").append(this.fieldName);
        sb.append(" / join=").append(this.join);
        return sb.toString();
    }
}

