/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.lib;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.lib.AbstractPMapcluster;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapter;
import org.objectweb.jorm.mapper.rdb.lib.Column;
import org.objectweb.jorm.mapper.rdb.lib.PMapperRdb;
import org.objectweb.jorm.mapper.rdb.lib.RdbConnectionWrapper;
import org.objectweb.jorm.mapper.rdb.lib.RdbPMappingStructuresManager;
import org.objectweb.jorm.mapper.rdb.lib.RdbScriptWriter;
import org.objectweb.jorm.mapper.rdb.lib.Table;
import org.objectweb.util.monolog.api.BasicLevel;

public class RdbPMapCluster
extends AbstractPMapcluster {
    private ArrayList tables;
    private RdbPMappingStructuresManager manager;
    private RdbAdapter adapter;

    RdbPMapCluster(String jcname, RdbPMappingStructuresManager man) {
        this.manager = man;
        this.jcNames = new HashSet(1);
        this.unresolvedDependencies.add(jcname);
        this.tables = new ArrayList(1);
        this.structuresActive = false;
        if (this.manager.getPMapper() != null) {
            this.adapter = ((PMapperRdb)this.manager.getPMapper()).getRdbAdapter();
        }
    }

    RdbPMapCluster(String jcname, String tname, RdbPMappingStructuresManager man) {
        this(jcname, man);
        this.tables.add(new Table(tname, this));
    }

    void addTableColumn(String tname, String cname, String type, boolean notnull, boolean ispkcol, boolean isMaster) throws PException {
        Column c;
        Table curt = null;
        Iterator it = this.tables.iterator();
        while (it.hasNext()) {
            curt = (Table)it.next();
            if (curt.name.equals(tname)) break;
            curt = null;
        }
        if (curt == null) {
            curt = new Table(tname, this);
            this.tables.add(curt);
        }
        if ((c = curt.getColumn(cname)) == null) {
            curt.addColumn(cname, type, notnull, ispkcol, isMaster);
            return;
        }
        if (isMaster) {
            if (c.isMaster) {
                if (!c.type.equals(type)) {
                    throw new PException("Incompatible column definition [typing problem] \n\t- existing: " + c + " \n\t-asked : Column (name:" + cname + ", type:" + type + ", notNull:" + notnull + ", isMaster:" + isMaster + ", isPkCol:" + ispkcol + ")");
                }
                if (ispkcol && !c.isPkCol) {
                    c.notNull = notnull;
                    c.isPkCol = ispkcol;
                }
            } else {
                c.type = type;
                c.isMaster = true;
                c.notNull = notnull;
                c.isPkCol = ispkcol;
            }
        } else if (!c.isMaster && !c.type.equals(type)) {
            throw new PException("Incompatible column definition [typing problem] \n\t- existing: " + c + " \n\t-asked : Column (name:" + cname + ", type:" + type + ", notNull:" + notnull + ", isMaster:" + isMaster + ", isPkCol:" + ispkcol + ")");
        }
    }

    boolean containColumn(String tname, String cname, String type, boolean notnull) throws PException {
        Table curt = null;
        Iterator it = this.tables.iterator();
        while (it.hasNext()) {
            curt = (Table)it.next();
            if (curt.name.equals(tname)) break;
            curt = null;
        }
        if (curt == null) {
            return false;
        }
        return curt.containColumn(cname, type, notnull);
    }

    boolean containTable(String tname) {
        Iterator it = this.tables.iterator();
        while (it.hasNext()) {
            Table cur = (Table)it.next();
            if (!cur.name.equals(tname)) continue;
            return true;
        }
        return false;
    }

    Table getTable(String tname) {
        Iterator it = this.tables.iterator();
        while (it.hasNext()) {
            Table cur = (Table)it.next();
            if (!cur.name.equals(tname)) continue;
            return cur;
        }
        return null;
    }

    void merge(RdbPMapCluster cl) throws PException {
        this.jcNames.addAll(cl.jcNames);
        this.unresolvedDependencies.addAll(cl.getUnResolvedDependencies());
        this.unresolvedDependencies.removeAll(this.jcNames);
        for (int i = 0; i < cl.tables.size(); ++i) {
            Table cur = (Table)cl.tables.get(i);
            Table t = this.getTable(cur.name);
            if (t == null) {
                this.tables.add(cur);
                continue;
            }
            t.merge(cur);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMappingStructures(boolean force) throws PException {
        if (this.structuresActive) {
            throw new PException("Cannot change mapping structures while they are under use");
        }
        if (!this.isDefined()) {
            throw new PException("Cannot create hosting struture: the following dependencies has not been resolved: " + this.unresolvedDependencies);
        }
        if (this.manager instanceof RdbScriptWriter && ((RdbScriptWriter)((Object)this.manager)).isWriteScript()) {
            Iterator it = this.tables.iterator();
            while (it.hasNext()) {
                Table table = (Table)it.next();
                table.create(null);
            }
        } else {
            Object conn = this.manager.getConnection();
            try {
                Iterator it = this.tables.iterator();
                while (it.hasNext()) {
                    Table table = (Table)it.next();
                    if (table.exist(RdbConnectionWrapper.narrow2SQL(conn), this.adapter)) {
                        if (!force) continue;
                        throw new PException("Cannot create table " + table.name + ": already exist");
                    }
                    table.create(RdbConnectionWrapper.narrow2SQL(conn));
                }
            }
            finally {
                this.manager.closeConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteData() throws PException {
        if (!this.isDefined()) {
            throw new PException("Cannot remove data: the following dependencies has not been resolved: " + this.unresolvedDependencies);
        }
        if (this.manager instanceof RdbScriptWriter && ((RdbScriptWriter)((Object)this.manager)).isWriteScript()) {
            Iterator it = this.tables.iterator();
            while (it.hasNext()) {
                Table table = (Table)it.next();
                table.deleteData(null);
            }
        } else {
            Object conn = this.manager.getConnection();
            try {
                Iterator it = this.tables.iterator();
                while (it.hasNext()) {
                    Table table = (Table)it.next();
                    if (table.exist(RdbConnectionWrapper.narrow2SQL(conn), this.adapter)) {
                        table.deleteData(RdbConnectionWrapper.narrow2SQL(conn));
                        continue;
                    }
                    this.manager.logger.log(BasicLevel.WARN, (Object)("Impossible to delete the data of the table '" + table.name + "': table does not exist."));
                }
            }
            finally {
                this.manager.closeConnection(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMappingStructures() throws PException {
        if (this.structuresActive) {
            throw new PException("Cannot change mapping structures while they are under use");
        }
        if (!this.isDefined()) {
            throw new PException("Cannot delete hosting struture: the following dependencies has not been resolved: " + this.unresolvedDependencies);
        }
        if (this.manager instanceof RdbScriptWriter && ((RdbScriptWriter)((Object)this.manager)).isWriteScript()) {
            Iterator it = this.tables.iterator();
            while (it.hasNext()) {
                Table table = (Table)it.next();
                table.delete(null);
            }
        } else {
            Object conn = this.manager.getConnection();
            try {
                Iterator it = this.tables.iterator();
                while (it.hasNext()) {
                    Table table = (Table)it.next();
                    if (!table.exist(RdbConnectionWrapper.narrow2SQL(conn), this.adapter)) continue;
                    table.delete(RdbConnectionWrapper.narrow2SQL(conn));
                }
            }
            finally {
                this.manager.closeConnection(conn);
            }
        }
    }

    public RdbPMappingStructuresManager getManager() {
        return this.manager;
    }
}

