/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.lib;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PExceptionIO;
import org.objectweb.jorm.mapper.rdb.adapter.api.RdbAdapter;
import org.objectweb.jorm.mapper.rdb.lib.Column;
import org.objectweb.jorm.mapper.rdb.lib.RdbPMapCluster;
import org.objectweb.jorm.mapper.rdb.lib.RdbScriptWriter;

class Table {
    String name;
    ArrayList columns;
    RdbPMapCluster cluster;

    Table(String tname, RdbPMapCluster cluster) {
        this.name = tname;
        this.cluster = cluster;
        this.columns = new ArrayList();
    }

    void addColumn(String cname, String type, boolean notnull, boolean ispkcol, boolean ismaster) throws PException {
        Column cur = new Column();
        cur.name = cname;
        cur.type = type;
        cur.notNull = notnull;
        cur.isPkCol = ispkcol;
        cur.isMaster = ismaster;
        this.columns.add(cur);
    }

    void merge(Table t) throws PException {
        for (int i = 0; i < t.columns.size(); ++i) {
            Column cur = (Column)t.columns.get(i);
            Column c = this.getColumn(cur.name);
            if (c == null) {
                this.columns.add(cur);
                continue;
            }
            c.merge(cur);
        }
    }

    boolean containColumn(String cname, String type, boolean notnull) throws PException {
        Iterator it = this.columns.iterator();
        while (it.hasNext()) {
            Column cur = (Column)it.next();
            if (!cur.name.equals(cname)) continue;
            return true;
        }
        return false;
    }

    Column getColumn(String cname) {
        Iterator it = this.columns.iterator();
        while (it.hasNext()) {
            Column cur = (Column)it.next();
            if (!cur.name.equals(cname)) continue;
            return cur;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void create(Connection connection) throws PException {
        Statement stmt = null;
        StringBuffer sb = new StringBuffer("CREATE TABLE " + this.name + " (");
        try {
            try {
                Column col;
                String sep = "";
                Iterator it = this.columns.iterator();
                while (it.hasNext()) {
                    sb.append(sep);
                    sep = ", ";
                    col = (Column)it.next();
                    sb.append(col.name);
                    sb.append(" ");
                    sb.append(col.type);
                    if (!col.notNull || col.type.indexOf("NOT NULL") != -1) continue;
                    sb.append(" NOT NULL");
                }
                sep = "";
                it = this.columns.iterator();
                while (it.hasNext()) {
                    col = (Column)it.next();
                    if (!col.isPkCol) continue;
                    if (sep.equals("")) {
                        sb.append(", PRIMARY KEY (");
                    }
                    sb.append(sep);
                    sep = ", ";
                    sb.append(col.name);
                }
                if (!sep.equals("")) {
                    sb.append(")");
                }
                sb.append(")");
                if (this.cluster.getManager() instanceof RdbScriptWriter && ((RdbScriptWriter)((Object)this.cluster.getManager())).isWriteScript()) {
                    ((RdbScriptWriter)((Object)this.cluster.getManager())).getFileWriter().write(sb.toString() + ";\n");
                } else {
                    stmt = connection.createStatement();
                    stmt.execute(sb.toString());
                }
            }
            catch (SQLException se) {
                throw new PExceptionIO(se, "Impossible to create the table '" + this.name + "' of the cluster " + this.cluster.getClusterClasses() + " : " + sb.toString());
            }
            catch (IOException ioe) {
                throw new PExceptionIO(ioe, "Problem while writting create statement in the sql script file");
            }
            Object var8_9 = null;
            if (stmt == null) return;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (stmt == null) throw throwable;
            try {
                stmt.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException e) {}
        stmt.close();
        return;
    }

    /*
     * Loose catch block
     */
    void deleteData(Connection connection) throws PException {
        block18: {
            PException resex;
            Statement stmt;
            block16: {
                block15: {
                    stmt = null;
                    resex = null;
                    StringBuffer sb = new StringBuffer("DELETE FROM " + this.name);
                    if (this.cluster.getManager() instanceof RdbScriptWriter && ((RdbScriptWriter)((Object)this.cluster.getManager())).isWriteScript()) {
                        ((RdbScriptWriter)((Object)this.cluster.getManager())).getFileWriter().write(sb.toString() + ";\n");
                        break block15;
                    }
                    stmt = connection.createStatement();
                    stmt.execute(sb.toString());
                }
                Object var6_7 = null;
                if (stmt == null) break block16;
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    if (resex != null) break block16;
                    resex = new PException(e, "Problem while closing statment.");
                }
            }
            if (resex != null) {
                throw resex;
            }
            break block18;
            {
                catch (SQLException se) {
                    block17: {
                        resex = new PExceptionIO(se, "SQL problem while deleting data: class <" + this.name + ">");
                        Object var6_8 = null;
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException e) {
                                if (resex != null) break block17;
                                resex = new PException(e, "Problem while closing statment.");
                            }
                        }
                    }
                    if (resex != null) {
                        throw resex;
                    }
                    break block18;
                }
                catch (IOException ioe) {
                    throw new PExceptionIO(ioe, "Problem while writting delete statement in the sql script file");
                }
            }
            catch (Throwable throwable) {
                block19: {
                    Object var6_9 = null;
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e) {
                            if (resex != null) break block19;
                            resex = new PException(e, "Problem while closing statment.");
                        }
                    }
                }
                if (resex != null) {
                    throw resex;
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    void delete(Connection connection) throws PException {
        block18: {
            PException resex;
            Statement stmt;
            block16: {
                block15: {
                    stmt = null;
                    resex = null;
                    StringBuffer sb = new StringBuffer("DROP TABLE " + this.name);
                    if (this.cluster.getManager() instanceof RdbScriptWriter && ((RdbScriptWriter)((Object)this.cluster.getManager())).isWriteScript()) {
                        ((RdbScriptWriter)((Object)this.cluster.getManager())).getFileWriter().write(sb.toString() + ";\n");
                        break block15;
                    }
                    stmt = connection.createStatement();
                    stmt.execute(sb.toString());
                }
                Object var6_7 = null;
                if (stmt == null) break block16;
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    if (resex != null) break block16;
                    resex = new PException(e, "Problem while closing statment.");
                }
            }
            if (resex != null) {
                throw resex;
            }
            break block18;
            {
                catch (SQLException se) {
                    block17: {
                        resex = new PExceptionIO(se);
                        Object var6_8 = null;
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (SQLException e) {
                                if (resex != null) break block17;
                                resex = new PException(e, "Problem while closing statment.");
                            }
                        }
                    }
                    if (resex != null) {
                        throw resex;
                    }
                    break block18;
                }
                catch (IOException ioe) {
                    throw new PExceptionIO(ioe, "Problem while writting drop table statement in the sql script file");
                }
            }
            catch (Throwable throwable) {
                block19: {
                    Object var6_9 = null;
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e) {
                            if (resex != null) break block19;
                            resex = new PException(e, "Problem while closing statment.");
                        }
                    }
                }
                if (resex != null) {
                    throw resex;
                }
                throw throwable;
            }
        }
    }

    boolean exist(Connection connection, RdbAdapter adapter) throws PException {
        try {
            return adapter.existTable(connection, this.name);
        }
        catch (SQLException e) {
            throw new PException(e, "Pb while testing the existence of table " + this.name);
        }
    }
}

