/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.metainfo;

import java.util.Collection;
import java.util.Iterator;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbClassMultiMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbGenClassMapping;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassMapping;
import org.objectweb.jorm.metainfo.api.ClassProject;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.Mapping;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.ParentClassMapping;
import org.objectweb.jorm.metainfo.lib.BasicMapping;
import org.objectweb.util.monolog.api.BasicLevel;

public class RdbMapping
extends BasicMapping {
    public RdbMapping(String mapperName, MetaObject parent) {
        super(mapperName, parent);
    }

    public ClassMapping createClassMapping(String ruleName) {
        return this.createClassMultiMapping(ruleName);
    }

    public RdbClassMultiMapping createClassMultiMapping(String ruleName) {
        RdbClassMultiMapping res = (RdbClassMultiMapping)this.getClassMapping();
        if (res == null) {
            res = new RdbClassMultiMapping(ruleName, this.getParent().getParent(), this);
            this.setClassMapping(res);
            res.setLogger(this.logger);
        } else {
            res.setRuleName(ruleName);
        }
        return res;
    }

    public RdbGenClassMapping createGenClassMapping(String ruleName, MetaObject linkedMO) {
        RdbGenClassMapping res;
        String gcid = ((GenClassRef)linkedMO).getGenClassId();
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("(gcid " + gcid + ")"));
        }
        if ((res = (RdbGenClassMapping)this.getGenClassMapping(gcid)) == null) {
            res = new RdbGenClassMapping(ruleName, linkedMO, this);
            res.setLogger(this.logger);
            this.addGenClassMapping(gcid, res);
        } else {
            res.setRuleName(ruleName);
            res.setLinkedMO(linkedMO);
        }
        return res;
    }

    public boolean isFilteredMapping() {
        boolean isFilteredMapping = this.isFilteredMapping(this);
        if (!isFilteredMapping) {
            Class clazz = (Class)this.getClassMapping().getLinkedMO();
            Collection cs = clazz.getSubClasses();
            if (cs.isEmpty()) {
                return false;
            }
            String proj = ((ClassProject)this.getParent()).getProjectName();
            Iterator it = cs.iterator();
            while (it.hasNext() && !isFilteredMapping) {
                Mapping m = ((Class)it.next()).getClassProject(proj).getMapping(this.getMapperName());
                isFilteredMapping = this.isFilteredMapping(m);
            }
        }
        return isFilteredMapping;
    }

    private boolean isFilteredMapping(Mapping m) {
        Collection pcms = m.getClassMapping().getParentClassMappings();
        if (pcms.isEmpty()) {
            return false;
        }
        boolean isFilteredMapping = false;
        Iterator it = pcms.iterator();
        while (it.hasNext() && !isFilteredMapping) {
            ParentClassMapping pcm = (ParentClassMapping)it.next();
            isFilteredMapping = "to-extended-structures".equalsIgnoreCase(pcm.getRuleName());
        }
        return isFilteredMapping;
    }
}

