/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.metainfo.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.objectweb.jorm.metainfo.api.GenClass;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.lib.BasicMetaObject;
import org.objectweb.jorm.metainfo.lib.BasicPrimitiveElement;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.util.monolog.api.BasicLevel;

public class BasicGenClass
extends BasicMetaObject
implements GenClass {
    private String name;
    private boolean isAbstract;
    private Map indexFields;

    public BasicGenClass(String name, boolean isAbstract, MetaObject parent) {
        super(parent);
        this.name = name;
        this.isAbstract = isAbstract;
        this.indexFields = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public PrimitiveElement createIndexField(String indexFieldName, PType type) {
        PrimitiveElement result;
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("create a new PrimitiveElement (index field (" + indexFieldName + ")) for the current " + "GenClass (" + this.name + ")"));
        }
        if ((result = (PrimitiveElement)this.indexFields.get(indexFieldName)) != null) {
            if (this.debug) {
                this.logger.log(BasicLevel.WARN, (Object)("attention, try to create an existing PrimitiveElement (" + this.name + "), return existing one"));
            }
        } else {
            result = new BasicPrimitiveElement(indexFieldName, type, -1, -1, this);
            this.setLoggingOnChild(result);
            this.indexFields.put(indexFieldName, result);
        }
        return result;
    }

    public PrimitiveElement getIndexField(String indexFieldName) {
        return (PrimitiveElement)this.indexFields.get(indexFieldName);
    }

    public Iterator iterateIndexField() {
        return this.indexFields.values().iterator();
    }

    public int getIndexFieldNumber() {
        return this.indexFields.size();
    }

    protected Collection getChildren() {
        return this.indexFields.values();
    }
}

