/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.naming.lib;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.naming.api.KeyFilteredNamingContext;
import org.objectweb.jorm.naming.api.PBinder;
import org.objectweb.jorm.naming.api.PExceptionNaming;
import org.objectweb.jorm.naming.api.PName;
import org.objectweb.jorm.naming.api.PNameGetterConverter;
import org.objectweb.jorm.naming.api.PNameManager;
import org.objectweb.jorm.naming.lib.BasicPNamingContext;
import org.objectweb.jorm.naming.lib.SimplePNGConverter;
import org.objectweb.jorm.type.api.PType;

public abstract class AbstractInheritKeyFilteredPNamingContext
extends BasicPNamingContext
implements KeyFilteredNamingContext {
    protected PType expressionType;
    protected PNameGetterConverter pngConverter;
    protected Map key2binder = new HashMap();
    protected int codingType;
    protected Object nullValue;
    protected PName nullPName;

    public AbstractInheritKeyFilteredPNamingContext() {
    }

    public AbstractInheritKeyFilteredPNamingContext(PType expressionType, int codingType) throws PException {
        this();
        this.setExpressionType(expressionType);
        this.setCodingType(codingType);
    }

    public void init() throws PException {
        this.checkNullValue();
    }

    public void setCodingType(int codingType) {
        this.codingType = codingType;
        this.pngConverter = this.codingType != 524288 ? new SimplePNGConverter() : null;
    }

    public boolean isNull(Object png, Object ctx) throws PException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportClass(PBinder binder, Object key) throws PException {
        Map map = this.key2binder;
        synchronized (map) {
            PBinder oldbinder = this.key2binder.put(key, binder);
            if (oldbinder != null && oldbinder != binder) {
                this.key2binder.put(key, oldbinder);
                throw new PException("Another persistent class is alread exported with the same key: " + oldbinder.getBinderClassMapping().getClassName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unexportClass(Object key) throws PException {
        Map map = this.key2binder;
        synchronized (map) {
            Object oldbinder = this.key2binder.remove(key);
            if (oldbinder == null) {
                throw new PException("No persistent class to unexport with the key: " + key);
            }
        }
    }

    public PBinder lookup(Object key) {
        return (PBinder)this.key2binder.get(key);
    }

    public Map entries() {
        return Collections.unmodifiableMap(this.key2binder);
    }

    public void setExpressionType(PType type) {
        this.expressionType = type;
    }

    public PType getExpressionType() {
        return this.expressionType;
    }

    public abstract Object evaluate(Object var1, Object var2) throws PException;

    public PName resolve(Object conn, PName pn) throws PException {
        return pn;
    }

    public PName export(Object conn, Object infoitem) throws PException {
        if (infoitem instanceof PName) {
            return (PName)infoitem;
        }
        throw new PException("Operation not supported by this PNamingContext");
    }

    public PName export(Object conn, Object infoitem, Object hints) throws PException {
        throw new PException("Operation not supported by this PNamingContext");
    }

    public void unexport(Object conn, PName pn) throws PException {
        throw new PException("Operation not supported by this PNamingContext");
    }

    public void unexport(Object conn, PName pn, Object hints) throws PException {
        throw new PException("Operation not supported by this PNamingContext");
    }

    public boolean codingSupported(int codingtype) {
        return codingtype == this.codingType || codingtype == 1024;
    }

    public PName decodeAbstract(Object en, Object context) throws PExceptionNaming, UnsupportedOperationException {
        Object key;
        try {
            if (this.isNull(en, context)) {
                return this.nullPName;
            }
            key = this.evaluate(en, context);
        }
        catch (PExceptionNaming e) {
            throw e;
        }
        catch (PException e) {
            throw new PExceptionNaming(e);
        }
        PBinder binder = (PBinder)this.key2binder.get(key);
        if (binder == null) {
            throw new PExceptionNaming("No");
        }
        return binder.decodeAbstract(en, context);
    }

    public PName decodeByte(byte en) throws PExceptionNaming, UnsupportedOperationException {
        Object key;
        if (this.codingType != 1) {
            throw new PExceptionNaming("Bad coder type: " + this.codingType);
        }
        if ((Byte)this.nullValue == en) {
            return this.getNull();
        }
        try {
            key = this.evaluate(this.pngConverter.convert(en), null);
        }
        catch (PExceptionNaming e) {
            throw e;
        }
        catch (PException e) {
            throw new PExceptionNaming(e);
        }
        PBinder binder = (PBinder)this.key2binder.get(key);
        if (binder == null) {
            throw new PExceptionNaming("No");
        }
        return binder.decodeByte(en);
    }

    public PName decodeObyte(Byte en) throws PExceptionNaming, UnsupportedOperationException {
        Object key;
        if (this.codingType != 32) {
            throw new PExceptionNaming("Bad coder type: " + this.codingType);
        }
        if (this.nullValue == null ? en == null : en != null && ((Byte)this.nullValue).byteValue() == en.byteValue()) {
            return this.getNull();
        }
        try {
            key = this.evaluate(this.pngConverter.convert(en), null);
        }
        catch (PExceptionNaming e) {
            throw e;
        }
        catch (PException e) {
            throw new PExceptionNaming(e);
        }
        PBinder binder = (PBinder)this.key2binder.get(key);
        if (binder == null) {
            throw new PExceptionNaming("No binder associated to the key: " + key);
        }
        return binder.decodeObyte(en);
    }

    public PName decodeChar(char en) throws PExceptionNaming, UnsupportedOperationException {
        Object key;
        if (this.codingType != 2) {
            throw new PExceptionNaming("Bad coder type: " + this.codingType);
        }
        if (((Character)this.nullValue).charValue() == en) {
            return this.getNull();
        }
        try {
            key = this.evaluate(this.pngConverter.convert(en), null);
        }
        catch (PExceptionNaming e) {
            throw e;
        }
        catch (PException e) {
            throw new PExceptionNaming(e);
        }
        PBinder binder = (PBinder)this.key2binder.get(key);
        if (binder == null) {
            throw new PExceptionNaming("No binder associated to the key: " + key);
        }
        return binder.decodeChar(en);
    }

    public PName decodeOchar(Character en) throws PExceptionNaming, UnsupportedOperationException {
        Object key;
        if (this.codingType != 64) {
            throw new PExceptionNaming("Bad coder type: " + this.codingType);
        }
        if (this.nullValue == null ? en == null : en != null && ((Character)this.nullValue).charValue() == en.charValue()) {
            return this.getNull();
        }
        try {
            key = this.evaluate(this.pngConverter.convert(en), null);
        }
        catch (PExceptionNaming e) {
            throw e;
        }
        catch (PException e) {
            throw new PExceptionNaming(e);
        }
        PBinder binder = (PBinder)this.key2binder.get(key);
        if (binder == null) {
            throw new PExceptionNaming("No binder associated to the key: " + key);
        }
        return binder.decodeOchar(en);
    }

    public PName decodeInt(int en) throws PExceptionNaming, UnsupportedOperationException {
        Object key;
        if (this.codingType != 8) {
            throw new PExceptionNaming("Bad coder type: " + this.codingType);
        }
        if ((Integer)this.nullValue == en) {
            return this.getNull();
        }
        try {
            key = this.evaluate(this.pngConverter.convert(en), null);
        }
        catch (PExceptionNaming e) {
            throw e;
        }
        catch (PException e) {
            throw new PExceptionNaming(e);
        }
        PBinder binder = (PBinder)this.key2binder.get(key);
        if (binder == null) {
            throw new PExceptionNaming("No binder associated to the key: " + key);
        }
        return binder.decodeInt(en);
    }

    public PName decodeOint(Integer en) throws PExceptionNaming, UnsupportedOperationException {
        Object key;
        if (this.codingType != 256) {
            throw new PExceptionNaming("Bad coder type: " + this.codingType);
        }
        if (this.nullValue == null ? en == null : en != null && ((Integer)this.nullValue).intValue() == en.intValue()) {
            return this.getNull();
        }
        try {
            key = this.evaluate(this.pngConverter.convert(en), null);
        }
        catch (PExceptionNaming e) {
            throw e;
        }
        catch (PException e) {
            throw new PExceptionNaming(e);
        }
        PBinder binder = (PBinder)this.key2binder.get(key);
        if (binder == null) {
            throw new PExceptionNaming("No binder associated to the key: " + key);
        }
        return binder.decodeOint(en);
    }

    public PName decodeLong(long en) throws PExceptionNaming, UnsupportedOperationException {
        Object key;
        if (this.codingType != 16) {
            throw new PExceptionNaming("Bad coder type: " + this.codingType);
        }
        if ((Long)this.nullValue == en) {
            return this.getNull();
        }
        try {
            key = this.evaluate(this.pngConverter.convert(en), null);
        }
        catch (PExceptionNaming e) {
            throw e;
        }
        catch (PException e) {
            throw new PExceptionNaming(e);
        }
        PBinder binder = (PBinder)this.key2binder.get(key);
        if (binder == null) {
            throw new PExceptionNaming("No binder associated to the key: " + key);
        }
        return binder.decodeLong(en);
    }

    public PName decodeOlong(Long en) throws PExceptionNaming, UnsupportedOperationException {
        Object key;
        if (this.codingType != 512) {
            throw new PExceptionNaming("Bad coder type: " + this.codingType);
        }
        if (this.nullValue == null ? en == null : en != null && ((Long)this.nullValue).longValue() == en.longValue()) {
            return this.getNull();
        }
        try {
            key = this.evaluate(this.pngConverter.convert(en), null);
        }
        catch (PExceptionNaming e) {
            throw e;
        }
        catch (PException e) {
            throw new PExceptionNaming(e);
        }
        PBinder binder = (PBinder)this.key2binder.get(key);
        if (binder == null) {
            throw new PExceptionNaming("No binder associated to the key: " + key);
        }
        return binder.decodeOlong(en);
    }

    public PName decodeShort(short en) throws PExceptionNaming, UnsupportedOperationException {
        Object key;
        if (this.codingType != 4) {
            throw new PExceptionNaming("Bad coder type: " + this.codingType);
        }
        if ((Short)this.nullValue == en) {
            return this.getNull();
        }
        try {
            key = this.evaluate(this.pngConverter.convert(en), null);
        }
        catch (PExceptionNaming e) {
            throw e;
        }
        catch (PException e) {
            throw new PExceptionNaming(e);
        }
        PBinder binder = (PBinder)this.key2binder.get(key);
        if (binder == null) {
            throw new PExceptionNaming("No binder associated to the key: " + key);
        }
        return binder.decodeLong(en);
    }

    public PName decodeOshort(Short en) throws PExceptionNaming, UnsupportedOperationException {
        Object key;
        if (this.codingType != 128) {
            throw new PExceptionNaming("Bad coder type: " + this.codingType);
        }
        if (this.nullValue == null ? en == null : en != null && ((Short)this.nullValue).shortValue() == en.shortValue()) {
            return this.getNull();
        }
        try {
            key = this.evaluate(this.pngConverter.convert(en), null);
        }
        catch (PExceptionNaming e) {
            throw e;
        }
        catch (PException e) {
            throw new PExceptionNaming(e);
        }
        PBinder binder = (PBinder)this.key2binder.get(key);
        if (binder == null) {
            throw new PExceptionNaming("No binder associated to the key: " + key);
        }
        return binder.decodeOshort(en);
    }

    public PName decodeCharArray(char[] en) throws PExceptionNaming {
        Object key;
        if (this.codingType != 4096) {
            throw new PExceptionNaming("Bad coder type: " + this.codingType);
        }
        if (Arrays.equals((char[])this.nullValue, en)) {
            return this.getNull();
        }
        try {
            key = this.evaluate(this.pngConverter.convert(en), null);
        }
        catch (PExceptionNaming e) {
            throw e;
        }
        catch (PException e) {
            throw new PExceptionNaming(e);
        }
        PBinder binder = (PBinder)this.key2binder.get(key);
        if (binder == null) {
            throw new PExceptionNaming("No binder associated to the key: " + key);
        }
        return binder.decodeCharArray(en);
    }

    public PName decode(byte[] en) throws PExceptionNaming {
        Object key;
        if (this.codingType != 8192) {
            throw new PExceptionNaming("Bad coder type: " + this.codingType);
        }
        if (Arrays.equals((byte[])this.nullValue, en)) {
            return this.getNull();
        }
        try {
            key = this.evaluate(this.pngConverter.convert(en), null);
        }
        catch (PExceptionNaming e) {
            throw e;
        }
        catch (PException e) {
            throw new PExceptionNaming(e);
        }
        PBinder binder = (PBinder)this.key2binder.get(key);
        if (binder == null) {
            throw new PExceptionNaming("No binder associated to the key: " + key);
        }
        return binder.decode(en);
    }

    public PName decodeDate(Date en) throws PExceptionNaming {
        Object key;
        if (this.codingType != 2048) {
            throw new PExceptionNaming("Bad coder type: " + this.codingType);
        }
        if (this.nullValue == null ? en == null : en != null && ((Date)this.nullValue).getTime() == en.getTime()) {
            return this.getNull();
        }
        try {
            key = this.evaluate(this.pngConverter.convert(en), null);
        }
        catch (PExceptionNaming e) {
            throw e;
        }
        catch (PException e) {
            throw new PExceptionNaming(e);
        }
        PBinder binder = (PBinder)this.key2binder.get(key);
        if (binder == null) {
            throw new PExceptionNaming("No binder associated to the key: " + key);
        }
        return binder.decodeDate(en);
    }

    public PName decodeBigInteger(BigInteger en) throws PExceptionNaming {
        Object key;
        if (this.codingType != 16384) {
            throw new PExceptionNaming("Bad coder type: " + this.codingType);
        }
        if (this.nullValue == null ? en == null : ((BigInteger)this.nullValue).compareTo(en) == 0) {
            return this.getNull();
        }
        try {
            key = this.evaluate(this.pngConverter.convert(en), null);
        }
        catch (PExceptionNaming e) {
            throw e;
        }
        catch (PException e) {
            throw new PExceptionNaming(e);
        }
        PBinder binder = (PBinder)this.key2binder.get(key);
        if (binder == null) {
            throw new PExceptionNaming("No binder associated to the key: " + key);
        }
        return binder.decodeBigInteger(en);
    }

    public PName decodeBigDecimal(BigDecimal en) throws PExceptionNaming {
        Object key;
        if (this.codingType != 32768) {
            throw new PExceptionNaming("Bad coder type: " + this.codingType);
        }
        if (this.nullValue == null ? en == null : ((BigDecimal)this.nullValue).compareTo(en) == 0) {
            return this.getNull();
        }
        try {
            key = this.evaluate(this.pngConverter.convert(en), null);
        }
        catch (PExceptionNaming e) {
            throw e;
        }
        catch (PException e) {
            throw new PExceptionNaming(e);
        }
        PBinder binder = (PBinder)this.key2binder.get(key);
        if (binder == null) {
            throw new PExceptionNaming("No binder associated to the key: " + key);
        }
        return binder.decodeBigDecimal(en);
    }

    public PName decodeString(String en) throws PExceptionNaming {
        return null;
    }

    public byte encodeByte(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn == null) {
            throw new PExceptionNaming("Impossible to encode null");
        }
        if (pn == this.nullPName || pn.isNull()) {
            return (Byte)this.nullValue;
        }
        PNameManager pnm = pn.getPNameManager();
        if (pnm != this && pnm != null) {
            return pn.getPNameManager().encodeByte(pn);
        }
        throw new PExceptionNaming("This PName should not be encoded in this PNamingContext, pname: " + pn);
    }

    public char encodeChar(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn == null) {
            throw new PExceptionNaming("Impossible to encode null");
        }
        if (pn == this.nullPName || pn.isNull()) {
            return ((Character)this.nullValue).charValue();
        }
        PNameManager pnm = pn.getPNameManager();
        if (pnm != this && pnm != null) {
            return pn.getPNameManager().encodeChar(pn);
        }
        throw new PExceptionNaming("This PName should not be encoded in this PNamingContext, pname: " + pn);
    }

    public int encodeInt(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn == null) {
            throw new PExceptionNaming("Impossible to encode null");
        }
        if (pn == this.nullPName || pn.isNull()) {
            return (Integer)this.nullValue;
        }
        PNameManager pnm = pn.getPNameManager();
        if (pnm != this && pnm != null) {
            return pn.getPNameManager().encodeInt(pn);
        }
        throw new PExceptionNaming("This PName should not be encoded in this PNamingContext, pname: " + pn);
    }

    public long encodeLong(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn == null) {
            throw new PExceptionNaming("Impossible to encode null");
        }
        if (pn == this.nullPName || pn.isNull()) {
            return (Long)this.nullValue;
        }
        PNameManager pnm = pn.getPNameManager();
        if (pnm != this && pnm != null) {
            return pn.getPNameManager().encodeLong(pn);
        }
        throw new PExceptionNaming("This PName should not be encoded in this PNamingContext, pname: " + pn);
    }

    public short encodeShort(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn == null) {
            throw new PExceptionNaming("Impossible to encode null");
        }
        if (pn == this.nullPName || pn.isNull()) {
            return (Short)this.nullValue;
        }
        PNameManager pnm = pn.getPNameManager();
        if (pnm != this && pnm != null) {
            return pn.getPNameManager().encodeShort(pn);
        }
        throw new PExceptionNaming("This PName should not be encoded in this PNamingContext, pname: " + pn);
    }

    public Byte encodeObyte(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn == null) {
            throw new PExceptionNaming("Impossible to encode null");
        }
        if (pn == this.nullPName || pn.isNull()) {
            return (Byte)this.nullValue;
        }
        PNameManager pnm = pn.getPNameManager();
        if (pnm != this && pnm != null) {
            return pn.getPNameManager().encodeObyte(pn);
        }
        throw new PExceptionNaming("This PName should not be encoded in this PNamingContext, pname: " + pn);
    }

    public Character encodeOchar(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn == null) {
            throw new PExceptionNaming("Impossible to encode null");
        }
        if (pn == this.nullPName || pn.isNull()) {
            return (Character)this.nullValue;
        }
        PNameManager pnm = pn.getPNameManager();
        if (pnm != this && pnm != null) {
            return pn.getPNameManager().encodeOchar(pn);
        }
        throw new PExceptionNaming("This PName should not be encoded in this PNamingContext, pname: " + pn);
    }

    public Integer encodeOint(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn == null) {
            throw new PExceptionNaming("Impossible to encode null");
        }
        if (pn == this.nullPName || pn.isNull()) {
            return (Integer)this.nullValue;
        }
        PNameManager pnm = pn.getPNameManager();
        if (pnm != this && pnm != null) {
            return pn.getPNameManager().encodeOint(pn);
        }
        throw new PExceptionNaming("This PName should not be encoded in this PNamingContext, pname: " + pn);
    }

    public Long encodeOlong(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn == null) {
            throw new PExceptionNaming("Impossible to encode null");
        }
        if (pn == this.nullPName || pn.isNull()) {
            return (Long)this.nullValue;
        }
        PNameManager pnm = pn.getPNameManager();
        if (pnm != this && pnm != null) {
            return pn.getPNameManager().encodeOlong(pn);
        }
        throw new PExceptionNaming("This PName should not be encoded in this PNamingContext, pname: " + pn);
    }

    public Short encodeOshort(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn == null) {
            throw new PExceptionNaming("Impossible to encode null");
        }
        if (pn == this.nullPName || pn.isNull()) {
            return (Short)this.nullValue;
        }
        PNameManager pnm = pn.getPNameManager();
        if (pnm != this && pnm != null) {
            return pn.getPNameManager().encodeOshort(pn);
        }
        throw new PExceptionNaming("This PName should not be encoded in this PNamingContext, pname: " + pn);
    }

    public Date encodeDate(PName pn) throws PExceptionNaming {
        if (pn == null) {
            throw new PExceptionNaming("Impossible to encode null");
        }
        if (pn == this.nullPName || pn.isNull()) {
            return (Date)this.nullValue;
        }
        PNameManager pnm = pn.getPNameManager();
        if (pnm != this && pnm != null) {
            return pn.getPNameManager().encodeDate(pn);
        }
        throw new PExceptionNaming("This PName should not be encoded in this PNamingContext, pname: " + pn);
    }

    public BigInteger encodeBigInteger(PName pn) throws PExceptionNaming {
        if (pn == null) {
            throw new PExceptionNaming("Impossible to encode null");
        }
        if (pn == this.nullPName || pn.isNull()) {
            return (BigInteger)this.nullValue;
        }
        PNameManager pnm = pn.getPNameManager();
        if (pnm != this && pnm != null) {
            return pn.getPNameManager().encodeBigInteger(pn);
        }
        throw new PExceptionNaming("This PName should not be encoded in this PNamingContext, pname: " + pn);
    }

    public BigDecimal encodeBigDecimal(PName pn) throws PExceptionNaming {
        if (pn == null) {
            throw new PExceptionNaming("Impossible to encode null");
        }
        if (pn == this.nullPName || pn.isNull()) {
            return (BigDecimal)this.nullValue;
        }
        PNameManager pnm = pn.getPNameManager();
        if (pnm != this && pnm != null) {
            return pn.getPNameManager().encodeBigDecimal(pn);
        }
        throw new PExceptionNaming("This PName should not be encoded in this PNamingContext, pname: " + pn);
    }

    public byte[] encode(PName pn) throws PExceptionNaming {
        if (pn == null) {
            throw new PExceptionNaming("Impossible to encode null");
        }
        if (pn == this.nullPName || pn.isNull()) {
            return (byte[])this.nullValue;
        }
        PNameManager pnm = pn.getPNameManager();
        if (pnm != this && pnm != null) {
            return pn.getPNameManager().encode(pn);
        }
        throw new PExceptionNaming("This PName should not be encoded in this PNamingContext, pname: " + pn);
    }

    public char[] encodeCharArray(PName pn) throws PExceptionNaming {
        if (pn == null) {
            throw new PExceptionNaming("Impossible to encode null");
        }
        if (pn == this.nullPName || pn.isNull()) {
            return (char[])this.nullValue;
        }
        PNameManager pnm = pn.getPNameManager();
        if (pnm != this && pnm != null) {
            return pn.getPNameManager().encodeCharArray(pn);
        }
        throw new PExceptionNaming("This PName should not be encoded in this PNamingContext, pname: " + pn);
    }

    public Object encodeAbstract(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        if (pn == null) {
            throw new PExceptionNaming("Impossible to encode null");
        }
        if (pn == this.nullPName || pn.isNull()) {
            return this.nullPName;
        }
        PNameManager pnm = pn.getPNameManager();
        if (pnm != this && pnm != null) {
            return pn.getPNameManager().encodeAbstract(pn);
        }
        throw new PExceptionNaming("This PName should not be encoded in this PNamingContext, pname: " + pn);
    }

    public String encodeString(PName pn) throws PExceptionNaming {
        if (pn == null) {
            throw new PExceptionNaming("Impossible to encode null");
        }
        if (pn == this.nullValue || pn.isNull()) {
            return (String)this.nullValue;
        }
        PNameManager pnm = pn.getPNameManager();
        if (pnm != this && pnm != null) {
            return pn.getPNameManager().encodeString(pn);
        }
        throw new PExceptionNaming("This PName should not be encoded in this PNamingContext, pname: " + pn);
    }

    public PName getNull() {
        return this.nullPName;
    }

    public void setNullPName(Object o) throws PException {
        if (!(o instanceof PName)) {
            throw new PExceptionNaming("A KFPNC accepts only PName instance as parameter to define the null pname");
        }
        this.nullPName = (PName)o;
    }

    private void checkNullValue() throws PException {
        switch (this.codingType) {
            case 2: {
                this.nullValue = new Character(this.nullPName.encodeChar());
                break;
            }
            case 64: {
                this.nullValue = this.nullPName.encodeOchar();
                break;
            }
            case 1: {
                this.nullValue = new Byte(this.nullPName.encodeByte());
                break;
            }
            case 32: {
                this.nullValue = this.nullPName.encodeObyte();
                break;
            }
            case 4: {
                this.nullValue = new Short(this.nullPName.encodeShort());
                break;
            }
            case 128: {
                this.nullValue = this.nullPName.encodeOshort();
                break;
            }
            case 8: {
                this.nullValue = new Integer(this.nullPName.encodeInt());
                break;
            }
            case 256: {
                this.nullValue = this.nullPName.encodeOint();
                break;
            }
            case 16: {
                this.nullValue = new Long(this.nullPName.encodeLong());
                break;
            }
            case 512: {
                this.nullValue = this.nullPName.encodeOlong();
                break;
            }
            case 1024: {
                this.nullValue = this.nullPName.encodeString();
                break;
            }
            case 2048: {
                this.nullValue = this.nullPName.encodeDate();
                break;
            }
            case 32768: {
                this.nullValue = this.nullPName.encodeBigDecimal();
                break;
            }
            case 16384: {
                this.nullValue = this.nullPName.encodeBigInteger();
                break;
            }
            case 8192: {
                this.nullValue = this.nullPName.encode();
                break;
            }
            case 4096: {
                this.nullValue = this.nullPName.encodeCharArray();
                break;
            }
        }
    }
}

