/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.util.lib;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.DTDLocation;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.compiler.api.JormCompilerConfigurator;
import org.objectweb.jorm.compiler.api.JormCompilerParameter;
import org.objectweb.jorm.compiler.lib.JormCompiler;
import org.objectweb.jorm.compiler.lib.JormCompilerConfiguratorImpl;
import org.objectweb.jorm.compiler.lib.JormCompilerParameterImpl;
import org.objectweb.jorm.util.io.api.PathExplorer;
import org.objectweb.jorm.util.io.lib.DirJavaExplorer;

public class AntJormParser
extends MatchingTask {
    private String jormConfFile = "jorm.properties";
    private File pdDir = null;
    private static final char separator = File.separatorChar;
    private boolean antDtdLocationsSet = false;
    private ArrayList antDtdLocations = new ArrayList();
    private boolean classpathSet = false;
    private PathExplorer classpath = new DirJavaExplorer();
    private boolean antLogConfFileSet = false;
    private String antLogConfFile;
    private String antProjectName;
    private boolean antVerboseSet = false;
    private boolean antVerbose;
    private JormCompilerParameter jcp = new JormCompilerParameterImpl();
    private JormCompilerConfigurator jcc = new JormCompilerConfiguratorImpl();
    private JormCompiler jormcompiler = new JormCompiler(this.jcp, this.jcc);

    public void setPdDir(File d) {
        this.pdDir = d;
        this.classpath.addPath(d.getAbsolutePath());
        System.out.println("pdDir " + this.pdDir.getAbsolutePath());
    }

    public void setOtherPdFiles(Path cp) {
        String[] dl = cp.list();
        for (int i = 0; i < dl.length; ++i) {
            this.classpath.addPath(dl[i]);
            this.classpathSet = true;
        }
    }

    public void setOtherPdFilesRef(Reference r) {
        Path p = new Path(this.getProject());
        p.setRefid(r);
        this.setOtherPdFiles(p);
    }

    public DTDLocation createDTD() {
        DTDLocation dtdLocation = new DTDLocation();
        this.antDtdLocations.add(dtdLocation);
        this.antDtdLocationsSet = true;
        return dtdLocation;
    }

    public void setJormConf(String s) {
        this.jormConfFile = s;
    }

    public void setLogConf(String s) {
        this.antLogConfFile = s;
        this.antLogConfFileSet = true;
    }

    public void setProjectName(String s) {
        this.antProjectName = s;
    }

    public void setVerbose(boolean verbose) {
        this.antVerbose = verbose;
        this.antVerboseSet = true;
    }

    public void initJormCompiler() throws PException {
        try {
            if (this.jormConfFile == null) {
                this.jcc.configure();
            } else {
                this.jcc.configure(this.jormConfFile);
            }
            this.log("jcc.configure() ----------- ok");
            Collection c = this.jcc.getSubMappers("rdb");
            this.log("rdb sub mappers: " + c);
            if (!this.antLogConfFileSet) {
                this.jcc.configureLog(this.jormConfFile);
            } else {
                this.jcc.configureLog(this.antLogConfFile);
            }
            this.log("jcc.configureLog() ----------- ok");
            this.log("jormcOpts file= " + this.jcc.getJormcOptsFile());
            this.jcp.loadConfFile(this.jcc.getGlobalJormcOptsFile(), this.jcc.knownMappers());
            this.log("jcp.loadConfFile ----------- ok");
            this.log("pdDir= " + this.pdDir);
            if (this.antDtdLocationsSet) {
                this.jcp.setDtdLocations(this.antDtdLocations);
            }
            if (this.antProjectName != null) {
                this.jcp.setProjectName(this.antProjectName);
            }
            this.log("jcp.projectName= " + this.jcp.getProjectName());
            ArrayList<String> temp = new ArrayList<String>(Arrays.asList(super.getDirectoryScanner(this.pdDir).getIncludedFiles()));
            String inputFile = null;
            Iterator it = temp.iterator();
            while (it.hasNext()) {
                inputFile = this.pdDir.getAbsolutePath() + separator + (String)it.next();
                this.jcp.getInputFiles().add(inputFile);
                this.log("input file= " + inputFile);
            }
            this.log("jcp.inputFiles ----------- ok");
            if (this.classpathSet) {
                this.jcp.setClasspath(this.classpath);
            } else {
                DirJavaExplorer pe = new DirJavaExplorer();
                pe.setLogger(this.jcc.getLoggerFactory().getLogger("org.objectweb.jorm.io.pathexplorer"));
                this.jcp.setClasspath(pe);
            }
            this.log("jcp.classpath ----------- ok");
            this.jcp.setGeneratedWithMapperPackage(false);
            if (this.antLogConfFileSet) {
                this.jcp.setLogConfFile(this.antLogConfFile);
            }
            if (this.antVerboseSet) {
                this.jcp.setVerbose(this.antVerbose);
            }
        }
        catch (PException e) {
            throw new PException(e, "Impossible to configure the Jorm parser");
        }
    }

    public void execute() throws BuildException {
        try {
            this.initJormCompiler();
            this.jormcompiler.parseFiles(this.jcp.getInputFiles());
            this.log("parseFiles...... done");
        }
        catch (PException e) {
            Exception current = e;
            while (current instanceof PException && current.getNestedException() != null) {
                current = current.getNestedException();
            }
            throw new BuildException(current);
        }
    }
}

