/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Arrays;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.Xid;

public class JavaXidImpl
implements javax.transaction.xa.Xid,
Serializable {
    public static final int JOTM_FORMAT_ID = 47892;
    private static SecureRandom rand = null;
    private final byte internalVersId = 1;
    private static int count = 1;
    private static long uuid0;
    private static long uuid1;
    private static boolean uuidsRecovered;
    private static byte[] gtrid_base;
    private static String host;
    private static String server;
    private String fullString = "";
    private String shortString = "";
    private boolean hashcodevalid = false;
    private int myhashcode;
    static String[] HexDigits;
    private int formatId;
    private int gtrid_length;
    private int bqual_length;
    private byte[] gtrid;
    private byte[] bqual;

    public JavaXidImpl(Xid jotmXid) {
        if (TraceTm.jotm.isDebugEnabled()) {
            TraceTm.jotm.debug("jotmXID= " + jotmXid);
        }
        this.formatId = jotmXid.getFormatId();
        this.gtrid = jotmXid.getGlobalTransactionId();
        this.gtrid_length = this.gtrid.length;
        this.bqual = jotmXid.getBranchQualifier();
        this.bqual_length = this.bqual.length;
    }

    public int getFormatId() {
        return this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this.gtrid;
    }

    public byte[] getBranchQualifier() {
        return this.bqual;
    }

    static final void byteToHex(byte inbyte, StringBuffer str_buff) {
        int myByte = 0xFF & inbyte;
        str_buff.append(HexDigits[myByte]);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean Full) {
        int strlen;
        byte[] gtrid_local = null;
        byte[] bqual_local = null;
        if (Full && this.fullString.length() != 0) {
            return this.fullString;
        }
        if (!Full && this.shortString.length() != 0) {
            return this.shortString;
        }
        StringBuffer str_buff_gtrid = new StringBuffer(128);
        StringBuffer str_buff_bqual = new StringBuffer(128);
        gtrid_local = new byte[64];
        ByteBuffer aa = ByteBuffer.wrap(gtrid_local);
        System.arraycopy(this.gtrid, 0, gtrid_local, 0, this.gtrid_length);
        for (int i = 0; i < this.gtrid_length; ++i) {
            JavaXidImpl.byteToHex(aa.get(), str_buff_gtrid);
        }
        bqual_local = new byte[64];
        ByteBuffer bb = ByteBuffer.wrap(bqual_local);
        if (this.bqual != null) {
            System.arraycopy(this.bqual, 0, bqual_local, 0, this.bqual_length);
            for (int i = 0; i < this.bqual_length; ++i) {
                JavaXidImpl.byteToHex(bb.get(), str_buff_bqual);
            }
        }
        if (this.gtrid_length > 30 && !Full) {
            strlen = str_buff_gtrid.length();
            str_buff_gtrid.replace(strlen / 6, strlen / 6 + 2, "...");
            str_buff_gtrid.delete(strlen / 6 + 3, strlen - 5);
        }
        if (this.bqual_length > 30 && !Full) {
            strlen = str_buff_bqual.length();
            str_buff_bqual.replace(strlen / 6, strlen / 6 + 2, "...");
            str_buff_bqual.delete(strlen / 6 + 3, strlen - 5);
        }
        if (Full) {
            this.fullString = Long.toHexString(this.formatId) + ":" + Long.toHexString(this.gtrid_length) + ":" + Long.toHexString(this.bqual_length) + ":" + str_buff_gtrid.toString() + ":" + str_buff_bqual.toString();
            return this.fullString;
        }
        this.shortString = Long.toHexString(this.formatId) + ":" + Long.toHexString(this.gtrid_length) + ":" + Long.toHexString(this.bqual_length) + ":" + str_buff_gtrid.toString() + ":" + str_buff_bqual.toString();
        return this.shortString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] makeGtrid() {
        long uniqueTimeStamp;
        this.makeGtridBase();
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            uniqueTimeStamp = System.currentTimeMillis() * 1024L + (long)count;
            ++count;
        }
        ByteBuffer bb = ByteBuffer.allocate(gtrid_base.length + 8);
        bb.put(gtrid_base);
        bb.putLong(uniqueTimeStamp);
        return bb.array();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeGtridBase() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (rand == null) {
                rand = new SecureRandom();
                if (!uuidsRecovered) {
                    uuid0 = rand.nextLong();
                    uuid1 = rand.nextLong();
                    byte[] UniqueID = new byte[19];
                    byte[][] UniqueIDRecord = new byte[1][19];
                    String rt1 = "RU1";
                    ByteBuffer rr1 = ByteBuffer.wrap(UniqueID);
                    rr1.put(rt1.getBytes());
                    rr1.putLong(uuid0);
                    rr1.putLong(uuid1);
                    UniqueIDRecord[0] = UniqueID;
                }
                host = "";
                server = "";
                host = (host + "                ").substring(0, 15);
                server = (server + "               ").substring(0, 14);
                gtrid_base = new byte[48];
                ByteBuffer bb = ByteBuffer.wrap(gtrid_base);
                bb.put((byte)1);
                bb.putLong(uuid0);
                bb.putLong(uuid1);
                bb.put(host.getBytes());
                bb.put(server.getBytes());
            }
        }
    }

    public boolean equals(Object obj2) {
        JavaXidImpl xid2 = (JavaXidImpl)obj2;
        return this.formatId == xid2.getFormatId() && Arrays.equals(this.bqual, xid2.getBranchQualifier()) && Arrays.equals(this.gtrid, xid2.getGlobalTransactionId());
    }

    public int hashCode() {
        int hc = 0;
        if (!this.hashcodevalid) {
            int i;
            for (i = 0; i < this.gtrid.length; ++i) {
                hc = hc * 37 + this.gtrid[i];
            }
            for (i = 0; i < this.bqual.length; ++i) {
                hc = hc * 37 + this.bqual[i];
            }
            this.myhashcode = hc;
            this.hashcodevalid = true;
        }
        return this.myhashcode;
    }

    static {
        uuidsRecovered = false;
        gtrid_base = null;
        HexDigits = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "0a", "0b", "0c", "0d", "0e", "0f", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "1a", "1b", "1c", "1d", "1e", "1f", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "2a", "2b", "2c", "2d", "2e", "2f", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "3a", "3b", "3c", "3d", "3e", "3f", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "4a", "4b", "4c", "4d", "4e", "4f", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "5a", "5b", "5c", "5d", "5e", "5f", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "6a", "6b", "6c", "6d", "6e", "6f", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "7a", "7b", "7c", "7d", "7e", "7f", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "8a", "8b", "8c", "8d", "8e", "8f", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99", "9a", "9b", "9c", "9d", "9e", "9f", "a0", "a1", "a2", "a3", "a4", "a5", "a6", "a7", "a8", "a9", "aa", "ab", "ac", "ad", "ae", "af", "b0", "b1", "b2", "b3", "b4", "b5", "b6", "b7", "b8", "b9", "ba", "bb", "bc", "bd", "be", "bf", "c0", "c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8", "c9", "ca", "cb", "cc", "cd", "ce", "cf", "d0", "d1", "d2", "d3", "d4", "d5", "d6", "d7", "d8", "d9", "da", "db", "dc", "dd", "de", "df", "e0", "e1", "e2", "e3", "e4", "e5", "e6", "e7", "e8", "e9", "ea", "eb", "ec", "ed", "ee", "ef", "f0", "f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8", "f9", "fa", "fb", "fc", "fd", "fe", "ff"};
    }
}

