/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.datasource.lib;

import java.util.HashMap;
import org.objectweb.medor.api.DataSourceException;
import org.objectweb.medor.datasource.api.DataStore;
import org.objectweb.medor.datasource.api.Wrapper;
import org.objectweb.medor.datasource.api.WrapperFactory;
import org.objectweb.medor.datasource.lib.TCWrapper;
import org.objectweb.medor.datasource.rdb.lib.JDBCWrapper;

public class MedorWrapperFactory
implements WrapperFactory {
    private HashMap wrapperCache = new HashMap();
    private HashMap dsType2WrapperClass = new HashMap();

    public Wrapper getWrapper(DataStore dl) throws DataSourceException {
        Short type = new Short(dl.getDataStoreType());
        Wrapper w = (Wrapper)this.wrapperCache.get(type);
        if (w == null) {
            switch (dl.getDataStoreType()) {
                case 0: {
                    w = new TCWrapper();
                    break;
                }
                case 1: {
                    w = new JDBCWrapper();
                    break;
                }
                default: {
                    Class wClass = (Class)this.dsType2WrapperClass.get(type);
                    if (wClass == null) {
                        throw new DataSourceException("I don't no wrapping this dataStore type :" + dl);
                    }
                    try {
                        w = (Wrapper)wClass.newInstance();
                        break;
                    }
                    catch (Exception e) {
                        throw new DataSourceException("Impossible to instanciate the Wrapper. Class " + wClass.getName(), e);
                    }
                }
            }
            this.wrapperCache.put(type, w);
        }
        return w;
    }

    public void bindDataStoreToWrapper(short dataStoreType, Class wrapperClass) throws DataSourceException {
        Class o = this.dsType2WrapperClass.put(new Short(dataStoreType), wrapperClass);
        if (o != null) {
            this.dsType2WrapperClass.put(new Short(dataStoreType), o);
            throw new DataSourceException("Another wrapper is already associated to this DataStore type");
        }
    }
}

