/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.eval.lib;

import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.eval.api.BinaryEvaluatedTC;
import org.objectweb.medor.eval.api.NodeEvaluator;
import org.objectweb.medor.eval.lib.BasicBinaryEvalutedTC;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.VariableOperand;
import org.objectweb.medor.expression.lib.BasicVariableOperand;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.tuple.api.Tuple;
import org.objectweb.medor.tuple.api.TupleCollection;
import org.objectweb.medor.tuple.lib.MemoryTuple;

public class CartesianEvaluatedTC
extends BasicBinaryEvalutedTC
implements BinaryEvaluatedTC {
    private QueryNode query;
    private TupleCollection leftTC;
    private TupleCollection rightTC;
    private ParameterOperand[] parameters;
    private Tuple currentBuffer;
    private Tuple leftTuple;
    private Tuple rightTuple;
    private VariableOperand[] operandBuffers;
    private int cursor;
    private int size;
    private int leftTCSize;
    private int rightTCSize;

    public CartesianEvaluatedTC(QueryNode query, NodeEvaluator leftNodeEvaluator, NodeEvaluator rightNodeEvaluator, ParameterOperand[] parameters) throws MedorException {
        this.parameters = parameters;
        this.query = query;
        this.leftTCSize = leftNodeEvaluator.getQueryNode().getTupleStructure().getSize();
        this.rightTCSize = rightNodeEvaluator.getQueryNode().getTupleStructure().getSize();
        this.size = query.getTupleStructure().getSize();
        this.operandBuffers = new BasicVariableOperand[this.size];
        this.currentBuffer = new MemoryTuple(this.operandBuffers);
        this.rightTC = rightNodeEvaluator.fetchData(parameters);
        this.leftTC = leftNodeEvaluator.fetchData(parameters);
        if (this.isEmpty()) {
            this.cursor = -2;
        } else {
            this.init();
        }
    }

    public void close() throws MedorException {
        super.close();
        if (this.leftTC != null) {
            this.leftTC.close();
        }
        if (this.rightTC != null) {
            this.rightTC.close();
        }
    }

    public TupleStructure getMetaData() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        return this.query.getTupleStructure();
    }

    public boolean isLast() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        return this.rightTC.isLast() && this.leftTC.isLast();
    }

    private void init() throws MedorException {
        this.leftTC.first();
        this.rightTC.first();
        this.leftTuple = this.leftTC.getTuple();
        this.rightTuple = this.rightTC.getTuple();
        this.fixeTheLeftResult();
        this.fixeTheRightResult();
        this.cursor = 1;
    }

    public boolean next() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        boolean moved = false;
        if (this.isLast()) {
            moved = false;
        } else {
            moved = true;
            ++this.cursor;
            if (this.rightTC.next()) {
                this.leftTuple = this.leftTC.getTuple();
                this.rightTuple = this.rightTC.getTuple();
                this.fixeTheRightResult();
            } else if (this.leftTC.next()) {
                this.rightTC.first();
                this.rightTuple = this.rightTC.getTuple();
                this.leftTuple = this.leftTC.getTuple();
                this.fixeTheLeftResult();
                this.fixeTheRightResult();
            }
        }
        return moved;
    }

    public void first() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.init();
    }

    public int getRow() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        return this.cursor;
    }

    public Tuple getTuple() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        if (!this.isEmpty() && this.getRow() >= 1) {
            return this.currentBuffer;
        }
        throw new MedorException(" No elements fetched in this TupleCollection  " + this.getRow());
    }

    public synchronized Tuple getTuple(int numTuple) throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        return this.getTuple();
    }

    public boolean isEmpty() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        return this.leftTC.isEmpty() && this.rightTC.isEmpty();
    }

    public boolean row(int numTuple) throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        this.first();
        int cpt = 1;
        boolean go = true;
        while (cpt <= numTuple && cpt > 1 && go) {
            if (this.next()) continue;
            go = false;
        }
        if (!go) {
            return false;
        }
        this.cursor = numTuple;
        return true;
    }

    private void fixeTheLeftResult() throws MedorException {
        for (int cpt = 0; cpt < this.leftTCSize; ++cpt) {
            this.operandBuffers[cpt] = (VariableOperand)this.leftTuple.getLikeOperand(cpt + 1);
        }
    }

    private void fixeTheRightResult() throws MedorException {
        for (int cpt = this.leftTCSize; cpt < this.size; ++cpt) {
            this.operandBuffers[cpt] = (VariableOperand)this.rightTuple.getLikeOperand(cpt - this.leftTCSize + 1);
        }
    }

    public int getLeftTCCursor() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        return this.leftTC.getRow();
    }

    public int getRightTCCursor() throws MedorException {
        if (this.closed) {
            throw new MedorException("Impossible to use a closed TupleCollection");
        }
        return this.rightTC.getRow();
    }
}

