/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.eval.lib;

import java.util.LinkedList;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.eval.api.BinaryEvaluatedTC;
import org.objectweb.medor.eval.api.EvaluationMetaData;
import org.objectweb.medor.eval.api.NodeEvaluator;
import org.objectweb.medor.eval.lib.BasicBinaryEvalutedTC;
import org.objectweb.medor.eval.lib.UnaryIteratifNodeEvaluator;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.VariableOperand;
import org.objectweb.medor.expression.lib.And;
import org.objectweb.medor.expression.lib.BasicVariableOperand;
import org.objectweb.medor.expression.lib.Equal;
import org.objectweb.medor.filter.api.ExpressionHelper;
import org.objectweb.medor.filter.lib.BasicFieldOperand;
import org.objectweb.medor.filter.postfix.PostfixExpressionHelper;
import org.objectweb.medor.query.api.NestQueryNode;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.lib.SelectProject;
import org.objectweb.medor.tuple.api.Tuple;
import org.objectweb.medor.tuple.api.TupleCollection;
import org.objectweb.medor.tuple.lib.MemoryTuple;

public class NestEvaluatedTC
extends BasicBinaryEvalutedTC
implements BinaryEvaluatedTC {
    private NestQueryNode nestedQueryTree;
    private QueryNode query1;
    private QueryNode query2;
    private Expression groupByFilter1;
    private Expression groupByFilter2;
    private int cursor;
    private int tcResultSize;
    private boolean isTheLast;
    private boolean nextEvaluatorIsFree;
    private LinkedList visitedGroup;
    private ExpressionHelper expressionHeleper;
    private NodeEvaluator subNodeEvaluator;
    private NodeEvaluator nodeEvaluator1;
    private NodeEvaluator nodeEvaluator2;
    private MemoryTuple tupleBuffer1;
    private MemoryTuple tupleBuffer2;
    private VariableOperand[] operandBuffer1;
    private VariableOperand[] operandBuffer2;
    private TupleCollection nestedTupleCollection;
    private Field[] groupByFields;
    private EvaluationMetaData evaluationMetaData;

    public NestEvaluatedTC(NestQueryNode query, NodeEvaluator subNodeEvaluator, ParameterOperand[] parameters, EvaluationMetaData evaluationMetaData) throws MedorException {
        int cpt;
        this.nestedQueryTree = query;
        this.subNodeEvaluator = subNodeEvaluator;
        this.evaluationMetaData = evaluationMetaData;
        this.visitedGroup = new LinkedList();
        this.nestedTupleCollection = subNodeEvaluator.fetchData(parameters);
        this.groupByFields = query.getNestingFields();
        this.tcResultSize = this.groupByFields.length;
        int sizeOfFilter = (this.groupByFields.length - 1) * 4 + 3;
        Expression[] filterExpression = new Expression[sizeOfFilter];
        Expression[] filterExpressionClone = new Expression[sizeOfFilter];
        int filterIndex = 0;
        for (cpt = 0; cpt < this.groupByFields.length; ++cpt) {
            BasicFieldOperand fop = new BasicFieldOperand(this.groupByFields[cpt]);
            if (filterIndex == 0) {
                filterExpression[0] = fop;
                filterExpressionClone[0] = fop;
                filterExpression[2] = new Equal();
                filterExpressionClone[2] = new Equal();
                filterIndex = 2;
                continue;
            }
            filterExpression[++filterIndex] = fop;
            filterExpressionClone[++filterIndex] = fop;
            filterExpression[filterIndex += 2] = new Equal();
            filterExpressionClone[filterIndex] = new Equal();
            filterExpression[++filterIndex] = new And();
            filterExpressionClone[++filterIndex] = new And();
        }
        this.expressionHeleper = new PostfixExpressionHelper();
        try {
            this.groupByFilter1 = this.expressionHeleper.join(filterExpression);
            this.groupByFilter2 = this.expressionHeleper.join(filterExpressionClone);
        }
        catch (ExpressionException e) {
            throw new MedorException(e);
        }
        this.operandBuffer1 = new VariableOperand[this.tcResultSize];
        this.operandBuffer2 = new VariableOperand[this.tcResultSize];
        for (cpt = 0; cpt < this.nestedQueryTree.getTupleStructure().getSize(); ++cpt) {
            this.operandBuffer1[cpt] = new BasicVariableOperand(this.nestedQueryTree.getTupleStructure().getField(cpt + 1).getType());
            this.operandBuffer2[cpt] = new BasicVariableOperand(this.nestedQueryTree.getTupleStructure().getField(cpt + 1).getType());
        }
        this.tupleBuffer1 = new MemoryTuple(this.operandBuffer1);
        this.tupleBuffer2 = new MemoryTuple(this.operandBuffer2);
        this.init();
    }

    public void close() throws MedorException {
        super.close();
        if (this.nestedTupleCollection != null) {
            this.nestedTupleCollection.close();
        }
    }

    private void changeGroupByFilter(Expression filter, Operand[] values) throws ExpressionException {
        Expression[] exp = this.expressionHeleper.toStack(filter);
        exp[1] = values[0];
        int rg = 4;
        for (int i = 1; i < values.length - 1; ++i) {
            exp[rg] = values[i];
            rg += 4;
        }
    }

    private boolean prepareNextNotVisitedGroupIn(VariableOperand[] dest) throws MedorException, ExpressionException {
        Tuple tuple = null;
        boolean stop = false;
        while (!stop && this.nestedTupleCollection.next()) {
            if (this.visitedGroup.contains(new Integer(this.nestedTupleCollection.getRow()))) continue;
            this.visitedGroup.add(new Integer(this.nestedTupleCollection.getRow()));
            stop = true;
            tuple = this.nestedTupleCollection.getTuple();
        }
        if (stop) {
            this.nestedQueryTree.getTupleLoader().loadTuple(tuple, dest, null);
            return true;
        }
        return false;
    }

    private void init() throws MedorException {
        this.cursor = 1;
        this.nextEvaluatorIsFree = false;
        try {
            this.nestedQueryTree.getTupleLoader().loadTuple(this.nestedTupleCollection.getTuple(), this.operandBuffer1, null);
            this.visitedGroup.add(new Integer(1));
            this.changeGroupByFilter(this.groupByFilter1, this.operandBuffer1);
            this.query1 = new SelectProject(this.groupByFilter1, "");
            Field[] nestedFields1 = this.nestedQueryTree.getNestedField().getFields();
            for (int i1 = 0; i1 < nestedFields1.length; ++i1) {
                this.query1.addPropagatedField(nestedFields1[i1].getName(), nestedFields1[i1].getType(), new QueryTreeField[]{(QueryTreeField)nestedFields1[i1]});
            }
            this.nodeEvaluator1 = new UnaryIteratifNodeEvaluator(this.query1, this.subNodeEvaluator, this.evaluationMetaData);
            TupleCollection tctemp = this.nodeEvaluator1.fetchData(null);
            BinaryEvaluatedTC itc = (BinaryEvaluatedTC)tctemp;
            do {
                this.visitedGroup.add(new Integer(itc.getRightTCCursor()));
            } while (tctemp.next());
            tctemp.first();
            this.operandBuffer1[this.tcResultSize - 1].setValue(tctemp);
            if (!this.prepareNextNotVisitedGroupIn(this.operandBuffer2)) {
                this.isTheLast = true;
            } else {
                this.changeGroupByFilter(this.groupByFilter2, this.operandBuffer2);
                this.query2 = new SelectProject(this.groupByFilter1, "");
                Field[] nestedFields2 = this.nestedQueryTree.getNestedField().getFields();
                for (int i2 = 0; i2 < nestedFields2.length; ++i2) {
                    this.query2.addPropagatedField(nestedFields2[i2].getName(), nestedFields2[i2].getType(), new QueryTreeField[]{(QueryTreeField)nestedFields2[i2]});
                }
                this.nodeEvaluator2 = new UnaryIteratifNodeEvaluator(this.query1, this.subNodeEvaluator, this.evaluationMetaData);
                TupleCollection tctemp1 = this.nodeEvaluator2.fetchData(null);
                BinaryEvaluatedTC itc1 = (BinaryEvaluatedTC)tctemp1;
                this.visitedGroup.add(new Integer(this.nestedTupleCollection.getRow()));
                do {
                    this.visitedGroup.add(new Integer(itc1.getRightTCCursor()));
                } while (tctemp1.next());
                tctemp1.first();
                this.operandBuffer2[this.tcResultSize - 1].setValue(tctemp1);
            }
        }
        catch (MedorException e) {
            throw e;
        }
        catch (ExpressionException e) {
            throw new MedorException(e);
        }
    }

    public TupleStructure getMetaData() throws MedorException {
        return this.nestedQueryTree.getTupleStructure();
    }

    public boolean isLast() throws MedorException {
        return this.isTheLast;
    }

    public boolean next() throws MedorException {
        boolean deplacer = false;
        if (this.isEmpty() || this.cursor == -2) {
            deplacer = false;
        } else if (this.isLast()) {
            this.tupleBuffer1 = null;
            this.tupleBuffer2 = null;
            this.cursor = -2;
            deplacer = false;
        } else {
            deplacer = true;
            ++this.cursor;
            BinaryEvaluatedTC itc = null;
            TupleCollection tctemp = null;
            try {
                if (this.nextEvaluatorIsFree) {
                    if (!this.prepareNextNotVisitedGroupIn(this.operandBuffer2)) {
                        this.isTheLast = true;
                        this.nextEvaluatorIsFree = false;
                    } else {
                        this.changeGroupByFilter(this.groupByFilter2, this.operandBuffer2);
                        tctemp = this.nodeEvaluator2.fetchData(null);
                        itc = (BinaryEvaluatedTC)tctemp;
                        this.visitedGroup.add(new Integer(this.nestedTupleCollection.getRow()));
                        do {
                            this.visitedGroup.add(new Integer(itc.getRightTCCursor()));
                        } while (tctemp.next());
                        tctemp.first();
                        this.operandBuffer2[this.tcResultSize - 1].setValue(tctemp);
                        this.nextEvaluatorIsFree = false;
                    }
                } else if (!this.prepareNextNotVisitedGroupIn(this.operandBuffer1)) {
                    this.isTheLast = true;
                    this.nextEvaluatorIsFree = true;
                } else {
                    this.changeGroupByFilter(this.groupByFilter1, this.operandBuffer1);
                    tctemp = this.nodeEvaluator1.fetchData(null);
                    itc = (BinaryEvaluatedTC)tctemp;
                    this.visitedGroup.add(new Integer(this.nestedTupleCollection.getRow()));
                    do {
                        this.visitedGroup.add(new Integer(itc.getRightTCCursor()));
                    } while (tctemp.next());
                    tctemp.first();
                    this.operandBuffer1[this.tcResultSize - 1].setValue(tctemp);
                    this.nextEvaluatorIsFree = true;
                }
            }
            catch (MedorException e) {
                throw e;
            }
            catch (ExpressionException e) {
                throw new MedorException(e);
            }
        }
        return deplacer;
    }

    public void first() throws MedorException {
        this.init();
    }

    public int getRow() throws MedorException {
        return this.cursor;
    }

    public boolean isEmpty() throws MedorException {
        return this.nestedTupleCollection.isEmpty();
    }

    public Tuple getTuple() throws MedorException {
        if (!this.isEmpty() && this.getRow() >= 1) {
            if (this.nextEvaluatorIsFree) {
                return this.tupleBuffer2;
            }
            return this.tupleBuffer1;
        }
        throw new MedorException(" No elements fetched in this TupleCollection  " + this.getRow());
    }

    public synchronized Tuple getTuple(int numTuple) throws MedorException {
        return this.getTuple();
    }

    public TupleCollection getGroupByTupleCollection() throws MedorException {
        if (!this.isEmpty() && this.getRow() >= 1) {
            TupleCollection otemp;
            TupleCollection tc = otemp = this.tupleBuffer1.getTupleCollection(this.tcResultSize);
            return tc;
        }
        throw new MedorException(" No elements fetched in this TupleCollection  " + this.getRow());
    }

    public boolean row(int numTuple) throws MedorException {
        this.first();
        int cpt = 1;
        boolean go = true;
        while (cpt <= numTuple && cpt > 1 && go) {
            if (this.next()) continue;
            go = false;
        }
        if (!go) {
            return false;
        }
        this.cursor = numTuple;
        return true;
    }

    public int getLeftTCCursor() throws MedorException {
        return this.nestedTupleCollection.getRow();
    }

    public int getRightTCCursor() throws MedorException {
        return -1;
    }
}

