/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.eval.lib;

import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.eval.api.NodeEvaluator;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.VariableOperand;
import org.objectweb.medor.query.api.NestedField;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.UnnestQueryNode;
import org.objectweb.medor.tuple.api.Tuple;
import org.objectweb.medor.tuple.api.TupleCollection;
import org.objectweb.medor.tuple.lib.MemoryTuple;

public class UnnestEvaluatedTC
implements TupleCollection {
    private TupleStructure tcStructure;
    private ParameterOperand[] parameters;
    private int sizeOfResult;
    private int sizeOfNotUnnestedFields;
    private int nestedFieldRank;
    private NestedField unnestField;
    private VariableOperand[] currentAttBuffers;
    private Tuple nestedCurrentTuple;
    private Tuple currentBuffer;
    private TupleCollection nestedFieldTC;
    private TupleCollection unnestedTupleCollection;
    private int cursor;
    private int[] indexes;
    private boolean closed = false;

    public UnnestEvaluatedTC(UnnestQueryNode unnestQueryTree, NodeEvaluator subNodeEvaluator, ParameterOperand[] parameters) throws MedorException {
        this.tcStructure = unnestQueryTree.getTupleStructure();
        this.parameters = parameters;
        this.unnestField = unnestQueryTree.getUnnestedField();
        this.unnestedTupleCollection = subNodeEvaluator.fetchData(parameters);
        this.sizeOfResult = unnestQueryTree.getTupleStructure().getSize();
        this.sizeOfNotUnnestedFields = unnestQueryTree.getProjectedFields().length;
        this.indexes = new int[this.sizeOfNotUnnestedFields];
        QueryTree[] childs = unnestQueryTree.getChildren();
        PropagatedField[] notNestedFields = unnestQueryTree.getProjectedFields();
        for (int cpt = 0; cpt < this.sizeOfNotUnnestedFields; ++cpt) {
            this.indexes[cpt] = childs[0].getTupleStructure().getFieldRank(notNestedFields[cpt].getPreviousFields()[0]);
        }
        this.nestedFieldRank = childs[0].getTupleStructure().getFieldRank(this.unnestField);
        this.currentAttBuffers = new VariableOperand[this.sizeOfResult];
        this.currentBuffer = new MemoryTuple(this.currentAttBuffers);
        this.init();
    }

    private void init() throws MedorException {
        this.cursor = 1;
        if (!this.isEmpty()) {
            int cpt;
            this.nestedCurrentTuple = this.unnestedTupleCollection.getTuple();
            this.nestedFieldTC = this.nestedCurrentTuple.getTupleCollection(this.indexes[this.nestedFieldRank]);
            for (cpt = 0; cpt < this.sizeOfNotUnnestedFields; ++cpt) {
                this.currentAttBuffers[cpt] = (VariableOperand)this.nestedCurrentTuple.getLikeOperand(this.indexes[cpt]);
            }
            if (!this.nestedFieldTC.isEmpty()) {
                for (cpt = this.sizeOfNotUnnestedFields; cpt < this.sizeOfResult; ++cpt) {
                    this.currentAttBuffers[cpt] = (VariableOperand)this.nestedFieldTC.getTuple().getLikeOperand(cpt - this.sizeOfNotUnnestedFields + 1);
                }
            }
        }
    }

    public void close() throws MedorException {
        this.closed = true;
        if (this.nestedFieldTC != null) {
            this.nestedFieldTC.close();
        }
        if (this.unnestedTupleCollection != null) {
            this.unnestedTupleCollection.close();
        }
    }

    public TupleStructure getMetaData() throws MedorException {
        return this.tcStructure;
    }

    public boolean isLast() throws MedorException {
        return this.unnestedTupleCollection.isLast() && this.nestedFieldTC.isLast();
    }

    public boolean next() throws MedorException {
        if (this.nestedFieldTC.next()) {
            for (int cpt = this.sizeOfNotUnnestedFields; cpt < this.sizeOfResult; ++cpt) {
                this.currentAttBuffers[cpt] = (VariableOperand)this.nestedFieldTC.getTuple().getLikeOperand(cpt - this.sizeOfNotUnnestedFields + 1);
            }
            ++this.cursor;
            return true;
        }
        if (this.unnestedTupleCollection.next()) {
            int cpt;
            this.nestedCurrentTuple = this.unnestedTupleCollection.getTuple();
            this.nestedFieldTC = this.nestedCurrentTuple.getTupleCollection(this.nestedFieldRank);
            for (cpt = 0; cpt < this.sizeOfNotUnnestedFields; ++cpt) {
                this.currentAttBuffers[cpt] = (VariableOperand)this.nestedCurrentTuple.getLikeOperand(this.indexes[cpt]);
            }
            if (!this.nestedFieldTC.isEmpty()) {
                for (cpt = this.sizeOfNotUnnestedFields; cpt < this.sizeOfResult; ++cpt) {
                    this.currentAttBuffers[cpt] = (VariableOperand)this.nestedFieldTC.getTuple().getLikeOperand(cpt - this.sizeOfNotUnnestedFields + 1);
                }
            }
            ++this.cursor;
            return true;
        }
        return false;
    }

    public void first() throws MedorException {
        this.init();
    }

    public int getRow() throws MedorException {
        return this.cursor;
    }

    public Tuple getTuple() throws MedorException {
        return this.currentBuffer;
    }

    public synchronized Tuple getTuple(int numTuple) throws MedorException {
        return this.getTuple();
    }

    public boolean row(int row) throws MedorException {
        return false;
    }

    public int card() throws MedorException {
        return 0;
    }

    public boolean isEmpty() throws MedorException {
        return this.unnestedTupleCollection.isEmpty();
    }
}

