/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.filter.jorm.lib;

import java.util.ArrayList;
import java.util.Map;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassRef;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.Reference;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.api.Operand;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.TypingException;
import org.objectweb.medor.expression.lib.BasicBinaryOperator;
import org.objectweb.medor.expression.lib.BasicOperand;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.jorm.lib.PNameField;

public class NavigatorOperator
extends BasicBinaryOperator {
    protected boolean isPName;
    private MetaObject jormMO;
    private FieldOperand myFop;

    public NavigatorOperator(FieldOperand fop, String att) throws MedorException {
        super(fop, new BasicOperand(att));
        this.myFop = fop;
        Field f = fop.getField();
        if (f instanceof PropagatedField) {
            Field[] fs = ((PropagatedField)f).getOriginFields();
            f = fs[0];
        }
        if (!(f instanceof PNameField)) {
            throw new MedorException("Impossible to create a NavigatorOperator without PNameField as begin of expression: " + f);
        }
        PNameField pnf = (PNameField)f;
        if (pnf.isClassPName()) {
            if (pnf.isInGenClass()) {
                throw new MedorException("Impossible to navigate with a GenClass: pnf=" + pnf.getName() + " /  attribut=" + att);
            }
            this.jormMO = this.getTypedElement(pnf.getMetaObjectClass(), att);
            this.type = ((TypedElement)this.jormMO).getType();
        } else {
            this.jormMO = pnf.getReference();
            if (this.jormMO instanceof ClassRef) {
                this.jormMO = this.getTypedElement(((ClassRef)this.jormMO).getMOClass(), att);
                this.type = ((TypedElement)this.jormMO).getType();
            } else if (this.jormMO instanceof GenClassRef) {
                this.type = ((GenClassRef)this.jormMO).getType();
            }
        }
        if (this.jormMO == null) {
            throw new MedorException("No field " + att + " found");
        }
        this.isPName = this.jormMO instanceof Reference;
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        ((NavigatorOperator)clone).isPName = this.isPName;
        ((NavigatorOperator)clone).jormMO = this.jormMO;
        return clone;
    }

    public NavigatorOperator(NavigatorOperator nop, String att) throws MedorException {
        super(nop, new BasicOperand(att));
        if (!nop.isPName()) {
            throw new MedorException("The specified Navigator operand is not a PName");
        }
        this.myFop = nop.getFieldOperand();
        this.jormMO = nop.getMetaObject();
        if (this.jormMO instanceof ClassRef) {
            this.jormMO = ((ClassRef)this.jormMO).getMOClass().getTypedElement(att);
            this.type = ((TypedElement)this.jormMO).getType();
        } else if (this.jormMO instanceof GenClassRef) {
            throw new MedorException("Impossible to navigate with a GenClass: pnf=" + nop + " /  attribut=" + att);
        }
        if (this.jormMO == null) {
            throw new MedorException("No field " + att + " found");
        }
        this.isPName = this.jormMO instanceof Reference;
    }

    public boolean isPName() {
        return this.isPName;
    }

    public FieldOperand getFieldOperand() {
        return this.myFop;
    }

    public ArrayList getPath() throws MedorException {
        ArrayList theList = new ArrayList();
        return this.getPath(theList);
    }

    public ArrayList getPath(ArrayList theList) throws MedorException {
        Expression e = this.getExpression(0);
        if (!(e instanceof FieldOperand)) {
            theList = ((NavigatorOperator)e).getPath(theList);
        }
        try {
            theList.add(((Operand)this.getExpression(1)).getString());
        }
        catch (TypingException exc) {
            throw new MedorException(exc);
        }
        return theList;
    }

    public MetaObject getMetaObject() {
        return this.jormMO;
    }

    public String getOperatorString() {
        return ".";
    }

    public Operand evaluate(ParameterOperand[] pos, Object o) throws ExpressionException {
        throw new ExpressionException("This operator is not evaluable, and must be transformed into JoinProjects instance during the optimization step.");
    }

    public Operand compileExpression() throws MalformedExpressionException {
        throw new MalformedExpressionException("This operator is not evaluable, and must be transform edinto JoinProjects instance during the optimization step.");
    }

    private TypedElement getTypedElement(Class clazz, String fn) {
        int idx = fn.length();
        TypedElement te = null;
        te = clazz.getTypedElement(fn);
        while ((idx = fn.lastIndexOf(".", idx)) != -1 && te == null) {
            te = clazz.getTypedElement(fn.substring(idx + 1, fn.length()));
            --idx;
        }
        return te;
    }
}

