/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.jorm;

import java.util.ArrayList;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.UnaryOperator;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.filter.lib.ExpressionPrinter;
import org.objectweb.medor.optim.api.RewriteRule;
import org.objectweb.medor.optim.jorm.JormFlatten2Rdb;
import org.objectweb.medor.optim.jorm.JormRule;
import org.objectweb.medor.optim.lib.DropUnusedProjFieldsRule;
import org.objectweb.medor.query.api.CalculatedField;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.lib.Nest;
import org.objectweb.medor.query.lib.QueryTreePrinter;
import org.objectweb.medor.query.rdb.lib.AggregateRdbQueryNode;
import org.objectweb.medor.query.rdb.lib.BasicRdbExpQueryLeaf;
import org.objectweb.util.monolog.api.BasicLevel;

public class Jorm2Rdb
extends JormRule {
    private RewriteRule jormRule = new JormFlatten2Rdb();

    public Jorm2Rdb() {
        super("Jorm2Rdb");
    }

    public QueryTree rewrite(QueryTree qt, QueryNode parent) throws MedorException {
        this.log.log(BasicLevel.DEBUG, (Object)"Jorm2Rdb: Input query tree:");
        QueryTreePrinter.printQueryTree(qt, this.log, BasicLevel.DEBUG);
        if (qt instanceof Nest) {
            QueryTree qtInter = this.jormRule.rewrite(((QueryNode)qt).getChildren()[0], (QueryNode)qt);
            this.log.log(BasicLevel.DEBUG, (Object)"Jorm2Rdb: intermediate query tree:");
            QueryTreePrinter.printQueryTree(qtInter, this.log);
            DropUnusedProjFieldsRule dropProj = new DropUnusedProjFieldsRule();
            QueryTree qt2 = dropProj.rewrite(qt, parent);
            this.log.log(BasicLevel.DEBUG, (Object)"Jorm2Rdb: intermediate query tree after dropping unused projections:");
            QueryTreePrinter.printQueryTree(qt2, this.log);
            qt = qt2;
            if (qtInter instanceof QueryNode && !(qtInter instanceof Nest) && this.noCalculatedField((QueryNode)qtInter)) {
                Field[] fs = qtInter.getTupleStructure().getFields();
                for (int i = 0; i < fs.length; ++i) {
                    if (!(fs[i] instanceof PropagatedField)) continue;
                    this.log.log(BasicLevel.DEBUG, (Object)("PropagatedField " + ((PropagatedField)fs[i]).getPreviousFields()[0]));
                    QueryTreeField qtf = (QueryTreeField)((PropagatedField)fs[i]).getPreviousFields()[0];
                    this.log.log(BasicLevel.DEBUG, (Object)("PF name " + qtf.getName()));
                }
                this.log.log(BasicLevel.DEBUG, (Object)("NestedField " + ((Nest)qt).getNestedField()));
                Field[] tmpQT = ((Nest)qt).getNestedField().getFields();
                ArrayList<Field> tmpQT2 = new ArrayList<Field>();
                for (int jj = 0; jj < tmpQT.length; ++jj) {
                    this.log.log(BasicLevel.DEBUG, (Object)("containing " + tmpQT[jj] + " " + tmpQT[jj].getName() + " (" + (QueryTreeField)((PropagatedField)tmpQT[jj]).getPreviousFields()[0] + ") of node " + ((QueryTreeField)((PropagatedField)tmpQT[jj]).getPreviousFields()[0]).getQueryTree()));
                    if (tmpQT2.contains(((PropagatedField)tmpQT[jj]).getPreviousFields()[0])) continue;
                    tmpQT2.add(((PropagatedField)tmpQT[jj]).getPreviousFields()[0]);
                }
                BasicRdbExpQueryLeaf theLeaf = (BasicRdbExpQueryLeaf)((QueryNode)qtInter).getChildren()[0];
                AggregateRdbQueryNode qtNew = new AggregateRdbQueryNode(tmpQT2.toArray(new QueryTreeField[0]), ((Nest)qt).getNestedField().getName(), this.replaceGroupByFields((Nest)qt), theLeaf, theLeaf.getDataStore(), qt.getName());
                qtNew.setDistinct(qtInter.getDistinct());
                Field[] otherFields = qt.getTupleStructure().getFields();
                for (int fl = 0; fl < otherFields.length; ++fl) {
                    this.log.log(BasicLevel.DEBUG, (Object)("Handling other field " + otherFields[fl]));
                    if (otherFields[fl] instanceof CalculatedField) {
                        CalculatedField cf = (CalculatedField)otherFields[fl];
                        this.replaceAggregatedField(cf.getExpression());
                        qtNew.addCalculatedField(cf.getName().substring(cf.getName().indexOf(qt.getName()) + qt.getName().length() + 1), cf.getType(), cf.getExpression());
                        this.log.log(BasicLevel.DEBUG, (Object)("Adding CalculatedField " + cf + " (" + ExpressionPrinter.e2str(cf.getExpression()) + ")"));
                        continue;
                    }
                    if (otherFields[fl] instanceof PropagatedField) {
                        this.log.log(BasicLevel.DEBUG, (Object)("Adding PropagatedField from " + otherFields[fl]));
                        QueryTreeField previousField = (QueryTreeField)((PropagatedField)((PropagatedField)otherFields[fl]).getPreviousFields()[0]).getPreviousFields()[0];
                        this.log.log(BasicLevel.DEBUG, (Object)("Previous field is " + previousField + " of node " + previousField.getQueryTree()));
                        qtNew.addPropagatedField(previousField.getName(), previousField.getType(), new QueryTreeField[]{previousField});
                        continue;
                    }
                    this.log.log(BasicLevel.DEBUG, (Object)"Doing nothing");
                }
                this.log.log(BasicLevel.DEBUG, (Object)"Jorm2Rdb: final query tree:");
                QueryTreePrinter.printQueryTree(qtNew, this.log);
                return qtNew;
            }
            this.log.log(BasicLevel.DEBUG, (Object)"Jorm2Rdb: some calculated fields: keeping input query tree");
            return qt;
        }
        return this.jormRule.rewrite(qt, parent);
    }

    private void replaceAggregatedField(Expression e) {
        UnaryOperator op = (UnaryOperator)e;
        FieldOperand fo = (FieldOperand)op.getExpression(0);
        fo.setField(((PropagatedField)fo.getField()).getPreviousFields()[0]);
    }

    private QueryTreeField[] replaceGroupByFields(Nest nest) {
        this.log.log(BasicLevel.DEBUG, (Object)"Jorm2Rdb: replacing GroupBy fields");
        QueryTreeField[] groupBy = nest.getNestingFields();
        QueryTreeField[] newGroupBy = new QueryTreeField[groupBy.length];
        for (int i = 0; i < groupBy.length; ++i) {
            this.log.log(BasicLevel.DEBUG, (Object)("Jorm2Rdb: examining GroupBy field " + groupBy[i]));
            if (groupBy[i] instanceof PropagatedField) {
                newGroupBy[i] = (QueryTreeField)((PropagatedField)groupBy[i]).getPreviousFields()[0];
            } else if (groupBy[i] instanceof CalculatedField) {
                newGroupBy[i] = groupBy[i];
                this.log.log(BasicLevel.ERROR, (Object)("Jorm2Rdb.replaceGroupByFields: Cannot find previous field of a calculated field :" + groupBy[i]));
            }
            this.log.log(BasicLevel.DEBUG, (Object)("new GroupBy field " + i + ": " + newGroupBy[i] + " of node " + newGroupBy[i].getQueryTree()));
        }
        return newGroupBy;
    }

    private boolean noCalculatedField(QueryNode qn) throws MedorException {
        boolean noCCF = true;
        TupleStructure ts = qn.getTupleStructure();
        for (int i = 0; i < ts.getSize(); ++i) {
            if (!(ts.getField(i + 1) instanceof CalculatedField)) continue;
            this.log.log(BasicLevel.DEBUG, (Object)("Found CalculatedField " + ts.getField(i + 1).getName()));
            noCCF = false;
        }
        return noCCF;
    }
}

