/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.query.jorm.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassMapping;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.jorm.metainfo.api.PrimitiveElementMapping;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.query.api.CalculatedField;
import org.objectweb.medor.query.api.FilteredQueryTree;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryLeaf;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.jorm.api.JormExtent;
import org.objectweb.medor.query.jorm.lib.ClassExtent;

public class JormQueryTreeHelper {
    public static Collection getJormExtents(QueryTree qt) {
        if (qt == null) {
            return null;
        }
        ArrayList<QueryTree> res = new ArrayList<QueryTree>();
        ArrayList<QueryTree> toTreat = new ArrayList<QueryTree>();
        toTreat.add(qt);
        while (!toTreat.isEmpty()) {
            QueryTree current = (QueryTree)toTreat.remove(0);
            if (current instanceof JormExtent) {
                res.add(current);
                continue;
            }
            if (!(current instanceof QueryNode)) continue;
            QueryTree[] children = ((QueryNode)current).getChildren();
            for (int i = 0; i < children.length; ++i) {
                toTreat.add(children[i]);
            }
        }
        return res;
    }

    public static Collection getRequiredPNameManagers(QueryTree qt) {
        if (qt == null) {
            return null;
        }
        ArrayList res = new ArrayList();
        ArrayList<QueryTree> toTreat = new ArrayList<QueryTree>();
        toTreat.add(qt);
        while (!toTreat.isEmpty()) {
            QueryTree current = (QueryTree)toTreat.remove(0);
            Field[] fs = qt.getTupleStructure().getFields();
            for (int i = 0; i < fs.length; ++i) {
                if (!(fs[i] instanceof CalculatedField)) continue;
                JormQueryTreeHelper.getRequiredPNameManagers(((CalculatedField)fs[i]).getExpression(), res);
            }
            if (current instanceof FilteredQueryTree) {
                JormQueryTreeHelper.getRequiredPNameManagers(((FilteredQueryTree)current).getQueryFilter(), res);
            }
            if (!(current instanceof QueryNode)) continue;
            QueryTree[] children = ((QueryNode)qt).getChildren();
            for (int i = 0; i < children.length; ++i) {
                toTreat.add(children[i]);
            }
        }
        return res;
    }

    private static void getRequiredPNameManagers(Expression e, Collection c) {
        if (e instanceof ParameterOperand) {
            ParameterOperand po = (ParameterOperand)e;
            if (po.getType().getTypeCode() == 200) {
                c.add(po);
            }
        } else if (e instanceof Operator) {
            Operator op = (Operator)e;
            int nb = op.getOperandNumber();
            for (int i = 0; i < nb; ++i) {
                JormQueryTreeHelper.getRequiredPNameManagers(op.getExpression(i), c);
            }
        }
    }

    public static void addPrefetchFields(ClassExtent ext, QueryTree oldroot, QueryNode newroot) throws MedorException {
        JormQueryTreeHelper.addPrefetchFields(ext, oldroot, newroot, true);
    }

    public static void addPrefetchFields(ClassExtent ext, QueryTree oldroot, QueryNode newroot, boolean withSubClasses) throws MedorException {
        ClassMapping cm = ((Class)ext.getMetaObject()).getClassProject(ext.getProjectName()).getMapping(JormQueryTreeHelper.getMapperName(ext.getPMapper().getMapperName())).getClassMapping();
        ArrayList<PrimitiveElementMapping> pems = new ArrayList<PrimitiveElementMapping>(cm.getAllPrimitiveElementMappings());
        if (withSubClasses) {
            Class cl = (Class)ext.getMetaObject();
            PClassMapping pcm = ext.getPMapper().lookup(cl.getFQName());
            try {
                PClassMapping[] childrenPCMs = pcm.getSubPCMs();
                if (childrenPCMs != null) {
                    for (int j = 0; j < childrenPCMs.length; ++j) {
                        Class subclass = ext.getPMapper().getMetaInfoManager().getClass(childrenPCMs[j].getClassName());
                        if (subclass == null) {
                            throw new MedorException("Impossible to retrieve the jorm class " + childrenPCMs[j].getClassName());
                        }
                        ClassMapping subCM = subclass.getClassMapping(ext.getProjectName(), JormQueryTreeHelper.getMapperName(ext.getPMapper().getMapperName()));
                        if (subCM == null) continue;
                        Collection newpems = subCM.getPrimitiveElementMappings();
                        Iterator it = newpems.iterator();
                        while (it.hasNext()) {
                            PrimitiveElementMapping newpem = (PrimitiveElementMapping)it.next();
                            PrimitiveElement newpe = (PrimitiveElement)newpem.getLinkedMO();
                            boolean found = false;
                            Iterator it2 = pems.iterator();
                            while (it2.hasNext() && !found) {
                                PrimitiveElementMapping pem = (PrimitiveElementMapping)it2.next();
                                PrimitiveElement pe = (PrimitiveElement)pem.getLinkedMO();
                                found = pe == newpe;
                            }
                            if (found) continue;
                            pems.add(newpem);
                        }
                    }
                    Collections.sort(pems);
                }
            }
            catch (PException e) {
                throw new MedorException("Problem occurred while computing list of pems for sub classes.", e);
            }
        }
        List fields = JormQueryTreeHelper.recurseAPF(ext, oldroot, pems);
        if (((Class)ext.getMetaObject()).isPolymorphic() && withSubClasses) {
            Collections.sort(fields);
        }
        if (fields == null) {
            throw new MedorException("Impossible to add prefetched field(s) on an extent which is not in the queryTree");
        }
        for (int i = 0; i < fields.size(); ++i) {
            QueryTreeField qtf = (QueryTreeField)fields.get(i);
            newroot.addPropagatedField(qtf.getName(), qtf.getType(), new QueryTreeField[]{qtf});
        }
        ext.setPrefetch(true);
    }

    public static void addPrefetchFields(ClassExtent ext, QueryTree qt) throws MedorException {
        ClassMapping cm = ((Class)ext.getMetaObject()).getClassProject(ext.getProjectName()).getMapping(JormQueryTreeHelper.getMapperName(ext.getPMapper().getMapperName())).getClassMapping();
        ArrayList fields = new ArrayList(cm.getAllPrimitiveElementMappings());
        JormQueryTreeHelper.recurseAPF(ext, qt, fields);
        ext.setPrefetch(true);
    }

    private static List recurseAPF(ClassExtent ext, QueryTree qt, List pems) throws MedorException {
        int i;
        if (qt == ext) {
            ArrayList<QueryTreeField> result = new ArrayList<QueryTreeField>(pems.size());
            for (int i2 = 0; i2 < pems.size(); ++i2) {
                PrimitiveElement pe = (PrimitiveElement)((PrimitiveElementMapping)pems.get(i2)).getLinkedMO();
                String fn = pe.getName();
                Field f = null;
                f = ext.contains(ext.getFieldName(ext.getName(), fn)) ? ext.getField(ext.getFieldName(ext.getName(), fn)) : ext.addField(pe);
                result.add((QueryTreeField)f);
            }
            return result;
        }
        if (qt instanceof QueryLeaf) {
            return null;
        }
        QueryTree[] children = ((QueryNode)qt).getChildren();
        List childfs = null;
        for (i = 0; i < children.length && (childfs = JormQueryTreeHelper.recurseAPF(ext, children[i], pems)) == null; ++i) {
        }
        if (childfs == null) {
            return null;
        }
        Field[] qtfs = qt.getTupleStructure().getFields();
        ArrayList<Field> result = new ArrayList<Field>(pems.size());
        for (int j = 0; j < childfs.size(); ++j) {
            QueryTreeField previous = (QueryTreeField)childfs.get(j);
            for (i = 0; i < qtfs.length; ++i) {
                if (!(qtfs[i] instanceof PropagatedField) || ((PropagatedField)qtfs[i]).getPreviousFields()[0] != previous) continue;
                result.add(qtfs[i]);
                break;
            }
            if (i != qtfs.length) continue;
            try {
                result.add(((QueryNode)qt).addPropagatedField(previous.getName(), previous.getType(), new QueryTreeField[]{previous}));
                continue;
            }
            catch (MedorException e) {
                // empty catch block
            }
        }
        return result;
    }

    private static String getMapperName(String mn) {
        if (mn == null) {
            return null;
        }
        int idx = mn.indexOf(46);
        if (idx == -1) {
            return mn;
        }
        return mn.substring(0, idx);
    }
}

