/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.query.jorm.lib;

import java.util.Iterator;
import java.util.Map;
import org.objectweb.jorm.lib.JormPathHelper;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassProject;
import org.objectweb.jorm.metainfo.api.ClassRef;
import org.objectweb.jorm.metainfo.api.GenClassRef;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.jorm.metainfo.api.Mapping;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.metainfo.api.NameDef;
import org.objectweb.jorm.metainfo.api.Reference;
import org.objectweb.jorm.metainfo.api.ReferenceMapping;
import org.objectweb.jorm.metainfo.api.TypedElement;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.jorm.api.JormExtent;
import org.objectweb.medor.query.jorm.lib.BasicJormField;
import org.objectweb.util.monolog.api.BasicLevel;

public class PNameField
extends BasicJormField {
    protected Class clazz;
    protected boolean isClassPName;
    protected boolean isInGenClass;

    public PNameField() {
    }

    public PNameField(String fieldName, GenClassRef gcr, boolean isGenClassPName, QueryTree qt) throws MedorException {
        super(fieldName, qt, gcr);
        this.isInGenClass = true;
        this.isClassPName = isGenClassPName;
    }

    public PNameField(String fieldName, ClassRef cr, QueryTree qt) throws MedorException {
        super(fieldName, qt, cr);
        this.isInGenClass = cr.getParent() instanceof GenClassRef;
        this.isClassPName = false;
    }

    public PNameField(String fn, Class cl, QueryTree qt) throws MedorException {
        super(fn, qt);
        this.isInGenClass = false;
        TypedElement te = this.getTypedElement(cl, fn);
        if (te != null && te instanceof Reference) {
            this.type = te.getType();
            this.isClassPName = false;
            this.te = te;
        } else {
            this.clazz = cl;
            this.isClassPName = true;
            this.type = this.clazz.getPType();
        }
    }

    public Object clone(Object clone, Map obj2clone) throws CloneNotSupportedException {
        clone = super.clone(clone, obj2clone);
        ((PNameField)clone).clazz = this.clazz;
        ((PNameField)clone).isClassPName = this.isClassPName;
        ((PNameField)clone).isInGenClass = this.isInGenClass;
        return clone;
    }

    public boolean isClassPName() {
        return this.isClassPName;
    }

    public Reference getReference() {
        return (Reference)this.te;
    }

    public Class getMetaObjectClass() {
        return this.clazz;
    }

    public GenClassRef getGenClassRef() {
        return (GenClassRef)this.te;
    }

    public boolean isInGenClass() {
        return this.isInGenClass;
    }

    private TypedElement getTypedElement(Class clazz, String fn) {
        int idx = fn.length();
        TypedElement te = null;
        te = clazz.getTypedElement(fn);
        while ((idx = fn.lastIndexOf(".", idx)) != -1 && te == null) {
            te = clazz.getTypedElement(fn.substring(idx + 1, fn.length()));
            --idx;
        }
        return te;
    }

    public NameDef getNameDef(JormExtent extent) throws MedorException {
        if (this.isClassPName) {
            if (this.isInGenClass) {
                return this.getRefNameDef((GenClassRef)extent.getMetaObject(), extent);
            }
            return this.getClassNameDef(extent);
        }
        if (this.isInGenClass) {
            return this.getElemNameDef((Reference)this.te, extent);
        }
        return this.getRefNameDef((Reference)this.te, extent);
    }

    public String getPNamingContextParameter() {
        if (this.isClassPName) {
            if (this.isInGenClass) {
                return JormPathHelper.getPath((GenClassRef)this.te, false);
            }
            return JormPathHelper.getPath(this.clazz);
        }
        if (this.te instanceof GenClassRef) {
            return JormPathHelper.getPath((GenClassRef)this.te, !this.isInGenClass);
        }
        return JormPathHelper.getPath((ClassRef)this.te);
    }

    public MetaObject getTargetedMetaObject() {
        if (this.isInGenClass) {
            if (this.isClassPName) {
                return this.te;
            }
            GenClassRef gcr = (GenClassRef)this.te;
            if (gcr.isClassRef()) {
                return gcr.getClassRef().getMOClass();
            }
            if (gcr.isGenClassRef()) {
                return gcr.getGenClassRef();
            }
            return null;
        }
        if (this.isClassPName) {
            return this.clazz;
        }
        return this.te;
    }

    private NameDef getRefNameDef(GenClassRef gcr, JormExtent extent) throws MedorException {
        return (NameDef)this.getMapping(extent).getGenClassMapping(gcr.getGenClassId()).getIdentifierMapping().getLinkedMO();
    }

    private NameDef getElemNameDef(Reference r, JormExtent extent) throws MedorException {
        return (NameDef)this.getMapping(extent).getGenClassMapping(((GenClassRef)r.getParent()).getGenClassId()).getReferenceMapping().getLinkedMO();
    }

    private NameDef getRefNameDef(Reference r, JormExtent extent) throws MedorException {
        if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Extent class mapping " + this.getMapping(extent).getClassMapping()));
            Iterator it = this.getMapping(extent).getClassMapping().getReferenceMappings().iterator();
            while (it.hasNext()) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Reference rule name " + ((ReferenceMapping)it.next()).getRuleName()));
            }
            this.logger.log(BasicLevel.DEBUG, (Object)("+ reference mapping " + this.getMapping(extent).getClassMapping().getReferenceMapping(r.getName())));
            this.logger.log(BasicLevel.DEBUG, (Object)("+ rule name " + this.getMapping(extent).getClassMapping().getReferenceMapping(r.getName()).getRuleName()));
            this.logger.log(BasicLevel.DEBUG, (Object)("+ linkedMO " + this.getMapping(extent).getClassMapping().getReferenceMapping(r.getName()).getLinkedMO()));
        }
        return (NameDef)this.getMapping(extent).getClassMapping().getReferenceMapping(r.getName()).getLinkedMO();
    }

    private Class getClass(MetaObject mo) {
        if (mo instanceof Class) {
            return (Class)mo;
        }
        if (mo instanceof Package || mo instanceof Manager) {
            return null;
        }
        return this.getClass(mo.getParent());
    }

    private Mapping getMapping(JormExtent extent) throws MedorException {
        Class c = this.getClass(extent.getMetaObject());
        ClassProject cp = c.getClassProject(extent.getProjectName());
        if (cp == null) {
            throw new MedorException("No classproject found for the class " + c.getFQName() + " and  the project " + extent.getProjectName());
        }
        String mapperName = extent.getPMapper().getMapperName();
        int idx = mapperName.indexOf(46);
        Mapping m = cp.getMapping(idx == -1 ? mapperName : mapperName.substring(0, idx));
        if (m == null) {
            throw new MedorException("No mapping found for the class " + c.getFQName() + ",  the project " + extent.getProjectName() + " and  the mapper " + mapperName);
        }
        return m;
    }

    private NameDef getClassNameDef(JormExtent extent) throws MedorException {
        return (NameDef)this.getMapping(extent).getClassMapping().getIdentifierMapping().getLinkedMO();
    }
}

