/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.query.lib;

import java.util.ArrayList;
import java.util.Iterator;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.filter.lib.ExpressionPrinter;
import org.objectweb.medor.query.api.CalculatedField;
import org.objectweb.medor.query.api.FilteredQueryTree;
import org.objectweb.medor.query.api.NestedField;
import org.objectweb.medor.query.api.OrderField;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.lib.Nest;
import org.objectweb.medor.query.rdb.api.QualifiedTable;
import org.objectweb.medor.query.rdb.api.RdbExpField;
import org.objectweb.medor.query.rdb.api.RdbExpQueryLeaf;
import org.objectweb.medor.query.rdb.api.RdbField;
import org.objectweb.medor.query.rdb.api.RdbQueryLeaf;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class QueryTreePrinter {
    static int id = 0;

    public static void printQueryTree(QueryTree qt, Logger log, int level) {
        if (log != null && log.isLoggable(level)) {
            id = 0;
            QueryTreePrinter.printQT("", qt, log, level);
        }
    }

    public static void printQueryTree(QueryTree qt, Logger log) {
        if (log != null && log.isLoggable(BasicLevel.DEBUG)) {
            id = 0;
            QueryTreePrinter.printQT("", qt, log, BasicLevel.DEBUG);
        }
    }

    private static void printQT(String prefix, QueryTree qt, Logger log, int level) {
        OrderField[] ofs;
        Expression e;
        int myId = ++id;
        log.log(level, (Object)(prefix + "*Node number " + myId));
        log.log(level, (Object)(prefix + " - Class " + qt));
        log.log(level, (Object)(prefix + " - Name " + qt.getName()));
        if (qt instanceof FilteredQueryTree && (e = ((FilteredQueryTree)qt).getQueryFilter()) != null) {
            log.log(level, (Object)(prefix + " -Filter: " + ExpressionPrinter.e2str(e)));
        }
        if (qt instanceof RdbQueryLeaf) {
            try {
                log.log(level, (Object)(prefix + " - sqlRequest: " + ((RdbQueryLeaf)qt).getSqlRequest(null, false, false)));
            }
            catch (Exception e2) {
                log.log(level, (Object)(prefix + " - sqlRequest: error"));
                e2.printStackTrace(System.out);
            }
            if (qt instanceof RdbExpQueryLeaf) {
                log.log(level, (Object)(prefix + "(resetting SQL request)"));
                ((RdbExpQueryLeaf)qt).resetSqlRequest();
                QualifiedTable[] qts = ((RdbExpQueryLeaf)qt).getQualifiedTables();
                for (int i = 0; i < qts.length; ++i) {
                    log.log(level, (Object)(prefix + " - tableName[" + i + "]:" + qts[i].getTableName() + " as " + qts[i].getAliasName()));
                }
            }
        }
        log.log(level, (Object)(prefix + " - Field names:"));
        Field[] fs = qt.getTupleStructure().getFields();
        String msg = null;
        for (int i = 0; i < fs.length; ++i) {
            msg = prefix + "\t-" + fs[i].getName();
            if (fs[i] instanceof RdbField) {
                msg = msg + "(" + ((RdbField)fs[i]).getColumnName();
                if (fs[i] instanceof RdbExpField) {
                    msg = msg + " in " + ((RdbExpField)fs[i]).getTable().getTableName() + " as " + ((RdbExpField)fs[i]).getTable().getAliasName();
                }
                msg = msg + ")";
            } else if (fs[i] instanceof CalculatedField) {
                msg = msg + " expression=" + ExpressionPrinter.e2str(((CalculatedField)fs[i]).getExpression());
            } else if (fs[i] instanceof PropagatedField) {
                Field[] previous = ((PropagatedField)fs[i]).getPreviousFields();
                msg = msg + " previous=";
                for (int j = 0; j < previous.length; ++j) {
                    msg = msg + previous[j].getName() + " ";
                    msg = msg + "of node " + ((QueryTreeField)previous[j]).getQueryTree();
                }
            }
            log.log(level, (Object)msg);
        }
        if (qt instanceof Nest) {
            log.log(level, (Object)(prefix + " --Nest: group by fields"));
            QueryTreeField[] gbFields = ((Nest)qt).getNestingFields();
            for (int i = 0; i < gbFields.length; ++i) {
                msg = " ---groupBy:" + gbFields[i];
                if (gbFields[i] instanceof PropagatedField) {
                    Field[] previous = ((PropagatedField)gbFields[i]).getPreviousFields();
                    msg = msg + " previous=";
                    for (int j = 0; j < previous.length; ++j) {
                        msg = msg + previous[j].getName() + " ";
                        msg = msg + "of node " + ((QueryTreeField)previous[j]).getQueryTree();
                    }
                }
                log.log(level, (Object)msg);
            }
        }
        if ((ofs = qt.getOrderBy()) != null) {
            StringBuffer sb = new StringBuffer();
            String sep = "";
            for (int i = 0; i < ofs.length; ++i) {
                sb.append(sep);
                sep = ", ";
                sb.append(ofs[i].getField().getName());
                sb.append(ofs[i].getDesc() ? " descending" : " ascending");
            }
            log.log(level, (Object)(prefix + " - Order By: " + sb.toString()));
        }
        log.log(level, (Object)"");
        if (qt instanceof QueryNode) {
            Iterator it = QueryTreePrinter.getChildren((QueryNode)qt).iterator();
            while (it.hasNext()) {
                log.log(level, (Object)(prefix + " -Children of " + myId));
                QueryTree qtchild = (QueryTree)it.next();
                if (qt instanceof QueryNode) {
                    log.log(level, (Object)(prefix + "\t" + (((QueryNode)qt).isOuter(qtchild) ? "OUTER" : "INNER")));
                }
                log.log(level, (Object)(prefix + "\t---------------"));
                if (qtchild == null) {
                    log.log(level, (Object)(prefix + "\tNull child !!!!!!!"));
                    continue;
                }
                QueryTreePrinter.printQT(prefix + "\t", qtchild, log, level);
            }
        }
    }

    public static ArrayList getChildren(QueryNode qn) {
        ArrayList<QueryTree> children = new ArrayList<QueryTree>();
        Field[] fs = qn.getTupleStructure().getFields();
        for (int i = 0; i < fs.length; ++i) {
            QueryTree qt;
            int j;
            if (fs[i] instanceof PropagatedField) {
                Field[] anc = ((PropagatedField)fs[i]).getPreviousFields();
                for (j = 0; j < anc.length; ++j) {
                    qt = ((QueryTreeField)anc[j]).getQueryTree();
                    if (children.contains(qt)) continue;
                    children.add(qt);
                }
                continue;
            }
            if (fs[i] instanceof NestedField) {
                Field[] grouped = ((NestedField)fs[i]).getFields();
                for (j = 0; j < grouped.length; ++j) {
                    qt = ((QueryTreeField)grouped[j]).getQueryTree();
                    if (children.contains(qt)) continue;
                    children.add(qt);
                }
                continue;
            }
            if (!(fs[i] instanceof CalculatedField)) continue;
            QueryTreePrinter.addChildrenFromExpression(children, ((CalculatedField)fs[i]).getExpression());
        }
        QueryTreePrinter.addChildrenFromExpression(children, qn.getQueryFilter());
        return children;
    }

    private static void addChildrenFromExpression(ArrayList children, Expression exp) {
        if (exp instanceof FieldOperand) {
            Field f = ((FieldOperand)exp).getField();
            QueryTree qt = ((QueryTreeField)f).getQueryTree();
            if (!children.contains(qt)) {
                children.add(qt);
            }
        } else if (exp instanceof Operator) {
            for (int i = 0; i < ((Operator)exp).getOperandNumber(); ++i) {
                QueryTreePrinter.addChildrenFromExpression(children, ((Operator)exp).getExpression(i));
            }
        }
    }
}

